/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.internal.text.SelectionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class JFaceTextUtil {
    private JFaceTextUtil() {
    }

    public static int computeLineHeight(StyledText styledText, int n, int n2, int n3) {
        return JFaceTextUtil.getLinePixel(styledText, n2) - JFaceTextUtil.getLinePixel(styledText, n);
    }

    public static int getBottomIndex(StyledText styledText) {
        int n = JFaceTextUtil.computeLastVisiblePixel(styledText);
        int n2 = styledText.getLineIndex(n);
        if (n2 == 0) {
            return n2;
        }
        int n3 = styledText.getLinePixel(n2);
        if (n3 <= 0) {
            return n2;
        }
        int n4 = styledText.getOffsetAtLine(n2);
        int n5 = styledText.getLineHeight(n4);
        if (n3 + n5 - 1 > n) {
            return n2 - 1;
        }
        return n2;
    }

    public static int getPartialTopIndex(StyledText styledText) {
        int n = styledText.getTopIndex();
        int n2 = styledText.getLinePixel(n);
        if (n2 == -styledText.getLineHeight(styledText.getOffsetAtLine(n))) {
            ++n;
            n2 = 0;
        }
        if (n2 > 0) {
            --n;
        }
        return n;
    }

    public static int getPartialBottomIndex(StyledText styledText) {
        int n = JFaceTextUtil.computeLastVisiblePixel(styledText);
        int n2 = styledText.getLineIndex(n);
        return n2;
    }

    private static int computeLastVisiblePixel(StyledText styledText) {
        int n = styledText.getClientArea().height;
        int n2 = n - 1;
        return n2;
    }

    public static int getPartialTopIndex(ITextViewer iTextViewer) {
        StyledText styledText = iTextViewer.getTextWidget();
        int n = JFaceTextUtil.getPartialTopIndex(styledText);
        return JFaceTextUtil.widgetLine2ModelLine(iTextViewer, n);
    }

    public static int getPartialBottomIndex(ITextViewer iTextViewer) {
        StyledText styledText = iTextViewer.getTextWidget();
        int n = JFaceTextUtil.getPartialBottomIndex(styledText);
        return JFaceTextUtil.widgetLine2ModelLine(iTextViewer, n);
    }

    public static ILineRange getVisibleModelLines(ITextViewer iTextViewer) {
        int n = JFaceTextUtil.getPartialTopIndex(iTextViewer);
        int n2 = JFaceTextUtil.getPartialBottomIndex(iTextViewer);
        if (n == -1 || n2 == -1) {
            return null;
        }
        return new LineRange(n, n2 - n + 1);
    }

    public static int widgetLine2ModelLine(ITextViewer iTextViewer, int n) {
        int n2;
        if (iTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)iTextViewer);
            n2 = iTextViewerExtension5.widgetLine2ModelLine(n);
        } else {
            try {
                IRegion iRegion = iTextViewer.getVisibleRegion();
                IDocument iDocument = iTextViewer.getDocument();
                n2 = n + iDocument.getLineOfOffset(iRegion.getOffset());
            }
            catch (BadLocationException badLocationException) {
                n2 = n;
            }
        }
        return n2;
    }

    public static int modelLineToWidgetLine(ITextViewer iTextViewer, int n) {
        int n2;
        if (iTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)iTextViewer);
            n2 = iTextViewerExtension5.modelLine2WidgetLine(n);
        } else {
            IRegion iRegion = iTextViewer.getVisibleRegion();
            IDocument iDocument = iTextViewer.getDocument();
            try {
                int n3 = iDocument.getLineOfOffset(iRegion.getOffset());
                int n4 = iDocument.getLineOfOffset(iRegion.getOffset() + iRegion.getLength());
                n2 = n < n3 || n > n4 ? -1 : n - n3;
            }
            catch (BadLocationException badLocationException) {
                n2 = -1;
            }
        }
        return n2;
    }

    public static int getHiddenTopLinePixels(StyledText styledText) {
        int n = JFaceTextUtil.getPartialTopIndex(styledText);
        return -styledText.getLinePixel(n);
    }

    public static int getLinePixel(StyledText styledText, int n) {
        return styledText.getLinePixel(n);
    }

    public static int getLineIndex(StyledText styledText, int n) {
        int n2 = styledText.getLineIndex(n);
        return n2;
    }

    public static boolean isShowingEntireContents(StyledText styledText) {
        if (styledText.getTopPixel() != 0) {
            return false;
        }
        int n = JFaceTextUtil.computeLastVisiblePixel(styledText);
        int n2 = styledText.getLinePixel(styledText.getLineCount());
        return n2 <= n;
    }

    public static Rectangle computeArea(IRegion iRegion, ITextViewer iTextViewer) {
        Rectangle rectangle;
        int n = 0;
        int n2 = 0;
        IRegion iRegion2 = JFaceTextUtil.modelRange2WidgetRange(iRegion, iTextViewer);
        if (iRegion2 != null) {
            n = iRegion2.getOffset();
            n2 = n + iRegion2.getLength();
        }
        StyledText styledText = iTextViewer.getTextWidget();
        if (n2 > 0 && n < n2) {
            rectangle = styledText.getTextBounds(n, n2 - 1);
        } else {
            Point point = styledText.getLocationAtOffset(n);
            rectangle = new Rectangle(point.x, point.y, JFaceTextUtil.getAverageCharWidth((Control)iTextViewer.getTextWidget()), styledText.getLineHeight(n));
        }
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private static IRegion modelRange2WidgetRange(IRegion iRegion, ITextViewer iTextViewer) {
        if (iTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)iTextViewer);
            return iTextViewerExtension5.modelRange2WidgetRange(iRegion);
        }
        IRegion iRegion2 = iTextViewer.getVisibleRegion();
        int n = iRegion.getOffset() - iRegion2.getOffset();
        int n2 = n + iRegion.getLength();
        if (n2 > iRegion2.getLength()) {
            n2 = iRegion2.getLength();
        }
        return new Region(n, n2 - n);
    }

    public static int getAverageCharWidth(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        int n = gC.getFontMetrics().getAverageCharWidth();
        gC.dispose();
        return n;
    }

    public static boolean isEmpty(ITextViewer iTextViewer, ITextSelection iTextSelection) throws BadLocationException {
        return new SelectionProcessor(iTextViewer).isEmpty(iTextSelection);
    }

    public static IRegion[] getCoveredRanges(ITextViewer iTextViewer, ITextSelection iTextSelection) throws BadLocationException {
        return new SelectionProcessor(iTextViewer).getRanges(iTextSelection);
    }

    public static int getOffsetForCursorLocation(ITextViewer iTextViewer) {
        StyledText styledText;
        block5: {
            try {
                styledText = iTextViewer.getTextWidget();
                if (styledText != null && !styledText.isDisposed()) break block5;
                return -1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }
        Display display = styledText.getDisplay();
        Point point = display.getCursorLocation();
        Point point2 = styledText.toControl(point);
        int n = styledText.getOffsetAtLocation(point2);
        Point point3 = styledText.getLocationAtOffset(n);
        if (point3.x > point2.x) {
            --n;
        }
        if (iTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)iTextViewer);
            return iTextViewerExtension5.widgetOffset2ModelOffset(n);
        }
        return n + iTextViewer.getVisibleRegion().getOffset();
    }
}

