/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.events.VerifyEvent;

public class DocumentCommand {
    public boolean doit = false;
    public int offset;
    public int length;
    public String text;
    public IDocumentListener owner;
    public int caretOffset;
    private final List fCommands = new ArrayList();
    public boolean shiftsCaret;

    protected DocumentCommand() {
    }

    void setEvent(VerifyEvent verifyEvent, IRegion iRegion) {
        this.doit = true;
        this.text = verifyEvent.text;
        this.offset = iRegion.getOffset();
        this.length = iRegion.getLength();
        this.owner = null;
        this.caretOffset = -1;
        this.shiftsCaret = true;
        this.fCommands.clear();
    }

    boolean fillEvent(VerifyEvent verifyEvent, IRegion iRegion) {
        verifyEvent.text = this.text;
        verifyEvent.doit = this.offset == iRegion.getOffset() && this.length == iRegion.getLength() && this.doit && this.caretOffset == -1;
        return verifyEvent.doit;
    }

    public void addCommand(int n, int n2, String string, IDocumentListener iDocumentListener) throws BadLocationException {
        Command command = new Command(n, n2, string, iDocumentListener);
        if (this.intersects(command)) {
            throw new BadLocationException();
        }
        int n3 = Collections.binarySearch(this.fCommands, command);
        if (n3 >= 0) {
            throw new BadLocationException();
        }
        int n4 = -(n3 + 1);
        if (n4 != this.fCommands.size() && this.intersects((Command)this.fCommands.get(n4), command)) {
            throw new BadLocationException();
        }
        if (n4 != 0 && this.intersects((Command)this.fCommands.get(n4 - 1), command)) {
            throw new BadLocationException();
        }
        this.fCommands.add(n4, command);
    }

    public Iterator getCommandIterator() {
        Command command = new Command(this.offset, this.length, this.text, this.owner);
        return new CommandIterator(this.fCommands, command, true);
    }

    public int getCommandCount() {
        return 1 + this.fCommands.size();
    }

    private boolean intersects(Command command, Command command2) {
        if (command.fOffset + command.fLength <= command2.fOffset || command2.fOffset + command2.fLength <= command.fOffset) {
            return 2 * command.fOffset + command.fLength - (2 * command2.fOffset + command2.fLength) == 0;
        }
        return true;
    }

    private boolean intersects(Command command) {
        if (this.offset + this.length <= command.fOffset || command.fOffset + command.fLength <= this.offset) {
            return 2 * this.offset + this.length - (2 * command.fOffset + command.fLength) == 0;
        }
        return true;
    }

    void execute(IDocument iDocument) throws BadLocationException {
        block18: {
            if (this.length == 0 && this.text == null && this.fCommands.size() == 0) {
                return;
            }
            DefaultPositionUpdater defaultPositionUpdater = new DefaultPositionUpdater(this.getCategory());
            Position position = null;
            try {
                if (this.updateCaret()) {
                    iDocument.addPositionCategory(this.getCategory());
                    iDocument.addPositionUpdater((IPositionUpdater)defaultPositionUpdater);
                    position = new Position(this.caretOffset);
                    iDocument.addPosition(this.getCategory(), position);
                }
                Command command = new Command(this.offset, this.length, this.text, this.owner);
                CommandIterator commandIterator = new CommandIterator(this.fCommands, command, false);
                while (commandIterator.hasNext()) {
                    ((Command)commandIterator.next()).execute(iDocument);
                }
            }
            catch (BadLocationException badLocationException) {
                if (!this.updateCaret()) break block18;
                iDocument.removePositionUpdater((IPositionUpdater)defaultPositionUpdater);
                try {
                    iDocument.removePositionCategory(this.getCategory());
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    Assert.isTrue((boolean)false);
                }
                this.caretOffset = position.getOffset();
                break block18;
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                try {
                    if (!this.updateCaret()) break block18;
                }
                catch (Throwable throwable) {
                    if (this.updateCaret()) {
                        iDocument.removePositionUpdater((IPositionUpdater)defaultPositionUpdater);
                        try {
                            iDocument.removePositionCategory(this.getCategory());
                        }
                        catch (BadPositionCategoryException badPositionCategoryException2) {
                            Assert.isTrue((boolean)false);
                        }
                        this.caretOffset = position.getOffset();
                    }
                    throw throwable;
                }
                iDocument.removePositionUpdater((IPositionUpdater)defaultPositionUpdater);
                try {
                    iDocument.removePositionCategory(this.getCategory());
                }
                catch (BadPositionCategoryException badPositionCategoryException3) {
                    Assert.isTrue((boolean)false);
                }
                this.caretOffset = position.getOffset();
                break block18;
            }
            if (!this.updateCaret()) break block18;
            iDocument.removePositionUpdater((IPositionUpdater)defaultPositionUpdater);
            try {
                iDocument.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
            this.caretOffset = position.getOffset();
        }
    }

    private boolean updateCaret() {
        return this.shiftsCaret && this.caretOffset != -1;
    }

    private String getCategory() {
        return this.toString();
    }

    private static class Command
    implements Comparable {
        private final int fOffset;
        private final int fLength;
        private final String fText;
        private final IDocumentListener fOwner;

        public Command(int n, int n2, String string, IDocumentListener iDocumentListener) {
            if (n < 0 || n2 < 0) {
                throw new IllegalArgumentException();
            }
            this.fOffset = n;
            this.fLength = n2;
            this.fText = string;
            this.fOwner = iDocumentListener;
        }

        public void execute(IDocument iDocument) throws BadLocationException {
            if (this.fLength == 0 && this.fText == null) {
                return;
            }
            if (this.fOwner != null) {
                iDocument.removeDocumentListener(this.fOwner);
            }
            iDocument.replace(this.fOffset, this.fLength, this.fText);
            if (this.fOwner != null) {
                iDocument.addDocumentListener(this.fOwner);
            }
        }

        public int compareTo(Object object) {
            int n;
            if (this.isEqual(object)) {
                return 0;
            }
            Command command = (Command)object;
            if ((this.fOffset + this.fLength <= command.fOffset || command.fOffset + command.fLength <= this.fOffset) && (n = 2 * this.fOffset + this.fLength - (2 * command.fOffset + command.fLength)) != 0) {
                return n;
            }
            return 42;
        }

        private boolean isEqual(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Command)) {
                return false;
            }
            Command command = (Command)object;
            return command.fOffset == this.fOffset && command.fLength == this.fLength;
        }
    }

    private static class CommandIterator
    implements Iterator {
        private final Iterator fIterator;
        private Command fCommand;
        private boolean fForward;

        public CommandIterator(List list, Command command, boolean bl) {
            if (list == null || command == null) {
                throw new IllegalArgumentException();
            }
            this.fIterator = bl ? list.iterator() : new ReverseListIterator(list.listIterator(list.size()));
            this.fCommand = command;
            this.fForward = bl;
        }

        @Override
        public boolean hasNext() {
            return this.fCommand != null || this.fIterator.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.fCommand == null) {
                return this.fIterator.next();
            }
            if (!this.fIterator.hasNext()) {
                Command command = this.fCommand;
                this.fCommand = null;
                return command;
            }
            Command command = (Command)this.fIterator.next();
            int n = command.compareTo(this.fCommand);
            if (n < 0 ^ !this.fForward) {
                return command;
            }
            if (n > 0 ^ !this.fForward) {
                Command command2 = this.fCommand;
                this.fCommand = command;
                return command2;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReverseListIterator
    implements Iterator {
        private final ListIterator fListIterator;

        public ReverseListIterator(ListIterator listIterator) {
            if (listIterator == null) {
                throw new IllegalArgumentException();
            }
            this.fListIterator = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.fListIterator.hasPrevious();
        }

        public Object next() {
            return this.fListIterator.previous();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

