/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.JFaceTextMessages;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DefaultUndoManager
implements IUndoManager,
IUndoManagerExtension {
    private StringBuffer fTextBuffer;
    private StringBuffer fPreservedTextBuffer;
    protected long fPreservedUndoModificationStamp = -1L;
    protected long fPreservedRedoModificationStamp = -1L;
    private KeyAndMouseListener fKeyAndMouseListener;
    private DocumentListener fDocumentListener;
    private TextInputListener fTextInputListener;
    private boolean fInserting = false;
    private boolean fOverwriting = false;
    private boolean fFoldingIntoCompoundChange = false;
    private ITextViewer fTextViewer;
    private int fUndoLevel;
    private TextCommand fCurrent;
    private TextCommand fPreviousDelete;
    private IOperationHistory fHistory;
    private IUndoContext fUndoContext;
    private IOperationHistoryListener fHistoryListener = new HistoryListener();
    private TextCommand fLastAddedCommand = null;

    public DefaultUndoManager(int n) {
        this.fHistory = OperationHistoryFactory.getOperationHistory();
        this.setMaximalUndoLevel(n);
    }

    private boolean isConnected() {
        return this.fTextViewer != null;
    }

    @Override
    public void beginCompoundChange() {
        if (this.isConnected()) {
            this.fFoldingIntoCompoundChange = true;
            this.commit();
        }
    }

    @Override
    public void endCompoundChange() {
        if (this.isConnected()) {
            this.fFoldingIntoCompoundChange = false;
            this.commit();
        }
    }

    private void addListeners() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            this.fKeyAndMouseListener = new KeyAndMouseListener();
            styledText.addMouseListener((MouseListener)this.fKeyAndMouseListener);
            styledText.addKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.fTextInputListener = new TextInputListener();
            this.fTextViewer.addTextInputListener(this.fTextInputListener);
            this.fHistory.addOperationHistoryListener(this.fHistoryListener);
            this.listenToTextChanges(true);
        }
    }

    private void removeListeners() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            if (this.fKeyAndMouseListener != null) {
                styledText.removeMouseListener((MouseListener)this.fKeyAndMouseListener);
                styledText.removeKeyListener((KeyListener)this.fKeyAndMouseListener);
                this.fKeyAndMouseListener = null;
            }
            if (this.fTextInputListener != null) {
                this.fTextViewer.removeTextInputListener(this.fTextInputListener);
                this.fTextInputListener = null;
            }
            this.listenToTextChanges(false);
            this.fHistory.removeOperationHistoryListener(this.fHistoryListener);
        }
    }

    private void addToCommandStack(TextCommand textCommand) {
        if (!this.fFoldingIntoCompoundChange || textCommand instanceof CompoundTextCommand) {
            this.fHistory.add((IUndoableOperation)textCommand);
            this.fLastAddedCommand = textCommand;
        }
    }

    private void disposeCommandStack() {
        this.fHistory.dispose(this.fUndoContext, true, true, true);
    }

    private void initializeCommandStack() {
        if (this.fHistory != null && this.fUndoContext != null) {
            this.fHistory.dispose(this.fUndoContext, true, true, false);
        }
    }

    private void listenToTextChanges(boolean bl) {
        if (bl) {
            if (this.fDocumentListener == null && this.fTextViewer.getDocument() != null) {
                this.fDocumentListener = new DocumentListener();
                this.fTextViewer.getDocument().addDocumentListener((IDocumentListener)this.fDocumentListener);
            }
        } else if (!bl && this.fDocumentListener != null && this.fTextViewer.getDocument() != null) {
            this.fTextViewer.getDocument().removeDocumentListener((IDocumentListener)this.fDocumentListener);
            this.fDocumentListener = null;
        }
    }

    private void commit() {
        if (this.fLastAddedCommand != this.fCurrent) {
            this.fCurrent.pretendCommit();
            if (this.fCurrent.isValid()) {
                this.addToCommandStack(this.fCurrent);
            }
        }
        this.fCurrent.commit();
    }

    private void resetProcessChangeSate() {
        this.fInserting = false;
        this.fOverwriting = false;
        this.fPreviousDelete.reinitialize();
    }

    private boolean isWhitespaceText(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String[] stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters();
        int n = TextUtilities.startsWith((String[])stringArray, (String)string);
        if (n > -1) {
            int n2 = string.length();
            int n3 = stringArray[n].length();
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c != ' ' && c != '\t') {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    private void processChange(int n, int n2, String string, String string2, long l, long l2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        int n3 = string.length();
        int n4 = n2 - n;
        if (this.fCurrent.fUndoModificationStamp == -1L) {
            this.fCurrent.fUndoModificationStamp = l;
        }
        if (n4 < 0) {
            int n5 = n2;
            n2 = n;
            n = n5;
        }
        if (n == n2) {
            if (n3 == 1 || this.isWhitespaceText(string)) {
                if (!this.fInserting || n != this.fCurrent.fStart + this.fTextBuffer.length()) {
                    this.fCurrent.fRedoModificationStamp = l;
                    if (this.fCurrent.attemptCommit()) {
                        this.fCurrent.fUndoModificationStamp = l;
                    }
                    this.fInserting = true;
                }
                if (this.fCurrent.fStart < 0) {
                    this.fCurrent.fStart = this.fCurrent.fEnd = n;
                }
                if (n3 > 0) {
                    this.fTextBuffer.append(string);
                }
            } else if (n3 >= 0) {
                this.fCurrent.fRedoModificationStamp = l;
                if (this.fCurrent.attemptCommit()) {
                    this.fCurrent.fUndoModificationStamp = l;
                }
                this.fCurrent.fStart = this.fCurrent.fEnd = n;
                this.fTextBuffer.append(string);
                this.fCurrent.fRedoModificationStamp = l2;
                if (this.fCurrent.attemptCommit()) {
                    this.fCurrent.fUndoModificationStamp = l2;
                }
            }
        } else if (n3 == 0) {
            n3 = string2.length();
            String[] stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters();
            if (n3 == 1 || TextUtilities.equals((String[])stringArray, (String)string2) > -1) {
                if (this.fPreviousDelete.fStart == n && this.fPreviousDelete.fEnd == n2) {
                    if (this.fCurrent.fStart == n2 && this.fCurrent.fEnd == n) {
                        this.fCurrent.fStart = n;
                        this.fCurrent.fEnd = n2;
                    }
                    this.fPreservedTextBuffer.append(string2);
                    ++this.fCurrent.fEnd;
                } else if (this.fPreviousDelete.fStart == n2) {
                    this.fPreservedTextBuffer.insert(0, string2);
                    this.fCurrent.fStart = n;
                } else {
                    this.fCurrent.fRedoModificationStamp = l;
                    if (this.fCurrent.attemptCommit()) {
                        this.fCurrent.fUndoModificationStamp = l;
                    }
                    this.fPreservedTextBuffer.append(string2);
                    this.fCurrent.fStart = n;
                    this.fCurrent.fEnd = n2;
                }
                this.fPreviousDelete.set(n, n2);
            } else if (n3 > 0) {
                this.fCurrent.fRedoModificationStamp = l;
                if (this.fCurrent.attemptCommit()) {
                    this.fCurrent.fUndoModificationStamp = l;
                }
                this.fCurrent.fStart = n;
                this.fCurrent.fEnd = n2;
                this.fPreservedTextBuffer.append(string2);
            }
        } else {
            if (n3 == 1) {
                n3 = string2.length();
                String[] stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters();
                if (n3 == 1 || TextUtilities.equals((String[])stringArray, (String)string2) > -1) {
                    if (!this.fOverwriting || n != this.fCurrent.fStart + this.fTextBuffer.length()) {
                        this.fCurrent.fRedoModificationStamp = l;
                        if (this.fCurrent.attemptCommit()) {
                            this.fCurrent.fUndoModificationStamp = l;
                        }
                        this.fOverwriting = true;
                    }
                    if (this.fCurrent.fStart < 0) {
                        this.fCurrent.fStart = n;
                    }
                    this.fCurrent.fEnd = n2;
                    this.fTextBuffer.append(string);
                    this.fPreservedTextBuffer.append(string2);
                    this.fCurrent.fRedoModificationStamp = l2;
                    return;
                }
            }
            this.fCurrent.fRedoModificationStamp = l;
            if (this.fCurrent.attemptCommit()) {
                this.fCurrent.fUndoModificationStamp = l;
            }
            this.fCurrent.fStart = n;
            this.fCurrent.fEnd = n2;
            this.fTextBuffer.append(string);
            this.fPreservedTextBuffer.append(string2);
        }
        this.fCurrent.fRedoModificationStamp = l2;
    }

    private void openErrorDialog(final String string, final Exception exception) {
        StyledText styledText;
        Shell shell = null;
        if (this.isConnected() && (styledText = this.fTextViewer.getTextWidget()) != null && !styledText.isDisposed()) {
            shell = styledText.getShell();
        }
        if (Display.getCurrent() != null) {
            MessageDialog.openError(shell, (String)string, (String)exception.getLocalizedMessage());
        } else {
            final Shell shell2 = shell;
            styledText = shell2 != null ? shell2.getDisplay() : Display.getDefault();
            styledText.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell2, (String)string, (String)exception.getLocalizedMessage());
                }
            });
        }
    }

    @Override
    public void setMaximalUndoLevel(int n) {
        this.fUndoLevel = Math.max(0, n);
        if (this.isConnected()) {
            this.fHistory.setLimit(this.fUndoContext, this.fUndoLevel);
        }
    }

    @Override
    public void connect(ITextViewer iTextViewer) {
        if (!this.isConnected() && iTextViewer != null) {
            this.fTextViewer = iTextViewer;
            this.fTextBuffer = new StringBuffer();
            this.fPreservedTextBuffer = new StringBuffer();
            if (this.fUndoContext == null) {
                this.fUndoContext = new ObjectUndoContext((Object)this);
            }
            this.fHistory.setLimit(this.fUndoContext, this.fUndoLevel);
            this.initializeCommandStack();
            this.fCurrent = new TextCommand(this.fUndoContext);
            this.fPreviousDelete = new TextCommand(this.fUndoContext);
            this.addListeners();
        }
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            this.removeListeners();
            this.fCurrent = null;
            this.fTextViewer = null;
            this.disposeCommandStack();
            this.fTextBuffer = null;
            this.fPreservedTextBuffer = null;
            this.fUndoContext = null;
        }
    }

    @Override
    public void reset() {
        if (this.isConnected()) {
            this.initializeCommandStack();
            this.fCurrent = new TextCommand(this.fUndoContext);
            this.fFoldingIntoCompoundChange = false;
            this.fInserting = false;
            this.fOverwriting = false;
            this.fTextBuffer.setLength(0);
            this.fPreservedTextBuffer.setLength(0);
            this.fPreservedUndoModificationStamp = -1L;
            this.fPreservedRedoModificationStamp = -1L;
        }
    }

    @Override
    public boolean redoable() {
        return this.fHistory.canRedo(this.fUndoContext);
    }

    @Override
    public boolean undoable() {
        return this.fHistory.canUndo(this.fUndoContext);
    }

    @Override
    public void redo() {
        if (this.isConnected() && this.redoable()) {
            try {
                this.fHistory.redo(this.fUndoContext, null, null);
            }
            catch (ExecutionException executionException) {
                this.openErrorDialog(JFaceTextMessages.getString("DefaultUndoManager.error.redoFailed.title"), (Exception)((Object)executionException));
            }
        }
    }

    @Override
    public void undo() {
        if (this.isConnected() && this.undoable()) {
            try {
                this.fHistory.undo(this.fUndoContext, null, null);
            }
            catch (ExecutionException executionException) {
                this.openErrorDialog(JFaceTextMessages.getString("DefaultUndoManager.error.undoFailed.title"), (Exception)((Object)executionException));
            }
        }
    }

    protected void selectAndReveal(int n, int n2) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fTextViewer);
            iTextViewerExtension5.exposeModelRange((IRegion)new Region(n, n2));
        } else if (!this.fTextViewer.overlapsWithVisibleRegion(n, n2)) {
            this.fTextViewer.resetVisibleRegion();
        }
        this.fTextViewer.setSelectedRange(n, n2);
        this.fTextViewer.revealRange(n, n2);
    }

    @Override
    public IUndoContext getUndoContext() {
        return this.fUndoContext;
    }

    class CompoundTextCommand
    extends TextCommand {
        private List fCommands;

        CompoundTextCommand(IUndoContext iUndoContext) {
            super(iUndoContext);
            this.fCommands = new ArrayList();
        }

        protected void add(TextCommand textCommand) {
            this.fCommands.add(textCommand);
        }

        @Override
        public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) {
            DefaultUndoManager.this.resetProcessChangeSate();
            int n = this.fCommands.size();
            if (n > 0) {
                TextCommand textCommand;
                int n2 = n - 1;
                while (n2 > 0) {
                    textCommand = (TextCommand)((Object)this.fCommands.get(n2));
                    textCommand.undoTextChange();
                    --n2;
                }
                textCommand = (TextCommand)((Object)this.fCommands.get(0));
                textCommand.undo(iProgressMonitor, iAdaptable);
            }
            return Status.OK_STATUS;
        }

        @Override
        public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) {
            DefaultUndoManager.this.resetProcessChangeSate();
            int n = this.fCommands.size();
            if (n > 0) {
                TextCommand textCommand;
                int n2 = 0;
                while (n2 < n - 1) {
                    textCommand = (TextCommand)((Object)this.fCommands.get(n2));
                    textCommand.redoTextChange();
                    ++n2;
                }
                textCommand = (TextCommand)((Object)this.fCommands.get(n - 1));
                textCommand.redo(iProgressMonitor, iAdaptable);
            }
            return Status.OK_STATUS;
        }

        @Override
        protected void updateCommand() {
            super.updateCommand();
            TextCommand textCommand = new TextCommand(DefaultUndoManager.this.fUndoContext);
            textCommand.fStart = this.fStart;
            textCommand.fEnd = this.fEnd;
            textCommand.fText = this.fText;
            textCommand.fPreservedText = this.fPreservedText;
            textCommand.fUndoModificationStamp = this.fUndoModificationStamp;
            textCommand.fRedoModificationStamp = this.fRedoModificationStamp;
            this.add(textCommand);
            this.reinitialize();
        }

        @Override
        protected TextCommand createCurrent() {
            if (!DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                return new TextCommand(DefaultUndoManager.this.fUndoContext);
            }
            this.reinitialize();
            return this;
        }

        @Override
        protected void commit() {
            if (this.fStart > -1) {
                this.updateCommand();
            }
            DefaultUndoManager.this.fCurrent = this.createCurrent();
            DefaultUndoManager.this.resetProcessChangeSate();
        }

        @Override
        protected boolean isValid() {
            if (DefaultUndoManager.this.isConnected()) {
                return this.fStart > -1 || this.fCommands.size() > 0;
            }
            return false;
        }

        @Override
        protected long getUndoModificationStamp() {
            if (this.fStart > -1) {
                return super.getUndoModificationStamp();
            }
            if (this.fCommands.size() > 0) {
                return ((TextCommand)((Object)this.fCommands.get(0))).getUndoModificationStamp();
            }
            return this.fUndoModificationStamp;
        }

        @Override
        protected long getRedoModificationStamp() {
            if (this.fStart > -1) {
                return super.getRedoModificationStamp();
            }
            if (this.fCommands.size() > 0) {
                return ((TextCommand)((Object)this.fCommands.get(this.fCommands.size() - 1))).getRedoModificationStamp();
            }
            return this.fRedoModificationStamp;
        }
    }

    class DocumentListener
    implements IDocumentListener {
        private String fReplacedText;

        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            try {
                this.fReplacedText = documentEvent.getDocument().get(documentEvent.getOffset(), documentEvent.getLength());
                DefaultUndoManager.this.fPreservedUndoModificationStamp = documentEvent.getModificationStamp();
            }
            catch (BadLocationException badLocationException) {
                this.fReplacedText = null;
            }
        }

        public void documentChanged(DocumentEvent documentEvent) {
            DefaultUndoManager.this.fPreservedRedoModificationStamp = documentEvent.getModificationStamp();
            IUndoableOperation iUndoableOperation = DefaultUndoManager.this.fHistory.getUndoOperation(DefaultUndoManager.this.fUndoContext);
            boolean bl = false;
            if (iUndoableOperation != null) {
                bl = iUndoableOperation.canUndo();
            }
            DefaultUndoManager.this.processChange(documentEvent.getOffset(), documentEvent.getOffset() + documentEvent.getLength(), documentEvent.getText(), this.fReplacedText, DefaultUndoManager.this.fPreservedUndoModificationStamp, DefaultUndoManager.this.fPreservedRedoModificationStamp);
            DefaultUndoManager.this.fCurrent.pretendCommit();
            if (iUndoableOperation == DefaultUndoManager.this.fCurrent) {
                if (bl != DefaultUndoManager.this.fCurrent.isValid()) {
                    DefaultUndoManager.this.fHistory.operationChanged(iUndoableOperation);
                }
            } else if (DefaultUndoManager.this.fCurrent != DefaultUndoManager.this.fLastAddedCommand && DefaultUndoManager.this.fCurrent.isValid()) {
                DefaultUndoManager.this.addToCommandStack(DefaultUndoManager.this.fCurrent);
            }
        }
    }

    class HistoryListener
    implements IOperationHistoryListener {
        private IUndoableOperation fOperation;

        HistoryListener() {
        }

        public void historyNotification(final OperationHistoryEvent operationHistoryEvent) {
            final int n = operationHistoryEvent.getEventType();
            switch (n) {
                case 2: 
                case 3: {
                    if (!operationHistoryEvent.getOperation().hasContext(DefaultUndoManager.this.fUndoContext)) break;
                    DefaultUndoManager.this.fTextViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (operationHistoryEvent.getOperation() instanceof TextCommand) {
                                if (DefaultUndoManager.this.fTextViewer instanceof TextViewer) {
                                    ((TextViewer)DefaultUndoManager.this.fTextViewer).ignoreAutoEditStrategies(true);
                                }
                                DefaultUndoManager.this.listenToTextChanges(false);
                                if (n == 3 && DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                                    DefaultUndoManager.this.endCompoundChange();
                                }
                            } else {
                                DefaultUndoManager.this.commit();
                                DefaultUndoManager.this.fLastAddedCommand = null;
                            }
                        }
                    });
                    this.fOperation = operationHistoryEvent.getOperation();
                    break;
                }
                case 7: 
                case 9: 
                case 10: {
                    if (operationHistoryEvent.getOperation() != this.fOperation) break;
                    DefaultUndoManager.this.fTextViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DefaultUndoManager.this.listenToTextChanges(true);
                            HistoryListener.this.fOperation = null;
                            if (DefaultUndoManager.this.fTextViewer instanceof TextViewer) {
                                ((TextViewer)DefaultUndoManager.this.fTextViewer).ignoreAutoEditStrategies(false);
                            }
                        }
                    });
                }
            }
        }
    }

    class KeyAndMouseListener
    implements MouseListener,
    KeyListener {
        KeyAndMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                DefaultUndoManager.this.commit();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    DefaultUndoManager.this.commit();
                }
            }
        }
    }

    class TextCommand
    extends AbstractOperation {
        protected int fStart;
        protected int fEnd;
        protected String fText;
        protected String fPreservedText;
        protected long fUndoModificationStamp;
        protected long fRedoModificationStamp;

        TextCommand(IUndoContext iUndoContext) {
            super(JFaceTextMessages.getString("DefaultUndoManager.operationLabel"));
            this.fStart = -1;
            this.fEnd = -1;
            this.fUndoModificationStamp = -1L;
            this.fRedoModificationStamp = -1L;
            this.addContext(iUndoContext);
        }

        protected void reinitialize() {
            this.fEnd = -1;
            this.fStart = -1;
            this.fPreservedText = null;
            this.fText = null;
            this.fUndoModificationStamp = -1L;
            this.fRedoModificationStamp = -1L;
        }

        protected void set(int n, int n2) {
            this.fStart = n;
            this.fEnd = n2;
            this.fText = null;
            this.fPreservedText = null;
        }

        public void dispose() {
            this.reinitialize();
        }

        protected void undoTextChange() {
            try {
                IDocument iDocument = DefaultUndoManager.this.fTextViewer.getDocument();
                if (iDocument instanceof IDocumentExtension4) {
                    ((IDocumentExtension4)iDocument).replace(this.fStart, this.fText.length(), this.fPreservedText, this.fUndoModificationStamp);
                } else {
                    iDocument.replace(this.fStart, this.fText.length(), this.fPreservedText);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        public boolean canUndo() {
            if (DefaultUndoManager.this.isConnected() && this.isValid()) {
                IDocument iDocument = DefaultUndoManager.this.fTextViewer.getDocument();
                if (iDocument instanceof IDocumentExtension4) {
                    boolean bl;
                    long l = ((IDocumentExtension4)iDocument).getModificationStamp();
                    boolean bl2 = bl = l == -1L || l == this.getRedoModificationStamp();
                    if (!bl && this == DefaultUndoManager.this.fHistory.getUndoOperation(DefaultUndoManager.this.fUndoContext) && this != DefaultUndoManager.this.fCurrent && !DefaultUndoManager.this.fCurrent.isValid() && ((DefaultUndoManager)DefaultUndoManager.this).fCurrent.fUndoModificationStamp != -1L) {
                        boolean bl3 = bl = ((DefaultUndoManager)DefaultUndoManager.this).fCurrent.fRedoModificationStamp == l;
                    }
                    if (!bl && this == DefaultUndoManager.this.fHistory.getUndoOperation(DefaultUndoManager.this.fUndoContext) && this instanceof CompoundTextCommand && this == DefaultUndoManager.this.fCurrent && this.fStart == -1 && ((DefaultUndoManager)DefaultUndoManager.this).fCurrent.fRedoModificationStamp != -1L) {
                        bl = ((DefaultUndoManager)DefaultUndoManager.this).fCurrent.fRedoModificationStamp == l;
                    }
                }
                return true;
            }
            return false;
        }

        public boolean canRedo() {
            if (DefaultUndoManager.this.isConnected() && this.isValid()) {
                IDocument iDocument = DefaultUndoManager.this.fTextViewer.getDocument();
                if (iDocument instanceof IDocumentExtension4) {
                    long l = ((IDocumentExtension4)iDocument).getModificationStamp();
                    return l == -1L || l == this.getUndoModificationStamp();
                }
                return true;
            }
            return false;
        }

        public boolean canExecute() {
            return DefaultUndoManager.this.isConnected();
        }

        public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) {
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) {
            if (this.isValid()) {
                this.undoTextChange();
                DefaultUndoManager.this.selectAndReveal(this.fStart, this.fPreservedText == null ? 0 : this.fPreservedText.length());
                DefaultUndoManager.this.resetProcessChangeSate();
                return Status.OK_STATUS;
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }

        protected void redoTextChange() {
            try {
                IDocument iDocument = DefaultUndoManager.this.fTextViewer.getDocument();
                if (iDocument instanceof IDocumentExtension4) {
                    ((IDocumentExtension4)iDocument).replace(this.fStart, this.fEnd - this.fStart, this.fText, this.fRedoModificationStamp);
                } else {
                    DefaultUndoManager.this.fTextViewer.getDocument().replace(this.fStart, this.fEnd - this.fStart, this.fText);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) {
            if (this.isValid()) {
                this.redoTextChange();
                DefaultUndoManager.this.resetProcessChangeSate();
                DefaultUndoManager.this.selectAndReveal(this.fStart, this.fText == null ? 0 : this.fText.length());
                return Status.OK_STATUS;
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }

        protected void updateCommand() {
            this.fText = DefaultUndoManager.this.fTextBuffer.toString();
            DefaultUndoManager.this.fTextBuffer.setLength(0);
            this.fPreservedText = DefaultUndoManager.this.fPreservedTextBuffer.toString();
            DefaultUndoManager.this.fPreservedTextBuffer.setLength(0);
        }

        protected TextCommand createCurrent() {
            return DefaultUndoManager.this.fFoldingIntoCompoundChange ? new CompoundTextCommand(DefaultUndoManager.this.fUndoContext) : new TextCommand(DefaultUndoManager.this.fUndoContext);
        }

        protected void commit() {
            if (this.fStart < 0) {
                if (DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                    DefaultUndoManager.this.fCurrent = this.createCurrent();
                } else {
                    this.reinitialize();
                }
            } else {
                this.updateCommand();
                DefaultUndoManager.this.fCurrent = this.createCurrent();
            }
            DefaultUndoManager.this.resetProcessChangeSate();
        }

        protected void pretendCommit() {
            if (this.fStart > -1) {
                this.fText = DefaultUndoManager.this.fTextBuffer.toString();
                this.fPreservedText = DefaultUndoManager.this.fPreservedTextBuffer.toString();
            }
        }

        protected boolean attemptCommit() {
            this.pretendCommit();
            if (this.isValid()) {
                DefaultUndoManager.this.commit();
                return true;
            }
            return false;
        }

        protected boolean isValid() {
            return this.fStart > -1 && this.fEnd > -1 && this.fText != null;
        }

        public String toString() {
            String string = ", ";
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append("\n");
            stringBuffer.append(((Object)((Object)this)).getClass().getName());
            stringBuffer.append(" undo modification stamp: ");
            stringBuffer.append(this.fUndoModificationStamp);
            stringBuffer.append(" redo modification stamp: ");
            stringBuffer.append(this.fRedoModificationStamp);
            stringBuffer.append(" start: ");
            stringBuffer.append(this.fStart);
            stringBuffer.append(string);
            stringBuffer.append("end: ");
            stringBuffer.append(this.fEnd);
            stringBuffer.append(string);
            stringBuffer.append("text: '");
            stringBuffer.append(this.fText);
            stringBuffer.append('\'');
            stringBuffer.append(string);
            stringBuffer.append("preservedText: '");
            stringBuffer.append(this.fPreservedText);
            stringBuffer.append('\'');
            return stringBuffer.toString();
        }

        protected long getUndoModificationStamp() {
            return this.fUndoModificationStamp;
        }

        protected long getRedoModificationStamp() {
            return this.fRedoModificationStamp;
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        @Override
        public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
            if (iDocument != null && DefaultUndoManager.this.fDocumentListener != null) {
                iDocument.removeDocumentListener((IDocumentListener)DefaultUndoManager.this.fDocumentListener);
                DefaultUndoManager.this.commit();
            }
        }

        @Override
        public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
            if (iDocument2 != null) {
                if (DefaultUndoManager.this.fDocumentListener == null) {
                    DefaultUndoManager.this.fDocumentListener = new DocumentListener();
                }
                iDocument2.addDocumentListener((IDocumentListener)DefaultUndoManager.this.fDocumentListener);
            }
        }
    }
}

