/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;

public class DefaultTextHover
implements ITextHover {
    private ISourceViewer fSourceViewer;

    public DefaultTextHover(ISourceViewer iSourceViewer) {
        Assert.isNotNull((Object)iSourceViewer);
        this.fSourceViewer = iSourceViewer;
    }

    @Override
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        IAnnotationModel iAnnotationModel = this.getAnnotationModel(this.fSourceViewer);
        if (iAnnotationModel == null) {
            return null;
        }
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            String string;
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (!this.isIncluded(annotation) || (position = iAnnotationModel.getPosition(annotation)) == null || !position.overlapsWith(iRegion.getOffset(), iRegion.getLength()) || (string = annotation.getText()) == null || string.trim().length() <= 0) continue;
            return string;
        }
        return null;
    }

    @Override
    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        return this.findWord(iTextViewer.getDocument(), n);
    }

    protected boolean isIncluded(Annotation annotation) {
        return true;
    }

    private IAnnotationModel getAnnotationModel(ISourceViewer iSourceViewer) {
        if (iSourceViewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 iSourceViewerExtension2 = (ISourceViewerExtension2)((Object)iSourceViewer);
            return iSourceViewerExtension2.getVisualAnnotationModel();
        }
        return iSourceViewer.getAnnotationModel();
    }

    private IRegion findWord(IDocument iDocument, int n) {
        int n2 = -2;
        int n3 = -1;
        try {
            char c;
            int n4 = n;
            while (n4 >= 0) {
                c = iDocument.getChar(n4);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --n4;
            }
            n2 = n4;
            n4 = n;
            int n5 = iDocument.getLength();
            while (n4 < n5) {
                c = iDocument.getChar(n4);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++n4;
            }
            n3 = n4;
        }
        catch (BadLocationException badLocationException) {}
        if (n2 >= -1 && n3 > -1) {
            if (n2 == n && n3 == n) {
                return new Region(n, 0);
            }
            if (n2 == n) {
                return new Region(n2, n3 - n2);
            }
            return new Region(n2 + 1, n3 - n2 - 1);
        }
        return null;
    }
}

