/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import com.ibm.icu.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.Locale;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class DefaultTextDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private DocumentCharacterIterator fDocIter = new DocumentCharacterIterator();
    private BreakIterator fWordBreakIterator;
    private BreakIterator fPOSIXWordBreakIterator;

    @Override
    public void doubleClicked(ITextViewer iTextViewer) {
        int n = iTextViewer.getSelectedRange().x;
        if (n < 0) {
            return;
        }
        IDocument iDocument = iTextViewer.getDocument();
        IRegion iRegion = this.findExtendedDoubleClickSelection(iDocument, n);
        if (iRegion == null) {
            iRegion = this.findWord(iDocument, n);
        }
        if (iRegion != null) {
            iTextViewer.setSelectedRange(iRegion.getOffset(), iRegion.getLength());
        }
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument iDocument, int n) {
        return null;
    }

    protected IRegion findWord(IDocument iDocument, int n) {
        return this.findWord(iDocument, n, this.getWordBreakIterator());
    }

    private BreakIterator getWordBreakIterator() {
        if (this.fWordBreakIterator == null) {
            this.fWordBreakIterator = BreakIterator.getWordInstance();
        }
        return this.fWordBreakIterator;
    }

    private BreakIterator getPOSIXWordBreakIterator() {
        if (this.fPOSIXWordBreakIterator == null) {
            this.fPOSIXWordBreakIterator = BreakIterator.getWordInstance((Locale)new Locale("en", "US", "POSIX"));
        }
        return this.fPOSIXWordBreakIterator;
    }

    private IRegion findWord(IDocument iDocument, int n, BreakIterator breakIterator) {
        int n2;
        IRegion iRegion;
        try {
            iRegion = iDocument.getLineInformationOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (n == iRegion.getOffset() + iRegion.getLength()) {
            return null;
        }
        this.fDocIter.setDocument(iDocument, iRegion);
        breakIterator.setText((CharacterIterator)this.fDocIter);
        int n3 = breakIterator.preceding(n);
        if (n3 == -1) {
            n3 = iRegion.getOffset();
        }
        if ((n2 = breakIterator.following(n)) == -1) {
            n2 = iRegion.getOffset() + iRegion.getLength();
        }
        if (breakIterator.isBoundary(n)) {
            if (n2 - n > n - n3) {
                n3 = n;
            } else {
                n2 = n;
            }
        }
        if (n2 == n3) {
            return null;
        }
        int n4 = n2 - n3;
        try {
            IRegion iRegion2;
            if (this.fPOSIXWordBreakIterator != breakIterator && iDocument.get(n3, n4).indexOf(46) != -1 && (iRegion2 = this.findWord(iDocument, n, this.getPOSIXWordBreakIterator())) != null) {
                int n5 = iRegion2.getOffset();
                int n6 = n5 + iRegion2.getLength();
                if ((n5 == n3 || n5 > n3 && iDocument.getChar(n5 - 1) == '.') && (n6 == n2 || n6 < n2 && iDocument.getChar(n6) == '.')) {
                    return iRegion2;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return new Region(n3, n4);
    }

    static class DocumentCharacterIterator
    implements CharacterIterator {
        private IDocument fDocument;
        private int fOffset = -1;
        private int fEndOffset = -1;
        private int fIndex = -1;

        public void setDocument(IDocument iDocument, IRegion iRegion) {
            this.fDocument = iDocument;
            this.fOffset = iRegion.getOffset();
            this.fEndOffset = this.fOffset + iRegion.getLength();
        }

        @Override
        public char first() {
            this.fIndex = this.fOffset;
            return this.current();
        }

        @Override
        public char last() {
            this.fIndex = this.fOffset < this.fEndOffset ? this.fEndOffset - 1 : this.fEndOffset;
            return this.current();
        }

        @Override
        public char current() {
            if (this.fOffset <= this.fIndex && this.fIndex < this.fEndOffset) {
                try {
                    return this.fDocument.getChar(this.fIndex);
                }
                catch (BadLocationException badLocationException) {}
            }
            return '\uffff';
        }

        @Override
        public char next() {
            ++this.fIndex;
            int n = this.getEndIndex();
            if (this.fIndex >= n) {
                this.fIndex = n;
                return '\uffff';
            }
            return this.current();
        }

        @Override
        public char previous() {
            if (this.fIndex == this.fOffset) {
                return '\uffff';
            }
            if (this.fIndex > this.fOffset) {
                --this.fIndex;
            }
            return this.current();
        }

        @Override
        public char setIndex(int n) {
            this.fIndex = n;
            return this.current();
        }

        @Override
        public int getBeginIndex() {
            return this.fOffset;
        }

        @Override
        public int getEndIndex() {
            return this.fEndOffset;
        }

        @Override
        public int getIndex() {
            return this.fIndex;
        }

        @Override
        public Object clone() {
            DocumentCharacterIterator documentCharacterIterator = new DocumentCharacterIterator();
            documentCharacterIterator.fDocument = this.fDocument;
            documentCharacterIterator.fIndex = this.fIndex;
            documentCharacterIterator.fOffset = this.fOffset;
            documentCharacterIterator.fEndOffset = this.fEndOffset;
            return documentCharacterIterator;
        }
    }
}

