/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DefaultInformationControl
extends AbstractInformationControl
implements DisposeListener {
    private static final int INNER_BORDER = 1;
    private StyledText fText;
    private final IInformationPresenter fPresenter;
    private final TextPresentation fPresentation = new TextPresentation();
    private final int fAdditionalTextStyles;

    public DefaultInformationControl(Shell shell, boolean bl) {
        super(shell, bl);
        this.fAdditionalTextStyles = bl ? 768 : 0;
        this.fPresenter = new HTMLTextPresenter(!bl);
        this.create();
    }

    public DefaultInformationControl(Shell shell, String string) {
        this(shell, string, (IInformationPresenter)new HTMLTextPresenter(true));
    }

    public DefaultInformationControl(Shell shell, String string, IInformationPresenter iInformationPresenter) {
        super(shell, string);
        this.fAdditionalTextStyles = 0;
        this.fPresenter = iInformationPresenter;
        this.create();
    }

    public DefaultInformationControl(Shell shell, ToolBarManager toolBarManager) {
        this(shell, toolBarManager, (IInformationPresenter)new HTMLTextPresenter(false));
    }

    public DefaultInformationControl(Shell shell, ToolBarManager toolBarManager, IInformationPresenter iInformationPresenter) {
        super(shell, toolBarManager);
        this.fAdditionalTextStyles = 768;
        this.fPresenter = iInformationPresenter;
        this.create();
    }

    public DefaultInformationControl(Shell shell) {
        this(shell, (String)null, (IInformationPresenter)null);
    }

    public DefaultInformationControl(Shell shell, IInformationPresenter iInformationPresenter) {
        this(shell, (String)null, iInformationPresenter);
    }

    public DefaultInformationControl(Shell shell, int n, int n2, IInformationPresenter iInformationPresenter) {
        this(shell, n, n2, iInformationPresenter, null);
    }

    public DefaultInformationControl(Shell shell, int n, int n2, IInformationPresenter iInformationPresenter, String string) {
        super(shell, 0x84000 | n, string, null);
        this.fAdditionalTextStyles = n2;
        this.fPresenter = iInformationPresenter;
        this.create();
    }

    public DefaultInformationControl(Shell shell, int n, IInformationPresenter iInformationPresenter) {
        this(shell, n, iInformationPresenter, null);
    }

    public DefaultInformationControl(Shell shell, int n, IInformationPresenter iInformationPresenter, String string) {
        super(shell, string);
        this.fAdditionalTextStyles = n;
        this.fPresenter = iInformationPresenter;
        this.create();
    }

    @Override
    protected void createContent(Composite composite) {
        this.fText = new StyledText(composite, 0xA | this.fAdditionalTextStyles);
        this.fText.setForeground(composite.getForeground());
        this.fText.setBackground(composite.getBackground());
        this.fText.setFont(JFaceResources.getDialogFont());
        FillLayout fillLayout = (FillLayout)composite.getLayout();
        if (this.fText.getWordWrap()) {
            fillLayout.marginHeight = 1;
            fillLayout.marginWidth = 1;
        } else {
            this.fText.setIndent(1);
        }
    }

    @Override
    public void setInformation(String string) {
        if (this.fPresenter == null) {
            this.fText.setText(string);
        } else {
            this.fPresentation.clear();
            int n = -1;
            int n2 = -1;
            Point point = this.getSizeConstraints();
            if (point != null) {
                n = point.x;
                n2 = point.y;
                if (this.fText.getWordWrap()) {
                    n -= 2;
                    n2 -= 2;
                } else {
                    --n;
                }
                Rectangle rectangle = this.computeTrim();
                n -= rectangle.width;
                n2 -= rectangle.height;
                n -= this.fText.getCaret().getSize().x;
            }
            if (this.isResizable()) {
                n2 = Integer.MAX_VALUE;
            }
            if ((string = this.fPresenter instanceof IInformationPresenterExtension ? ((IInformationPresenterExtension)((Object)this.fPresenter)).updatePresentation((Drawable)this.fText, string, this.fPresentation, n, n2) : this.fPresenter.updatePresentation(this.getShell().getDisplay(), string, this.fPresentation, n, n2)) != null) {
                this.fText.setText(string);
                TextPresentation.applyTextPresentation(this.fPresentation, this.fText);
            } else {
                this.fText.setText("");
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this.fText.getWordWrap()) {
            Point point = this.getShell().getSize();
            this.getShell().pack(true);
            Point point2 = this.getShell().getSize();
            if (point2.x > point.x || point2.y > point.y) {
                this.setSize(point.x, point.y);
            }
        }
        super.setVisible(bl);
    }

    @Override
    public Point computeSizeHint() {
        int n = -1;
        Point point = this.getSizeConstraints();
        if (point != null && this.fText.getWordWrap()) {
            n = point.x;
        }
        return this.getShell().computeSize(n, -1, true);
    }

    @Override
    public Rectangle computeTrim() {
        return Geometry.add((Rectangle)super.computeTrim(), (Rectangle)this.fText.computeTrim(0, 0, 0, 0));
    }

    @Override
    public void setForegroundColor(Color color) {
        super.setForegroundColor(color);
        this.fText.setForeground(color);
    }

    @Override
    public void setBackgroundColor(Color color) {
        super.setBackgroundColor(color);
        this.fText.setBackground(color);
    }

    @Override
    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            @Override
            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, null, DefaultInformationControl.this.fPresenter);
            }
        };
    }

    public static interface IInformationPresenter {
        public String updatePresentation(Display var1, String var2, TextPresentation var3, int var4, int var5);
    }

    public static interface IInformationPresenterExtension {
        public String updatePresentation(Drawable var1, String var2, TextPresentation var3, int var4, int var5);
    }
}

