/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class DefaultIndentLineAutoEditStrategy
implements IAutoEditStrategy {
    protected int findEndOfWhiteSpace(IDocument iDocument, int n, int n2) throws BadLocationException {
        while (n < n2) {
            char c = iDocument.getChar(n);
            if (c != ' ' && c != '\t') {
                return n;
            }
            ++n;
        }
        return n2;
    }

    private void autoIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset == -1 || iDocument.getLength() == 0) {
            return;
        }
        try {
            int n = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            int n3 = this.findEndOfWhiteSpace(iDocument, n2, documentCommand.offset);
            StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
            if (n3 > n2) {
                stringBuffer.append(iDocument.get(n2, n3 - n2));
            }
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    @Override
    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.length == 0 && documentCommand.text != null && TextUtilities.endsWith((String[])iDocument.getLegalLineDelimiters(), (String)documentCommand.text) != -1) {
            this.autoIndentAfterNewLine(iDocument, documentCommand);
        }
    }
}

