/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentClone;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IDocumentAdapterExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRepairableDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;

class DefaultDocumentAdapter
implements IDocumentAdapter,
IDocumentListener,
IDocumentAdapterExtension {
    private IDocument fDocument;
    private IDocument fDocumentClone;
    private String fOriginalContent;
    private String[] fOriginalLineDelimiters;
    private List fTextChangeListeners = new ArrayList(1);
    private DocumentEvent fEvent;
    private String fLineDelimiter = null;
    private boolean fIsForwarding = true;
    private int fRememberedLengthOfDocument;
    private int fRememberedLengthOfFirstLine;
    private DocumentEvent fOriginalEvent = new DocumentEvent();

    @Override
    public void setDocument(IDocument iDocument) {
        if (this.fDocument != null) {
            this.fDocument.removePrenotifiedDocumentListener((IDocumentListener)this);
        }
        this.fDocument = iDocument;
        this.fLineDelimiter = null;
        if (!this.fIsForwarding) {
            this.fDocumentClone = null;
            if (this.fDocument != null) {
                this.fOriginalContent = this.fDocument.get();
                this.fOriginalLineDelimiters = this.fDocument.getLegalLineDelimiters();
            } else {
                this.fOriginalContent = null;
                this.fOriginalLineDelimiters = null;
            }
        }
        if (this.fDocument != null) {
            this.fDocument.addPrenotifiedDocumentListener((IDocumentListener)this);
        }
    }

    public void addTextChangeListener(TextChangeListener textChangeListener) {
        Assert.isNotNull((Object)textChangeListener);
        if (!this.fTextChangeListeners.contains(textChangeListener)) {
            this.fTextChangeListeners.add(textChangeListener);
        }
    }

    public void removeTextChangeListener(TextChangeListener textChangeListener) {
        Assert.isNotNull((Object)textChangeListener);
        this.fTextChangeListeners.remove(textChangeListener);
    }

    private void repairLineInformation(IDocument iDocument) {
        if (iDocument instanceof IRepairableDocument) {
            IRepairableDocument iRepairableDocument = (IRepairableDocument)iDocument;
            iRepairableDocument.repairLineInformation();
        }
    }

    private String doGetLine(IDocument iDocument, int n) throws BadLocationException {
        IRegion iRegion = iDocument.getLineInformation(n);
        return iDocument.get(iRegion.getOffset(), iRegion.getLength());
    }

    private IDocument getDocumentForRead() {
        if (!this.fIsForwarding) {
            if (this.fDocumentClone == null) {
                String string = this.fOriginalContent == null ? "" : this.fOriginalContent;
                String[] stringArray = this.fOriginalLineDelimiters == null ? DefaultLineTracker.DELIMITERS : this.fOriginalLineDelimiters;
                this.fDocumentClone = new DocumentClone(string, stringArray);
            }
            return this.fDocumentClone;
        }
        return this.fDocument;
    }

    public String getLine(int n) {
        IDocument iDocument = this.getDocumentForRead();
        try {
            return this.doGetLine(iDocument, n);
        }
        catch (BadLocationException badLocationException) {
            this.repairLineInformation(iDocument);
            try {
                return this.doGetLine(iDocument, n);
            }
            catch (BadLocationException badLocationException2) {
                SWT.error((int)5);
                return null;
            }
        }
    }

    public int getLineAtOffset(int n) {
        IDocument iDocument = this.getDocumentForRead();
        try {
            return iDocument.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            this.repairLineInformation(iDocument);
            try {
                return iDocument.getLineOfOffset(n);
            }
            catch (BadLocationException badLocationException2) {
                SWT.error((int)5);
                return -1;
            }
        }
    }

    public int getLineCount() {
        return this.getDocumentForRead().getNumberOfLines();
    }

    public int getOffsetAtLine(int n) {
        IDocument iDocument = this.getDocumentForRead();
        try {
            return iDocument.getLineOffset(n);
        }
        catch (BadLocationException badLocationException) {
            this.repairLineInformation(iDocument);
            try {
                return iDocument.getLineOffset(n);
            }
            catch (BadLocationException badLocationException2) {
                SWT.error((int)5);
                return -1;
            }
        }
    }

    public String getTextRange(int n, int n2) {
        try {
            return this.getDocumentForRead().get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            SWT.error((int)5);
            return null;
        }
    }

    public void replaceTextRange(int n, int n2, String string) {
        try {
            this.fDocument.replace(n, n2, string);
        }
        catch (BadLocationException badLocationException) {
            SWT.error((int)5);
        }
    }

    public void setText(String string) {
        this.fDocument.set(string);
    }

    public int getCharCount() {
        return this.getDocumentForRead().getLength();
    }

    public String getLineDelimiter() {
        if (this.fLineDelimiter == null) {
            this.fLineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.fDocument);
        }
        return this.fLineDelimiter;
    }

    public void documentChanged(DocumentEvent documentEvent) {
        if (this.fEvent == null || documentEvent != this.fEvent) {
            return;
        }
        if (this.isPatchedEvent(documentEvent) || documentEvent.getOffset() == 0 && documentEvent.getLength() == this.fRememberedLengthOfDocument) {
            this.fLineDelimiter = null;
            this.fireTextSet();
        } else {
            if (documentEvent.getOffset() < this.fRememberedLengthOfFirstLine) {
                this.fLineDelimiter = null;
            }
            this.fireTextChanged();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        this.fRememberedLengthOfDocument = this.fDocument.getLength();
        try {
            this.fRememberedLengthOfFirstLine = this.fDocument.getLineLength(0);
        }
        catch (BadLocationException badLocationException) {
            this.fRememberedLengthOfFirstLine = -1;
        }
        this.fEvent = documentEvent;
        this.rememberEventData(this.fEvent);
        this.fireTextChanging();
    }

    private boolean isPatchedEvent(DocumentEvent documentEvent) {
        return this.fOriginalEvent.fOffset != documentEvent.fOffset || this.fOriginalEvent.fLength != documentEvent.fLength || this.fOriginalEvent.fText != documentEvent.fText;
    }

    private void rememberEventData(DocumentEvent documentEvent) {
        this.fOriginalEvent.fOffset = documentEvent.fOffset;
        this.fOriginalEvent.fLength = documentEvent.fLength;
        this.fOriginalEvent.fText = documentEvent.fText;
    }

    private void fireTextChanged() {
        if (!this.fIsForwarding) {
            return;
        }
        TextChangedEvent textChangedEvent = new TextChangedEvent((StyledTextContent)this);
        if (this.fTextChangeListeners != null && this.fTextChangeListeners.size() > 0) {
            Iterator iterator = new ArrayList(this.fTextChangeListeners).iterator();
            while (iterator.hasNext()) {
                ((TextChangeListener)iterator.next()).textChanged(textChangedEvent);
            }
        }
    }

    private void fireTextSet() {
        if (!this.fIsForwarding) {
            return;
        }
        TextChangedEvent textChangedEvent = new TextChangedEvent((StyledTextContent)this);
        if (this.fTextChangeListeners != null && this.fTextChangeListeners.size() > 0) {
            Iterator iterator = new ArrayList(this.fTextChangeListeners).iterator();
            while (iterator.hasNext()) {
                ((TextChangeListener)iterator.next()).textSet(textChangedEvent);
            }
        }
    }

    private void fireTextChanging() {
        if (!this.fIsForwarding) {
            return;
        }
        try {
            IDocument iDocument = this.fEvent.getDocument();
            if (iDocument == null) {
                return;
            }
            TextChangingEvent textChangingEvent = new TextChangingEvent((StyledTextContent)this);
            textChangingEvent.start = this.fEvent.fOffset;
            textChangingEvent.replaceCharCount = this.fEvent.fLength;
            textChangingEvent.replaceLineCount = iDocument.getNumberOfLines(this.fEvent.fOffset, this.fEvent.fLength) - 1;
            textChangingEvent.newText = this.fEvent.fText;
            textChangingEvent.newCharCount = this.fEvent.fText == null ? 0 : this.fEvent.fText.length();
            int n = textChangingEvent.newLineCount = this.fEvent.fText == null ? 0 : iDocument.computeNumberOfLines(this.fEvent.fText);
            if (this.fTextChangeListeners != null && this.fTextChangeListeners.size() > 0) {
                Iterator iterator = new ArrayList(this.fTextChangeListeners).iterator();
                while (iterator.hasNext()) {
                    ((TextChangeListener)iterator.next()).textChanging(textChangingEvent);
                }
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    @Override
    public void resumeForwardingDocumentChanges() {
        this.fIsForwarding = true;
        this.fDocumentClone = null;
        this.fOriginalContent = null;
        this.fOriginalLineDelimiters = null;
        this.fireTextSet();
    }

    @Override
    public void stopForwardingDocumentChanges() {
        this.fDocumentClone = null;
        this.fOriginalContent = this.fDocument.get();
        this.fOriginalLineDelimiters = this.fDocument.getLegalLineDelimiters();
        this.fIsForwarding = false;
    }
}

