/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public class CursorLinePainter
implements IPainter,
LineBackgroundListener {
    private final ITextViewer fViewer;
    private Color fHighlightColor;
    private IPaintPositionManager fPositionManager;
    private Position fCurrentLine = new Position(0, 0);
    private Position fLastLine = new Position(0, 0);
    private int fLastLineNumber = -1;
    private boolean fIsActive;

    public CursorLinePainter(ITextViewer iTextViewer) {
        this.fViewer = iTextViewer;
    }

    public void setHighlightColor(Color color) {
        this.fHighlightColor = color;
    }

    public void lineGetBackground(LineBackgroundEvent lineBackgroundEvent) {
        StyledText styledText = this.fViewer.getTextWidget();
        if (styledText != null) {
            int n = styledText.getCaretOffset();
            int n2 = lineBackgroundEvent.lineText.length();
            if (lineBackgroundEvent.lineOffset <= n && n <= lineBackgroundEvent.lineOffset + n2 && !this.hasMultiLineSelection(styledText)) {
                lineBackgroundEvent.lineBackground = this.fHighlightColor;
            }
        }
    }

    private boolean updateHighlightLine() {
        try {
            IDocument iDocument = this.fViewer.getDocument();
            int n = this.getModelCaret();
            int n2 = iDocument.getLineOfOffset(n);
            if (n2 != this.fLastLineNumber || !this.fCurrentLine.overlapsWith(n, 0)) {
                this.fLastLine.offset = this.fCurrentLine.offset;
                this.fLastLine.length = this.fCurrentLine.length;
                this.fLastLine.isDeleted = this.fCurrentLine.isDeleted;
                if (this.fCurrentLine.isDeleted) {
                    this.fCurrentLine.isDeleted = false;
                    this.fPositionManager.managePosition(this.fCurrentLine);
                }
                this.fCurrentLine.offset = iDocument.getLineOffset(n2);
                this.fCurrentLine.length = n2 == iDocument.getNumberOfLines() - 1 ? iDocument.getLength() - this.fCurrentLine.offset : iDocument.getLineOffset(n2 + 1) - this.fCurrentLine.offset;
                this.fLastLineNumber = n2;
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private int getModelCaret() {
        int n = this.fViewer.getTextWidget().getCaretOffset();
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fViewer);
            return iTextViewerExtension5.widgetOffset2ModelOffset(n);
        }
        IRegion iRegion = this.fViewer.getVisibleRegion();
        return n + iRegion.getOffset();
    }

    private void drawHighlightLine(Position position) {
        ITextViewerExtension5 iTextViewerExtension5;
        if (position.isDeleted()) {
            return;
        }
        int n = 0;
        if (this.fViewer instanceof ITextViewerExtension5) {
            iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fViewer);
            n = iTextViewerExtension5.modelOffset2WidgetOffset(position.getOffset());
            if (n == -1) {
                return;
            }
        } else {
            iTextViewerExtension5 = this.fViewer.getVisibleRegion();
            n = position.getOffset() - iTextViewerExtension5.getOffset();
            if (n < 0 || iTextViewerExtension5.getLength() < n) {
                return;
            }
        }
        iTextViewerExtension5 = this.fViewer.getTextWidget();
        if (n >= 0 && n <= iTextViewerExtension5.getCharCount()) {
            Point point = iTextViewerExtension5.getLocationAtOffset(n);
            int n2 = iTextViewerExtension5.getClientArea().width + iTextViewerExtension5.getHorizontalPixel();
            int n3 = iTextViewerExtension5.getLineHeight(n);
            iTextViewerExtension5.redraw(0, point.y, n2, n3, false);
        }
    }

    @Override
    public void deactivate(boolean bl) {
        if (this.fIsActive) {
            this.fIsActive = false;
            if (bl) {
                this.drawHighlightLine(this.fCurrentLine);
            }
            this.fViewer.getTextWidget().removeLineBackgroundListener((LineBackgroundListener)this);
            if (this.fPositionManager != null) {
                this.fPositionManager.unmanagePosition(this.fCurrentLine);
            }
            this.fLastLineNumber = -1;
            this.fCurrentLine.offset = 0;
            this.fCurrentLine.length = 0;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void paint(int n) {
        if (this.fViewer.getDocument() == null) {
            this.deactivate(false);
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        if (this.hasMultiLineSelection(styledText)) {
            this.deactivate(true);
            return;
        }
        if (!this.fIsActive) {
            styledText.addLineBackgroundListener((LineBackgroundListener)this);
            this.fPositionManager.managePosition(this.fCurrentLine);
            this.fIsActive = true;
        }
        if (this.updateHighlightLine()) {
            this.drawHighlightLine(this.fLastLine);
            this.drawHighlightLine(this.fCurrentLine);
        }
    }

    private boolean hasMultiLineSelection(StyledText styledText) {
        Point point = styledText.getSelection();
        try {
            int n = styledText.getLineAtOffset(point.x);
            int n2 = styledText.getLineAtOffset(point.y);
            return n != n2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void setPositionManager(IPaintPositionManager iPaintPositionManager) {
        this.fPositionManager = iPaintPositionManager;
    }
}

