/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.SelectionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IBlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;

public class BlockTextSelection
extends TextSelection
implements IBlockTextSelection {
    private final int fStartLine;
    private final int fStartColumn;
    private final int fEndLine;
    private final int fEndColumn;
    private final int fTabWidth;

    public BlockTextSelection(IDocument iDocument, int n, int n2, int n3, int n4, int n5) {
        super(iDocument, BlockTextSelection.computeOffset(iDocument, n, n2), BlockTextSelection.computeOffset(iDocument, n3, n4) - BlockTextSelection.computeOffset(iDocument, n, n2));
        Assert.isLegal((n >= 0 ? 1 : 0) != 0);
        Assert.isLegal((n2 >= 0 ? 1 : 0) != 0);
        Assert.isLegal((n3 >= n ? 1 : 0) != 0);
        Assert.isLegal((n4 >= 0 ? 1 : 0) != 0);
        Assert.isLegal((n5 >= 0 ? 1 : 0) != 0);
        this.fStartLine = n;
        this.fStartColumn = n2;
        this.fEndLine = n3;
        this.fEndColumn = n4;
        this.fTabWidth = n5 > 0 ? n5 : 8;
    }

    private static int computeOffset(IDocument iDocument, int n, int n2) {
        try {
            IRegion iRegion = iDocument.getLineInformation(n);
            int n3 = Math.min(n2, iRegion.getLength());
            return iRegion.getOffset() + n3;
        }
        catch (BadLocationException badLocationException) {
            if (n < 0) {
                return 0;
            }
            return iDocument.getLength();
        }
    }

    @Override
    public int getStartLine() {
        return this.fStartLine;
    }

    @Override
    public int getStartColumn() {
        return this.fStartColumn;
    }

    @Override
    public int getEndLine() {
        return this.fEndLine;
    }

    @Override
    public int getEndColumn() {
        return this.fEndColumn;
    }

    @Override
    public String getText() {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            try {
                return new SelectionProcessor(iDocument, this.fTabWidth).getText(this);
            }
            catch (BadLocationException badLocationException) {}
        }
        return super.getText();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.fEndColumn;
        n = 31 * n + this.fEndLine;
        n = 31 * n + this.fStartColumn;
        n = 31 * n + this.fStartLine;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        BlockTextSelection blockTextSelection = (BlockTextSelection)object;
        if (this.fEndColumn != blockTextSelection.fEndColumn) {
            return false;
        }
        if (this.fEndLine != blockTextSelection.fEndLine) {
            return false;
        }
        if (this.fStartColumn != blockTextSelection.fStartColumn) {
            return false;
        }
        return this.fStartLine == blockTextSelection.fStartLine;
    }

    @Override
    public IRegion[] getRegions() {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            try {
                return new SelectionProcessor(iDocument, this.fTabWidth).getRanges(this);
            }
            catch (BadLocationException badLocationException) {}
        }
        return new IRegion[]{new Region(this.getOffset(), this.getLength())};
    }
}

