/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.internal.text.InternalAccessor;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlCreatorExtension;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;

public abstract class AbstractInformationControlManager {
    private static final Anchor[] ANCHORS = new Anchor[]{new Anchor(128), new Anchor(1024), new Anchor(16384), new Anchor(131072)};
    public static final Anchor ANCHOR_TOP = ANCHORS[0];
    public static final Anchor ANCHOR_BOTTOM = ANCHORS[1];
    public static final Anchor ANCHOR_LEFT = ANCHORS[2];
    public static final Anchor ANCHOR_RIGHT = ANCHORS[3];
    public static final Anchor ANCHOR_GLOBAL = new Anchor(0x1000000);
    public static final String STORE_LOCATION_X = "location.x";
    public static final String STORE_LOCATION_Y = "location.y";
    public static final String STORE_SIZE_WIDTH = "size.width";
    public static final String STORE_SIZE_HEIGHT = "size.height";
    protected static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text/debug/AbstractInformationControlManager"));
    private Control fSubjectControl;
    private Rectangle fSubjectArea;
    private Object fInformation;
    private boolean fTakesFocusWhenVisible = false;
    protected IInformationControl fInformationControl;
    protected IInformationControlCreator fInformationControlCreator;
    protected IInformationControlCloser fInformationControlCloser;
    protected boolean fDisposed = false;
    private InformationControlReplacer fInformationControlReplacer;
    private boolean fEnabled = false;
    private Point fSizeConstraints;
    private int fMarginY = 5;
    private int fMarginX = 5;
    private int fWidthConstraint = 60;
    private int fHeightConstraint = 6;
    private boolean fEnforceAsMinimalSize = false;
    private boolean fEnforceAsMaximalSize = false;
    private Anchor fAnchor = ANCHOR_BOTTOM;
    private Anchor[] fFallbackAnchors = ANCHORS;
    private volatile IInformationControlCreator fCustomInformationControlCreator;
    private boolean fIsCustomInformationControl = false;
    private IDialogSettings fDialogSettings;
    private boolean fIsRestoringLocation;
    private boolean fIsRestoringSize;
    private DisposeListener fSubjectControlDisposeListener;

    protected AbstractInformationControlManager(IInformationControlCreator iInformationControlCreator) {
        Assert.isNotNull((Object)iInformationControlCreator);
        this.fInformationControlCreator = iInformationControlCreator;
    }

    protected abstract void computeInformation();

    protected final void setInformation(String string, Rectangle rectangle) {
        this.setInformation((Object)string, rectangle);
    }

    protected final void setInformation(Object object, Rectangle rectangle) {
        this.fInformation = object;
        this.fSubjectArea = rectangle;
        this.presentInformation();
    }

    protected void setCloser(IInformationControlCloser iInformationControlCloser) {
        this.fInformationControlCloser = iInformationControlCloser;
    }

    void setInformationControlReplacer(InformationControlReplacer informationControlReplacer) {
        if (this.fInformationControlReplacer != null) {
            this.fInformationControlReplacer.dispose();
        }
        this.fInformationControlReplacer = informationControlReplacer;
    }

    InformationControlReplacer getInformationControlReplacer() {
        return this.fInformationControlReplacer;
    }

    boolean hasInformationControlReplacer() {
        return this.fInformationControlReplacer != null;
    }

    boolean canReplace(IInformationControl iInformationControl) {
        return iInformationControl instanceof IInformationControlExtension3 && iInformationControl instanceof IInformationControlExtension5 && ((IInformationControlExtension5)((Object)iInformationControl)).getInformationPresenterControlCreator() != null;
    }

    IInformationControl getCurrentInformationControl() {
        return this.fInformationControl;
    }

    boolean isReplaceInProgress() {
        return this.fInformationControlReplacer != null && this.fInformationControlReplacer.isReplacing();
    }

    public void setMargins(int n, int n2) {
        this.fMarginX = n;
        this.fMarginY = n2;
    }

    public void setSizeConstraints(int n, int n2, boolean bl, boolean bl2) {
        this.fSizeConstraints = null;
        this.fWidthConstraint = n;
        this.fHeightConstraint = n2;
        this.fEnforceAsMinimalSize = bl;
        this.fEnforceAsMaximalSize = bl2;
    }

    public void setRestoreInformationControlBounds(IDialogSettings iDialogSettings, boolean bl, boolean bl2) {
        Assert.isTrue((iDialogSettings != null && (bl || bl2) ? 1 : 0) != 0);
        this.fDialogSettings = iDialogSettings;
        this.fIsRestoringLocation = bl;
        this.fIsRestoringSize = bl2;
    }

    public void setAnchor(Anchor anchor) {
        this.fAnchor = anchor;
    }

    public void setFallbackAnchors(Anchor[] anchorArray) {
        if (anchorArray != null) {
            this.fFallbackAnchors = new Anchor[anchorArray.length];
            System.arraycopy(anchorArray, 0, this.fFallbackAnchors, 0, anchorArray.length);
        } else {
            this.fFallbackAnchors = null;
        }
    }

    protected void setCustomInformationControlCreator(IInformationControlCreator iInformationControlCreator) {
        IInformationControlCreatorExtension iInformationControlCreatorExtension;
        if (iInformationControlCreator != null && this.fCustomInformationControlCreator instanceof IInformationControlCreatorExtension && (iInformationControlCreatorExtension = (IInformationControlCreatorExtension)((Object)this.fCustomInformationControlCreator)).canReplace(iInformationControlCreator)) {
            return;
        }
        this.fCustomInformationControlCreator = iInformationControlCreator;
    }

    public void takesFocusWhenVisible(boolean bl) {
        this.fTakesFocusWhenVisible = bl;
    }

    protected boolean isTakingFocusWhenVisible() {
        return this.fTakesFocusWhenVisible;
    }

    protected void handleSubjectControlDisposed() {
        this.disposeInformationControl();
    }

    public void install(Control control) {
        if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed() && this.fSubjectControlDisposeListener != null) {
            this.fSubjectControl.removeDisposeListener(this.fSubjectControlDisposeListener);
        }
        this.fSubjectControl = control;
        if (this.fSubjectControl != null) {
            this.fSubjectControl.addDisposeListener(this.getSubjectControlDisposeListener());
        }
        if (this.fInformationControlCloser != null) {
            this.fInformationControlCloser.setSubjectControl(control);
        }
        this.setEnabled(true);
        this.fDisposed = false;
    }

    private DisposeListener getSubjectControlDisposeListener() {
        if (this.fSubjectControlDisposeListener == null) {
            this.fSubjectControlDisposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    AbstractInformationControlManager.this.handleSubjectControlDisposed();
                }
            };
        }
        return this.fSubjectControlDisposeListener;
    }

    protected Control getSubjectControl() {
        return this.fSubjectControl;
    }

    protected Rectangle getSubjectArea() {
        return this.fSubjectArea;
    }

    public void setEnabled(boolean bl) {
        this.fEnabled = bl;
    }

    protected boolean isEnabled() {
        return this.fEnabled;
    }

    protected Point computeSizeConstraints(Control control, IInformationControl iInformationControl) {
        if (this.fSizeConstraints == null) {
            IInformationControlExtension5 iInformationControlExtension5;
            if (iInformationControl instanceof IInformationControlExtension5) {
                iInformationControlExtension5 = (IInformationControlExtension5)((Object)iInformationControl);
                this.fSizeConstraints = iInformationControlExtension5.computeSizeConstraints(this.fWidthConstraint, this.fHeightConstraint);
                if (this.fSizeConstraints != null) {
                    return Geometry.copy((Point)this.fSizeConstraints);
                }
            }
            if (control == null) {
                return null;
            }
            iInformationControlExtension5 = new GC((Drawable)control);
            iInformationControlExtension5.setFont(control.getFont());
            int n = iInformationControlExtension5.getFontMetrics().getAverageCharWidth();
            int n2 = iInformationControlExtension5.getFontMetrics().getHeight();
            iInformationControlExtension5.dispose();
            this.fSizeConstraints = new Point(this.fWidthConstraint * n, this.fHeightConstraint * n2);
        }
        return new Point(this.fSizeConstraints.x, this.fSizeConstraints.y);
    }

    protected Point computeSizeConstraints(Control control, Rectangle rectangle, IInformationControl iInformationControl) {
        return this.computeSizeConstraints(control, iInformationControl);
    }

    protected void handleInformationControlDisposed() {
        this.storeInformationControlBounds();
        if (this.fInformationControl instanceof IInformationControlExtension5) {
            this.fSizeConstraints = null;
        }
        this.fInformationControl = null;
        if (this.fInformationControlCloser != null) {
            this.fInformationControlCloser.setInformationControl(null);
            this.fInformationControlCloser.stop();
        }
    }

    protected IInformationControl getInformationControl() {
        if (this.fDisposed) {
            return this.fInformationControl;
        }
        IInformationControlCreator iInformationControlCreator = null;
        if (this.fCustomInformationControlCreator == null) {
            iInformationControlCreator = this.fInformationControlCreator;
            if (this.fIsCustomInformationControl && this.fInformationControl != null) {
                if (this.fInformationControl instanceof IInformationControlExtension5) {
                    this.fSizeConstraints = null;
                }
                this.fInformationControl.dispose();
                this.fInformationControl = null;
            }
            this.fIsCustomInformationControl = false;
        } else {
            iInformationControlCreator = this.fCustomInformationControlCreator;
            if (iInformationControlCreator instanceof IInformationControlCreatorExtension) {
                IInformationControlCreatorExtension iInformationControlCreatorExtension = (IInformationControlCreatorExtension)((Object)iInformationControlCreator);
                if (this.fInformationControl != null && iInformationControlCreatorExtension.canReuse(this.fInformationControl)) {
                    return this.fInformationControl;
                }
            }
            if (this.fInformationControl != null) {
                if (this.fInformationControl instanceof IInformationControlExtension5) {
                    this.fSizeConstraints = null;
                }
                this.fInformationControl.dispose();
                this.fInformationControl = null;
            }
            this.fIsCustomInformationControl = true;
        }
        if (this.fInformationControl == null) {
            this.fInformationControl = iInformationControlCreator.createInformationControl(this.fSubjectControl.getShell());
            this.fInformationControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    AbstractInformationControlManager.this.handleInformationControlDisposed();
                }
            });
            if (this.fInformationControlCloser != null) {
                this.fInformationControlCloser.setInformationControl(this.fInformationControl);
            }
        }
        return this.fInformationControl;
    }

    protected Point computeLocation(Rectangle rectangle, Point point, Anchor anchor) {
        boolean bl;
        int n = 0;
        int n2 = 0;
        switch (anchor.getSWTFlag()) {
            case 0x1000000: {
                Point point2 = this.fSubjectControl.getSize();
                Point point3 = new Point(point2.x / 2, point2.y / 2);
                point3.x -= point.x / 2;
                point3.y -= point.y / 2;
                return this.fSubjectControl.toDisplay(point3);
            }
            case 1024: {
                n2 = rectangle.height + this.fMarginY;
                break;
            }
            case 131072: {
                n = this.fMarginX + rectangle.width;
                break;
            }
            case 128: {
                n2 = -point.y - this.fMarginY;
                break;
            }
            case 16384: {
                n = -point.x - this.fMarginX;
            }
        }
        boolean bl2 = bl = this.fSubjectControl != null && (this.fSubjectControl.getStyle() & 0x4000000) != 0;
        if (bl) {
            n += point.x;
        }
        return this.fSubjectControl.toDisplay(new Point(rectangle.x + n, rectangle.y + n2));
    }

    protected Rectangle computeAvailableArea(Rectangle rectangle, Rectangle rectangle2, Anchor anchor) {
        Rectangle rectangle3;
        switch (anchor.getSWTFlag()) {
            case 0x1000000: {
                rectangle3 = rectangle2;
                break;
            }
            case 1024: {
                int n = rectangle.y + rectangle.height + this.fMarginY;
                rectangle3 = new Rectangle(rectangle2.x, n, rectangle2.width, rectangle2.y + rectangle2.height - n);
                break;
            }
            case 131072: {
                int n = rectangle.x + rectangle.width + this.fMarginX;
                rectangle3 = new Rectangle(n, rectangle2.y, rectangle2.x + rectangle2.width - n, rectangle2.height);
                break;
            }
            case 128: {
                rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle.y - rectangle2.y - this.fMarginY);
                break;
            }
            case 16384: {
                rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle.x - rectangle2.x - this.fMarginX, rectangle2.height);
                break;
            }
            default: {
                Assert.isLegal((boolean)false);
                return null;
            }
        }
        rectangle3.intersect(rectangle2);
        return rectangle3;
    }

    protected boolean updateLocation(Point point, Point point2, Rectangle rectangle, Anchor anchor) {
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = point.x + point2.x;
        int n4 = point.y + point2.y;
        if (ANCHOR_BOTTOM == anchor || ANCHOR_TOP == anchor) {
            if (ANCHOR_BOTTOM == anchor ? n4 > n2 : point.y < rectangle.y) {
                return false;
            }
            if (n3 > n) {
                point.x -= n3 - n;
            }
            return point.x >= rectangle.x && point.y >= rectangle.y;
        }
        if (ANCHOR_RIGHT == anchor || ANCHOR_LEFT == anchor) {
            if (ANCHOR_RIGHT == anchor ? n3 > n : point.x < rectangle.x) {
                return false;
            }
            if (n4 > n2) {
                point.y -= n4 - n2;
            }
            return point.x >= rectangle.x && point.y >= rectangle.y;
        }
        if (ANCHOR_GLOBAL == anchor) {
            if (n3 > n) {
                point.x -= n3 - n;
            }
            if (n4 > n2) {
                point.y -= n4 - n2;
            }
            return point.x >= rectangle.x && point.y >= rectangle.y;
        }
        return false;
    }

    protected Anchor getNextFallbackAnchor(Anchor anchor) {
        if (anchor == null || this.fFallbackAnchors == null) {
            return null;
        }
        int n = 0;
        while (n < this.fFallbackAnchors.length) {
            if (this.fFallbackAnchors[n] == anchor) {
                return this.fFallbackAnchors[n + 1 == this.fFallbackAnchors.length ? 0 : n + 1];
            }
            ++n;
        }
        return null;
    }

    protected Point computeInformationControlLocation(Rectangle rectangle, Point point) {
        Rectangle rectangle2 = Geometry.toDisplay((Control)this.fSubjectControl, (Rectangle)rectangle);
        Anchor anchor = this.fAnchor;
        Rectangle rectangle3 = null;
        int n = Integer.MIN_VALUE;
        Anchor anchor2 = null;
        do {
            Monitor monitor;
            Point point2;
            if (this.updateLocation(point2 = this.computeLocation(rectangle, point, anchor), point, (monitor = this.getClosestMonitor(rectangle2, anchor)).getClientArea(), anchor)) {
                return point2;
            }
            Rectangle rectangle4 = this.computeAvailableArea(rectangle2, monitor.getClientArea(), anchor);
            Rectangle rectangle5 = new Rectangle(point2.x, point2.y, point.x, point.y);
            rectangle4.intersect(rectangle5);
            int n2 = rectangle4.width * rectangle4.height;
            if (n2 <= n) continue;
            n = n2;
            rectangle3 = rectangle4;
            anchor2 = anchor;
        } while ((anchor = this.getNextFallbackAnchor(anchor)) != this.fAnchor && anchor != null);
        if (anchor2 != ANCHOR_GLOBAL) {
            Geometry.set((Point)point, (Point)Geometry.getSize((Rectangle)rectangle3));
        }
        return Geometry.getLocation((Rectangle)rectangle3);
    }

    private Monitor getClosestMonitor(Rectangle rectangle, Anchor anchor) {
        Point point = ANCHOR_GLOBAL == anchor ? Geometry.centerPoint((Rectangle)rectangle) : Geometry.centerPoint((Rectangle)Geometry.getExtrudedEdge((Rectangle)rectangle, (int)0, (int)anchor.getSWTFlag()));
        return this.getClosestMonitor(this.fSubjectControl.getDisplay(), Geometry.createRectangle((Point)point, (Point)new Point(0, 0)));
    }

    private Monitor getClosestMonitor(Display display, Rectangle rectangle) {
        int n = Integer.MAX_VALUE;
        Point point = Geometry.centerPoint((Rectangle)rectangle);
        Monitor[] monitorArray = display.getMonitors();
        Monitor monitor = monitorArray[0];
        int n2 = 0;
        while (n2 < monitorArray.length) {
            Monitor monitor2 = monitorArray[n2];
            Rectangle rectangle2 = monitor2.getClientArea();
            if (rectangle2.contains(point)) {
                return monitor2;
            }
            int n3 = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)rectangle2), (Point)point);
            if (n3 < n) {
                n = n3;
                monitor = monitor2;
            }
            ++n2;
        }
        return monitor;
    }

    public void showInformation() {
        if (this.fEnabled) {
            this.doShowInformation();
        }
    }

    protected void doShowInformation() {
        this.fSubjectArea = null;
        this.fInformation = null;
        this.computeInformation();
    }

    protected void presentInformation() {
        boolean bl = false;
        if (this.fInformation instanceof String) {
            bl = ((String)this.fInformation).trim().length() > 0;
        } else {
            boolean bl2 = bl = this.fInformation != null;
        }
        if (this.fSubjectArea != null && bl) {
            this.internalShowInformationControl(this.fSubjectArea, this.fInformation);
        } else {
            this.hideInformationControl();
        }
    }

    private void internalShowInformationControl(Rectangle rectangle, Object object) {
        if (this instanceof InformationControlReplacer) {
            ((InformationControlReplacer)this).showInformationControl(rectangle, object);
            return;
        }
        IInformationControl iInformationControl = this.getInformationControl();
        if (iInformationControl != null) {
            Rectangle rectangle2;
            Object object2;
            Point point = this.computeSizeConstraints(this.fSubjectControl, this.fSubjectArea, iInformationControl);
            if (iInformationControl instanceof IInformationControlExtension3) {
                object2 = (IInformationControlExtension3)((Object)iInformationControl);
                rectangle2 = object2.computeTrim();
                point.x += rectangle2.width;
                point.y += rectangle2.height;
            }
            iInformationControl.setSizeConstraints(point.x, point.y);
            if (iInformationControl instanceof IInformationControlExtension2) {
                ((IInformationControlExtension2)((Object)iInformationControl)).setInput(object);
            } else {
                iInformationControl.setInformation(object.toString());
            }
            if (iInformationControl instanceof IInformationControlExtension && !(object2 = (IInformationControlExtension)((Object)iInformationControl)).hasContents()) {
                return;
            }
            object2 = null;
            rectangle2 = null;
            Rectangle rectangle3 = this.restoreInformationControlBounds();
            if (rectangle3 != null) {
                if (rectangle3.x > -1 && rectangle3.y > -1) {
                    rectangle2 = Geometry.getLocation((Rectangle)rectangle3);
                }
                if (rectangle3.width > -1 && rectangle3.height > -1) {
                    object2 = Geometry.getSize((Rectangle)rectangle3);
                }
            }
            if (object2 == null) {
                object2 = iInformationControl.computeSizeHint();
            }
            if (this.fEnforceAsMinimalSize) {
                object2 = Geometry.max((Point)object2, (Point)point);
            }
            if (this.fEnforceAsMaximalSize) {
                object2 = Geometry.min((Point)object2, (Point)point);
            }
            if (rectangle2 == null) {
                rectangle2 = this.computeInformationControlLocation(rectangle, (Point)object2);
            }
            Rectangle rectangle4 = Geometry.createRectangle((Point)rectangle2, (Point)object2);
            this.cropToClosestMonitor(rectangle4);
            rectangle2 = Geometry.getLocation((Rectangle)rectangle4);
            object2 = Geometry.getSize((Rectangle)rectangle4);
            iInformationControl.setLocation((Point)rectangle2);
            iInformationControl.setSize(((Point)object2).x, ((Point)object2).y);
            this.showInformationControl(rectangle);
        }
    }

    void cropToClosestMonitor(Rectangle rectangle) {
        Rectangle rectangle2 = this.getClosestMonitor(this.fSubjectControl.getDisplay(), rectangle).getClientArea();
        rectangle.intersect(rectangle2);
    }

    protected void hideInformationControl() {
        if (this.fInformationControl != null) {
            this.storeInformationControlBounds();
            this.fInformationControl.setVisible(false);
            if (this.fInformationControlCloser != null) {
                this.fInformationControlCloser.stop();
            }
        }
        if (this.canClearDataOnHide()) {
            this.fSubjectArea = null;
            this.fInformation = null;
        }
    }

    protected boolean canClearDataOnHide() {
        return true;
    }

    protected void showInformationControl(Rectangle rectangle) {
        this.fInformationControl.setVisible(true);
        if (this.fInformationControl == null) {
            return;
        }
        if (this.fTakesFocusWhenVisible) {
            this.fInformationControl.setFocus();
        }
        if (this.fInformationControlCloser != null) {
            this.fInformationControlCloser.start(rectangle);
        }
    }

    void replaceInformationControl(boolean bl) {
        if (this.fInformationControlReplacer != null && this.canReplace(this.fInformationControl)) {
            IInformationControlExtension3 iInformationControlExtension3 = (IInformationControlExtension3)((Object)this.fInformationControl);
            Rectangle rectangle = iInformationControlExtension3.getBounds();
            Rectangle rectangle2 = iInformationControlExtension3.computeTrim();
            Rectangle rectangle3 = new Rectangle(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y, rectangle.width - rectangle2.width, rectangle.height - rectangle2.height);
            IInformationControlCreator iInformationControlCreator = ((IInformationControlExtension5)((Object)this.fInformationControl)).getInformationPresenterControlCreator();
            this.fInformationControlReplacer.replaceInformationControl(iInformationControlCreator, rectangle3, this.fInformation, this.fSubjectArea, bl);
        }
        this.hideInformationControl();
    }

    public void disposeInformationControl() {
        if (this.fInformationControl != null) {
            this.fInformationControl.dispose();
            this.handleInformationControlDisposed();
        }
    }

    public void dispose() {
        if (!this.fDisposed) {
            this.fDisposed = true;
            this.setEnabled(false);
            this.disposeInformationControl();
            if (this.fInformationControlReplacer != null) {
                this.fInformationControlReplacer.dispose();
                this.fInformationControlReplacer = null;
            }
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed() && this.fSubjectControlDisposeListener != null) {
                this.fSubjectControl.removeDisposeListener(this.fSubjectControlDisposeListener);
            }
            this.fSubjectControl = null;
            this.fSubjectControlDisposeListener = null;
            this.fIsCustomInformationControl = false;
            this.fCustomInformationControlCreator = null;
            this.fInformationControlCreator = null;
            this.fInformationControlCloser = null;
        }
    }

    protected void storeInformationControlBounds() {
        if (this.fDialogSettings == null || this.fInformationControl == null || !this.fIsRestoringLocation && !this.fIsRestoringSize) {
            return;
        }
        if (!(this.fInformationControl instanceof IInformationControlExtension3)) {
            throw new UnsupportedOperationException();
        }
        boolean bl = ((IInformationControlExtension3)((Object)this.fInformationControl)).restoresSize();
        boolean bl2 = ((IInformationControlExtension3)((Object)this.fInformationControl)).restoresLocation();
        Rectangle rectangle = ((IInformationControlExtension3)((Object)this.fInformationControl)).getBounds();
        if (rectangle == null) {
            return;
        }
        if (this.fIsRestoringSize && bl) {
            this.fDialogSettings.put(STORE_SIZE_WIDTH, rectangle.width);
            this.fDialogSettings.put(STORE_SIZE_HEIGHT, rectangle.height);
        }
        if (this.fIsRestoringLocation && bl2) {
            this.fDialogSettings.put(STORE_LOCATION_X, rectangle.x);
            this.fDialogSettings.put(STORE_LOCATION_Y, rectangle.y);
        }
    }

    protected Rectangle restoreInformationControlBounds() {
        if (this.fDialogSettings == null || !this.fIsRestoringLocation && !this.fIsRestoringSize) {
            return null;
        }
        if (!(this.fInformationControl instanceof IInformationControlExtension3)) {
            throw new UnsupportedOperationException();
        }
        boolean bl = ((IInformationControlExtension3)((Object)this.fInformationControl)).restoresSize();
        boolean bl2 = ((IInformationControlExtension3)((Object)this.fInformationControl)).restoresLocation();
        Rectangle rectangle = new Rectangle(-1, -1, -1, -1);
        if (this.fIsRestoringSize && bl) {
            try {
                rectangle.width = this.fDialogSettings.getInt(STORE_SIZE_WIDTH);
                rectangle.height = this.fDialogSettings.getInt(STORE_SIZE_HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {
                rectangle.width = -1;
                rectangle.height = -1;
            }
        }
        if (this.fIsRestoringLocation && bl2) {
            try {
                rectangle.x = this.fDialogSettings.getInt(STORE_LOCATION_X);
                rectangle.y = this.fDialogSettings.getInt(STORE_LOCATION_Y);
            }
            catch (NumberFormatException numberFormatException) {
                rectangle.x = -1;
                rectangle.y = -1;
            }
        }
        if (rectangle.x == -1 && rectangle.y == -1 && rectangle.width == -1 && rectangle.height == -1) {
            return null;
        }
        Rectangle rectangle2 = null;
        if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
            rectangle2 = this.fSubjectControl.getDisplay().getBounds();
        } else {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display != null && !display.isDisposed()) {
                rectangle2 = display.getBounds();
            }
        }
        if (rectangle.width > -1 && rectangle.height > -1) {
            if (rectangle2 != null) {
                rectangle.width = Math.min(rectangle.width, rectangle2.width);
                rectangle.height = Math.min(rectangle.height, rectangle2.height);
            }
            rectangle.width = Math.max(rectangle.width, 30);
            rectangle.height = Math.max(rectangle.height, 30);
        }
        if (rectangle.x > -1 && rectangle.y > -1 && rectangle2 != null) {
            rectangle.x = Math.max(rectangle.x, rectangle2.x);
            rectangle.y = Math.max(rectangle.y, rectangle2.y);
            if (rectangle.width > -1 && rectangle.height > -1) {
                rectangle.x = Math.min(rectangle.x, rectangle2.width - rectangle.width);
                rectangle.y = Math.min(rectangle.y, rectangle2.height - rectangle.height);
            }
        }
        return rectangle;
    }

    public InternalAccessor getInternalAccessor() {
        return new MyInternalAccessor();
    }

    public static final class Anchor {
        private final int fFlag;

        private Anchor(int n) {
            this.fFlag = n;
        }

        int getSWTFlag() {
            return this.fFlag;
        }

        public String toString() {
            switch (this.fFlag) {
                case 1024: {
                    return "BOTTOM";
                }
                case 128: {
                    return "TOP";
                }
                case 16384: {
                    return "LEFT";
                }
                case 131072: {
                    return "RIGHT";
                }
                case 0x1000000: {
                    return "CENTER";
                }
            }
            return Integer.toHexString(this.fFlag);
        }
    }

    public static interface IInformationControlCloser {
        public void setSubjectControl(Control var1);

        public void setInformationControl(IInformationControl var1);

        public void start(Rectangle var1);

        public void stop();
    }

    class MyInternalAccessor
    extends InternalAccessor {
        MyInternalAccessor() {
        }

        @Override
        public IInformationControl getCurrentInformationControl() {
            return AbstractInformationControlManager.this.getCurrentInformationControl();
        }

        @Override
        public void setInformationControlReplacer(InformationControlReplacer informationControlReplacer) {
            AbstractInformationControlManager.this.setInformationControlReplacer(informationControlReplacer);
        }

        @Override
        public InformationControlReplacer getInformationControlReplacer() {
            return AbstractInformationControlManager.this.getInformationControlReplacer();
        }

        @Override
        public boolean canReplace(IInformationControl iInformationControl) {
            return AbstractInformationControlManager.this.canReplace(iInformationControl);
        }

        @Override
        public boolean isReplaceInProgress() {
            return AbstractInformationControlManager.this.isReplaceInProgress();
        }

        @Override
        public void replaceInformationControl(boolean bl) {
            AbstractInformationControlManager.this.replaceInformationControl(bl);
        }

        @Override
        public void cropToClosestMonitor(Rectangle rectangle) {
            AbstractInformationControlManager.this.cropToClosestMonitor(rectangle);
        }

        @Override
        public void setHoverEnrichMode(ITextViewerExtension8.EnrichMode enrichMode) {
            throw new UnsupportedOperationException("only implemented in AbstractHoverInformationControlManager");
        }

        @Override
        public boolean getAllowMouseExit() {
            throw new UnsupportedOperationException("only implemented in AnnotationBarHoverManager");
        }
    }
}

