/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.revisions.Colors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.ToolBar;

public abstract class AbstractInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
IInformationControlExtension4,
IInformationControlExtension5 {
    private final Shell fShell;
    private final Composite fContentComposite;
    private final boolean fResizable;
    private Composite fStatusComposite;
    private Label fSeparator;
    private Label fStatusLabel;
    private Font fStatusLabelFont;
    private Color fStatusLabelForeground;
    private final ToolBarManager fToolBarManager;
    private ToolBar fToolBar;
    private Listener fShellListener;
    private final ListenerList fFocusListeners = new ListenerList(1);
    private Point fSizeConstraints;
    private int fResizeHandleSize;

    public AbstractInformationControl(Shell shell, String string) {
        this(shell, 16388, string, null);
    }

    public AbstractInformationControl(Shell shell, ToolBarManager toolBarManager) {
        this(shell, 16404, null, toolBarManager);
    }

    public AbstractInformationControl(Shell shell, boolean bl) {
        this(shell, 0x4004 | (bl ? 16 : 0), null, null);
    }

    AbstractInformationControl(Shell shell, int n, String string, ToolBarManager toolBarManager) {
        Assert.isTrue((string == null || toolBarManager == null ? 1 : 0) != 0);
        this.fResizeHandleSize = -1;
        this.fToolBarManager = toolBarManager;
        if ((n & 8) != 0) {
            n &= 0xFFFFFB07;
        }
        this.fResizable = (n & 0x10) != 0;
        this.fShell = new Shell(shell, n);
        Display display = this.fShell.getDisplay();
        Color color = display.getSystemColor(28);
        Color color2 = display.getSystemColor(29);
        AbstractInformationControl.setColor((Control)this.fShell, color, color2);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.fShell.setLayout((Layout)gridLayout);
        this.fContentComposite = new Composite((Composite)this.fShell, 0);
        this.fContentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fContentComposite.setLayout((Layout)new FillLayout());
        AbstractInformationControl.setColor((Control)this.fContentComposite, color, color2);
        this.createStatusComposite(string, toolBarManager, color, color2);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AbstractInformationControl.this.handleDispose();
            }
        });
    }

    private void createStatusComposite(String string, ToolBarManager toolBarManager, Color color, Color color2) {
        if (toolBarManager == null && string == null) {
            return;
        }
        this.fStatusComposite = new Composite((Composite)this.fShell, 0);
        GridData gridData = new GridData(4, 1024, true, false);
        this.fStatusComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 1;
        this.fStatusComposite.setLayout((Layout)gridLayout);
        this.fSeparator = new Label(this.fStatusComposite, 258);
        this.fSeparator.setLayoutData((Object)new GridData(768));
        if (string != null) {
            this.createStatusLabel(string, color, color2);
        } else {
            this.createToolBar(toolBarManager);
        }
    }

    private void createStatusLabel(String string, Color color, Color color2) {
        this.fStatusLabel = new Label(this.fStatusComposite, 131072);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fStatusLabel.setText(string);
        FontData[] fontDataArray = JFaceResources.getDialogFont().getFontData();
        int n = 0;
        while (n < fontDataArray.length) {
            fontDataArray[n].setHeight(fontDataArray[n].getHeight() * 9 / 10);
            ++n;
        }
        this.fStatusLabelFont = new Font((Device)this.fStatusLabel.getDisplay(), fontDataArray);
        this.fStatusLabel.setFont(this.fStatusLabelFont);
        this.fStatusLabelForeground = new Color((Device)this.fStatusLabel.getDisplay(), Colors.blend(color2.getRGB(), color.getRGB(), 0.56f));
        AbstractInformationControl.setColor((Control)this.fStatusLabel, this.fStatusLabelForeground, color2);
        AbstractInformationControl.setColor((Control)this.fStatusComposite, color, color2);
    }

    private void createToolBar(ToolBarManager toolBarManager) {
        Composite composite = new Composite(this.fStatusComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.fToolBar = toolBarManager.createControl(composite);
        GridData gridData = new GridData(1, 1, false, false);
        this.fToolBar.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        composite2.setLayoutData((Object)gridData);
        this.addMoveSupport((Control)composite2);
        this.addResizeSupportIfNecessary(composite);
    }

    private void addResizeSupportIfNecessary(Composite composite) {
        String string = SWT.getPlatform();
        final boolean bl = string.equals("win32");
        if (!bl && !string.equals("gtk")) {
            return;
        }
        final Canvas canvas = new Canvas(composite, 0);
        int n = this.getResizeHandleSize(composite);
        GridData gridData = new GridData(0x1000008, 0x1000008, false, true);
        gridData.widthHint = n;
        gridData.heightHint = n;
        canvas.setLayoutData((Object)gridData);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Point point = canvas.getSize();
                int n = point.x - 2;
                int n2 = point.y - 2;
                int n3 = Math.min(n, n2);
                if (bl) {
                    int n4;
                    paintEvent.gc.setBackground(canvas.getDisplay().getSystemColor(20));
                    int n5 = n3 - 1;
                    int n6 = 0;
                    while (n6 <= 2) {
                        n4 = 0;
                        while (n4 <= 2 - n6) {
                            paintEvent.gc.fillRectangle(n5 - 4 * n6, n5 - 4 * n4, 2, 2);
                            ++n4;
                        }
                        ++n6;
                    }
                    --n5;
                    paintEvent.gc.setBackground(canvas.getDisplay().getSystemColor(18));
                    n6 = 0;
                    while (n6 <= 2) {
                        n4 = 0;
                        while (n4 <= 2 - n6) {
                            paintEvent.gc.fillRectangle(n5 - 4 * n6, n5 - 4 * n4, 2, 2);
                            ++n4;
                        }
                        ++n6;
                    }
                } else {
                    paintEvent.gc.setForeground(canvas.getDisplay().getSystemColor(18));
                    int n7 = 1;
                    while (n7 < n3) {
                        paintEvent.gc.drawLine(n7, n2, n, n7);
                        n7 += 4;
                    }
                    paintEvent.gc.setForeground(canvas.getDisplay().getSystemColor(20));
                    n7 = 2;
                    while (n7 < n3) {
                        paintEvent.gc.drawLine(n7, n2, n, n7);
                        n7 += 4;
                    }
                }
            }
        });
        final boolean bl2 = (canvas.getShell().getStyle() & 0x4000000) != 0;
        canvas.setCursor(canvas.getDisplay().getSystemCursor(bl2 ? 16 : 15));
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private MouseMoveListener fResizeListener;

            public void mouseDown(MouseEvent mouseEvent) {
                Rectangle rectangle = AbstractInformationControl.this.fShell.getBounds();
                final int n = rectangle.x;
                final int n2 = rectangle.y;
                final int n3 = rectangle.width;
                final int n4 = rectangle.height;
                Point point = canvas.toDisplay(mouseEvent.x, mouseEvent.y);
                final int n5 = point.x;
                final int n6 = point.y;
                this.fResizeListener = new MouseMoveListener(){

                    public void mouseMove(MouseEvent mouseEvent) {
                        Point point = canvas.toDisplay(mouseEvent.x, mouseEvent.y);
                        int n7 = point.x - n5;
                        int n22 = point.y - n6;
                        if (bl2) {
                            AbstractInformationControl.this.setLocation(new Point(n + n7, n2));
                            AbstractInformationControl.this.setSize(n3 - n7, n4 + n22);
                        } else {
                            AbstractInformationControl.this.setSize(n3 + n7, n4 + n22);
                        }
                    }
                };
                canvas.addMouseMoveListener(this.fResizeListener);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                canvas.removeMouseMoveListener(this.fResizeListener);
                this.fResizeListener = null;
            }
        };
        canvas.addMouseListener((MouseListener)mouseAdapter);
    }

    private int getResizeHandleSize(Composite composite) {
        if (this.fResizeHandleSize == -1) {
            Slider slider = new Slider(composite, 512);
            Slider slider2 = new Slider(composite, 256);
            int n = slider.computeSize((int)-1, (int)-1).x;
            int n2 = slider2.computeSize((int)-1, (int)-1).y;
            slider.dispose();
            slider2.dispose();
            this.fResizeHandleSize = Math.min(n, n2);
        }
        return this.fResizeHandleSize;
    }

    private void addMoveSupport(final Control control) {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private MouseMoveListener fMoveListener;

            public void mouseDown(MouseEvent mouseEvent) {
                Point point = AbstractInformationControl.this.fShell.getLocation();
                final int n = point.x;
                final int n2 = point.y;
                Point point2 = control.toDisplay(mouseEvent.x, mouseEvent.y);
                final int n3 = point2.x;
                final int n4 = point2.y;
                this.fMoveListener = new MouseMoveListener(){

                    public void mouseMove(MouseEvent mouseEvent) {
                        Point point = control.toDisplay(mouseEvent.x, mouseEvent.y);
                        int n5 = point.x - n3;
                        int n22 = point.y - n4;
                        AbstractInformationControl.this.fShell.setLocation(n + n5, n2 + n22);
                    }
                };
                control.addMouseMoveListener(this.fMoveListener);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                control.removeMouseMoveListener(this.fMoveListener);
                this.fMoveListener = null;
            }
        };
        control.addMouseListener((MouseListener)mouseAdapter);
    }

    private static void setColor(Control control, Color color, Color color2) {
        control.setForeground(color);
        control.setBackground(color2);
    }

    protected final Shell getShell() {
        return this.fShell;
    }

    protected final ToolBarManager getToolBarManager() {
        return this.fToolBarManager;
    }

    protected final void create() {
        this.createContent(this.fContentComposite);
    }

    protected abstract void createContent(Composite var1);

    @Override
    public void setInformation(String string) {
    }

    public boolean isResizable() {
        return this.fResizable;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.fShell.isVisible() == bl) {
            return;
        }
        this.fShell.setVisible(bl);
    }

    @Override
    public void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        }
    }

    protected void handleDispose() {
        if (this.fStatusLabelFont != null) {
            this.fStatusLabelFont.dispose();
            this.fStatusLabelFont = null;
        }
        if (this.fStatusLabelForeground != null) {
            this.fStatusLabelForeground.dispose();
            this.fStatusLabelForeground = null;
        }
    }

    @Override
    public void setSize(int n, int n2) {
        this.fShell.setSize(n, n2);
    }

    @Override
    public void setLocation(Point point) {
        this.fShell.setLocation(point);
    }

    @Override
    public void setSizeConstraints(int n, int n2) {
        this.fSizeConstraints = new Point(n, n2);
    }

    protected final Point getSizeConstraints() {
        return this.fSizeConstraints != null ? Geometry.copy((Point)this.fSizeConstraints) : null;
    }

    @Override
    public Point computeSizeHint() {
        Point point = this.getSizeConstraints();
        if (point == null) {
            return this.fShell.computeSize(-1, -1, true);
        }
        return this.fShell.computeSize(point.x, point.y, true);
    }

    @Override
    public Rectangle computeTrim() {
        Rectangle rectangle = this.fShell.computeTrim(0, 0, 0, 0);
        if (this.fStatusComposite != null) {
            rectangle.height += this.fStatusComposite.computeSize((int)-1, (int)-1).y;
        }
        return rectangle;
    }

    @Override
    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    @Override
    public boolean restoresLocation() {
        return false;
    }

    @Override
    public boolean restoresSize() {
        return false;
    }

    @Override
    public void addDisposeListener(DisposeListener disposeListener) {
        this.fShell.addDisposeListener(disposeListener);
    }

    @Override
    public void removeDisposeListener(DisposeListener disposeListener) {
        this.fShell.removeDisposeListener(disposeListener);
    }

    @Override
    public void setForegroundColor(Color color) {
        this.fContentComposite.setForeground(color);
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.fContentComposite.setBackground(color);
    }

    @Override
    public boolean isFocusControl() {
        return this.fShell.getDisplay().getActiveShell() == this.fShell;
    }

    @Override
    public void setFocus() {
        boolean bl = this.fShell.setFocus();
        if (!bl) {
            this.fShell.forceFocus();
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.fFocusListeners.isEmpty()) {
            this.fShellListener = new Listener(){

                public void handleEvent(Event event) {
                    Object[] objectArray = AbstractInformationControl.this.fFocusListeners.getListeners();
                    int n = 0;
                    while (n < objectArray.length) {
                        FocusListener focusListener = (FocusListener)objectArray[n];
                        if (event.type == 26) {
                            focusListener.focusGained(new FocusEvent(event));
                        } else {
                            focusListener.focusLost(new FocusEvent(event));
                        }
                        ++n;
                    }
                }
            };
            this.fShell.addListener(27, this.fShellListener);
            this.fShell.addListener(26, this.fShellListener);
        }
        this.fFocusListeners.add((Object)focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.fFocusListeners.remove((Object)focusListener);
        if (this.fFocusListeners.isEmpty()) {
            this.fShell.removeListener(26, this.fShellListener);
            this.fShell.removeListener(27, this.fShellListener);
            this.fShellListener = null;
        }
    }

    @Override
    public void setStatusText(String string) {
        if (this.fStatusLabel != null && !this.getShell().isVisible()) {
            if (string == null) {
                this.fStatusComposite.setVisible(false);
            } else {
                this.fStatusLabel.setText(string);
                this.fStatusComposite.setVisible(true);
            }
        }
    }

    @Override
    public boolean containsControl(Control control) {
        do {
            if (control == this.fShell) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.fShell != null && !this.fShell.isDisposed() && this.fShell.isVisible();
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        return null;
    }

    @Override
    public Point computeSizeConstraints(int n, int n2) {
        GC gC = new GC((Drawable)this.fContentComposite);
        gC.setFont(JFaceResources.getDialogFont());
        int n3 = gC.getFontMetrics().getAverageCharWidth();
        int n4 = gC.getFontMetrics().getHeight();
        gC.dispose();
        return new Point(n * n3, n2 * n4);
    }
}

