/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.internal.text.DelayedInputChangeListener;
import org.eclipse.jface.internal.text.InternalAccessor;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IDelayedInputChangeProvider;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public abstract class AbstractHoverInformationControlManager
extends AbstractInformationControlManager {
    private static final long HOVER_AUTO_REPLACING_DELAY = 200L;
    private MouseTracker fMouseTracker = new MouseTracker();
    private MouseEvent fHoverEvent = null;
    private int fHoverEventStateMask = 0;
    private Job fReplacingDelayJob;
    private ITextViewerExtension8.EnrichMode fEnrichMode;
    private boolean fWaitForMouseUp = false;

    protected AbstractHoverInformationControlManager(IInformationControlCreator iInformationControlCreator) {
        super(iInformationControlCreator);
        this.setCloser(new Closer());
        this.setHoverEnrichMode(ITextViewerExtension8.EnrichMode.AFTER_DELAY);
    }

    private boolean inKeepUpZone(int n, int n2, Control control, Rectangle rectangle, boolean bl) {
        if (rectangle.contains(n, n2)) {
            return true;
        }
        IInformationControl iInformationControl = this.getCurrentInformationControl();
        if (iInformationControl instanceof IInformationControlExtension5 && !((IInformationControlExtension5)((Object)iInformationControl)).isVisible()) {
            iInformationControl = null;
            if (this.getInformationControlReplacer() != null && (iInformationControl = this.getInformationControlReplacer().getCurrentInformationControl2()) instanceof IInformationControlExtension5 && !((IInformationControlExtension5)((Object)iInformationControl)).isVisible()) {
                return false;
            }
        }
        if (iInformationControl instanceof IInformationControlExtension3) {
            IInformationControlExtension3 iInformationControlExtension3 = (IInformationControlExtension3)((Object)iInformationControl);
            Rectangle rectangle2 = control.getDisplay().map(null, control, iInformationControlExtension3.getBounds());
            Rectangle rectangle3 = Geometry.copy((Rectangle)rectangle2);
            if (bl && this.isReplaceInProgress()) {
                int n3 = this.getInformationControlReplacer().getKeepUpMargin();
                Geometry.expand((Rectangle)rectangle3, (int)n3, (int)n3, (int)n3, (int)n3);
            }
            if (!bl) {
                if (rectangle2.contains(n, n2)) {
                    return true;
                }
                if (rectangle.y + rectangle.height < rectangle2.y) {
                    return rectangle.y + rectangle.height <= n2 && n2 <= rectangle3.y && rectangle.x <= n && n <= rectangle.x + rectangle.width;
                }
                if (rectangle2.x + rectangle2.width < rectangle.x) {
                    return rectangle2.x + rectangle2.width <= n && n <= rectangle.x && rectangle2.y <= n2 && n2 <= rectangle2.y + rectangle2.height;
                }
                if (rectangle.x + rectangle.width < rectangle2.x) {
                    return rectangle.x + rectangle.width <= n && n <= rectangle2.x && rectangle2.y <= n2 && n2 <= rectangle2.y + rectangle2.height;
                }
            }
            rectangle3.add(rectangle);
            if (rectangle3.contains(n, n2)) {
                return true;
            }
        }
        return false;
    }

    boolean canMoveIntoInformationControl(IInformationControl iInformationControl) {
        return this.fEnrichMode != null && this.canReplace(iInformationControl);
    }

    @Override
    protected void hideInformationControl() {
        this.cancelReplacingDelay();
        super.hideInformationControl();
    }

    void setHoverEnrichMode(ITextViewerExtension8.EnrichMode enrichMode) {
        this.fEnrichMode = enrichMode;
    }

    @Override
    void replaceInformationControl(boolean bl) {
        this.fWaitForMouseUp = false;
        super.replaceInformationControl(bl);
    }

    boolean cancelReplacingDelay() {
        this.fWaitForMouseUp = false;
        if (this.fReplacingDelayJob != null && this.fReplacingDelayJob.getState() != 4) {
            boolean bl = this.fReplacingDelayJob.cancel();
            this.fReplacingDelayJob = null;
            return bl;
        }
        return true;
    }

    private void startReplaceInformationControl(final Display display) {
        if (this.fEnrichMode == ITextViewerExtension8.EnrichMode.ON_CLICK) {
            return;
        }
        if (this.fReplacingDelayJob != null) {
            if (this.fReplacingDelayJob.getState() != 4 && this.fReplacingDelayJob.cancel()) {
                if (this.fEnrichMode == ITextViewerExtension8.EnrichMode.IMMEDIATELY) {
                    this.fReplacingDelayJob = null;
                    if (!this.fWaitForMouseUp) {
                        this.replaceInformationControl(false);
                    }
                } else {
                    this.fReplacingDelayJob.schedule(200L);
                }
            }
            return;
        }
        this.fReplacingDelayJob = new Job("AbstractHoverInformationControlManager Replace Delayer"){

            public IStatus run(final IProgressMonitor iProgressMonitor) {
                if (iProgressMonitor.isCanceled() || display.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractHoverInformationControlManager.this.fReplacingDelayJob = null;
                        if (iProgressMonitor.isCanceled()) {
                            return;
                        }
                        if (!AbstractHoverInformationControlManager.this.fWaitForMouseUp) {
                            AbstractHoverInformationControlManager.this.replaceInformationControl(false);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.fReplacingDelayJob.setSystem(true);
        this.fReplacingDelayJob.setPriority(10);
        this.fReplacingDelayJob.schedule(200L);
    }

    @Override
    protected void presentInformation() {
        if (this.fMouseTracker == null) {
            super.presentInformation();
            return;
        }
        Rectangle rectangle = this.getSubjectArea();
        if (rectangle != null) {
            this.fMouseTracker.setSubjectArea(rectangle);
        }
        if (this.fMouseTracker.isMouseLost()) {
            this.fMouseTracker.computationCompleted();
            this.fMouseTracker.deactivate();
        } else {
            this.fMouseTracker.computationCompleted();
            super.presentInformation();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        boolean bl3 = this.isEnabled();
        if (bl2 != bl3 && this.fMouseTracker != null) {
            if (bl3) {
                this.fMouseTracker.start(this.getSubjectControl());
            } else {
                this.fMouseTracker.stop();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.fMouseTracker != null) {
            this.fMouseTracker.stop();
            this.fMouseTracker.fSubjectControl = null;
            this.fMouseTracker = null;
        }
        super.dispose();
    }

    protected Point getHoverEventLocation() {
        return this.fHoverEvent != null ? new Point(this.fHoverEvent.x, this.fHoverEvent.y) : new Point(-1, -1);
    }

    protected MouseEvent getHoverEvent() {
        return this.fHoverEvent;
    }

    protected int getHoverEventStateMask() {
        return this.fHoverEventStateMask;
    }

    @Override
    public InternalAccessor getInternalAccessor() {
        return new AbstractInformationControlManager.MyInternalAccessor(this){

            @Override
            public void setHoverEnrichMode(ITextViewerExtension8.EnrichMode enrichMode) {
                AbstractHoverInformationControlManager.this.setHoverEnrichMode(enrichMode);
            }
        };
    }

    class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    MouseListener,
    MouseMoveListener,
    ControlListener,
    KeyListener,
    SelectionListener,
    Listener {
        private Control fSubjectControl;
        private Rectangle fSubjectArea;
        private boolean fIsActive = false;
        private Display fDisplay;

        @Override
        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        @Override
        public void setInformationControl(IInformationControl iInformationControl) {
        }

        @Override
        public void start(Rectangle rectangle) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            AbstractHoverInformationControlManager.this.fWaitForMouseUp = false;
            this.fSubjectArea = rectangle;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
                if (this.fSubjectControl instanceof Scrollable) {
                    ScrollBar scrollBar;
                    Scrollable scrollable = (Scrollable)this.fSubjectControl;
                    ScrollBar scrollBar2 = scrollable.getVerticalBar();
                    if (scrollBar2 != null) {
                        scrollBar2.addSelectionListener((SelectionListener)this);
                    }
                    if ((scrollBar = scrollable.getHorizontalBar()) != null) {
                        scrollBar.addSelectionListener((SelectionListener)this);
                    }
                }
                this.fDisplay = this.fSubjectControl.getDisplay();
                if (!this.fDisplay.isDisposed()) {
                    this.fDisplay.addFilter(26, (Listener)this);
                    this.fDisplay.addFilter(37, (Listener)this);
                    this.fDisplay.addFilter(16, (Listener)this);
                    this.fDisplay.addFilter(3, (Listener)this);
                    this.fDisplay.addFilter(4, (Listener)this);
                    this.fDisplay.addFilter(5, (Listener)this);
                    this.fDisplay.addFilter(6, (Listener)this);
                    this.fDisplay.addFilter(7, (Listener)this);
                }
            }
        }

        @Override
        public void stop() {
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            if (DEBUG) {
                System.out.println("AbstractHoverInformationControlManager.Closer stopped");
            }
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
                if (this.fSubjectControl instanceof Scrollable) {
                    ScrollBar scrollBar;
                    Scrollable scrollable = (Scrollable)this.fSubjectControl;
                    ScrollBar scrollBar2 = scrollable.getVerticalBar();
                    if (scrollBar2 != null) {
                        scrollBar2.removeSelectionListener((SelectionListener)this);
                    }
                    if ((scrollBar = scrollable.getHorizontalBar()) != null) {
                        scrollBar.removeSelectionListener((SelectionListener)this);
                    }
                }
            }
            if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                this.fDisplay.removeFilter(26, (Listener)this);
                this.fDisplay.removeFilter(37, (Listener)this);
                this.fDisplay.removeFilter(16, (Listener)this);
                this.fDisplay.removeFilter(3, (Listener)this);
                this.fDisplay.removeFilter(4, (Listener)this);
                this.fDisplay.removeFilter(5, (Listener)this);
                this.fDisplay.removeFilter(6, (Listener)this);
                this.fDisplay.removeFilter(7, (Listener)this);
            }
            this.fDisplay = null;
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (!AbstractHoverInformationControlManager.this.hasInformationControlReplacer() || !AbstractHoverInformationControlManager.this.canMoveIntoInformationControl(AbstractHoverInformationControlManager.this.getCurrentInformationControl())) {
                if (!this.fSubjectArea.contains(mouseEvent.x, mouseEvent.y)) {
                    AbstractHoverInformationControlManager.this.hideInformationControl();
                }
            } else if (AbstractHoverInformationControlManager.this.getCurrentInformationControl() != null && !AbstractHoverInformationControlManager.this.getCurrentInformationControl().isFocusControl() && !AbstractHoverInformationControlManager.this.inKeepUpZone(mouseEvent.x, mouseEvent.y, this.fSubjectControl, this.fSubjectArea, true)) {
                AbstractHoverInformationControlManager.this.hideInformationControl();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            AbstractHoverInformationControlManager.this.hideInformationControl();
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            AbstractHoverInformationControlManager.this.hideInformationControl();
        }

        public void controlResized(ControlEvent controlEvent) {
            AbstractHoverInformationControlManager.this.hideInformationControl();
        }

        public void controlMoved(ControlEvent controlEvent) {
            AbstractHoverInformationControlManager.this.hideInformationControl();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            AbstractHoverInformationControlManager.this.hideInformationControl();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            AbstractHoverInformationControlManager.this.hideInformationControl();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: 
                case 37: {
                    if (!AbstractHoverInformationControlManager.this.hasInformationControlReplacer()) {
                        AbstractHoverInformationControlManager.this.hideInformationControl();
                        break;
                    }
                    if (AbstractHoverInformationControlManager.this.isReplaceInProgress()) break;
                    IInformationControl iInformationControl = AbstractHoverInformationControlManager.this.getCurrentInformationControl();
                    if (event.widget instanceof Control && iInformationControl instanceof IInformationControlExtension5) {
                        IInformationControlExtension5 iInformationControlExtension5 = (IInformationControlExtension5)((Object)iInformationControl);
                        Control control = (Control)event.widget;
                        if (!iInformationControlExtension5.containsControl(control)) {
                            AbstractHoverInformationControlManager.this.hideInformationControl();
                            break;
                        }
                        if (event.type != 37 || !AbstractHoverInformationControlManager.this.cancelReplacingDelay()) break;
                        AbstractHoverInformationControlManager.this.replaceInformationControl(false);
                        break;
                    }
                    if (iInformationControl == null || !iInformationControl.isFocusControl() || !AbstractHoverInformationControlManager.this.cancelReplacingDelay()) break;
                    AbstractHoverInformationControlManager.this.replaceInformationControl(true);
                    break;
                }
                case 3: 
                case 4: {
                    if (!AbstractHoverInformationControlManager.this.hasInformationControlReplacer()) {
                        AbstractHoverInformationControlManager.this.hideInformationControl();
                        break;
                    }
                    if (AbstractHoverInformationControlManager.this.isReplaceInProgress()) break;
                    IInformationControl iInformationControl = AbstractHoverInformationControlManager.this.getCurrentInformationControl();
                    if (event.widget instanceof Control && iInformationControl instanceof IInformationControlExtension5) {
                        IInformationControlExtension5 iInformationControlExtension5 = (IInformationControlExtension5)((Object)iInformationControl);
                        Control control = (Control)event.widget;
                        if (!iInformationControlExtension5.containsControl(control)) {
                            AbstractHoverInformationControlManager.this.hideInformationControl();
                            break;
                        }
                        if (!AbstractHoverInformationControlManager.this.cancelReplacingDelay()) break;
                        if (event.type == 4) {
                            this.stop();
                            if (iInformationControl instanceof IDelayedInputChangeProvider) {
                                final IDelayedInputChangeProvider iDelayedInputChangeProvider = (IDelayedInputChangeProvider)((Object)iInformationControl);
                                DelayedInputChangeListener delayedInputChangeListener = new DelayedInputChangeListener(iDelayedInputChangeProvider, AbstractHoverInformationControlManager.this.getInformationControlReplacer());
                                iDelayedInputChangeProvider.setDelayedInputChangeListener(delayedInputChangeListener);
                                control.getShell().getDisplay().timerExec(1000, new Runnable(){

                                    @Override
                                    public void run() {
                                        iDelayedInputChangeProvider.setDelayedInputChangeListener(null);
                                    }
                                });
                            }
                            control.getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractHoverInformationControlManager.this.replaceInformationControl(true);
                                }
                            });
                            break;
                        }
                        AbstractHoverInformationControlManager.this.fWaitForMouseUp = true;
                        break;
                    }
                    this.handleMouseMove(event);
                    break;
                }
                case 16: {
                    IInformationControl iInformationControl = AbstractHoverInformationControlManager.this.getCurrentInformationControl();
                    if (iInformationControl == null || iInformationControl.isFocusControl()) break;
                    AbstractHoverInformationControlManager.this.hideInformationControl();
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.handleMouseMove(event);
                }
            }
        }

        private void handleMouseMove(Event event) {
            if (!(event.widget instanceof Control)) {
                return;
            }
            Control control = (Control)event.widget;
            Point point = event.display.map(control, this.fSubjectControl, event.x, event.y);
            if (this.fSubjectArea.contains(point)) {
                return;
            }
            IInformationControl iInformationControl = AbstractHoverInformationControlManager.this.getCurrentInformationControl();
            if (!AbstractHoverInformationControlManager.this.hasInformationControlReplacer() || !AbstractHoverInformationControlManager.this.canMoveIntoInformationControl(iInformationControl)) {
                if (AbstractHoverInformationControlManager.this instanceof AnnotationBarHoverManager && AbstractHoverInformationControlManager.this.getInternalAccessor().getAllowMouseExit()) {
                    return;
                }
                AbstractHoverInformationControlManager.this.hideInformationControl();
                return;
            }
            IInformationControlExtension3 iInformationControlExtension3 = (IInformationControlExtension3)((Object)iInformationControl);
            Rectangle rectangle = iInformationControlExtension3.getBounds();
            if (rectangle != null) {
                Rectangle rectangle2 = event.display.map(null, control, rectangle);
                if (rectangle2.contains(event.x, event.y)) {
                    if (!AbstractHoverInformationControlManager.this.isReplaceInProgress() && event.type != 7) {
                        AbstractHoverInformationControlManager.this.startReplaceInformationControl(event.display);
                    }
                    return;
                }
                AbstractHoverInformationControlManager.this.cancelReplacingDelay();
            }
            if (!this.fSubjectControl.getBounds().contains(point) && !AbstractHoverInformationControlManager.this.inKeepUpZone(point.x, point.y, this.fSubjectControl, this.fSubjectArea, true)) {
                AbstractHoverInformationControlManager.this.hideInformationControl();
                return;
            }
        }
    }

    class MouseTracker
    extends ShellAdapter
    implements MouseTrackListener,
    MouseMoveListener {
        private static final int EPSILON = 3;
        private Rectangle fHoverArea;
        private Rectangle fSubjectArea;
        private Control fSubjectControl;
        private boolean fIsInRestartMode = false;
        private boolean fIsComputing = false;
        private boolean fMouseLostWhileComputing = false;
        private boolean fShellDeactivatedWhileComputing = false;

        public void setSubjectArea(Rectangle rectangle) {
            Assert.isNotNull((Object)rectangle);
            this.fSubjectArea = rectangle;
        }

        public void start(Control control) {
            this.fSubjectControl = control;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addMouseTrackListener((MouseTrackListener)this);
            }
            this.fIsInRestartMode = false;
            this.fIsComputing = false;
            this.fMouseLostWhileComputing = false;
            this.fShellDeactivatedWhileComputing = false;
        }

        public void stop() {
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeMouseTrackListener((MouseTrackListener)this);
                this.fSubjectControl.removeMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.getShell().removeShellListener((ShellListener)this);
            }
        }

        public void mouseHover(MouseEvent mouseEvent) {
            if (this.fIsComputing || this.fIsInRestartMode || this.fSubjectControl != null && !this.fSubjectControl.isDisposed() && this.fSubjectControl.getShell() != this.fSubjectControl.getShell().getDisplay().getActiveShell()) {
                if (DEBUG) {
                    System.out.println("AbstractHoverInformationControlManager...mouseHover: @ " + mouseEvent.x + "/" + mouseEvent.y + " : hover cancelled: fIsComputing= " + this.fIsComputing + ", fIsInRestartMode= " + this.fIsInRestartMode);
                }
                return;
            }
            this.fIsInRestartMode = true;
            this.fIsComputing = true;
            this.fMouseLostWhileComputing = false;
            this.fShellDeactivatedWhileComputing = false;
            AbstractHoverInformationControlManager.this.fHoverEventStateMask = mouseEvent.stateMask;
            AbstractHoverInformationControlManager.this.fHoverEvent = mouseEvent;
            this.fHoverArea = new Rectangle(mouseEvent.x - 3, mouseEvent.y - 3, 6, 6);
            if (this.fHoverArea.x < 0) {
                this.fHoverArea.x = 0;
            }
            if (this.fHoverArea.y < 0) {
                this.fHoverArea.y = 0;
            }
            this.setSubjectArea(this.fHoverArea);
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.getShell().addShellListener((ShellListener)this);
            }
            AbstractHoverInformationControlManager.this.doShowInformation();
        }

        protected void deactivate() {
            if (this.fIsComputing) {
                return;
            }
            this.fIsInRestartMode = false;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.getShell().removeShellListener((ShellListener)this);
            }
        }

        public void mouseEnter(MouseEvent mouseEvent) {
        }

        public void mouseExit(MouseEvent mouseEvent) {
            if (!(AbstractHoverInformationControlManager.this.hasInformationControlReplacer() && AbstractHoverInformationControlManager.this.canMoveIntoInformationControl(AbstractHoverInformationControlManager.this.getCurrentInformationControl()) && AbstractHoverInformationControlManager.this.inKeepUpZone(mouseEvent.x, mouseEvent.y, this.fSubjectControl, this.fSubjectArea, false))) {
                this.fMouseLostWhileComputing = true;
                this.deactivate();
            }
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (!AbstractHoverInformationControlManager.this.hasInformationControlReplacer() || !AbstractHoverInformationControlManager.this.canMoveIntoInformationControl(AbstractHoverInformationControlManager.this.getCurrentInformationControl())) {
                if (!this.fSubjectArea.contains(mouseEvent.x, mouseEvent.y)) {
                    this.deactivate();
                }
            } else if (!AbstractHoverInformationControlManager.this.inKeepUpZone(mouseEvent.x, mouseEvent.y, this.fSubjectControl, this.fSubjectArea, false)) {
                this.deactivate();
            }
        }

        public void shellDeactivated(ShellEvent shellEvent) {
            this.fShellDeactivatedWhileComputing = true;
            this.deactivate();
        }

        public void shellIconified(ShellEvent shellEvent) {
            this.fShellDeactivatedWhileComputing = true;
            this.deactivate();
        }

        public void computationCompleted() {
            this.fIsComputing = false;
            this.fMouseLostWhileComputing = false;
            this.fShellDeactivatedWhileComputing = false;
        }

        public boolean isMouseLost() {
            if (this.fMouseLostWhileComputing || this.fShellDeactivatedWhileComputing) {
                return true;
            }
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                Display display = this.fSubjectControl.getDisplay();
                Point point = display.getCursorLocation();
                if (!this.fSubjectArea.contains(point = this.fSubjectControl.toControl(point)) && !this.fHoverArea.contains(point)) {
                    return true;
                }
            }
            return false;
        }
    }
}

