/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.source;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.ILineDifferExtension2;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class DiffPainter {
    private final IVerticalRulerColumn fColumn;
    private CompositeRuler fParentRuler;
    private Control fControl;
    private ITextViewer fViewer;
    private StyledText fWidget;
    private ILineDiffer fLineDiffer = null;
    private Color fAddedColor;
    private Color fChangedColor;
    private Color fDeletedColor;
    private Color fBackground;
    private IAnnotationHover fHover;
    private final AnnotationListener fAnnotationListener = new AnnotationListener();
    private final ISharedTextColors fSharedColors;

    public DiffPainter(IVerticalRulerColumn iVerticalRulerColumn, ISharedTextColors iSharedTextColors) {
        Assert.isLegal((iVerticalRulerColumn != null ? 1 : 0) != 0);
        this.fColumn = iVerticalRulerColumn;
        this.fSharedColors = iSharedTextColors;
    }

    public void setParentRuler(CompositeRuler compositeRuler) {
        this.fParentRuler = compositeRuler;
    }

    public void setHover(IAnnotationHover iAnnotationHover) {
        this.fHover = iAnnotationHover;
    }

    public IAnnotationHover getHover() {
        return this.fHover;
    }

    public void setBackground(Color color) {
        this.fBackground = color;
    }

    public void paint(GC gC, ILineRange iLineRange) {
        this.connectIfNeeded();
        if (!this.isConnected()) {
            return;
        }
        int n = DiffPainter.end(iLineRange);
        int n2 = this.getWidth();
        Color color = this.getDeletionColor();
        int n3 = iLineRange.getStartLine();
        while (n3 < n) {
            this.paintLine(n3, gC, n2, color);
            ++n3;
        }
    }

    private void connectIfNeeded() {
        if (this.isConnected() || this.fParentRuler == null) {
            return;
        }
        this.fViewer = this.fParentRuler.getTextViewer();
        if (this.fViewer == null) {
            return;
        }
        this.fWidget = this.fViewer.getTextWidget();
        if (this.fWidget == null) {
            return;
        }
        this.fControl = this.fColumn.getControl();
        if (this.fControl == null) {
            return;
        }
        this.fControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                DiffPainter.this.handleDispose();
            }
        });
    }

    private boolean isConnected() {
        return this.fControl != null;
    }

    private void handleDispose() {
        if (this.fLineDiffer != null) {
            ((IAnnotationModel)this.fLineDiffer).removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            this.fLineDiffer = null;
        }
    }

    private void paintLine(int n, GC gC, int n2, Color color) {
        int n3 = JFaceTextUtil.modelLineToWidgetLine(this.fViewer, n);
        if (n3 == -1) {
            return;
        }
        ILineDiffInfo iLineDiffInfo = this.getDiffInfo(n);
        if (iLineDiffInfo != null) {
            int n4 = this.fWidget.getLinePixel(n3);
            int n5 = this.fWidget.getLineHeight(this.fWidget.getOffsetAtLine(n3));
            if (this.hasSpecialColor(iLineDiffInfo)) {
                gC.setBackground(this.getColor(iLineDiffInfo));
                gC.fillRectangle(0, n4, n2, n5);
            }
            int n6 = iLineDiffInfo.getRemovedLinesAbove();
            int n7 = iLineDiffInfo.getRemovedLinesBelow();
            if (n6 > 0 || n7 > 0) {
                gC.setForeground(color);
                if (n6 > 0) {
                    gC.drawLine(0, n4, n2, n4);
                }
                if (n7 > 0) {
                    gC.drawLine(0, n4 + n5 - 1, n2, n4 + n5 - 1);
                }
            }
        }
    }

    private boolean hasSpecialColor(ILineDiffInfo iLineDiffInfo) {
        return iLineDiffInfo.getChangeType() == 1 || iLineDiffInfo.getChangeType() == 2;
    }

    private ILineDiffInfo getDiffInfo(int n) {
        if (this.fLineDiffer != null) {
            return this.fLineDiffer.getLineInfo(n);
        }
        return null;
    }

    private Color getDeletionColor() {
        return this.fDeletedColor == null ? this.getBackground() : this.fDeletedColor;
    }

    private Color getColor(ILineDiffInfo iLineDiffInfo) {
        Assert.isTrue((iLineDiffInfo != null && iLineDiffInfo.getChangeType() != 0 ? 1 : 0) != 0);
        Color color = null;
        switch (iLineDiffInfo.getChangeType()) {
            case 2: {
                color = this.getShadedColor(this.fChangedColor);
                break;
            }
            case 1: {
                color = this.getShadedColor(this.fAddedColor);
            }
        }
        return color == null ? this.getBackground() : color;
    }

    private Color getShadedColor(Color color) {
        if (color == null) {
            return null;
        }
        if (this.fSharedColors == null) {
            return color;
        }
        RGB rGB = color.getRGB();
        RGB rGB2 = this.getBackground().getRGB();
        boolean bl = DiffPainter.isDark(rGB);
        boolean bl2 = DiffPainter.isDark(rGB2);
        if (bl && bl2) {
            rGB2 = new RGB(255, 255, 255);
        } else if (!bl && !bl2) {
            rGB2 = new RGB(0, 0, 0);
        }
        return this.fSharedColors.getColor(DiffPainter.interpolate(rGB, rGB2, 0.6));
    }

    public void setModel(IAnnotationModel iAnnotationModel) {
        IAnnotationModel iAnnotationModel2 = iAnnotationModel instanceof IAnnotationModelExtension ? ((IAnnotationModelExtension)iAnnotationModel).getAnnotationModel((Object)"diff") : iAnnotationModel;
        this.setDiffer(iAnnotationModel2);
    }

    private void setDiffer(IAnnotationModel iAnnotationModel) {
        if (iAnnotationModel instanceof ILineDiffer && this.fLineDiffer != iAnnotationModel) {
            if (this.fLineDiffer != null) {
                ((IAnnotationModel)this.fLineDiffer).removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
            this.fLineDiffer = (ILineDiffer)iAnnotationModel;
            if (this.fLineDiffer != null) {
                ((IAnnotationModel)this.fLineDiffer).addAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
        }
    }

    private final void postRedraw() {
        Display display;
        if (this.isConnected() && !this.fControl.isDisposed() && (display = this.fControl.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiffPainter.this.redraw();
                }
            });
        }
    }

    private void redraw() {
        this.fColumn.redraw();
    }

    private int getWidth() {
        return this.fColumn.getWidth();
    }

    private static int end(ILineRange iLineRange) {
        return iLineRange.getStartLine() + iLineRange.getNumberOfLines();
    }

    private Color getBackground() {
        if (this.fBackground == null) {
            return this.fWidget.getDisplay().getSystemColor(25);
        }
        return this.fBackground;
    }

    public void setAddedColor(Color color) {
        this.fAddedColor = color;
    }

    public void setChangedColor(Color color) {
        this.fChangedColor = color;
    }

    public void setDeletedColor(Color color) {
        this.fDeletedColor = color;
    }

    public boolean hasHover(int n) {
        return true;
    }

    public String getDisplayCharacter(int n) {
        return this.getDisplayCharacter(this.getDiffInfo(n));
    }

    private String getDisplayCharacter(ILineDiffInfo iLineDiffInfo) {
        if (iLineDiffInfo == null) {
            return " ";
        }
        switch (iLineDiffInfo.getChangeType()) {
            case 2: {
                return "~";
            }
            case 1: {
                return "+";
            }
        }
        return " ";
    }

    private static RGB interpolate(RGB rGB, RGB rGB2, double d) {
        return new RGB((int)((1.0 - d) * (double)rGB.red + d * (double)rGB2.red), (int)((1.0 - d) * (double)rGB.green + d * (double)rGB2.green), (int)((1.0 - d) * (double)rGB.blue + d * (double)rGB2.blue));
    }

    private static double greyLevel(RGB rGB) {
        if (rGB.red == rGB.green && rGB.green == rGB.blue) {
            return rGB.red;
        }
        return 0.299 * (double)rGB.red + 0.587 * (double)rGB.green + 0.114 * (double)rGB.blue + 0.5;
    }

    private static boolean isDark(RGB rGB) {
        return DiffPainter.greyLevel(rGB) > 128.0;
    }

    public boolean hasInformation() {
        if (this.fLineDiffer instanceof ILineDifferExtension2) {
            return !((ILineDifferExtension2)((Object)this.fLineDiffer)).isSuspended();
        }
        return this.fLineDiffer != null;
    }

    private class AnnotationListener
    implements IAnnotationModelListener {
        private AnnotationListener() {
        }

        public void modelChanged(IAnnotationModel iAnnotationModel) {
            DiffPainter.this.postRedraw();
        }
    }
}

