/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.revisions;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.internal.text.revisions.RevisionPainter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public final class RevisionSelectionProvider
implements ISelectionProvider {
    private final RevisionPainter fPainter;
    private final ListenerList fListeners = new ListenerList();
    private ITextViewer fViewer;
    private PostSelectionListener fSelectionListener;
    private Revision fSelection;
    private boolean fIgnoreEvents = false;

    RevisionSelectionProvider(RevisionPainter revisionPainter) {
        this.fPainter = revisionPainter;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fListeners.add((Object)iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fListeners.remove((Object)iSelectionChangedListener);
    }

    public ISelection getSelection() {
        if (this.fSelection == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.fSelection);
    }

    public void setSelection(ISelection iSelection) {
        if (this.fIgnoreEvents) {
            return;
        }
        if (iSelection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object instanceof Revision) {
                this.fPainter.handleRevisionSelected((Revision)object);
            } else if (object instanceof String) {
                this.fPainter.handleRevisionSelected((String)object);
            } else if (iSelection.isEmpty()) {
                this.fPainter.handleRevisionSelected((Revision)null);
            }
        }
    }

    void install(ITextViewer iTextViewer) {
        ISelectionProvider iSelectionProvider;
        this.uninstall();
        this.fViewer = iTextViewer;
        if (this.fViewer != null && (iSelectionProvider = this.fViewer.getSelectionProvider()) instanceof IPostSelectionProvider) {
            IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
            this.fSelectionListener = new PostSelectionListener(iPostSelectionProvider);
        }
    }

    void uninstall() {
        this.fViewer = null;
        if (this.fSelectionListener != null) {
            this.fSelectionListener.dispose();
            this.fSelectionListener = null;
        }
    }

    void revisionSelected(Revision revision) {
        this.setSelectedRevision(revision);
    }

    private void setSelectedRevision(Revision revision) {
        if (revision != this.fSelection) {
            this.fSelection = revision;
            this.fireSelectionEvent();
        }
    }

    private void fireSelectionEvent() {
        this.fIgnoreEvents = true;
        try {
            ISelection iSelection = this.getSelection();
            SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ISelectionChangedListener)objectArray[n]).selectionChanged(selectionChangedEvent);
                ++n;
            }
        }
        finally {
            this.fIgnoreEvents = false;
        }
    }

    private final class PostSelectionListener
    implements ISelectionChangedListener {
        private final IPostSelectionProvider fPostProvider;

        public PostSelectionListener(IPostSelectionProvider iPostSelectionProvider) {
            iPostSelectionProvider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            this.fPostProvider = iPostSelectionProvider;
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ISelection iSelection = selectionChangedEvent.getSelection();
            if (iSelection instanceof ITextSelection) {
                ITextSelection iTextSelection = (ITextSelection)iSelection;
                int n = iTextSelection.getOffset();
                RevisionSelectionProvider.this.setSelectedRevision(RevisionSelectionProvider.this.fPainter.getRevision(n));
            }
        }

        public void dispose() {
            this.fPostProvider.removePostSelectionChangedListener((ISelectionChangedListener)this);
        }
    }
}

