/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.revisions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.revisions.Colors;
import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.internal.text.revisions.HunkComputer;
import org.eclipse.jface.internal.text.revisions.RevisionSelectionProvider;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.revisions.IRevisionListener;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionEvent;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.revisions.RevisionRange;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationHoverExtension2;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class RevisionPainter {
    private static boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text.source/debug/RevisionRulerColumn"));
    private static final RGB BY_DATE_START_COLOR = new RGB(199, 134, 57);
    private static final RGB BY_DATE_END_COLOR = new RGB(241, 225, 206);
    private static final String fgStyleSheet = "/* Font definitions */\nbody, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt {font-family: sans-serif; font-size: 9pt }\npre\t\t\t\t{ font-family: monospace; font-size: 9pt }\n\n/* Margins */\nbody\t     { overflow: auto; margin-top: 0; margin-bottom: 4; margin-left: 3; margin-right: 0 }\nh1           { margin-top: 5; margin-bottom: 1 }\t\nh2           { margin-top: 25; margin-bottom: 3 }\nh3           { margin-top: 20; margin-bottom: 3 }\nh4           { margin-top: 20; margin-bottom: 3 }\nh5           { margin-top: 0; margin-bottom: 0 }\np            { margin-top: 10px; margin-bottom: 10px }\npre\t         { margin-left: 6 }\nul\t         { margin-top: 0; margin-bottom: 10 }\nli\t         { margin-top: 0; margin-bottom: 0 } \nli p\t     { margin-top: 0; margin-bottom: 0 } \nol\t         { margin-top: 0; margin-bottom: 10 }\ndl\t         { margin-top: 0; margin-bottom: 10 }\ndt\t         { margin-top: 0; margin-bottom: 0; font-weight: bold }\ndd\t         { margin-top: 0; margin-bottom: 0 }\n\n/* Styles and colors */\na:link\t     { color: #0000FF }\na:hover\t     { color: #000080 }\na:visited    { text-decoration: underline }\nh4           { font-style: italic }\nstrong\t     { font-weight: bold }\nem\t         { font-style: italic }\nvar\t         { font-style: italic }\nth\t         { font-weight: bold }\n";
    private final ISharedTextColors fSharedColors;
    private final ColorTool fColorTool = new ColorTool();
    private final MouseHandler fMouseHandler = new MouseHandler();
    private final RevisionHover fHover = new RevisionHover();
    private final AnnotationListener fAnnotationListener = new AnnotationListener();
    private final RevisionSelectionProvider fRevisionSelectionProvider = new RevisionSelectionProvider(this);
    private final ListenerList fRevisionListeners = new ListenerList(1);
    private final IVerticalRulerColumn fColumn;
    private CompositeRuler fParentRuler;
    private Control fControl;
    private ITextViewer fViewer;
    private StyledText fWidget;
    private RevisionInformation fRevisionInfo;
    private ILineDiffer fLineDiffer = null;
    private IAnnotationModel fAnnotationModel = null;
    private Color fBackground;
    private List fRevisionRanges = null;
    private List fAnnotations = new ArrayList();
    private int fFocusLine = -1;
    private RevisionRange fFocusRange = null;
    private Revision fFocusRevision = null;
    private Revision fSelectedRevision = null;
    private boolean fWheelHandlerInstalled = false;
    private IRevisionRulerColumnExtension.RenderingMode fRenderingMode = IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE;
    private int fRequiredWidth = -1;
    private int fRevisionIdChars = 0;
    private boolean fShowRevision = false;
    private boolean fShowAuthor = false;
    private int fAuthorInset;
    private int fLastWidth = -1;

    public RevisionPainter(IVerticalRulerColumn iVerticalRulerColumn, ISharedTextColors iSharedTextColors) {
        Assert.isLegal((iVerticalRulerColumn != null ? 1 : 0) != 0);
        Assert.isLegal((iSharedTextColors != null ? 1 : 0) != 0);
        this.fColumn = iVerticalRulerColumn;
        this.fSharedColors = iSharedTextColors;
    }

    public void setRevisionInformation(RevisionInformation revisionInformation) {
        if (this.fRevisionInfo != revisionInformation) {
            this.fRequiredWidth = -1;
            this.fRevisionIdChars = 0;
            this.fRevisionInfo = revisionInformation;
            this.clearRangeCache();
            this.updateFocusRange(null);
            this.handleRevisionSelected((Revision)null);
            this.fColorTool.setInfo(revisionInformation);
            this.postRedraw();
            this.informListeners();
        }
    }

    public void setRenderingMode(IRevisionRulerColumnExtension.RenderingMode renderingMode) {
        Assert.isLegal((renderingMode != null ? 1 : 0) != 0);
        if (this.fRenderingMode != renderingMode) {
            this.fRenderingMode = renderingMode;
            this.fColorTool.setInfo(this.fRevisionInfo);
            this.postRedraw();
        }
    }

    public void setBackground(Color color) {
        this.fBackground = color;
    }

    public void setParentRuler(CompositeRuler compositeRuler) {
        this.fParentRuler = compositeRuler;
    }

    public void paint(GC gC, ILineRange iLineRange) {
        int n;
        this.connectIfNeeded();
        if (!this.isConnected()) {
            return;
        }
        if (this.fShowAuthor && this.fShowRevision) {
            char[] cArray = new char[this.fRevisionIdChars + 1];
            Arrays.fill(cArray, '9');
            if (cArray.length > 1) {
                cArray[0] = 46;
                cArray[1] = 32;
            }
            this.fAuthorInset = gC.stringExtent((String)new String((char[])cArray)).x;
        }
        if ((n = this.getWidth()) != this.fLastWidth) {
            this.fColorTool.setInfo(this.fRevisionInfo);
            this.fLastWidth = n;
        }
        List list = this.getRanges(iLineRange);
        for (RevisionRange revisionRange : list) {
            this.paintRange(revisionRange, gC);
        }
    }

    private void connectIfNeeded() {
        if (this.isConnected() || this.fParentRuler == null) {
            return;
        }
        this.fViewer = this.fParentRuler.getTextViewer();
        if (this.fViewer == null) {
            return;
        }
        this.fWidget = this.fViewer.getTextWidget();
        if (this.fWidget == null) {
            return;
        }
        this.fControl = this.fColumn.getControl();
        if (this.fControl == null) {
            return;
        }
        this.fControl.addMouseTrackListener((MouseTrackListener)this.fMouseHandler);
        this.fControl.addMouseMoveListener((MouseMoveListener)this.fMouseHandler);
        this.fControl.addListener(4, (Listener)this.fMouseHandler);
        this.fControl.addListener(3, (Listener)this.fMouseHandler);
        this.fControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                RevisionPainter.this.handleDispose();
            }
        });
        this.fRevisionSelectionProvider.install(this.fViewer);
    }

    private boolean isConnected() {
        return this.fControl != null;
    }

    public void setModel(IAnnotationModel iAnnotationModel) {
        IAnnotationModel iAnnotationModel2 = iAnnotationModel instanceof IAnnotationModelExtension ? ((IAnnotationModelExtension)iAnnotationModel).getAnnotationModel((Object)"diff") : iAnnotationModel;
        this.setDiffer(iAnnotationModel2);
        this.setAnnotationModel(iAnnotationModel);
    }

    private void setAnnotationModel(IAnnotationModel iAnnotationModel) {
        if (this.fAnnotationModel != iAnnotationModel) {
            this.fAnnotationModel = iAnnotationModel;
        }
    }

    private void setDiffer(IAnnotationModel iAnnotationModel) {
        if ((iAnnotationModel instanceof ILineDiffer || iAnnotationModel == null) && this.fLineDiffer != iAnnotationModel) {
            if (this.fLineDiffer != null) {
                ((IAnnotationModel)this.fLineDiffer).removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
            this.fLineDiffer = (ILineDiffer)iAnnotationModel;
            if (this.fLineDiffer != null) {
                ((IAnnotationModel)this.fLineDiffer).addAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
        }
    }

    private void handleDispose() {
        this.updateFocusLine(-1);
        if (this.fLineDiffer != null) {
            ((IAnnotationModel)this.fLineDiffer).removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            this.fLineDiffer = null;
        }
        this.fRevisionSelectionProvider.uninstall();
    }

    private void paintRange(RevisionRange revisionRange, GC gC) {
        Color color;
        Color color2;
        ILineRange iLineRange = this.modelLinesToWidgetLines(revisionRange);
        if (iLineRange == null) {
            return;
        }
        Revision revision = revisionRange.getRevision();
        boolean bl = revisionRange == this.fMouseHandler.fMouseDownRegion;
        boolean bl2 = !bl && revision == this.fSelectedRevision;
        boolean bl3 = !bl2 && !bl && revision == this.fFocusRevision;
        Rectangle rectangle = this.computeBoxBounds(iLineRange);
        gC.setBackground(this.lookupColor(revision, false));
        if (bl) {
            color2 = gC.getForeground();
            color = this.lookupColor(revision, true);
            gC.setForeground(color);
            gC.fillRectangle(rectangle);
            gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            gC.drawRectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3);
            gC.setForeground(color2);
        } else if (bl3 || bl2) {
            color2 = gC.getForeground();
            color = this.lookupColor(revision, true);
            gC.setForeground(color);
            gC.fillRectangle(rectangle);
            gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            gC.setForeground(color2);
        } else {
            gC.fillRectangle(rectangle);
        }
        if (this.fShowAuthor || this.fShowRevision) {
            int n = 1;
            int n2 = this.getBaselineBias(gC, iLineRange.getStartLine());
            if (this.fShowAuthor && this.fShowRevision) {
                gC.drawString(revision.getId(), n, rectangle.y + n2, true);
                gC.drawString(revision.getAuthor(), this.fAuthorInset, rectangle.y + n2, true);
            } else if (this.fShowAuthor) {
                gC.drawString(revision.getAuthor(), n, rectangle.y + n2, true);
            } else if (this.fShowRevision) {
                gC.drawString(revision.getId(), n, rectangle.y + n2, true);
            }
        }
    }

    private int getBaselineBias(GC gC, int n) {
        int n2 = this.fWidget.getOffsetAtLine(n);
        int n3 = this.fWidget.getBaseline(n2);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n4 = fontMetrics.getAscent() + fontMetrics.getLeading();
        int n5 = n3 - n4;
        return Math.max(0, n5);
    }

    private Color lookupColor(Revision revision, boolean bl) {
        return this.fSharedColors.getColor(this.fColorTool.getColor(revision, bl));
    }

    private RevisionRange getRange(int n) {
        List list = this.getRangeCache();
        if (list.isEmpty() || n == -1) {
            return null;
        }
        for (RevisionRange revisionRange : list) {
            if (!RevisionPainter.contains(revisionRange, n)) continue;
            return revisionRange;
        }
        RevisionRange revisionRange = (RevisionRange)list.get(list.size() - 1);
        if (n == RevisionPainter.end(revisionRange)) {
            return revisionRange;
        }
        return null;
    }

    private List getRanges(ILineRange iLineRange) {
        List list = this.getRangeCache();
        int n = RevisionPainter.end(iLineRange);
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < list.size()) {
            RevisionRange revisionRange = (RevisionRange)list.get(n4);
            int n5 = RevisionPainter.end(revisionRange);
            if (n2 == -1 && n5 > iLineRange.getStartLine()) {
                n2 = n4;
            }
            if (n2 != -1 && n5 > n) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (n2 == -1) {
            return Collections.EMPTY_LIST;
        }
        if (n3 == -1) {
            n3 = list.size() - 1;
        }
        return list.subList(n2, n3 + 1);
    }

    private List getRangeCache() {
        if (this.fRevisionRanges == null) {
            if (this.fRevisionInfo == null) {
                this.fRevisionRanges = Collections.EMPTY_LIST;
            } else {
                Hunk[] hunkArray = HunkComputer.computeHunks(this.fLineDiffer, this.fViewer.getDocument().getNumberOfLines());
                this.fRevisionInfo.applyDiff(hunkArray);
                this.fRevisionRanges = this.fRevisionInfo.getRanges();
                this.updateOverviewAnnotations();
                this.informListeners();
            }
        }
        return this.fRevisionRanges;
    }

    private void clearRangeCache() {
        this.fRevisionRanges = null;
    }

    private static boolean contains(ILineRange iLineRange, int n) {
        return iLineRange.getStartLine() <= n && RevisionPainter.end(iLineRange) > n;
    }

    private static int end(ILineRange iLineRange) {
        return iLineRange.getStartLine() + iLineRange.getNumberOfLines();
    }

    private ILineRange modelLinesToWidgetLines(ILineRange iLineRange) {
        int n = -1;
        int n2 = -1;
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fViewer);
            int n3 = RevisionPainter.end(iLineRange);
            int n4 = iLineRange.getStartLine();
            while (n4 < n3) {
                int n5 = iTextViewerExtension5.modelLine2WidgetLine(n4);
                if (n5 != -1) {
                    if (n == -1) {
                        n = n5;
                    }
                    n2 = n5;
                }
                ++n4;
            }
        } else {
            IRegion iRegion = this.fViewer.getVisibleRegion();
            IDocument iDocument = this.fViewer.getDocument();
            try {
                int n6 = iDocument.getLineOfOffset(iRegion.getOffset());
                int n7 = iDocument.getLineOfOffset(iRegion.getOffset() + iRegion.getLength());
                n = Math.max(0, iLineRange.getStartLine() - n6);
                n2 = Math.min(n7, RevisionPainter.end(iLineRange) - 1);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (n == -1 || n2 == -1) {
            return null;
        }
        return new LineRange(n, n2 - n + 1);
    }

    public IAnnotationHover getHover() {
        return this.fHover;
    }

    private Rectangle computeBoxBounds(ILineRange iLineRange) {
        int n = this.fWidget.getLinePixel(iLineRange.getStartLine());
        int n2 = this.fWidget.getLinePixel(iLineRange.getStartLine() + iLineRange.getNumberOfLines());
        return new Rectangle(0, n, this.getWidth(), n2 - n - 1);
    }

    private void updateOverviewAnnotations() {
        if (this.fAnnotationModel == null) {
            return;
        }
        Revision revision = this.fFocusRevision != null ? this.fFocusRevision : this.fSelectedRevision;
        HashMap<RevisionAnnotation, Position> hashMap = null;
        if (revision != null) {
            hashMap = new HashMap<RevisionAnnotation, Position>();
            for (RevisionRange object : revision.getRegions()) {
                try {
                    IRegion iRegion = this.toCharRegion(object);
                    Position position = new Position(iRegion.getOffset(), iRegion.getLength());
                    RevisionAnnotation revisionAnnotation = new RevisionAnnotation(revision.getId());
                    hashMap.put(revisionAnnotation, position);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)this.fAnnotationModel;
            iAnnotationModelExtension.replaceAnnotations(this.fAnnotations.toArray(new Annotation[this.fAnnotations.size()]), hashMap);
        } else {
            for (Annotation annotation : this.fAnnotations) {
                this.fAnnotationModel.removeAnnotation(annotation);
            }
            if (hashMap != null) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                }
            }
        }
        this.fAnnotations.clear();
        if (hashMap != null) {
            this.fAnnotations.addAll(hashMap.keySet());
        }
    }

    private IRegion toCharRegion(ILineRange iLineRange) throws BadLocationException {
        IDocument iDocument = this.fViewer.getDocument();
        int n = iDocument.getLineOffset(iLineRange.getStartLine());
        int n2 = RevisionPainter.end(iLineRange);
        int n3 = n2 >= iDocument.getNumberOfLines() ? iDocument.getLength() : iDocument.getLineOffset(n2);
        return new Region(n, n3 - n);
    }

    void handleRevisionSelected(Revision revision) {
        this.fSelectedRevision = revision;
        this.fRevisionSelectionProvider.revisionSelected(revision);
        if (this.isConnected()) {
            this.updateOverviewAnnotations();
        }
        this.postRedraw();
    }

    void handleRevisionSelected(String string) {
        Assert.isLegal((string != null ? 1 : 0) != 0);
        if (this.fRevisionInfo == null) {
            return;
        }
        for (Revision revision : this.fRevisionInfo.getRevisions()) {
            if (!string.equals(revision.getId())) continue;
            this.handleRevisionSelected(revision);
            return;
        }
        this.handleRevisionSelected((Revision)null);
    }

    public RevisionSelectionProvider getRevisionSelectionProvider() {
        return this.fRevisionSelectionProvider;
    }

    private void updateFocusLine(int n) {
        if (this.fFocusLine != n) {
            this.onFocusLineChanged(this.fFocusLine, n);
        }
    }

    private void onFocusLineChanged(int n, int n2) {
        if (DEBUG) {
            System.out.println("line: " + n + " > " + n2);
        }
        this.fFocusLine = n2;
        RevisionRange revisionRange = this.getRange(n2);
        this.updateFocusRange(revisionRange);
    }

    private void updateFocusRange(RevisionRange revisionRange) {
        if (revisionRange != this.fFocusRange) {
            this.onFocusRangeChanged(this.fFocusRange, revisionRange);
        }
    }

    private void onFocusRangeChanged(RevisionRange revisionRange, RevisionRange revisionRange2) {
        if (DEBUG) {
            System.out.println("range: " + revisionRange + " > " + revisionRange2);
        }
        this.fFocusRange = revisionRange2;
        Revision revision = revisionRange2 == null ? null : revisionRange2.getRevision();
        this.updateFocusRevision(revision);
    }

    private void updateFocusRevision(Revision revision) {
        if (this.fFocusRevision != revision) {
            this.onFocusRevisionChanged(this.fFocusRevision, revision);
        }
    }

    private void onFocusRevisionChanged(Revision revision, Revision revision2) {
        if (DEBUG) {
            System.out.println("revision: " + revision + " > " + revision2);
        }
        this.fFocusRevision = revision2;
        this.uninstallWheelHandler();
        this.installWheelHandler();
        this.updateOverviewAnnotations();
        this.redraw();
    }

    private void uninstallWheelHandler() {
        this.fControl.removeListener(37, (Listener)this.fMouseHandler);
        this.fWheelHandlerInstalled = false;
    }

    private void installWheelHandler() {
        if (this.fFocusRevision != null && !this.fWheelHandlerInstalled) {
            this.fControl.addListener(37, (Listener)this.fMouseHandler);
            this.fWheelHandlerInstalled = true;
        }
    }

    private void handleMouseWheel(Event event) {
        ILineRange iLineRange;
        boolean bl = event.count > 0;
        int n = this.fFocusLine;
        ILineRange iLineRange2 = null;
        ILineRange iLineRange3 = null;
        List list = this.fFocusRevision.getRegions();
        if (bl) {
            for (RevisionRange revisionRange : list) {
                iLineRange = this.modelLinesToWidgetLines(revisionRange);
                if (RevisionPainter.contains(revisionRange, n)) {
                    iLineRange2 = iLineRange3;
                    break;
                }
                if (iLineRange == null) continue;
                iLineRange3 = iLineRange;
            }
        } else {
            Iterator iterator = list.listIterator(list.size());
            while (iterator.hasPrevious()) {
                RevisionRange revisionRange;
                revisionRange = (RevisionRange)iterator.previous();
                iLineRange = this.modelLinesToWidgetLines(revisionRange);
                if (RevisionPainter.contains(revisionRange, n)) {
                    iLineRange2 = iLineRange3;
                    break;
                }
                if (iLineRange == null) continue;
                iLineRange3 = iLineRange;
            }
        }
        if (iLineRange2 == null) {
            return;
        }
        int n2 = this.modelLinesToWidgetLines(new LineRange(n, 1)).getStartLine();
        int n3 = iLineRange2.getStartLine();
        int n4 = this.fWidget.getTopPixel() + JFaceTextUtil.computeLineHeight(this.fWidget, n2, n3, n3 - n2);
        this.fWidget.setTopPixel(n4);
        if (n4 < 0) {
            Point point = this.fWidget.getDisplay().getCursorLocation();
            point.y += n4;
            this.fWidget.getDisplay().setCursorLocation(point);
        } else {
            int n5 = this.fWidget.getTopPixel();
            if (n5 < n4) {
                Point point = this.fWidget.getDisplay().getCursorLocation();
                point.y += n4 - n5;
                this.fWidget.getDisplay().setCursorLocation(point);
            }
        }
        this.updateFocusLine(this.toDocumentLineNumber(this.fWidget.toControl((Point)this.fWidget.getDisplay().getCursorLocation()).y));
        this.immediateUpdate();
    }

    private final void postRedraw() {
        Display display;
        if (this.isConnected() && !this.fControl.isDisposed() && (display = this.fControl.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RevisionPainter.this.redraw();
                }
            });
        }
    }

    private int toDocumentLineNumber(int n) {
        return this.fParentRuler.toDocumentLineNumber(n);
    }

    private void redraw() {
        this.fColumn.redraw();
    }

    private void immediateUpdate() {
        this.fParentRuler.immediateUpdate();
    }

    private int getWidth() {
        return this.fColumn.getWidth();
    }

    private Color getBackground() {
        if (this.fBackground == null) {
            return this.fWidget.getDisplay().getSystemColor(25);
        }
        return this.fBackground;
    }

    public void setHover(IAnnotationHover iAnnotationHover) {
    }

    public boolean hasHover(int n) {
        return this.fViewer instanceof ISourceViewer && this.fHover.getHoverLineRange((ISourceViewer)this.fViewer, n) != null;
    }

    Revision getRevision(int n) {
        RevisionRange revisionRange;
        int n2;
        IDocument iDocument = this.fViewer.getDocument();
        try {
            n2 = iDocument.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (n2 != -1 && (revisionRange = this.getRange(n2)) != null) {
            return revisionRange.getRevision();
        }
        return null;
    }

    public boolean hasInformation() {
        return this.fRevisionInfo != null;
    }

    public int getRequiredWidth() {
        if (this.fRequiredWidth == -1) {
            if (this.hasInformation() && (this.fShowRevision || this.fShowAuthor)) {
                int n = 0;
                int n2 = 0;
                for (Revision revision : this.fRevisionInfo.getRevisions()) {
                    n = Math.max(n, revision.getId().length());
                    n2 = Math.max(n2, revision.getAuthor().length());
                }
                this.fRevisionIdChars = n + 1;
                this.fRequiredWidth = this.fShowAuthor && this.fShowRevision ? n + n2 + 2 : (this.fShowAuthor ? n2 + 1 : n + 1);
            } else {
                this.fRequiredWidth = 0;
            }
        }
        return this.fRequiredWidth;
    }

    public void showRevisionId(boolean bl) {
        if (this.fShowRevision != bl) {
            this.fRequiredWidth = -1;
            this.fRevisionIdChars = 0;
            this.fShowRevision = bl;
            this.postRedraw();
        }
    }

    public void showRevisionAuthor(boolean bl) {
        if (this.fShowAuthor != bl) {
            this.fRequiredWidth = -1;
            this.fRevisionIdChars = 0;
            this.fShowAuthor = bl;
            this.postRedraw();
        }
    }

    public void addRevisionListener(IRevisionListener iRevisionListener) {
        this.fRevisionListeners.add((Object)iRevisionListener);
    }

    public void removeRevisionListener(IRevisionListener iRevisionListener) {
        this.fRevisionListeners.remove((Object)iRevisionListener);
    }

    private void informListeners() {
        if (this.fRevisionInfo == null || this.fRevisionListeners.isEmpty()) {
            return;
        }
        RevisionEvent revisionEvent = new RevisionEvent(this.fRevisionInfo);
        Object[] objectArray = this.fRevisionListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IRevisionListener iRevisionListener = (IRevisionListener)objectArray[n];
            iRevisionListener.revisionInformationChanged(revisionEvent);
            ++n;
        }
    }

    private class AnnotationListener
    implements IAnnotationModelListener {
        private AnnotationListener() {
        }

        public void modelChanged(IAnnotationModel iAnnotationModel) {
            RevisionPainter.this.clearRangeCache();
            RevisionPainter.this.postRedraw();
        }
    }

    private final class ColorTool {
        private static final float AVERAGE_INTENSITY = 0.5f;
        private static final float MAX_SHADING = 0.7f;
        private static final float MIN_SHADING = 0.2f;
        private static final float FOCUS_COLOR_SHADING = 1.0f;
        private List fRevisions;
        private final Map fColors = new HashMap();
        private final Map fFocusColors = new HashMap();

        private ColorTool() {
        }

        public void setInfo(RevisionInformation revisionInformation) {
            this.fRevisions = null;
            this.fColors.clear();
            this.fFocusColors.clear();
            if (revisionInformation == null) {
                return;
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Revision revision : revisionInformation.getRevisions()) {
                arrayList.add(new Long(this.computeAge(revision)));
            }
            Collections.sort(arrayList);
            this.fRevisions = arrayList;
        }

        private RGB adaptColor(Revision revision, boolean bl) {
            float f;
            RGB rGB;
            if (RevisionPainter.this.fRenderingMode == IRevisionRulerColumnExtension.AGE) {
                int n = this.computeAgeIndex(revision);
                if (n == -1 || this.fRevisions.size() == 0) {
                    rGB = RevisionPainter.this.getBackground().getRGB();
                } else {
                    RGB[] rGBArray = Colors.palette(BY_DATE_START_COLOR, BY_DATE_END_COLOR, this.fRevisions.size());
                    rGB = rGBArray[rGBArray.length - n - 1];
                }
                f = 0.99f;
            } else if (RevisionPainter.this.fRenderingMode == IRevisionRulerColumnExtension.AUTHOR) {
                rGB = revision.getColor();
                rGB = Colors.adjustBrightness(rGB, 0.5f);
                f = 0.6f;
            } else if (RevisionPainter.this.fRenderingMode == IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE) {
                rGB = revision.getColor();
                rGB = Colors.adjustBrightness(rGB, 0.5f);
                int n = this.computeAgeIndex(revision);
                int n2 = this.fRevisions.size();
                f = n == -1 || n2 < 2 ? 0.5f : (float)n / (float)(n2 - 1);
            } else {
                Assert.isTrue((boolean)false);
                return null;
            }
            rGB = this.getShadedColor(rGB, f, bl);
            return rGB;
        }

        private int computeAgeIndex(Revision revision) {
            long l = this.computeAge(revision);
            int n = this.fRevisions.indexOf(new Long(l));
            return n;
        }

        private RGB getShadedColor(RGB rGB, float f, boolean bl) {
            Assert.isLegal(((double)f >= 0.0 ? 1 : 0) != 0);
            Assert.isLegal(((double)f <= 1.0 ? 1 : 0) != 0);
            RGB rGB2 = RevisionPainter.this.getBackground().getRGB();
            boolean bl2 = RevisionPainter.this.getWidth() <= 15;
            float f2 = bl2 ? 0.3f : 0.0f;
            float f3 = 0.7f + f2;
            float f4 = 0.2f + f2;
            f = (f3 - f4) * f + f4;
            if (bl && (f += 1.0f) > 1.0f) {
                rGB2 = new RGB(255 - rGB2.red, 255 - rGB2.green, 255 - rGB2.blue);
                f = 2.0f - f;
            }
            return Colors.blend(rGB2, rGB, f);
        }

        private long computeAge(Revision revision) {
            return revision.getDate().getTime();
        }

        public RGB getColor(Revision revision, boolean bl) {
            Map map = bl ? this.fFocusColors : this.fColors;
            RGB rGB = (RGB)map.get(revision);
            if (rGB != null) {
                return rGB;
            }
            rGB = this.adaptColor(revision, bl);
            map.put(revision, rGB);
            return rGB;
        }
    }

    private static final class HoverInformationControlCreator
    extends AbstractReusableInformationControlCreator {
        private boolean fIsFocusable;

        public HoverInformationControlCreator(boolean bl) {
            this.fIsFocusable = bl;
        }

        @Override
        protected IInformationControl doCreateInformationControl(Shell shell) {
            if (BrowserInformationControl.isAvailable((Composite)shell)) {
                return new BrowserInformationControl(shell, "org.eclipse.jface.dialogfont", this.fIsFocusable){

                    @Override
                    public void setInformation(String string) {
                        string = this.addCSSToHTMLFragment(string);
                        super.setInformation(string);
                    }

                    private String addCSSToHTMLFragment(String string) {
                        int n = Math.min(100, string.length());
                        if (string.substring(0, n).indexOf("<html>") != -1) {
                            return string;
                        }
                        StringBuffer stringBuffer = new StringBuffer(512 + string.length());
                        HTMLPrinter.insertPageProlog(stringBuffer, 0, RevisionPainter.fgStyleSheet);
                        stringBuffer.append(string);
                        HTMLPrinter.addPageEpilog(stringBuffer);
                        return stringBuffer.toString();
                    }
                };
            }
            return new DefaultInformationControl(shell, this.fIsFocusable);
        }

        @Override
        public boolean canReplace(IInformationControlCreator iInformationControlCreator) {
            return iInformationControlCreator.getClass() == this.getClass() && ((HoverInformationControlCreator)iInformationControlCreator).fIsFocusable == this.fIsFocusable;
        }
    }

    private class MouseHandler
    implements MouseMoveListener,
    MouseTrackListener,
    Listener {
        private RevisionRange fMouseDownRegion;

        private MouseHandler() {
        }

        private void handleMouseUp(Event event) {
            if (event.button == 1) {
                RevisionRange revisionRange = RevisionPainter.this.fFocusRange;
                RevisionRange revisionRange2 = this.fMouseDownRegion;
                this.fMouseDownRegion = null;
                if (revisionRange == revisionRange2) {
                    Revision revision;
                    Revision revision2 = revision = revisionRange == null ? null : revisionRange.getRevision();
                    if (revision == RevisionPainter.this.fSelectedRevision) {
                        revision = null;
                    }
                    RevisionPainter.this.handleRevisionSelected(revision);
                }
            }
        }

        private void handleMouseDown(Event event) {
            if (event.button == 3) {
                RevisionPainter.this.updateFocusRevision(null);
            }
            if (event.button == 1) {
                this.fMouseDownRegion = RevisionPainter.this.fFocusRange;
                RevisionPainter.this.postRedraw();
            }
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 37: {
                    RevisionPainter.this.handleMouseWheel(event);
                    break;
                }
                case 3: {
                    this.handleMouseDown(event);
                    break;
                }
                case 4: {
                    this.handleMouseUp(event);
                    break;
                }
                default: {
                    Assert.isLegal((boolean)false);
                }
            }
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            RevisionPainter.this.updateFocusLine(RevisionPainter.this.toDocumentLineNumber(mouseEvent.y));
        }

        public void mouseExit(MouseEvent mouseEvent) {
            RevisionPainter.this.updateFocusLine(-1);
        }

        public void mouseHover(MouseEvent mouseEvent) {
        }

        public void mouseMove(MouseEvent mouseEvent) {
            RevisionPainter.this.updateFocusLine(RevisionPainter.this.toDocumentLineNumber(mouseEvent.y));
        }
    }

    private static final class RevisionAnnotation
    extends Annotation {
        public RevisionAnnotation(String string) {
            super("org.eclipse.ui.workbench.texteditor.revisionAnnotation", false, string);
        }
    }

    private final class RevisionHover
    implements IAnnotationHover,
    IAnnotationHoverExtension,
    IAnnotationHoverExtension2,
    IInformationProviderExtension2 {
        private RevisionHover() {
        }

        @Override
        public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
            Object object = this.getHoverInfo(iSourceViewer, this.getHoverLineRange(iSourceViewer, n), 0);
            return object == null ? null : object.toString();
        }

        @Override
        public IInformationControlCreator getHoverControlCreator() {
            IInformationControlCreator iInformationControlCreator;
            RevisionInformation revisionInformation = RevisionPainter.this.fRevisionInfo;
            if (revisionInformation != null && (iInformationControlCreator = revisionInformation.getHoverControlCreator()) != null) {
                return iInformationControlCreator;
            }
            return new HoverInformationControlCreator(false);
        }

        @Override
        public boolean canHandleMouseCursor() {
            return false;
        }

        @Override
        public boolean canHandleMouseWheel() {
            return true;
        }

        @Override
        public Object getHoverInfo(ISourceViewer iSourceViewer, ILineRange iLineRange, int n) {
            RevisionRange revisionRange = RevisionPainter.this.getRange(iLineRange.getStartLine());
            Object object = revisionRange == null ? null : revisionRange.getRevision().getHoverInfo();
            return object;
        }

        @Override
        public ILineRange getHoverLineRange(ISourceViewer iSourceViewer, int n) {
            RevisionRange revisionRange = RevisionPainter.this.getRange(n);
            return revisionRange == null ? null : new LineRange(n, 1);
        }

        @Override
        public IInformationControlCreator getInformationPresenterControlCreator() {
            IInformationControlCreator iInformationControlCreator;
            RevisionInformation revisionInformation = RevisionPainter.this.fRevisionInfo;
            if (revisionInformation != null && (iInformationControlCreator = revisionInformation.getInformationPresenterControlCreator()) != null) {
                return iInformationControlCreator;
            }
            return new HoverInformationControlCreator(true);
        }
    }
}

