/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.revisions;

import org.eclipse.jface.internal.text.revisions.LineIndexOutOfBoundsException;
import org.eclipse.jface.text.source.ILineRange;

public final class Range
implements ILineRange,
Cloneable {
    private int fStart;
    private int fLength;

    public static Range copy(ILineRange iLineRange) throws LineIndexOutOfBoundsException {
        return Range.createRelative(iLineRange.getStartLine(), iLineRange.getNumberOfLines());
    }

    public static Range copy(Range range) {
        return Range.createRelative(range.start(), range.length());
    }

    public static Range createRelative(int n, int n2) throws LineIndexOutOfBoundsException {
        return new Range(n, n2);
    }

    public static Range createAbsolute(int n, int n2) {
        return new Range(n, n2 - n);
    }

    private Range(int n, int n2) {
        this.moveTo(n);
        this.setLength(n2);
    }

    @Override
    public int getStartLine() {
        return this.start();
    }

    @Override
    public int getNumberOfLines() {
        return this.length();
    }

    public int start() {
        return this.fStart;
    }

    public int length() {
        return this.fLength;
    }

    public int end() {
        return this.start() + this.length();
    }

    public void moveTo(int n) throws LineIndexOutOfBoundsException {
        if (n < 0) {
            throw new LineIndexOutOfBoundsException("Cannot set a negative start: " + n);
        }
        this.fStart = n;
    }

    public void moveEndTo(int n) throws LineIndexOutOfBoundsException {
        this.moveTo(n - this.length());
    }

    public void moveBy(int n) throws LineIndexOutOfBoundsException {
        this.moveTo(this.start() + n);
    }

    public void setStart(int n) throws LineIndexOutOfBoundsException {
        int n2 = this.end();
        if (n < 0 || n >= n2) {
            throw new LineIndexOutOfBoundsException("Cannot set a negative start: " + n);
        }
        this.moveTo(n);
        this.setEnd(n2);
    }

    public void setEnd(int n) throws LineIndexOutOfBoundsException {
        this.setLength(n - this.start());
    }

    public void setLength(int n) throws LineIndexOutOfBoundsException {
        if (n <= 0) {
            throw new LineIndexOutOfBoundsException("Cannot set length <= 0: " + n);
        }
        this.fLength = n;
    }

    public void setLengthAndMove(int n) throws LineIndexOutOfBoundsException {
        this.setStart(this.end() - n);
    }

    public void resizeBy(int n) throws LineIndexOutOfBoundsException {
        this.setLength(this.length() + n);
    }

    public void resizeAndMoveBy(int n) throws LineIndexOutOfBoundsException {
        this.setStart(this.start() + n);
    }

    public Range split(int n) throws LineIndexOutOfBoundsException {
        if (n >= this.length()) {
            throw new LineIndexOutOfBoundsException("Remaining must be less than length: " + this.length());
        }
        int n2 = this.length() - n;
        this.setLength(n);
        return new Range(this.end(), n2);
    }

    public boolean equalRange(ILineRange iLineRange) {
        if (iLineRange == this) {
            return true;
        }
        if (iLineRange == null) {
            return false;
        }
        return iLineRange.getStartLine() == this.start() && iLineRange.getNumberOfLines() == this.length();
    }

    public Object clone() {
        return Range.copy(this);
    }
}

