/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.revisions;

import java.util.ArrayList;
import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;

public final class HunkComputer {
    public static Hunk[] computeHunks(ILineDiffer iLineDiffer, int n) {
        ArrayList<Hunk> arrayList = new ArrayList<Hunk>(n);
        int n2 = 0;
        int n3 = 0;
        ILineDiffInfo iLineDiffInfo = null;
        int n4 = 0;
        while (n4 < n) {
            iLineDiffInfo = iLineDiffer.getLineInfo(n4);
            if (iLineDiffInfo != null) {
                int n5 = iLineDiffInfo.getChangeType();
                switch (n5) {
                    case 1: {
                        ++n2;
                        break;
                    }
                    case 2: {
                        ++n3;
                        break;
                    }
                    case 0: {
                        if ((n2 -= iLineDiffInfo.getRemovedLinesAbove()) == 0 && n3 == 0) break;
                        arrayList.add(new Hunk(n4 - n3 - Math.max(0, n2), n2, n3));
                        n2 = 0;
                        n3 = 0;
                    }
                }
            }
            ++n4;
        }
        if (iLineDiffInfo != null && ((n2 -= iLineDiffInfo.getRemovedLinesBelow()) != 0 || n3 != 0)) {
            arrayList.add(new Hunk(n - n3, n2, n3));
            n2 = 0;
            n3 = 0;
        }
        return arrayList.toArray(new Hunk[arrayList.size()]);
    }

    private HunkComputer() {
    }
}

