/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.revisions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.RGB;

public final class Colors {
    public static float brightness(RGB rGB) {
        return Math.min(1.0f, (0.2126f * (float)rGB.red + 0.7152f * (float)rGB.green + 0.0722f * (float)rGB.blue + 0.5f) / 255.0f);
    }

    public static RGB adjustBrightness(RGB rGB, float f) {
        float[] fArray = Colors.toHSI(rGB);
        float f2 = f - Colors.brightness(rGB);
        float f3 = 0.5f;
        fArray[2] = Math.max(0.0f, Math.min(1.0f, fArray[2] + f2 * f3));
        rGB = Colors.fromHSI(fArray);
        return rGB;
    }

    private static float[] toHSI(RGB rGB) {
        float f = (float)rGB.red / 255.0f;
        float f2 = (float)rGB.green / 255.0f;
        float f3 = (float)rGB.blue / 255.0f;
        float f4 = Math.max(Math.max(f, f2), f3);
        float f5 = Math.min(Math.min(f, f2), f3);
        float f6 = f4 - f5;
        float f7 = f4 + f5;
        float f8 = f7 / 2.0f;
        float f9 = (double)f8 < 0.5 ? f6 / f7 : f6 / (2.0f - f7);
        float f10 = 0.0f;
        if (f6 != 0.0f) {
            f10 = f == f4 ? (f2 - f3) / f6 : (f2 == f4 ? 2.0f + (f3 - f) / f6 : 4.0f + (f - f2) / f6);
            if ((f10 *= 60.0f) < 0.0f) {
                f10 += 360.0f;
            }
        }
        return new float[]{f10, f9, f8};
    }

    private static RGB fromHSI(float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4 = fArray[0];
        float f5 = fArray[1];
        float f6 = fArray[2];
        if (f5 == 0.0f) {
            f2 = f3 = f6;
            f = f3;
        } else {
            float f7 = f6 < 0.5f ? f6 * (1.0f + f5) : f6 + f5 - f6 * f5;
            float f8 = 2.0f * f6 - f7;
            if (f4 == 360.0f) {
                f4 = 0.0f;
            }
            f = Colors.hue2RGB(f8, f7, (f4 /= 360.0f) + 0.33333334f);
            f2 = Colors.hue2RGB(f8, f7, f4);
            f3 = Colors.hue2RGB(f8, f7, f4 - 0.33333334f);
        }
        int n = (int)((double)(f * 255.0f) + 0.5);
        int n2 = (int)((double)(f2 * 255.0f) + 0.5);
        int n3 = (int)((double)(f3 * 255.0f) + 0.5);
        return new RGB(n, n2, n3);
    }

    private static float hue2RGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        } else if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (6.0f * f3 < 1.0f) {
            return f + (f2 - f) * 6.0f * f3;
        }
        if (2.0f * f3 < 1.0f) {
            return f2;
        }
        if (3.0f * f3 < 2.0f) {
            return f + (f2 - f) * (0.6666667f - f3) * 6.0f;
        }
        return f;
    }

    public static RGB blend(RGB rGB, RGB rGB2, float f) {
        Assert.isLegal((rGB != null ? 1 : 0) != 0);
        Assert.isLegal((rGB2 != null ? 1 : 0) != 0);
        Assert.isLegal((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0);
        float f2 = 1.0f - f;
        return new RGB((int)(f2 * (float)rGB.red + f * (float)rGB2.red), (int)(f2 * (float)rGB.green + f * (float)rGB2.green), (int)(f2 * (float)rGB.blue + f * (float)rGB2.blue));
    }

    public static RGB[] palette(RGB rGB, RGB rGB2, int n) {
        Assert.isLegal((rGB != null ? 1 : 0) != 0);
        Assert.isLegal((rGB2 != null ? 1 : 0) != 0);
        Assert.isLegal((n > 0 ? 1 : 0) != 0);
        if (n == 1) {
            return new RGB[]{rGB};
        }
        float f = 1.0f / (float)(n - 1);
        RGB[] rGBArray = new RGB[n];
        int n2 = 0;
        while (n2 < n) {
            rGBArray[n2] = Colors.blend(rGB, rGB2, f * (float)n2);
            ++n2;
        }
        return rGBArray;
    }

    public static RGB[] rainbow(int n) {
        Assert.isLegal((n >= 2 ? 1 : 0) != 0);
        RGB[] rGBArray = new RGB[n];
        int n2 = 0;
        while (n2 < n) {
            rGBArray[n2] = new RGB(Colors.computeHue(n2), 1.0f, 1.0f);
            ++n2;
        }
        return rGBArray;
    }

    public static float computeHue(int n) {
        int n2;
        Assert.isLegal((n >= 0 ? 1 : 0) != 0);
        int n3 = n / 3;
        float f = 120.0f;
        float f2 = 0.0f;
        while (n3 > 0) {
            n2 = n3 % 2;
            f2 += (float)n2 * (f /= 2.0f);
            n3 >>= 1;
        }
        n2 = n % 3;
        float f3 = f2 + (float)n2 * 360.0f / 3.0f;
        Assert.isTrue((f3 >= 0.0f && f3 < 360.0f ? 1 : 0) != 0);
        return f3;
    }

    private Colors() {
    }
}

