/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.revisions;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.internal.text.revisions.Range;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;

public final class ChangeRegion {
    private final Revision fRevision;
    private final ILineRange fLines;
    private final List fAdjusted = new LinkedList();

    public ChangeRegion(Revision revision, ILineRange iLineRange) throws IndexOutOfBoundsException {
        Assert.isLegal((revision != null ? 1 : 0) != 0);
        Assert.isLegal((iLineRange != null ? 1 : 0) != 0);
        this.fLines = Range.copy(iLineRange);
        this.fRevision = revision;
        this.clearDiff();
    }

    public Revision getRevision() {
        return this.fRevision;
    }

    public ILineRange getOriginalRange() {
        return this.fLines;
    }

    public List getAdjustedRanges() {
        return this.fAdjusted;
    }

    public ILineRange getAdjustedCoverage() {
        if (this.fAdjusted.isEmpty()) {
            return new LineRange(this.fLines.getStartLine(), 0);
        }
        Range range = (Range)this.fAdjusted.get(0);
        Range range2 = (Range)this.fAdjusted.get(this.fAdjusted.size() - 1);
        return Range.createAbsolute(range.start(), range2.end());
    }

    public void clearDiff() {
        this.fAdjusted.clear();
        this.fAdjusted.add(Range.copy(this.fLines));
    }

    public void adjustTo(Hunk hunk) {
        ListIterator<Range> listIterator = this.fAdjusted.listIterator();
        while (listIterator.hasNext()) {
            int n;
            Range range = (Range)listIterator.next();
            int n2 = this.getUnchanged(hunk, range.start());
            if (n2 > 0) {
                if (n2 >= range.length()) continue;
                range = range.split(n2);
                listIterator.add(range);
                listIterator.previous();
                listIterator.next();
            }
            Assert.isTrue((hunk.line <= (n = range.start()) ? 1 : 0) != 0);
            int n3 = this.getOverlap(hunk, n);
            if (n3 >= range.length()) {
                listIterator.remove();
                continue;
            }
            range.moveBy(hunk.delta + n3);
            range.resizeBy(-n3);
        }
    }

    private int getUnchanged(Hunk hunk, int n) {
        return Math.max(0, hunk.line - n);
    }

    private int getOverlap(Hunk hunk, int n) {
        int n2 = hunk.line + hunk.changed;
        if (hunk.delta >= 0) {
            if (n2 <= n) {
                return 0;
            }
            return n2 - n;
        }
        int n3 = n2 - hunk.delta;
        int n4 = n3 - n;
        return Math.max(0, n4);
    }

    public String toString() {
        return "ChangeRegion [" + this.fRevision.toString() + ", [" + this.fLines.getStartLine() + "+" + this.fLines.getNumberOfLines() + ")]";
    }
}

