/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.link.contentassist;

import java.util.Stack;
import org.eclipse.jface.internal.text.link.contentassist.ContentAssistant2;
import org.eclipse.jface.internal.text.link.contentassist.Helper2;
import org.eclipse.jface.internal.text.link.contentassist.IContentAssistListener2;
import org.eclipse.jface.internal.text.link.contentassist.PopupCloser2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class ContextInformationPopup2
implements IContentAssistListener2 {
    private ITextViewer fViewer;
    private ContentAssistant2 fContentAssistant;
    private PopupCloser2 fPopupCloser = new PopupCloser2();
    private Shell fContextSelectorShell;
    private Table fContextSelectorTable;
    private IContextInformation[] fContextSelectorInput;
    private String fLineDelimiter = null;
    private Shell fContextInfoPopup;
    private StyledText fContextInfoText;
    private TextPresentation fTextPresentation;
    private Stack fContextFrameStack = new Stack();

    public ContextInformationPopup2(ContentAssistant2 contentAssistant2, ITextViewer iTextViewer) {
        this.fContentAssistant = contentAssistant2;
        this.fViewer = iTextViewer;
    }

    public String showContextProposals(boolean bl) {
        final StyledText styledText = this.fViewer.getTextWidget();
        BusyIndicator.showWhile((Display)styledText.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                int n;
                int n2 = ((ContextInformationPopup2)ContextInformationPopup2.this).fViewer.getSelectedRange().x;
                IContextInformation[] iContextInformationArray = ContextInformationPopup2.this.computeContextInformation(n2);
                int n3 = n = iContextInformationArray == null ? 0 : iContextInformationArray.length;
                if (n == 1) {
                    ContextInformationPopup2.this.internalShowContextInfo(iContextInformationArray[0], n2);
                } else if (n > 0) {
                    if (ContextInformationPopup2.this.fLineDelimiter == null) {
                        ContextInformationPopup2.this.fLineDelimiter = styledText.getLineDelimiter();
                    }
                    ContextInformationPopup2.this.createContextSelector();
                    ContextInformationPopup2.this.setContexts(iContextInformationArray);
                    ContextInformationPopup2.this.displayContextSelector();
                    ContextInformationPopup2.this.hideContextInfoPopup();
                }
            }
        });
        return this.getErrorMessage();
    }

    public void showContextInformation(final IContextInformation iContextInformation, final int n) {
        StyledText styledText = this.fViewer.getTextWidget();
        BusyIndicator.showWhile((Display)styledText.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ContextInformationPopup2.this.internalShowContextInfo(iContextInformation, n);
                ContextInformationPopup2.this.hideContextSelector();
            }
        });
    }

    private void internalShowContextInfo(IContextInformation iContextInformation, int n) {
        IContextInformationValidator iContextInformationValidator = this.fContentAssistant.getContextInformationValidator(this.fViewer, n);
        if (iContextInformationValidator != null) {
            ContextFrame contextFrame = new ContextFrame();
            contextFrame.fInformation = iContextInformation;
            int n2 = contextFrame.fBeginOffset = iContextInformation instanceof IContextInformationExtension ? ((IContextInformationExtension)((Object)iContextInformation)).getContextInformationPosition() : n;
            if (contextFrame.fBeginOffset == -1) {
                contextFrame.fBeginOffset = n;
            }
            contextFrame.fOffset = n;
            contextFrame.fVisibleOffset = this.fViewer.getTextWidget().getSelectionRange().x - (n - contextFrame.fBeginOffset);
            contextFrame.fValidator = iContextInformationValidator;
            contextFrame.fPresenter = this.fContentAssistant.getContextInformationPresenter(this.fViewer, n);
            this.fContextFrameStack.push(contextFrame);
            this.internalShowContextFrame(contextFrame, this.fContextFrameStack.size() == 1);
        }
    }

    private void internalShowContextFrame(ContextFrame contextFrame, boolean bl) {
        contextFrame.fValidator.install(contextFrame.fInformation, this.fViewer, contextFrame.fOffset);
        if (contextFrame.fPresenter != null) {
            if (this.fTextPresentation == null) {
                this.fTextPresentation = new TextPresentation();
            }
            contextFrame.fPresenter.install(contextFrame.fInformation, this.fViewer, contextFrame.fBeginOffset);
            contextFrame.fPresenter.updatePresentation(contextFrame.fOffset, this.fTextPresentation);
        }
        this.createContextInfoPopup();
        this.fContextInfoText.setText(contextFrame.fInformation.getInformationDisplayString());
        if (this.fTextPresentation != null) {
            TextPresentation.applyTextPresentation(this.fTextPresentation, this.fContextInfoText);
        }
        this.resize();
        if (bl) {
            if (this.fContentAssistant.addContentAssistListener(this, 2)) {
                this.fContentAssistant.addToLayout(this, this.fContextInfoPopup, 2, contextFrame.fVisibleOffset);
                this.fContextInfoPopup.setVisible(true);
            }
        } else {
            this.fContentAssistant.layout(2, contextFrame.fVisibleOffset);
        }
    }

    private IContextInformation[] computeContextInformation(int n) {
        return this.fContentAssistant.computeContextInformation(this.fViewer, n);
    }

    private String getErrorMessage() {
        return this.fContentAssistant.getErrorMessage();
    }

    private void createContextInfoPopup() {
        if (Helper2.okToUse((Widget)this.fContextInfoPopup)) {
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        Display display = styledText.getDisplay();
        this.fContextInfoPopup = new Shell(styledText.getShell(), 16392);
        this.fContextInfoPopup.setBackground(display.getSystemColor(2));
        this.fContextInfoText = new StyledText((Composite)this.fContextInfoPopup, 10);
        Color color = this.fContentAssistant.getContextInformationPopupBackground();
        if (color == null) {
            color = display.getSystemColor(29);
        }
        this.fContextInfoText.setBackground(color);
        color = this.fContentAssistant.getContextInformationPopupForeground();
        if (color == null) {
            color = display.getSystemColor(28);
        }
        this.fContextInfoText.setForeground(color);
    }

    private void resize() {
        Point point = this.fContextInfoText.computeSize(-1, -1, true);
        point.x += 3;
        this.fContextInfoText.setSize(point);
        this.fContextInfoText.setLocation(1, 1);
        point.x += 2;
        point.y += 2;
        this.fContextInfoPopup.setSize(point);
    }

    private void hideContextInfoPopup() {
        if (Helper2.okToUse((Widget)this.fContextInfoPopup)) {
            int n = this.fContextFrameStack.size();
            if (n > 0) {
                this.fContextFrameStack.pop();
                --n;
            }
            if (n > 0) {
                ContextFrame contextFrame = (ContextFrame)this.fContextFrameStack.peek();
                this.internalShowContextFrame(contextFrame, false);
            } else {
                this.fContentAssistant.removeContentAssistListener(this, 2);
                this.fContextInfoPopup.setVisible(false);
                this.fContextInfoPopup.dispose();
                this.fContextInfoPopup = null;
                if (this.fTextPresentation != null) {
                    this.fTextPresentation.clear();
                    this.fTextPresentation = null;
                }
            }
        }
        if (this.fContextInfoPopup == null) {
            this.fContentAssistant.contextInformationClosed();
        }
    }

    private void createContextSelector() {
        if (Helper2.okToUse((Widget)this.fContextSelectorShell)) {
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        this.fContextSelectorShell = new Shell(styledText.getShell(), 16392);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fContextSelectorShell.setLayout((Layout)gridLayout);
        this.fContextSelectorShell.setBackground(styledText.getDisplay().getSystemColor(2));
        this.fContextSelectorTable = new Table((Composite)this.fContextSelectorShell, 768);
        this.fContextSelectorTable.setLocation(1, 1);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.fContextSelectorTable.getItemHeight() * 10;
        gridData.widthHint = 300;
        this.fContextSelectorTable.setLayoutData((Object)gridData);
        this.fContextSelectorShell.pack(true);
        Color color = this.fContentAssistant.getContextSelectorBackground();
        if (color == null) {
            color = styledText.getDisplay().getSystemColor(29);
        }
        this.fContextSelectorTable.setBackground(color);
        color = this.fContentAssistant.getContextSelectorForeground();
        if (color == null) {
            color = styledText.getDisplay().getSystemColor(28);
        }
        this.fContextSelectorTable.setForeground(color);
        this.fContextSelectorTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ContextInformationPopup2.this.insertSelectedContext();
                ContextInformationPopup2.this.hideContextSelector();
            }
        });
        this.fPopupCloser.install(this.fContentAssistant, this.fContextSelectorTable);
        this.fContextSelectorTable.setHeaderVisible(false);
        this.fContentAssistant.addToLayout(this, this.fContextSelectorShell, 1, this.fContentAssistant.getSelectionOffset());
    }

    private void insertSelectedContext() {
        int n = this.fContextSelectorTable.getSelectionIndex();
        if (n < 0 || n >= this.fContextSelectorInput.length) {
            return;
        }
        int n2 = this.fViewer.getSelectedRange().x;
        this.internalShowContextInfo(this.fContextSelectorInput[n], n2);
    }

    private void setContexts(IContextInformation[] iContextInformationArray) {
        if (Helper2.okToUse((Widget)this.fContextSelectorTable)) {
            this.fContextSelectorInput = iContextInformationArray;
            this.fContextSelectorTable.setRedraw(false);
            this.fContextSelectorTable.removeAll();
            int n = 0;
            while (n < iContextInformationArray.length) {
                IContextInformation iContextInformation = iContextInformationArray[n];
                TableItem tableItem = new TableItem(this.fContextSelectorTable, 0);
                if (iContextInformation.getImage() != null) {
                    tableItem.setImage(iContextInformation.getImage());
                }
                tableItem.setText(iContextInformation.getContextDisplayString());
                ++n;
            }
            this.fContextSelectorTable.select(0);
            this.fContextSelectorTable.setRedraw(true);
        }
    }

    private void displayContextSelector() {
        if (this.fContentAssistant.addContentAssistListener(this, 0)) {
            this.fContextSelectorShell.setVisible(true);
        }
    }

    private void hideContextSelector() {
        if (Helper2.okToUse((Widget)this.fContextSelectorShell)) {
            this.fContentAssistant.removeContentAssistListener(this, 0);
            this.fPopupCloser.uninstall();
            this.fContextSelectorShell.setVisible(false);
            this.fContextSelectorShell.dispose();
            this.fContextSelectorShell = null;
        }
        if (!Helper2.okToUse((Widget)this.fContextInfoPopup)) {
            this.fContentAssistant.contextInformationClosed();
        }
    }

    public boolean hasFocus() {
        if (Helper2.okToUse((Widget)this.fContextSelectorShell)) {
            return this.fContextSelectorShell.isFocusControl() || this.fContextSelectorTable.isFocusControl();
        }
        return false;
    }

    public void hide() {
        this.hideContextSelector();
        this.hideContextInfoPopup();
    }

    public boolean isActive() {
        return Helper2.okToUse((Widget)this.fContextInfoPopup) || Helper2.okToUse((Widget)this.fContextSelectorShell);
    }

    @Override
    public boolean verifyKey(VerifyEvent verifyEvent) {
        if (Helper2.okToUse((Widget)this.fContextSelectorShell)) {
            return this.contextSelectorKeyPressed(verifyEvent);
        }
        if (Helper2.okToUse((Widget)this.fContextInfoPopup)) {
            return this.contextInfoPopupKeyPressed((KeyEvent)verifyEvent);
        }
        return true;
    }

    private boolean contextSelectorKeyPressed(VerifyEvent verifyEvent) {
        char c = verifyEvent.character;
        if (c == '\u0000') {
            int n;
            int n2 = this.fContextSelectorTable.getSize().y / this.fContextSelectorTable.getItemHeight() - 1;
            int n3 = this.fContextSelectorTable.getSelectionIndex();
            switch (verifyEvent.keyCode) {
                case 0x1000001: {
                    n = this.fContextSelectorTable.getSelectionIndex() > 0 ? -1 : 0;
                    break;
                }
                case 0x1000002: {
                    n = this.fContextSelectorTable.getSelectionIndex() < this.fContextSelectorTable.getItemCount() - 1 ? 1 : 0;
                    break;
                }
                case 0x1000006: {
                    n = n2;
                    if (n3 + n < this.fContextSelectorTable.getItemCount()) break;
                    n = this.fContextSelectorTable.getItemCount() - n3;
                    break;
                }
                case 0x1000005: {
                    n = -n2;
                    if (n3 + n >= 0) break;
                    n = -n3;
                    break;
                }
                case 0x1000007: {
                    n = -n3;
                    break;
                }
                case 0x1000008: {
                    n = this.fContextSelectorTable.getItemCount() - n3;
                    break;
                }
                default: {
                    if (verifyEvent.keyCode != SWT.MOD1 && verifyEvent.keyCode != SWT.MOD2 && verifyEvent.keyCode != SWT.MOD3 && verifyEvent.keyCode != SWT.MOD4) {
                        this.hideContextSelector();
                    }
                    return true;
                }
            }
            this.fContextSelectorTable.setSelection(n3 + n);
            this.fContextSelectorTable.showSelection();
            verifyEvent.doit = false;
            return false;
        }
        if ('\t' == c) {
            verifyEvent.doit = false;
            this.fContextSelectorShell.setFocus();
            return false;
        }
        if (c == '\u001b') {
            verifyEvent.doit = false;
            this.hideContextSelector();
        }
        return true;
    }

    private boolean contextInfoPopupKeyPressed(KeyEvent keyEvent) {
        char c = keyEvent.character;
        if (c == '\u0000') {
            switch (keyEvent.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    this.validateContextInformation();
                    break;
                }
                default: {
                    if (keyEvent.keyCode != SWT.MOD1 && keyEvent.keyCode != SWT.MOD2 && keyEvent.keyCode != SWT.MOD3 && keyEvent.keyCode != SWT.MOD4) {
                        this.hideContextInfoPopup();
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (c == '\u001b') {
            keyEvent.doit = false;
            this.hideContextInfoPopup();
        } else {
            this.validateContextInformation();
        }
        return true;
    }

    @Override
    public void processEvent(VerifyEvent verifyEvent) {
        if (Helper2.okToUse((Widget)this.fContextSelectorShell)) {
            this.contextSelectorProcessEvent(verifyEvent);
        }
        if (Helper2.okToUse((Widget)this.fContextInfoPopup)) {
            this.contextInfoPopupProcessEvent(verifyEvent);
        }
    }

    private void contextSelectorProcessEvent(VerifyEvent verifyEvent) {
        if (verifyEvent.start == verifyEvent.end && verifyEvent.text != null && verifyEvent.text.equals(this.fLineDelimiter)) {
            verifyEvent.doit = false;
            this.insertSelectedContext();
        }
        this.hideContextSelector();
    }

    private void contextInfoPopupProcessEvent(VerifyEvent verifyEvent) {
        if (verifyEvent.start != verifyEvent.end && (verifyEvent.text == null || verifyEvent.text.length() == 0)) {
            this.validateContextInformation();
        }
    }

    private void validateContextInformation() {
        this.fContextInfoPopup.getDisplay().asyncExec(new Runnable(){
            private ContextFrame fFrame;
            {
                this.fFrame = (ContextFrame)ContextInformationPopup2.this.fContextFrameStack.peek();
            }

            @Override
            public void run() {
                if (Helper2.okToUse((Widget)ContextInformationPopup2.this.fContextInfoPopup) && this.fFrame == ContextInformationPopup2.this.fContextFrameStack.peek()) {
                    int n = ((ContextInformationPopup2)ContextInformationPopup2.this).fViewer.getSelectedRange().x;
                    if (this.fFrame.fValidator == null || !this.fFrame.fValidator.isContextInformationValid(n)) {
                        ContextInformationPopup2.this.hideContextInfoPopup();
                    } else if (this.fFrame.fPresenter != null && this.fFrame.fPresenter.updatePresentation(n, ContextInformationPopup2.this.fTextPresentation)) {
                        TextPresentation.applyTextPresentation(ContextInformationPopup2.this.fTextPresentation, ContextInformationPopup2.this.fContextInfoText);
                        ContextInformationPopup2.this.resize();
                    }
                }
            }
        });
    }

    static class ContextFrame {
        public int fBeginOffset;
        public int fOffset;
        public int fVisibleOffset;
        public IContextInformation fInformation;
        public IContextInformationValidator fValidator;
        public IContextInformationPresenter fPresenter;

        ContextFrame() {
        }
    }
}

