/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.link.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.link.contentassist.AdditionalInfoController2;
import org.eclipse.jface.internal.text.link.contentassist.CompletionProposalPopup2;
import org.eclipse.jface.internal.text.link.contentassist.ContentAssistMessages;
import org.eclipse.jface.internal.text.link.contentassist.ContextInformationPopup2;
import org.eclipse.jface.internal.text.link.contentassist.Helper2;
import org.eclipse.jface.internal.text.link.contentassist.IContentAssistListener2;
import org.eclipse.jface.internal.text.link.contentassist.IProposalListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ContentAssistant2
implements IContentAssistant,
IContentAssistantExtension,
IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    static final int CONTEXT_SELECTOR = 0;
    static final int PROPOSAL_SELECTOR = 1;
    static final int CONTEXT_INFO_POPUP = 2;
    public static final int WIDGET_PRIORITY = 10;
    private static final int DEFAULT_AUTO_ACTIVATION_DELAY = 500;
    private IInformationControlCreator fInformationControlCreator;
    private int fAutoActivationDelay = 500;
    private boolean fIsAutoActivated = false;
    private boolean fIsAutoInserting = false;
    private int fProposalPopupOrientation = 10;
    private int fContextInfoPopupOrientation = 20;
    private Map fProcessors;
    private String fPartitioning;
    private Color fContextInfoPopupBackground;
    private Color fContextInfoPopupForeground;
    private Color fContextSelectorBackground;
    private Color fContextSelectorForeground;
    private ITextViewer fViewer;
    private String fLastErrorMessage;
    private Closer fCloser;
    private LayoutManager fLayoutManager;
    private AutoAssistListener fAutoAssistListener;
    private InternalListener fInternalListener;
    private CompletionProposalPopup2 fProposalPopup;
    private ContextInformationPopup2 fContextInfoPopup;
    private boolean fKeyListenerHooked = false;
    private IContentAssistListener2[] fListeners = new IContentAssistListener2[4];
    private int fCompletionPosition;
    private String[] fProposalStrings;
    private ICompletionProposal[] fProposals;
    private final List fProposalListeners = new ArrayList();
    private boolean fIsColoredLabelsSupportEnabled = false;

    public ContentAssistant2() {
        this.setContextInformationPopupOrientation(20);
        this.setInformationControlCreator(this.getInformationControlCreator());
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            @Override
            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, false);
            }
        };
    }

    public void setDocumentPartitioning(String string) {
        Assert.isNotNull((Object)string);
        this.fPartitioning = string;
    }

    @Override
    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setContentAssistProcessor(IContentAssistProcessor iContentAssistProcessor, String string) {
        Assert.isNotNull((Object)string);
        if (this.fProcessors == null) {
            this.fProcessors = new HashMap();
        }
        if (iContentAssistProcessor == null) {
            this.fProcessors.remove(string);
        } else {
            this.fProcessors.put(string, iContentAssistProcessor);
        }
    }

    @Override
    public IContentAssistProcessor getContentAssistProcessor(String string) {
        if (this.fProcessors == null) {
            return null;
        }
        return (IContentAssistProcessor)this.fProcessors.get(string);
    }

    public void enableAutoActivation(boolean bl) {
        this.fIsAutoActivated = bl;
        this.manageAutoActivation(this.fIsAutoActivated);
    }

    public void enableAutoInsert(boolean bl) {
        this.fIsAutoInserting = bl;
    }

    boolean isAutoInserting() {
        return this.fIsAutoInserting;
    }

    private void manageAutoActivation(boolean bl) {
        if (bl) {
            if (this.fViewer != null && this.fAutoAssistListener == null) {
                this.fAutoAssistListener = new AutoAssistListener();
                if (this.fViewer instanceof ITextViewerExtension) {
                    ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fViewer);
                    iTextViewerExtension.appendVerifyKeyListener(this.fAutoAssistListener);
                } else {
                    StyledText styledText = this.fViewer.getTextWidget();
                    if (Helper2.okToUse((Widget)styledText)) {
                        styledText.addVerifyKeyListener((VerifyKeyListener)this.fAutoAssistListener);
                    }
                }
            }
        } else if (this.fAutoAssistListener != null) {
            if (this.fViewer instanceof ITextViewerExtension) {
                ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fViewer);
                iTextViewerExtension.removeVerifyKeyListener(this.fAutoAssistListener);
            } else {
                StyledText styledText = this.fViewer.getTextWidget();
                if (Helper2.okToUse((Widget)styledText)) {
                    styledText.removeVerifyKeyListener((VerifyKeyListener)this.fAutoAssistListener);
                }
            }
            this.fAutoAssistListener = null;
        }
    }

    public void setAutoActivationDelay(int n) {
        this.fAutoActivationDelay = n;
    }

    public void setProposalPopupOrientation(int n) {
        this.fProposalPopupOrientation = n;
    }

    public void setContextInformationPopupOrientation(int n) {
        this.fContextInfoPopupOrientation = n;
    }

    public void setContextInformationPopupBackground(Color color) {
        this.fContextInfoPopupBackground = color;
    }

    Color getContextInformationPopupBackground() {
        return this.fContextInfoPopupBackground;
    }

    public void setContextInformationPopupForeground(Color color) {
        this.fContextInfoPopupForeground = color;
    }

    Color getContextInformationPopupForeground() {
        return this.fContextInfoPopupForeground;
    }

    public void setContextSelectorBackground(Color color) {
        this.fContextSelectorBackground = color;
    }

    Color getContextSelectorBackground() {
        return this.fContextSelectorBackground;
    }

    public void setContextSelectorForeground(Color color) {
        this.fContextSelectorForeground = color;
    }

    Color getContextSelectorForeground() {
        return this.fContextSelectorForeground;
    }

    public void setInformationControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fInformationControlCreator = iInformationControlCreator;
    }

    @Override
    public void install(ITextViewer iTextViewer) {
        Assert.isNotNull((Object)iTextViewer);
        this.fViewer = iTextViewer;
        this.fLayoutManager = new LayoutManager();
        this.fInternalListener = new InternalListener();
        AdditionalInfoController2 additionalInfoController2 = null;
        if (this.fInformationControlCreator != null) {
            additionalInfoController2 = new AdditionalInfoController2(this.fInformationControlCreator, OpenStrategy.getPostSelectionDelay());
        }
        this.fContextInfoPopup = new ContextInformationPopup2(this, this.fViewer);
        this.fProposalPopup = new CompletionProposalPopup2(this, this.fViewer, additionalInfoController2);
        this.manageAutoActivation(this.fIsAutoActivated);
    }

    @Override
    public void uninstall() {
        if (this.fProposalPopup != null) {
            this.fProposalPopup.hide();
        }
        if (this.fContextInfoPopup != null) {
            this.fContextInfoPopup.hide();
        }
        this.manageAutoActivation(false);
        if (this.fCloser != null) {
            this.fCloser.uninstall();
            this.fCloser = null;
        }
        this.fViewer = null;
    }

    void addToLayout(Object object, Shell shell, int n, int n2) {
        this.fLayoutManager.add(object, shell, n, n2);
    }

    void layout(int n, int n2) {
        this.fLayoutManager.layout(n, n2);
    }

    void popupFocusLost(FocusEvent focusEvent) {
        this.fCloser.focusLost(focusEvent);
    }

    int getSelectionOffset() {
        StyledText styledText = this.fViewer.getTextWidget();
        return styledText.getSelectionRange().x;
    }

    private boolean acquireWidgetToken(int n) {
        switch (n) {
            case 0: 
            case 1: {
                if (this.fViewer instanceof IWidgetTokenOwner) {
                    IWidgetTokenOwner iWidgetTokenOwner = (IWidgetTokenOwner)((Object)this.fViewer);
                    return iWidgetTokenOwner.requestWidgetToken(this);
                }
                if (!(this.fViewer instanceof IWidgetTokenOwnerExtension)) break;
                IWidgetTokenOwnerExtension iWidgetTokenOwnerExtension = (IWidgetTokenOwnerExtension)((Object)this.fViewer);
                return iWidgetTokenOwnerExtension.requestWidgetToken(this, 10);
            }
        }
        return true;
    }

    boolean addContentAssistListener(IContentAssistListener2 iContentAssistListener2, int n) {
        if (this.acquireWidgetToken(n)) {
            this.fListeners[n] = iContentAssistListener2;
            if (this.getNumberOfListeners() == 1) {
                this.fCloser = new Closer();
                this.fCloser.install();
                this.fViewer.setEventConsumer(this.fInternalListener);
                this.installKeyListener();
            }
            return true;
        }
        return false;
    }

    private void installKeyListener() {
        StyledText styledText;
        if (!this.fKeyListenerHooked && Helper2.okToUse((Widget)(styledText = this.fViewer.getTextWidget()))) {
            if (this.fViewer instanceof ITextViewerExtension) {
                ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fViewer);
                iTextViewerExtension.prependVerifyKeyListener(this.fInternalListener);
            } else {
                styledText.addVerifyKeyListener((VerifyKeyListener)this.fInternalListener);
            }
            this.fKeyListenerHooked = true;
        }
    }

    private void releaseWidgetToken(int n) {
        if (this.fListeners[0] == null && this.fListeners[1] == null && this.fViewer instanceof IWidgetTokenOwner) {
            IWidgetTokenOwner iWidgetTokenOwner = (IWidgetTokenOwner)((Object)this.fViewer);
            iWidgetTokenOwner.releaseWidgetToken(this);
        }
    }

    void removeContentAssistListener(IContentAssistListener2 iContentAssistListener2, int n) {
        this.fListeners[n] = null;
        if (this.getNumberOfListeners() == 0) {
            if (this.fCloser != null) {
                this.fCloser.uninstall();
                this.fCloser = null;
            }
            this.uninstallKeyListener();
            this.fViewer.setEventConsumer(null);
        }
        this.releaseWidgetToken(n);
    }

    private void uninstallKeyListener() {
        StyledText styledText;
        if (this.fKeyListenerHooked && Helper2.okToUse((Widget)(styledText = this.fViewer.getTextWidget()))) {
            if (this.fViewer instanceof ITextViewerExtension) {
                ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fViewer);
                iTextViewerExtension.removeVerifyKeyListener(this.fInternalListener);
            } else {
                styledText.removeVerifyKeyListener((VerifyKeyListener)this.fInternalListener);
            }
            this.fKeyListenerHooked = false;
        }
    }

    private int getNumberOfListeners() {
        int n = 0;
        int n2 = 0;
        while (n2 <= 2) {
            if (this.fListeners[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    @Override
    public String showPossibleCompletions() {
        return this.fProposalPopup.showProposals(false);
    }

    public void hidePossibleCompletions() {
        if (this.fProposalPopup != null) {
            this.fProposalPopup.hide();
        }
    }

    protected void hide() {
        if (this.fProposalPopup != null) {
            this.fProposalPopup.hide();
        }
        if (this.fContextInfoPopup != null) {
            this.fContextInfoPopup.hide();
        }
    }

    protected void possibleCompletionsClosed() {
    }

    @Override
    public String showContextInformation() {
        return this.fContextInfoPopup.showContextProposals(false);
    }

    protected void contextInformationClosed() {
    }

    void showContextInformation(IContextInformation iContextInformation, int n) {
        this.fContextInfoPopup.showContextInformation(iContextInformation, n);
    }

    String getErrorMessage() {
        return this.fLastErrorMessage;
    }

    private IContentAssistProcessor getProcessor(ITextViewer iTextViewer, int n) {
        try {
            String string = TextUtilities.getContentType((IDocument)iTextViewer.getDocument(), (String)this.getDocumentPartitioning(), (int)n, (boolean)true);
            return this.getContentAssistProcessor(string);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        if (this.fProposals != null) {
            return this.fProposals;
        }
        if (this.fProposalStrings != null) {
            ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[this.fProposalStrings.length];
            int n2 = 0;
            while (n2 < this.fProposalStrings.length) {
                iCompletionProposalArray[n2] = new CompletionProposal(this.fProposalStrings[n2], n, this.fProposalStrings[n2].length(), this.fProposalStrings[n2].length());
                ++n2;
            }
            return iCompletionProposalArray;
        }
        return null;
    }

    IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        this.fLastErrorMessage = null;
        IContextInformation[] iContextInformationArray = null;
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iTextViewer, n);
        if (iContentAssistProcessor != null) {
            iContextInformationArray = iContentAssistProcessor.computeContextInformation(iTextViewer, n);
            this.fLastErrorMessage = iContentAssistProcessor.getErrorMessage();
        }
        return iContextInformationArray;
    }

    IContextInformationValidator getContextInformationValidator(ITextViewer iTextViewer, int n) {
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iTextViewer, n);
        return iContentAssistProcessor != null ? iContentAssistProcessor.getContextInformationValidator() : null;
    }

    IContextInformationPresenter getContextInformationPresenter(ITextViewer iTextViewer, int n) {
        IContextInformationValidator iContextInformationValidator = this.getContextInformationValidator(iTextViewer, n);
        if (iContextInformationValidator instanceof IContextInformationPresenter) {
            return (IContextInformationPresenter)((Object)iContextInformationValidator);
        }
        return null;
    }

    private char[] getCompletionProposalAutoActivationCharacters(ITextViewer iTextViewer, int n) {
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iTextViewer, n);
        return iContentAssistProcessor != null ? iContentAssistProcessor.getCompletionProposalAutoActivationCharacters() : null;
    }

    private char[] getContextInformationAutoActivationCharacters(ITextViewer iTextViewer, int n) {
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iTextViewer, n);
        return iContentAssistProcessor != null ? iContentAssistProcessor.getContextInformationAutoActivationCharacters() : null;
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner) {
        this.hidePossibleCompletions();
        return true;
    }

    public void setCompletionPosition(int n) {
        this.fCompletionPosition = n;
    }

    public int getCompletionPosition() {
        return this.fCompletionPosition;
    }

    public void setCompletions(String[] stringArray) {
        this.fProposalStrings = stringArray;
    }

    public void setCompletions(ICompletionProposal[] iCompletionProposalArray) {
        this.fProposals = iCompletionProposalArray;
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner, int n) {
        if (n > 10) {
            this.hidePossibleCompletions();
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(IWidgetTokenOwner iWidgetTokenOwner) {
        if (this.fProposalPopup != null) {
            this.fProposalPopup.setFocus();
            return this.fProposalPopup.hasFocus();
        }
        return false;
    }

    public boolean hasFocus() {
        return this.fProposalPopup != null && this.fProposalPopup.hasFocus() || this.fContextInfoPopup != null && this.fContextInfoPopup.hasFocus();
    }

    @Override
    public String completePrefix() {
        return null;
    }

    public void fireProposalChosen(ICompletionProposal iCompletionProposal) {
        ArrayList arrayList = new ArrayList(this.fProposalListeners);
        for (IProposalListener iProposalListener : arrayList) {
            iProposalListener.proposalChosen(iCompletionProposal);
        }
    }

    public void removeProposalListener(IProposalListener iProposalListener) {
        this.fProposalListeners.remove(iProposalListener);
    }

    public void addProposalListener(IProposalListener iProposalListener) {
        this.fProposalListeners.add(iProposalListener);
    }

    boolean isColoredLabelsSupportEnabled() {
        return this.fIsColoredLabelsSupportEnabled;
    }

    public void enableColoredLabels(boolean bl) {
        this.fIsColoredLabelsSupportEnabled = bl;
    }

    static /* synthetic */ int access$1(ContentAssistant2 contentAssistant2) {
        return contentAssistant2.fAutoActivationDelay;
    }

    class AutoAssistListener
    implements VerifyKeyListener,
    Runnable {
        private Thread fThread;
        private boolean fIsReset = false;
        private Object fMutex = new Object();
        private int fShowStyle;
        private static final int SHOW_PROPOSALS = 1;
        private static final int SHOW_CONTEXT_INFO = 2;

        protected AutoAssistListener() {
        }

        protected void start(int n) {
            this.fShowStyle = n;
            this.fThread = new Thread((Runnable)this, ContentAssistMessages.getString("ContentAssistant.assist_delay_timer_name"));
            this.fThread.start();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset(int n) {
            Object object = this.fMutex;
            synchronized (object) {
                this.fShowStyle = n;
                this.fIsReset = true;
                this.fMutex.notifyAll();
            }
        }

        protected void stop() {
            Thread thread = this.fThread;
            if (thread != null) {
                thread.interrupt();
            }
        }

        private boolean contains(char[] cArray, char c) {
            if (cArray != null) {
                int n = 0;
                while (n < cArray.length) {
                    if (c == cArray[n]) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            int n;
            if (verifyEvent.character == '\u0000' && (verifyEvent.keyCode & 0x1000000) == 0) {
                return;
            }
            if (verifyEvent.character != '\u0000' && verifyEvent.stateMask == 65536) {
                return;
            }
            int n2 = ((ContentAssistant2)ContentAssistant2.this).fViewer.getSelectedRange().x;
            char[] cArray = ContentAssistant2.this.getCompletionProposalAutoActivationCharacters(ContentAssistant2.this.fViewer, n2);
            if (this.contains(cArray, verifyEvent.character) && !ContentAssistant2.this.fProposalPopup.isActive()) {
                n = 1;
            } else {
                cArray = ContentAssistant2.this.getContextInformationAutoActivationCharacters(ContentAssistant2.this.fViewer, n2);
                if (this.contains(cArray, verifyEvent.character) && !ContentAssistant2.this.fContextInfoPopup.isActive()) {
                    n = 2;
                } else {
                    if (this.fThread != null && this.fThread.isAlive()) {
                        this.stop();
                    }
                    return;
                }
            }
            if (this.fThread != null && this.fThread.isAlive()) {
                this.reset(n);
            } else {
                this.start(n);
            }
        }

        protected void showAssist(final int n) {
            StyledText styledText = ContentAssistant2.this.fViewer.getTextWidget();
            Display display = styledText.getDisplay();
            if (display != null) {
                try {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (n == 1) {
                                ContentAssistant2.this.fProposalPopup.showProposals(true);
                            } else if (n == 2) {
                                ContentAssistant2.this.fContextInfoPopup.showContextProposals(true);
                            }
                        }
                    });
                }
                catch (SWTError sWTError) {}
            }
        }
    }

    class Closer
    implements ControlListener,
    MouseListener,
    FocusListener,
    DisposeListener,
    IViewportListener {
        private Shell fShell;
        private long fViewportListenerStartTime;

        Closer() {
        }

        protected void install() {
            StyledText styledText = ContentAssistant2.this.fViewer.getTextWidget();
            if (Helper2.okToUse((Widget)styledText)) {
                Shell shell;
                this.fShell = shell = styledText.getShell();
                shell.addControlListener((ControlListener)this);
                styledText.addMouseListener((MouseListener)this);
                styledText.addFocusListener((FocusListener)this);
                styledText.addDisposeListener((DisposeListener)this);
            }
            ContentAssistant2.this.fViewer.addViewportListener(this);
            this.fViewportListenerStartTime = System.currentTimeMillis() + 500L;
        }

        protected void uninstall() {
            StyledText styledText;
            Shell shell = this.fShell;
            this.fShell = null;
            if (Helper2.okToUse((Widget)shell)) {
                shell.removeControlListener((ControlListener)this);
            }
            if (Helper2.okToUse((Widget)(styledText = ContentAssistant2.this.fViewer.getTextWidget()))) {
                styledText.removeMouseListener((MouseListener)this);
                styledText.removeFocusListener((FocusListener)this);
                styledText.removeDisposeListener((DisposeListener)this);
            }
            ContentAssistant2.this.fViewer.removeViewportListener(this);
        }

        public void controlResized(ControlEvent controlEvent) {
            ContentAssistant2.this.hide();
        }

        public void controlMoved(ControlEvent controlEvent) {
            ContentAssistant2.this.hide();
        }

        public void mouseDown(MouseEvent mouseEvent) {
            ContentAssistant2.this.hide();
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            ContentAssistant2.this.hide();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Display display;
            StyledText styledText;
            if (ContentAssistant2.this.fViewer != null && (styledText = ContentAssistant2.this.fViewer.getTextWidget()) != null && (display = styledText.getDisplay()) != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ContentAssistant2.this.hasFocus()) {
                            ContentAssistant2.this.hide();
                        }
                    }
                });
            }
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            ContentAssistant2.this.hide();
        }

        @Override
        public void viewportChanged(int n) {
            if (System.currentTimeMillis() > this.fViewportListenerStartTime) {
                ContentAssistant2.this.hide();
            }
        }
    }

    class InternalListener
    implements VerifyKeyListener,
    IEventConsumer {
        InternalListener() {
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            IContentAssistListener2[] iContentAssistListener2Array = (IContentAssistListener2[])ContentAssistant2.this.fListeners.clone();
            int n = 0;
            while (n < iContentAssistListener2Array.length) {
                if (!(iContentAssistListener2Array[n] == null || iContentAssistListener2Array[n].verifyKey(verifyEvent) && verifyEvent.doit)) {
                    return;
                }
                ++n;
            }
        }

        @Override
        public void processEvent(VerifyEvent verifyEvent) {
            ContentAssistant2.this.installKeyListener();
            IContentAssistListener2[] iContentAssistListener2Array = (IContentAssistListener2[])ContentAssistant2.this.fListeners.clone();
            int n = 0;
            while (n < iContentAssistListener2Array.length) {
                if (iContentAssistListener2Array[n] != null) {
                    iContentAssistListener2Array[n].processEvent(verifyEvent);
                    if (!verifyEvent.doit) {
                        return;
                    }
                }
                ++n;
            }
        }
    }

    class LayoutManager
    implements Listener {
        public static final int LAYOUT_PROPOSAL_SELECTOR = 0;
        public static final int LAYOUT_CONTEXT_SELECTOR = 1;
        public static final int LAYOUT_CONTEXT_INFO_POPUP = 2;
        int fContextType = 1;
        Shell[] fShells = new Shell[3];
        Object[] fPopups = new Object[3];

        LayoutManager() {
        }

        protected void add(Object object, Shell shell, int n, int n2) {
            Assert.isNotNull((Object)object);
            Assert.isTrue((shell != null && !shell.isDisposed() ? 1 : 0) != 0);
            this.checkType(n);
            if (this.fShells[n] != shell) {
                if (this.fShells[n] != null) {
                    this.fShells[n].removeListener(12, (Listener)this);
                }
                shell.addListener(12, (Listener)this);
                this.fShells[n] = shell;
            }
            this.fPopups[n] = object;
            if (n == 1 || n == 2) {
                this.fContextType = n;
            }
            this.layout(n, n2);
            this.adjustListeners(n);
        }

        protected void checkType(int n) {
            Assert.isTrue((n == 0 || n == 1 || n == 2 ? 1 : 0) != 0);
        }

        public void handleEvent(Event event) {
            Widget widget = event.widget;
            widget.removeListener(12, (Listener)this);
            int n = this.getShellType(widget);
            this.checkType(n);
            this.fShells[n] = null;
            switch (n) {
                case 0: {
                    if (this.fContextType != 1 || !Helper2.okToUse((Widget)this.fShells[1])) break;
                    ContentAssistant2.this.addContentAssistListener((IContentAssistListener2)this.fPopups[1], 0);
                    break;
                }
                case 1: {
                    if (Helper2.okToUse((Widget)this.fShells[0])) {
                        if (ContentAssistant2.this.fProposalPopupOrientation == 12) {
                            this.layout(0, ContentAssistant2.this.getSelectionOffset());
                        }
                        ContentAssistant2.this.addContentAssistListener((IContentAssistListener2)this.fPopups[0], 1);
                    }
                    this.fContextType = 2;
                    break;
                }
                case 2: {
                    if (Helper2.okToUse((Widget)this.fShells[0]) && ContentAssistant2.this.fContextInfoPopupOrientation == 21) {
                        this.layout(0, ContentAssistant2.this.getSelectionOffset());
                    }
                    this.fContextType = 1;
                }
            }
        }

        protected int getShellType(Widget widget) {
            int n = 0;
            while (n < this.fShells.length) {
                if (this.fShells[n] == widget) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        protected void layout(int n, int n2) {
            switch (n) {
                case 0: {
                    this.layoutProposalSelector(n2);
                    break;
                }
                case 1: {
                    this.layoutContextSelector(n2);
                    break;
                }
                case 2: {
                    this.layoutContextInfoPopup(n2);
                }
            }
        }

        protected void layoutProposalSelector(int n) {
            if (this.fContextType == 2 && ContentAssistant2.this.fContextInfoPopupOrientation == 21 && Helper2.okToUse((Widget)this.fShells[2])) {
                Shell shell = this.fShells[0];
                Shell shell2 = this.fShells[2];
                shell.setLocation(this.getStackedLocation(shell, shell2));
            } else if (this.fContextType != 1 || !Helper2.okToUse((Widget)this.fShells[1])) {
                Shell shell = this.fShells[0];
                shell.setLocation(this.getBelowLocation(shell, n));
            } else {
                switch (ContentAssistant2.this.fProposalPopupOrientation) {
                    case 11: {
                        this.fShells[1].dispose();
                        Shell shell = this.fShells[0];
                        shell.setLocation(this.getBelowLocation(shell, n));
                        break;
                    }
                    case 10: {
                        Shell shell = this.fShells[0];
                        shell.setLocation(this.getBelowLocation(shell, n));
                        break;
                    }
                    case 12: {
                        Shell shell = this.fShells[0];
                        Shell shell3 = this.fShells[1];
                        shell.setLocation(this.getStackedLocation(shell, shell3));
                    }
                }
            }
        }

        protected void layoutContextSelector(int n) {
            Shell shell = this.fShells[1];
            shell.setLocation(this.getBelowLocation(shell, n));
            if (Helper2.okToUse((Widget)this.fShells[0])) {
                switch (ContentAssistant2.this.fProposalPopupOrientation) {
                    case 11: {
                        this.fShells[0].dispose();
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 12: {
                        shell = this.fShells[0];
                        Shell shell2 = this.fShells[1];
                        shell.setLocation(this.getStackedLocation(shell, shell2));
                    }
                }
            }
        }

        protected void layoutContextInfoPopup(int n) {
            switch (ContentAssistant2.this.fContextInfoPopupOrientation) {
                case 20: {
                    Shell shell = this.fShells[2];
                    shell.setLocation(this.getAboveLocation(shell, n));
                    break;
                }
                case 21: {
                    Shell shell = this.fShells[2];
                    shell.setLocation(this.getBelowLocation(shell, n));
                    if (!Helper2.okToUse((Widget)this.fShells[0])) break;
                    Shell shell2 = this.fShells[0];
                    shell2.setLocation(this.getStackedLocation(shell2, shell));
                }
            }
        }

        protected void shiftHorizontalLocation(Point point, Rectangle rectangle, Rectangle rectangle2) {
            if (point.x + rectangle.width > rectangle2.width) {
                point.x = rectangle2.width - rectangle.width;
            }
            if (point.x < rectangle2.x) {
                point.x = rectangle2.x;
            }
        }

        protected void shiftVerticalLocation(Point point, Rectangle rectangle, Rectangle rectangle2) {
            if (point.y + rectangle.height > rectangle2.height) {
                point.y = rectangle2.height - rectangle.height;
            }
            if (point.y < rectangle2.y) {
                point.y = rectangle2.y;
            }
        }

        protected Point getAboveLocation(Shell shell, int n) {
            StyledText styledText = ContentAssistant2.this.fViewer.getTextWidget();
            Point point = styledText.getLocationAtOffset(n);
            point = styledText.toDisplay(point);
            Rectangle rectangle = shell.getBounds();
            Rectangle rectangle2 = shell.getDisplay().getClientArea();
            point.y -= rectangle.height;
            this.shiftHorizontalLocation(point, rectangle, rectangle2);
            this.shiftVerticalLocation(point, rectangle, rectangle2);
            return point;
        }

        protected Point getBelowLocation(Shell shell, int n) {
            StyledText styledText = ContentAssistant2.this.fViewer.getTextWidget();
            Point point = styledText.getLocationAtOffset(n);
            if (point.x < 0) {
                point.x = 0;
            }
            if (point.y < 0) {
                point.y = 0;
            }
            point = styledText.toDisplay(point);
            Rectangle rectangle = shell.getBounds();
            Rectangle rectangle2 = shell.getDisplay().getClientArea();
            point.y += styledText.getLineHeight(n);
            this.shiftHorizontalLocation(point, rectangle, rectangle2);
            this.shiftVerticalLocation(point, rectangle, rectangle2);
            return point;
        }

        protected Point getStackedLocation(Shell shell, Shell shell2) {
            Point point = shell2.getLocation();
            Point point2 = shell2.getSize();
            point.x += point2.x / 4;
            point.y += point2.y;
            point = shell2.toDisplay(point);
            Rectangle rectangle = shell.getBounds();
            Rectangle rectangle2 = shell.getDisplay().getClientArea();
            this.shiftHorizontalLocation(point, rectangle, rectangle2);
            this.shiftVerticalLocation(point, rectangle, rectangle2);
            return point;
        }

        protected void adjustListeners(int n) {
            switch (n) {
                case 0: {
                    if (this.fContextType != 1 || !Helper2.okToUse((Widget)this.fShells[1])) break;
                    ContentAssistant2.this.removeContentAssistListener((IContentAssistListener2)this.fPopups[1], 0);
                    break;
                }
                case 1: {
                    if (!Helper2.okToUse((Widget)this.fShells[0])) break;
                    ContentAssistant2.this.removeContentAssistListener((IContentAssistListener2)this.fPopups[0], 1);
                    break;
                }
            }
        }
    }
}

