/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.link.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.internal.text.TableOwnerDrawSupport;
import org.eclipse.jface.internal.text.link.contentassist.AdditionalInfoController2;
import org.eclipse.jface.internal.text.link.contentassist.ContentAssistant2;
import org.eclipse.jface.internal.text.link.contentassist.Helper2;
import org.eclipse.jface.internal.text.link.contentassist.IContentAssistListener2;
import org.eclipse.jface.internal.text.link.contentassist.PopupCloser2;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class CompletionProposalPopup2
implements IContentAssistListener2 {
    private ITextViewer fViewer;
    private ContentAssistant2 fContentAssistant;
    private AdditionalInfoController2 fAdditionalInfoController;
    private PopupCloser2 fPopupCloser = new PopupCloser2();
    private Shell fProposalShell;
    private Table fProposalTable;
    private boolean fInserting = false;
    private KeyListener fKeyListener;
    private List fDocumentEvents = new ArrayList();
    private IDocumentListener fDocumentListener;
    private long fInvocationCounter = 0L;
    private long fInvocationProcessedCounter = 0L;
    private ICompletionProposal[] fFilteredProposals;
    private ICompletionProposal[] fComputedProposals;
    private int fInvocationOffset;
    private int fFilterOffset;
    private String fLineDelimiter;
    private ICompletionProposal fLastProposal;
    private boolean fIsColoredLabelsSupportEnabled = false;
    private final IEditingSupport fFocusEditingSupport = new IEditingSupport(){

        @Override
        public boolean isOriginator(DocumentEvent documentEvent, IRegion iRegion) {
            return false;
        }

        @Override
        public boolean ownsFocusShell() {
            return Helper2.okToUse((Widget)CompletionProposalPopup2.this.fProposalShell) && CompletionProposalPopup2.this.fProposalShell.isFocusControl() || Helper2.okToUse((Widget)CompletionProposalPopup2.this.fProposalTable) && CompletionProposalPopup2.this.fProposalTable.isFocusControl();
        }
    };
    private final IEditingSupport fModificationEditingSupport = new IEditingSupport(){

        @Override
        public boolean isOriginator(DocumentEvent documentEvent, IRegion iRegion) {
            if (CompletionProposalPopup2.this.fViewer != null) {
                Point point = CompletionProposalPopup2.this.fViewer.getSelectedRange();
                return point.x <= iRegion.getOffset() + iRegion.getLength() && point.x + point.y >= iRegion.getOffset();
            }
            return false;
        }

        @Override
        public boolean ownsFocusShell() {
            return false;
        }
    };

    public CompletionProposalPopup2(ContentAssistant2 contentAssistant2, ITextViewer iTextViewer, AdditionalInfoController2 additionalInfoController2) {
        this.fContentAssistant = contentAssistant2;
        this.fViewer = iTextViewer;
        this.fAdditionalInfoController = additionalInfoController2;
    }

    public String showProposals(boolean bl) {
        int n;
        StyledText styledText;
        if (this.fKeyListener == null) {
            this.fKeyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if (!Helper2.okToUse((Widget)CompletionProposalPopup2.this.fProposalShell)) {
                        return;
                    }
                    if (keyEvent.character == '\u0000' && keyEvent.keyCode == 262144 && (n = CompletionProposalPopup2.this.fProposalTable.getSelectionIndex()) >= 0) {
                        CompletionProposalPopup2.this.selectProposal(n, true);
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                    int n;
                    if (!Helper2.okToUse((Widget)CompletionProposalPopup2.this.fProposalShell)) {
                        return;
                    }
                    if (keyEvent.character == '\u0000' && keyEvent.keyCode == 262144 && (n = CompletionProposalPopup2.this.fProposalTable.getSelectionIndex()) >= 0) {
                        CompletionProposalPopup2.this.selectProposal(n, false);
                    }
                }
            };
        }
        if ((styledText = this.fViewer.getTextWidget()) != null && !styledText.isDisposed()) {
            styledText.addKeyListener(this.fKeyListener);
        }
        this.fInvocationOffset = this.fViewer.getSelectedRange().x;
        this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
        int n2 = n = this.fComputedProposals == null ? 0 : this.fComputedProposals.length;
        if (n == 0) {
            if (!bl) {
                styledText.getDisplay().beep();
            }
        } else if (n == 1 && !bl && this.fContentAssistant.isAutoInserting()) {
            this.insertProposal(this.fComputedProposals[0], '\u0000', 0, this.fInvocationOffset);
        } else {
            if (this.fLineDelimiter == null) {
                this.fLineDelimiter = styledText.getLineDelimiter();
            }
            this.createProposalSelector();
            this.setProposals(this.fComputedProposals);
            this.resizeProposalSelector(true);
            this.displayProposals();
        }
        return this.getErrorMessage();
    }

    private ICompletionProposal[] computeProposals(int n) {
        return this.fContentAssistant.computeCompletionProposals(this.fViewer, n);
    }

    private String getErrorMessage() {
        return this.fContentAssistant.getErrorMessage();
    }

    private void createProposalSelector() {
        if (Helper2.okToUse((Widget)this.fProposalShell)) {
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        this.fProposalShell = new Shell(styledText.getShell(), 16384);
        this.fProposalTable = new Table((Composite)this.fProposalShell, 768);
        this.fIsColoredLabelsSupportEnabled = this.fContentAssistant.isColoredLabelsSupportEnabled();
        if (this.fIsColoredLabelsSupportEnabled) {
            TableOwnerDrawSupport.install(this.fProposalTable);
        }
        this.fProposalTable.setLocation(0, 0);
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.setSizeConstraints(50, 10, true, false);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fProposalShell.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.fProposalTable.setLayoutData((Object)gridData);
        this.fProposalShell.pack();
        Point point = this.fProposalShell.getLocation();
        Point point2 = this.getLocation();
        if (point2.x < point.x && point2.y == point.y || point2.y < point.y) {
            this.fProposalShell.setLocation(point2);
        }
        if (this.fAdditionalInfoController != null) {
            this.fProposalShell.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent controlEvent) {
                }

                public void controlResized(ControlEvent controlEvent) {
                    CompletionProposalPopup2.this.fAdditionalInfoController.setSizeConstraints(50, 10, true, false);
                }
            });
        }
        this.fProposalShell.setBackground(styledText.getDisplay().getSystemColor(2));
        Color color = styledText.getDisplay().getSystemColor(29);
        this.fProposalTable.setBackground(color);
        color = styledText.getDisplay().getSystemColor(28);
        this.fProposalTable.setForeground(color);
        this.fProposalTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CompletionProposalPopup2.this.selectProposalWithMask(selectionEvent.stateMask);
            }
        });
        this.fPopupCloser.install(this.fContentAssistant, this.fProposalTable);
        this.fProposalShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CompletionProposalPopup2.this.unregister();
            }
        });
        this.fProposalTable.setHeaderVisible(false);
        this.fContentAssistant.addToLayout(this, this.fProposalShell, 0, this.fContentAssistant.getSelectionOffset());
    }

    private ICompletionProposal getSelectedProposal() {
        int n = this.fProposalTable.getSelectionIndex();
        if (n < 0 || n >= this.fFilteredProposals.length) {
            return null;
        }
        return this.fFilteredProposals[n];
    }

    private boolean selectProposalWithMask(int n) {
        if (this.fInvocationCounter != this.fInvocationProcessedCounter && !this.doFilterProposals()) {
            return false;
        }
        ICompletionProposal iCompletionProposal = this.getSelectedProposal();
        this.hide();
        if (iCompletionProposal != null) {
            this.insertProposal(iCompletionProposal, '\u0000', n, this.fViewer.getSelectedRange().x);
            return true;
        }
        return false;
    }

    private void insertProposal(ICompletionProposal iCompletionProposal, char c, int n, int n2) {
        this.fInserting = true;
        IRewriteTarget iRewriteTarget = null;
        IEditingSupportRegistry iEditingSupportRegistry = null;
        try {
            IContextInformation iContextInformation;
            Object object;
            IDocument iDocument = this.fViewer.getDocument();
            if (this.fViewer instanceof ITextViewerExtension) {
                object = (ITextViewerExtension)((Object)this.fViewer);
                iRewriteTarget = object.getRewriteTarget();
            }
            if (iRewriteTarget != null) {
                iRewriteTarget.beginCompoundChange();
            }
            if (this.fViewer instanceof IEditingSupportRegistry) {
                iEditingSupportRegistry = (IEditingSupportRegistry)((Object)this.fViewer);
                iEditingSupportRegistry.register(this.fModificationEditingSupport);
            }
            if (iCompletionProposal instanceof ICompletionProposalExtension2) {
                object = (ICompletionProposalExtension2)((Object)iCompletionProposal);
                object.apply(this.fViewer, c, n, n2);
            } else if (iCompletionProposal instanceof ICompletionProposalExtension) {
                object = (ICompletionProposalExtension)((Object)iCompletionProposal);
                object.apply(iDocument, c, n2);
            } else {
                iCompletionProposal.apply(iDocument);
            }
            object = iCompletionProposal.getSelection(iDocument);
            if (object != null) {
                this.fViewer.setSelectedRange(((Point)object).x, ((Point)object).y);
                this.fViewer.revealRange(((Point)object).x, ((Point)object).y);
            }
            if ((iContextInformation = iCompletionProposal.getContextInformation()) != null) {
                int n3;
                if (iCompletionProposal instanceof ICompletionProposalExtension) {
                    ICompletionProposalExtension iCompletionProposalExtension = (ICompletionProposalExtension)((Object)iCompletionProposal);
                    n3 = iCompletionProposalExtension.getContextInformationPosition();
                } else {
                    if (object == null) {
                        object = this.fViewer.getSelectedRange();
                    }
                    n3 = ((Point)object).x + ((Point)object).y;
                }
                this.fContentAssistant.showContextInformation(iContextInformation, n3);
            }
            this.fContentAssistant.fireProposalChosen(iCompletionProposal);
        }
        finally {
            if (iRewriteTarget != null) {
                iRewriteTarget.endCompoundChange();
            }
            if (iEditingSupportRegistry != null) {
                iEditingSupportRegistry.unregister(this.fModificationEditingSupport);
            }
            this.fInserting = false;
        }
    }

    public boolean hasFocus() {
        if (Helper2.okToUse((Widget)this.fProposalShell)) {
            return this.fProposalShell.isFocusControl() || this.fProposalTable.isFocusControl();
        }
        return false;
    }

    public void hide() {
        IEditingSupportRegistry iEditingSupportRegistry;
        this.unregister();
        if (this.fViewer instanceof IEditingSupportRegistry) {
            iEditingSupportRegistry = (IEditingSupportRegistry)((Object)this.fViewer);
            iEditingSupportRegistry.unregister(this.fFocusEditingSupport);
        }
        if (Helper2.okToUse((Widget)this.fProposalShell)) {
            this.fContentAssistant.removeContentAssistListener(this, 1);
            this.fPopupCloser.uninstall();
            iEditingSupportRegistry = this.fProposalShell;
            this.fProposalShell = null;
            iEditingSupportRegistry.setVisible(false);
            iEditingSupportRegistry.dispose();
        }
    }

    private void unregister() {
        IDocument iDocument;
        if (this.fDocumentListener != null) {
            iDocument = this.fViewer.getDocument();
            if (iDocument != null) {
                iDocument.removeDocumentListener(this.fDocumentListener);
            }
            this.fDocumentListener = null;
        }
        this.fDocumentEvents.clear();
        iDocument = this.fViewer.getTextWidget();
        if (this.fKeyListener != null && iDocument != null && !iDocument.isDisposed()) {
            iDocument.removeKeyListener(this.fKeyListener);
        }
        if (this.fLastProposal != null) {
            if (this.fLastProposal instanceof ICompletionProposalExtension2) {
                ICompletionProposalExtension2 iCompletionProposalExtension2 = (ICompletionProposalExtension2)((Object)this.fLastProposal);
                iCompletionProposalExtension2.unselected(this.fViewer);
            }
            this.fLastProposal = null;
        }
        this.fFilteredProposals = null;
        this.fContentAssistant.possibleCompletionsClosed();
    }

    public boolean isActive() {
        return this.fProposalShell != null && !this.fProposalShell.isDisposed();
    }

    private void setProposals(ICompletionProposal[] iCompletionProposalArray) {
        if (Helper2.okToUse((Widget)this.fProposalTable)) {
            ICompletionProposal iCompletionProposal = this.getSelectedProposal();
            if (iCompletionProposal instanceof ICompletionProposalExtension2) {
                ((ICompletionProposalExtension2)((Object)iCompletionProposal)).unselected(this.fViewer);
            }
            this.fFilteredProposals = iCompletionProposalArray;
            int n = 0;
            this.fProposalTable.setRedraw(false);
            try {
                this.fProposalTable.removeAll();
                Point point = this.fViewer.getSelectedRange();
                int n2 = point.x + point.y;
                IDocument iDocument = this.fViewer.getDocument();
                boolean bl = false;
                if (point.y != 0 && iDocument != null) {
                    bl = true;
                }
                int n3 = 0;
                while (n3 < iCompletionProposalArray.length) {
                    String string;
                    ICompletionProposal iCompletionProposal2 = iCompletionProposalArray[n3];
                    TableItem tableItem = new TableItem(this.fProposalTable, 0);
                    if (iCompletionProposal2.getImage() != null) {
                        tableItem.setImage(iCompletionProposal2.getImage());
                    }
                    StyleRange[] styleRangeArray = null;
                    if (this.fIsColoredLabelsSupportEnabled && iCompletionProposal2 instanceof ICompletionProposalExtension6) {
                        StyledString styledString = ((ICompletionProposalExtension6)((Object)iCompletionProposal2)).getStyledDisplayString();
                        string = styledString.getString();
                        styleRangeArray = styledString.getStyleRanges();
                    } else {
                        string = iCompletionProposal2.getDisplayString();
                    }
                    tableItem.setText(string);
                    if (this.fIsColoredLabelsSupportEnabled) {
                        TableOwnerDrawSupport.storeStyleRanges(tableItem, 0, styleRangeArray);
                    }
                    tableItem.setData((Object)iCompletionProposal2);
                    if (bl && this.validateProposal(iDocument, iCompletionProposal2, n2, null)) {
                        n = n3;
                        bl = false;
                    }
                    ++n3;
                }
            }
            finally {
                this.fProposalTable.setRedraw(true);
            }
            this.resizeProposalSelector(false);
            this.selectProposal(n, false);
        }
    }

    private void resizeProposalSelector(boolean bl) {
        int n = bl ? -1 : ((GridData)this.fProposalTable.getLayoutData()).widthHint;
        Point point = this.fProposalTable.computeSize(n, -1, true);
        GridData gridData = new GridData(1808);
        gridData.widthHint = bl ? Math.min(point.x, 300) : n;
        gridData.heightHint = Math.min(this.getTableHeightHint(this.fProposalTable, this.fProposalTable.getItemCount()), this.getTableHeightHint(this.fProposalTable, 10));
        this.fProposalTable.setLayoutData((Object)gridData);
        this.fProposalShell.layout(true);
        this.fProposalShell.pack();
        if (bl) {
            this.fProposalShell.setLocation(this.getLocation());
        }
    }

    private int getTableHeightHint(Table table, int n) {
        if (table.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            table.setFont(JFaceResources.getDialogFont());
        }
        int n2 = table.getItemHeight() * n;
        if (table.getLinesVisible()) {
            n2 += table.getGridLineWidth() * (n - 1);
        }
        return n2;
    }

    private boolean validateProposal(IDocument iDocument, ICompletionProposal iCompletionProposal, int n, DocumentEvent documentEvent) {
        ICompletionProposalExtension iCompletionProposalExtension;
        ICompletionProposalExtension2 iCompletionProposalExtension2;
        return iCompletionProposal instanceof ICompletionProposalExtension2 ? (iCompletionProposalExtension2 = (ICompletionProposalExtension2)((Object)iCompletionProposal)).validate(iDocument, n, documentEvent) : iCompletionProposal instanceof ICompletionProposalExtension && (iCompletionProposalExtension = (ICompletionProposalExtension)((Object)iCompletionProposal)).isValidFor(iDocument, n);
    }

    private Point getLocation() {
        StyledText styledText = this.fViewer.getTextWidget();
        Point point = styledText.getSelection();
        Point point2 = styledText.getLocationAtOffset(point.x);
        point2.x -= this.fProposalShell.getBorderWidth();
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.y < 0) {
            point2.y = 0;
        }
        point2 = new Point(point2.x, point2.y + styledText.getLineHeight(point.x));
        point2 = styledText.toDisplay(point2);
        return point2;
    }

    private void displayProposals() {
        if (this.fContentAssistant.addContentAssistListener(this, 1)) {
            IDocument iDocument;
            if (this.fDocumentListener == null) {
                this.fDocumentListener = new IDocumentListener(){

                    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
                        if (!CompletionProposalPopup2.this.fInserting) {
                            CompletionProposalPopup2.this.fDocumentEvents.add(documentEvent);
                        }
                    }

                    public void documentChanged(DocumentEvent documentEvent) {
                        if (!CompletionProposalPopup2.this.fInserting) {
                            CompletionProposalPopup2.this.filterProposals();
                        }
                    }
                };
            }
            if ((iDocument = this.fViewer.getDocument()) != null) {
                iDocument.addDocumentListener(this.fDocumentListener);
            }
            if (this.fViewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry iEditingSupportRegistry = (IEditingSupportRegistry)((Object)this.fViewer);
                iEditingSupportRegistry.register(this.fFocusEditingSupport);
            }
            this.fProposalShell.setVisible(true);
            if (!Helper2.okToUse((Widget)this.fProposalShell)) {
                return;
            }
            if (this.fAdditionalInfoController != null) {
                this.fAdditionalInfoController.install((Control)this.fProposalTable);
                this.fAdditionalInfoController.handleTableSelectionChanged();
            }
        }
    }

    @Override
    public boolean verifyKey(VerifyEvent verifyEvent) {
        if (!Helper2.okToUse((Widget)this.fProposalShell)) {
            return true;
        }
        char c = verifyEvent.character;
        if (c == '\u0000') {
            int n = this.fProposalTable.getSelectionIndex();
            int n2 = this.fProposalTable.getSize().y / this.fProposalTable.getItemHeight() - 1;
            switch (verifyEvent.keyCode) {
                case 0x1000003: 
                case 0x1000004: {
                    this.filterProposals();
                    return true;
                }
                case 0x1000001: {
                    if (--n >= 0) break;
                    n = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 0x1000002: {
                    if (++n <= this.fProposalTable.getItemCount() - 1) break;
                    n = 0;
                    break;
                }
                case 0x1000006: {
                    if ((n += n2) < this.fProposalTable.getItemCount()) break;
                    n = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 0x1000005: {
                    if ((n -= n2) >= 0) break;
                    n = 0;
                    break;
                }
                case 0x1000007: {
                    n = 0;
                    break;
                }
                case 0x1000008: {
                    n = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                default: {
                    if (verifyEvent.keyCode != SWT.MOD1 && verifyEvent.keyCode != SWT.MOD2 && verifyEvent.keyCode != SWT.MOD3 && verifyEvent.keyCode != SWT.MOD4) {
                        this.hide();
                    }
                    return true;
                }
            }
            this.selectProposal(n, (verifyEvent.stateMask & 0x40000) != 0);
            verifyEvent.doit = false;
            return false;
        }
        switch (c) {
            case '\u001b': {
                verifyEvent.doit = false;
                this.hide();
                break;
            }
            case '\n': 
            case '\r': {
                if ((verifyEvent.stateMask & 0x40000) != 0) break;
                verifyEvent.doit = !this.selectProposalWithMask(verifyEvent.stateMask);
                break;
            }
            case '\t': {
                break;
            }
            default: {
                ICompletionProposalExtension iCompletionProposalExtension;
                char[] cArray;
                ICompletionProposal iCompletionProposal = this.getSelectedProposal();
                if (!(iCompletionProposal instanceof ICompletionProposalExtension) || !this.contains(cArray = (iCompletionProposalExtension = (ICompletionProposalExtension)((Object)iCompletionProposal)).getTriggerCharacters(), c)) break;
                this.hide();
                verifyEvent.doit = false;
                this.insertProposal(iCompletionProposal, c, verifyEvent.stateMask, this.fViewer.getSelectedRange().x);
            }
        }
        return true;
    }

    private void selectProposal(int n, boolean bl) {
        ICompletionProposal iCompletionProposal;
        ICompletionProposal iCompletionProposal2 = this.getSelectedProposal();
        if (iCompletionProposal2 instanceof ICompletionProposalExtension2) {
            ((ICompletionProposalExtension2)((Object)iCompletionProposal2)).unselected(this.fViewer);
        }
        if ((iCompletionProposal = this.fFilteredProposals[n]) instanceof ICompletionProposalExtension2) {
            ((ICompletionProposalExtension2)((Object)iCompletionProposal)).selected(this.fViewer, bl);
        }
        this.fLastProposal = iCompletionProposal;
        this.fProposalTable.setSelection(n);
        this.fProposalTable.showSelection();
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.handleTableSelectionChanged();
        }
    }

    private boolean contains(char[] cArray, char c) {
        if (cArray == null) {
            return false;
        }
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void processEvent(VerifyEvent verifyEvent) {
    }

    private void filterProposals() {
        ++this.fInvocationCounter;
        StyledText styledText = this.fViewer.getTextWidget();
        styledText.getDisplay().asyncExec(new Runnable(){
            long fCounter;
            {
                this.fCounter = CompletionProposalPopup2.this.fInvocationCounter;
            }

            @Override
            public void run() {
                if (this.fCounter != CompletionProposalPopup2.this.fInvocationCounter) {
                    return;
                }
                if (CompletionProposalPopup2.this.fInvocationProcessedCounter == CompletionProposalPopup2.this.fInvocationCounter) {
                    return;
                }
                CompletionProposalPopup2.this.doFilterProposals();
            }
        });
    }

    public boolean doFilterProposals() {
        ICompletionProposal[] iCompletionProposalArray;
        int n;
        block7: {
            this.fInvocationProcessedCounter = this.fInvocationCounter;
            n = this.fViewer.getSelectedRange().x;
            iCompletionProposalArray = null;
            try {
                try {
                    if (n > -1) {
                        DocumentEvent documentEvent = TextUtilities.mergeProcessedDocumentEvents((List)this.fDocumentEvents);
                        iCompletionProposalArray = this.computeFilteredProposals(n, documentEvent);
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.fDocumentEvents.clear();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.fDocumentEvents.clear();
                throw throwable;
            }
            this.fDocumentEvents.clear();
        }
        this.fFilterOffset = n;
        if (iCompletionProposalArray != null && iCompletionProposalArray.length > 0) {
            this.setProposals(iCompletionProposalArray);
            return true;
        }
        this.hide();
        return false;
    }

    private ICompletionProposal[] computeFilteredProposals(int n, DocumentEvent documentEvent) {
        if (n == this.fInvocationOffset && documentEvent == null) {
            return this.fComputedProposals;
        }
        if (n < this.fInvocationOffset) {
            return null;
        }
        ICompletionProposal[] iCompletionProposalArray = this.fComputedProposals;
        if (n > this.fFilterOffset) {
            iCompletionProposalArray = this.fFilteredProposals;
        }
        if (iCompletionProposalArray == null) {
            return null;
        }
        IDocument iDocument = this.fViewer.getDocument();
        int n2 = iCompletionProposalArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Object object;
            if (iCompletionProposalArray[n3] instanceof ICompletionProposalExtension2) {
                object = (ICompletionProposalExtension2)((Object)iCompletionProposalArray[n3]);
                if (object.validate(iDocument, n, documentEvent)) {
                    arrayList.add(object);
                }
            } else if (iCompletionProposalArray[n3] instanceof ICompletionProposalExtension) {
                object = (ICompletionProposalExtension)((Object)iCompletionProposalArray[n3]);
                if (object.isValidFor(iDocument, n)) {
                    arrayList.add(object);
                }
            } else {
                this.fInvocationOffset = n;
                this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
                return this.fComputedProposals;
            }
            ++n3;
        }
        ICompletionProposal[] iCompletionProposalArray2 = new ICompletionProposal[arrayList.size()];
        arrayList.toArray(iCompletionProposalArray2);
        return iCompletionProposalArray2;
    }

    public void setFocus() {
        if (Helper2.okToUse((Widget)this.fProposalShell)) {
            this.fProposalShell.setFocus();
        }
    }
}

