/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.html;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class HTMLPrinter {
    private static RGB BG_COLOR_RGB;
    private static RGB FG_COLOR_RGB;
    private static final String UNIT;

    static {
        block3: {
            BG_COLOR_RGB = new RGB(255, 255, 225);
            FG_COLOR_RGB = new RGB(0, 0, 0);
            UNIT = Util.isMac() ? "px" : "pt";
            final Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                try {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            HTMLPrinter.cacheColors(display);
                            HTMLPrinter.installColorUpdater(display);
                        }
                    });
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 45) break block3;
                    throw sWTError;
                }
            }
        }
    }

    private HTMLPrinter() {
    }

    private static void cacheColors(Display display) {
        BG_COLOR_RGB = display.getSystemColor(29).getRGB();
        FG_COLOR_RGB = display.getSystemColor(28).getRGB();
    }

    private static void installColorUpdater(final Display display) {
        display.addListener(39, new Listener(){

            public void handleEvent(Event event) {
                HTMLPrinter.cacheColors(display);
            }
        });
    }

    private static String replace(String string, char c, String string2) {
        int n = 0;
        int n2 = string.indexOf(c, n);
        if (n2 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string2);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String convertToHTMLContent(String string) {
        string = HTMLPrinter.replace(string, '&', "&amp;");
        string = HTMLPrinter.replace(string, '\"', "&quot;");
        string = HTMLPrinter.replace(string, '<', "&lt;");
        return HTMLPrinter.replace(string, '>', "&gt;");
    }

    public static String convertToHTMLContentWithWhitespace(String string) {
        string = HTMLPrinter.replace(string, '&', "&amp;");
        string = HTMLPrinter.replace(string, '\"', "&quot;");
        string = HTMLPrinter.replace(string, '<', "&lt;");
        string = HTMLPrinter.replace(string, '>', "&gt;");
        return "<span style='white-space:pre'>" + string + "</span>";
    }

    public static String read(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        try {
            int n = reader.read(cArray);
            while (n > 0) {
                stringBuffer.append(cArray, 0, n);
                n = reader.read(cArray);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n, RGB rGB, RGB rGB2, String string) {
        if (rGB == null) {
            rGB = FG_COLOR_RGB;
        }
        if (rGB2 == null) {
            rGB2 = BG_COLOR_RGB;
        }
        StringBuffer stringBuffer2 = new StringBuffer(300);
        stringBuffer2.append("<html>");
        HTMLPrinter.appendStyleSheet(stringBuffer2, string);
        HTMLPrinter.appendColors(stringBuffer2, rGB, rGB2);
        stringBuffer.insert(n, stringBuffer2.toString());
    }

    private static void appendColors(StringBuffer stringBuffer, RGB rGB, RGB rGB2) {
        stringBuffer.append("<body text=\"");
        HTMLPrinter.appendColor(stringBuffer, rGB);
        stringBuffer.append("\" bgcolor=\"");
        HTMLPrinter.appendColor(stringBuffer, rGB2);
        stringBuffer.append("\">");
    }

    private static void appendColor(StringBuffer stringBuffer, RGB rGB) {
        stringBuffer.append('#');
        HTMLPrinter.appendAsHexString(stringBuffer, rGB.red);
        HTMLPrinter.appendAsHexString(stringBuffer, rGB.green);
        HTMLPrinter.appendAsHexString(stringBuffer, rGB.blue);
    }

    private static void appendAsHexString(StringBuffer stringBuffer, int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
    }

    public static void insertStyles(StringBuffer stringBuffer, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer(10 * stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer2.append(" style=\"");
            stringBuffer2.append(stringArray[n]);
            stringBuffer2.append('\"');
            ++n;
        }
        n = stringBuffer.indexOf("<body ");
        if (n != -1) {
            stringBuffer.insert(n + 5, stringBuffer2);
            return;
        }
        n = stringBuffer.indexOf("<body>");
        if (n != -1) {
            stringBuffer.insert(n + 5, ' ');
            stringBuffer.insert(n + 6, stringBuffer2);
            return;
        }
    }

    private static void appendStyleSheet(StringBuffer stringBuffer, String string) {
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        HTMLPrinter.appendColor(stringBuffer2, FG_COLOR_RGB);
        string = string.replaceAll("InfoText", stringBuffer2.toString());
        StringBuffer stringBuffer3 = new StringBuffer();
        HTMLPrinter.appendColor(stringBuffer3, BG_COLOR_RGB);
        string = string.replaceAll("InfoBackground", stringBuffer3.toString());
        stringBuffer.append("<head><style CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        stringBuffer.append(string);
        stringBuffer.append("</style></head>");
    }

    private static void appendStyleSheetURL(StringBuffer stringBuffer, URL uRL) {
        if (uRL == null) {
            return;
        }
        stringBuffer.append("<head>");
        stringBuffer.append("<LINK REL=\"stylesheet\" HREF= \"");
        stringBuffer.append(uRL);
        stringBuffer.append("\" CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        stringBuffer.append("</head>");
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n) {
        StringBuffer stringBuffer2 = new StringBuffer(60);
        stringBuffer2.append("<html>");
        HTMLPrinter.appendColors(stringBuffer2, FG_COLOR_RGB, BG_COLOR_RGB);
        stringBuffer.insert(n, stringBuffer2.toString());
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n, URL uRL) {
        StringBuffer stringBuffer2 = new StringBuffer(300);
        stringBuffer2.append("<html>");
        HTMLPrinter.appendStyleSheetURL(stringBuffer2, uRL);
        HTMLPrinter.appendColors(stringBuffer2, FG_COLOR_RGB, BG_COLOR_RGB);
        stringBuffer.insert(n, stringBuffer2.toString());
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n, String string) {
        HTMLPrinter.insertPageProlog(stringBuffer, n, null, null, string);
    }

    public static void addPageProlog(StringBuffer stringBuffer) {
        HTMLPrinter.insertPageProlog(stringBuffer, stringBuffer.length());
    }

    public static void addPageEpilog(StringBuffer stringBuffer) {
        stringBuffer.append("</body></html>");
    }

    public static void startBulletList(StringBuffer stringBuffer) {
        stringBuffer.append("<ul>");
    }

    public static void endBulletList(StringBuffer stringBuffer) {
        stringBuffer.append("</ul>");
    }

    public static void addBullet(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<li>");
            stringBuffer.append(string);
            stringBuffer.append("</li>");
        }
    }

    public static void addSmallHeader(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<h5>");
            stringBuffer.append(string);
            stringBuffer.append("</h5>");
        }
    }

    public static void addParagraph(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<p>");
            stringBuffer.append(string);
        }
    }

    public static void addPreFormatted(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<pre>");
            stringBuffer.append(string);
            stringBuffer.append("</pre>");
        }
    }

    public static void addParagraph(StringBuffer stringBuffer, Reader reader) {
        if (reader != null) {
            HTMLPrinter.addParagraph(stringBuffer, HTMLPrinter.read(reader));
        }
    }

    public static String convertTopLevelFont(String string, FontData fontData) {
        boolean bl = (fontData.getStyle() & 1) != 0;
        boolean bl2 = (fontData.getStyle() & 2) != 0;
        String string2 = String.valueOf(Integer.toString(fontData.getHeight())) + UNIT;
        String string3 = "'" + fontData.getName() + "',sans-serif";
        string = string.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-size:\\s*)\\d+pt(\\;?.*\\})", "$1" + string2 + "$2");
        string = string.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-weight:\\s*)\\w+(\\;?.*\\})", "$1" + (bl ? "bold" : "normal") + "$2");
        string = string.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-style:\\s*)\\w+(\\;?.*\\})", "$1" + (bl2 ? "italic" : "normal") + "$2");
        string = string.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-family:\\s*).+?(;.*\\})", "$1" + string3 + "$2");
        return string;
    }
}

