/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.html;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IDelayedInputChangeProvider;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;

public class BrowserInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2,
IDelayedInputChangeProvider {
    private static final int MIN_WIDTH = 80;
    private static final int MIN_HEIGHT = 50;
    private static boolean fgIsAvailable = false;
    private static boolean fgAvailabilityChecked = false;
    private static Point fgScrollBarSize;
    private Browser fBrowser;
    private boolean fBrowserHasContent;
    private TextLayout fTextLayout;
    private TextStyle fBoldStyle;
    private BrowserInformationControlInput fInput;
    private boolean fCompleted = false;
    private IInputChangedListener fDelayedInputChangeListener;
    private ListenerList fInputChangeListeners = new ListenerList(1);
    private final String fSymbolicFontName;

    public static boolean isAvailable(Composite composite) {
        if (!fgAvailabilityChecked) {
            try {
                try {
                    Browser browser = new Browser(composite, 0);
                    browser.dispose();
                    fgIsAvailable = true;
                    Slider slider = new Slider(composite, 512);
                    Slider slider2 = new Slider(composite, 256);
                    int n = slider.computeSize((int)-1, (int)-1).x;
                    int n2 = slider2.computeSize((int)-1, (int)-1).y;
                    fgScrollBarSize = new Point(n, n2);
                    slider.dispose();
                    slider2.dispose();
                }
                catch (SWTError sWTError) {
                    fgIsAvailable = false;
                    fgAvailabilityChecked = true;
                }
            }
            finally {
                fgAvailabilityChecked = true;
            }
        }
        return fgIsAvailable;
    }

    public BrowserInformationControl(Shell shell, String string, boolean bl) {
        super(shell, bl);
        this.fSymbolicFontName = string;
        this.create();
    }

    public BrowserInformationControl(Shell shell, String string, String string2) {
        super(shell, string2);
        this.fSymbolicFontName = string;
        this.create();
    }

    public BrowserInformationControl(Shell shell, String string, ToolBarManager toolBarManager) {
        super(shell, toolBarManager);
        this.fSymbolicFontName = string;
        this.create();
    }

    @Override
    protected void createContent(Composite composite) {
        this.fBrowser = new Browser(composite, 0);
        this.fBrowser.setJavascriptEnabled(false);
        Display display = this.getShell().getDisplay();
        this.fBrowser.setForeground(display.getSystemColor(28));
        this.fBrowser.setBackground(display.getSystemColor(29));
        this.fBrowser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent progressEvent) {
                BrowserInformationControl.this.fCompleted = true;
            }
        });
        this.fBrowser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent windowEvent) {
                windowEvent.required = true;
            }
        });
        this.fBrowser.setMenu(new Menu((Decorations)this.getShell(), 0));
        this.createTextLayout();
    }

    @Override
    public void setInformation(final String string) {
        this.setInput(new BrowserInformationControlInput(null){

            @Override
            public String getHtml() {
                return string;
            }

            @Override
            public String getInputName() {
                return "";
            }

            @Override
            public Object getInputElement() {
                return string;
            }
        });
    }

    @Override
    public void setInput(Object object) {
        Assert.isLegal((object == null || object instanceof String || object instanceof BrowserInformationControlInput ? 1 : 0) != 0);
        if (object instanceof String) {
            this.setInformation((String)object);
            return;
        }
        this.fInput = (BrowserInformationControlInput)object;
        String string = null;
        if (this.fInput != null) {
            string = this.fInput.getHtml();
        }
        boolean bl = this.fBrowserHasContent = string != null && string.length() > 0;
        if (!this.fBrowserHasContent) {
            string = "<html><body ></html>";
        }
        boolean bl2 = (this.getShell().getStyle() & 0x4000000) != 0;
        boolean bl3 = this.isResizable();
        String[] stringArray = null;
        stringArray = bl2 && bl3 ? new String[]{"direction:rtl;", "overflow:scroll;", "word-wrap:break-word;"} : (bl2 && !bl3 ? new String[]{"direction:rtl;", "overflow:hidden;", "word-wrap:break-word;"} : (!bl3 ? new String[]{"overflow:hidden;"} : new String[]{"overflow:scroll;"}));
        StringBuffer stringBuffer = new StringBuffer(string);
        HTMLPrinter.insertStyles(stringBuffer, stringArray);
        string = stringBuffer.toString();
        this.fCompleted = false;
        this.fBrowser.setText(string);
        Object[] objectArray = this.fInputChangeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IInputChangedListener)objectArray[n]).inputChanged(this.fInput);
            ++n;
        }
    }

    @Override
    public void setVisible(boolean bl) {
        Shell shell = this.getShell();
        if (shell.isVisible() == bl) {
            return;
        }
        if (!bl) {
            super.setVisible(false);
            this.setInput(null);
            return;
        }
        Display display = shell.getDisplay();
        display.timerExec(100, new Runnable(){

            @Override
            public void run() {
                BrowserInformationControl.this.fCompleted = true;
            }
        });
        while (!this.fCompleted) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        if ("win32".equals(SWT.getPlatform())) {
            shell.moveAbove(null);
        }
        super.setVisible(true);
    }

    @Override
    public void setSize(int n, int n2) {
        this.fBrowser.setRedraw(false);
        try {
            super.setSize(n, n2);
        }
        finally {
            this.fBrowser.setRedraw(true);
        }
    }

    private void createTextLayout() {
        this.fTextLayout = new TextLayout((Device)this.fBrowser.getDisplay());
        String string = this.fSymbolicFontName == null ? "org.eclipse.jface.dialogfont" : this.fSymbolicFontName;
        Font font = JFaceResources.getFont((String)string);
        this.fTextLayout.setFont(font);
        this.fTextLayout.setWidth(-1);
        font = JFaceResources.getFontRegistry().getBold(string);
        this.fBoldStyle = new TextStyle(font, null, null);
        this.fTextLayout.setText("    ");
        int n = this.fTextLayout.getBounds().width;
        this.fTextLayout.setTabs(new int[]{n});
        this.fTextLayout.setText("");
    }

    @Override
    protected void handleDispose() {
        if (this.fTextLayout != null) {
            this.fTextLayout.dispose();
            this.fTextLayout = null;
        }
        this.fBrowser = null;
        super.handleDispose();
    }

    @Override
    public Point computeSizeHint() {
        Rectangle rectangle;
        String string;
        Point point = this.getSizeConstraints();
        Rectangle rectangle2 = this.computeTrim();
        int n = rectangle2.height;
        TextPresentation textPresentation = new TextPresentation();
        HTML2TextReader hTML2TextReader = new HTML2TextReader(new StringReader(this.fInput.getHtml()), textPresentation);
        try {
            string = hTML2TextReader.getString();
        }
        catch (IOException iOException) {
            string = "";
        }
        this.fTextLayout.setText(string);
        this.fTextLayout.setWidth(point == null ? -1 : point.x - rectangle2.width);
        Iterator iterator = textPresentation.getAllStyleRangeIterator();
        while (iterator.hasNext()) {
            rectangle = (StyleRange)iterator.next();
            if (rectangle.fontStyle != 1) continue;
            this.fTextLayout.setStyle(this.fBoldStyle, rectangle.start, rectangle.start + rectangle.length - 1);
        }
        rectangle = this.fTextLayout.getBounds();
        int n2 = this.fTextLayout.getLineCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            Rectangle rectangle3 = this.fTextLayout.getLineBounds(n4);
            int n5 = rectangle3.x + rectangle3.width;
            if (n4 == 0) {
                n5 += this.fInput.getLeadingImageWidth();
            }
            n3 = Math.max(n3, n5);
            ++n4;
        }
        rectangle.width = n3;
        this.fTextLayout.setText("");
        n4 = rectangle.width;
        n += rectangle.height;
        n4 += 15;
        n += 15;
        if (point != null) {
            if (point.x != -1) {
                n4 = Math.min(point.x, n4 + rectangle2.width);
            }
            if (point.y != -1) {
                n = Math.min(point.y, n);
            }
        }
        int n6 = Math.max(80, n4);
        n = Math.max(50, n);
        return new Point(n6, n);
    }

    @Override
    public Rectangle computeTrim() {
        Rectangle rectangle = super.computeTrim();
        if (this.isResizable()) {
            boolean bl;
            boolean bl2 = bl = (this.getShell().getStyle() & 0x4000000) != 0;
            if (bl) {
                rectangle.x -= BrowserInformationControl.fgScrollBarSize.x;
            }
            rectangle.width += BrowserInformationControl.fgScrollBarSize.x;
            rectangle.height += BrowserInformationControl.fgScrollBarSize.y;
        }
        return rectangle;
    }

    public void addLocationListener(LocationListener locationListener) {
        this.fBrowser.addLocationListener(locationListener);
    }

    @Override
    public void setForegroundColor(Color color) {
        super.setForegroundColor(color);
        this.fBrowser.setForeground(color);
    }

    @Override
    public void setBackgroundColor(Color color) {
        super.setBackgroundColor(color);
        this.fBrowser.setBackground(color);
    }

    @Override
    public boolean hasContents() {
        return this.fBrowserHasContent;
    }

    public void addInputChangeListener(IInputChangedListener iInputChangedListener) {
        Assert.isNotNull((Object)iInputChangedListener);
        this.fInputChangeListeners.add((Object)iInputChangedListener);
    }

    public void removeInputChangeListener(IInputChangedListener iInputChangedListener) {
        this.fInputChangeListeners.remove((Object)iInputChangedListener);
    }

    @Override
    public void setDelayedInputChangeListener(IInputChangedListener iInputChangedListener) {
        this.fDelayedInputChangeListener = iInputChangedListener;
    }

    public boolean hasDelayedInputChangeListener() {
        return this.fDelayedInputChangeListener != null;
    }

    public void notifyDelayedInputChange(Object object) {
        if (this.fDelayedInputChangeListener != null) {
            this.fDelayedInputChangeListener.inputChanged(object);
        }
    }

    public String toString() {
        String string = (this.getShell().getStyle() & 0x10) == 0 ? "fixed" : "resizeable";
        return String.valueOf(super.toString()) + " -  style: " + string;
    }

    public BrowserInformationControlInput getInput() {
        return this.fInput;
    }

    @Override
    public Point computeSizeConstraints(int n, int n2) {
        if (this.fSymbolicFontName == null) {
            return null;
        }
        GC gC = new GC((Drawable)this.fBrowser);
        Font font = this.fSymbolicFontName == null ? JFaceResources.getDialogFont() : JFaceResources.getFont((String)this.fSymbolicFontName);
        gC.setFont(font);
        int n3 = gC.getFontMetrics().getAverageCharWidth();
        int n4 = gC.getFontMetrics().getHeight();
        gC.dispose();
        return new Point(n * n3, n2 * n4);
    }
}

