/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableOwnerDrawSupport
implements Listener {
    private static final String STYLED_RANGES_KEY = "styled_ranges";
    private TextLayout fLayout;

    public static void install(Table table) {
        TableOwnerDrawSupport tableOwnerDrawSupport = new TableOwnerDrawSupport(table);
        table.addListener(12, (Listener)tableOwnerDrawSupport);
        table.addListener(41, (Listener)tableOwnerDrawSupport);
        table.addListener(40, (Listener)tableOwnerDrawSupport);
        table.addListener(42, (Listener)tableOwnerDrawSupport);
    }

    public static void storeStyleRanges(TableItem tableItem, int n, StyleRange[] styleRangeArray) {
        tableItem.setData(STYLED_RANGES_KEY + n, (Object)styleRangeArray);
    }

    private static StyleRange[] getStyledRanges(TableItem tableItem, int n) {
        return (StyleRange[])tableItem.getData(STYLED_RANGES_KEY + n);
    }

    private TableOwnerDrawSupport(Table table) {
        int n = table.getStyle() & 0x6000000;
        this.fLayout = new TextLayout((Device)table.getDisplay());
        this.fLayout.setOrientation(n);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 41: {
                break;
            }
            case 40: {
                event.detail &= 0xFFFFFFEF;
                break;
            }
            case 42: {
                this.performPaint(event);
                break;
            }
            case 12: {
                this.widgetDisposed();
            }
        }
    }

    private void performPaint(Event event) {
        int n;
        Rectangle rectangle;
        StyleRange[] styleRangeArray;
        Color color;
        TableItem tableItem = (TableItem)event.item;
        GC gC = event.gc;
        int n2 = event.index;
        boolean bl = (event.detail & 2) != 0;
        Color color2 = gC.getForeground();
        Color color3 = gC.getBackground();
        if (!bl) {
            color = tableItem.getForeground(n2);
            gC.setForeground(color);
            styleRangeArray = tableItem.getBackground(n2);
            gC.setBackground((Color)styleRangeArray);
        }
        if ((color = tableItem.getImage(n2)) != null) {
            styleRangeArray = tableItem.getImageBounds(n2);
            rectangle = color.getBounds();
            int n3 = styleRangeArray.x + Math.max(0, (styleRangeArray.width - rectangle.width) / 2);
            n = styleRangeArray.y + Math.max(0, (styleRangeArray.height - rectangle.height) / 2);
            gC.drawImage((Image)color, n3, n);
        }
        this.fLayout.setFont(tableItem.getFont(n2));
        this.fLayout.setText("");
        this.fLayout.setText(tableItem.getText(n2));
        styleRangeArray = TableOwnerDrawSupport.getStyledRanges(tableItem, n2);
        if (styleRangeArray != null) {
            int n4 = 0;
            while (n4 < styleRangeArray.length) {
                StyleRange styleRange = styleRangeArray[n4];
                if (bl) {
                    styleRange = (StyleRange)styleRange.clone();
                    styleRange.foreground = null;
                    styleRange.background = null;
                }
                this.fLayout.setStyle((TextStyle)styleRange, styleRange.start, styleRange.start + styleRange.length - 1);
                ++n4;
            }
        }
        if ((rectangle = tableItem.getTextBounds(n2)) != null) {
            Rectangle rectangle2 = this.fLayout.getBounds();
            n = rectangle.x;
            int n5 = rectangle.y + Math.max(0, (rectangle.height - rectangle2.height) / 2);
            this.fLayout.draw(gC, n, n5);
        }
        if ((event.detail & 4) != 0) {
            Rectangle rectangle3 = tableItem.getBounds();
            gC.drawFocus(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
        if (!bl) {
            gC.setForeground(color2);
            gC.setBackground(color3);
        }
    }

    private void widgetDisposed() {
        this.fLayout.dispose();
    }
}

