/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text;

import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StickyHoverManager
extends InformationControlReplacer
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    private static final int WIDGET_PRIORITY = -5;
    private final TextViewer fTextViewer;

    public StickyHoverManager(TextViewer textViewer) {
        super(new InformationControlReplacer.DefaultInformationControlCreator());
        this.fTextViewer = textViewer;
        this.setCloser(new Closer());
        this.install((Control)this.fTextViewer.getTextWidget());
    }

    @Override
    protected void showInformationControl(Rectangle rectangle) {
        if (this.fTextViewer != null && this.fTextViewer.requestWidgetToken(this, -5)) {
            super.showInformationControl(rectangle);
        } else if (DEBUG) {
            System.out.println("cancelled StickyHoverManager.showInformationControl(..): did not get widget token (with prio)");
        }
    }

    @Override
    public void hideInformationControl() {
        try {
            super.hideInformationControl();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    @Override
    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner) {
        this.hideInformationControl();
        if (DEBUG) {
            System.out.println("StickyHoverManager gave up widget token (no prio)");
        }
        return true;
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner, int n) {
        if (this.getCurrentInformationControl2() != null) {
            if (this.getCurrentInformationControl2().isFocusControl()) {
                if (DEBUG) {
                    System.out.println("StickyHoverManager kept widget token (focused)");
                }
                return false;
            }
            if (n > -5) {
                this.hideInformationControl();
                if (DEBUG) {
                    System.out.println("StickyHoverManager gave up widget token (prio)");
                }
                return true;
            }
            if (DEBUG) {
                System.out.println("StickyHoverManager kept widget token (prio)");
            }
            return false;
        }
        if (DEBUG) {
            System.out.println("StickyHoverManager gave up widget token (no iControl)");
        }
        return true;
    }

    @Override
    public boolean setFocus(IWidgetTokenOwner iWidgetTokenOwner) {
        IInformationControl iInformationControl = this.getCurrentInformationControl2();
        if (iInformationControl instanceof IInformationControlExtension5) {
            IInformationControlExtension5 iInformationControlExtension5 = (IInformationControlExtension5)((Object)iInformationControl);
            if (iInformationControlExtension5.isVisible()) {
                iInformationControl.setFocus();
                return iInformationControl.isFocusControl();
            }
            return false;
        }
        iInformationControl.setFocus();
        return iInformationControl.isFocusControl();
    }

    class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    ControlListener,
    MouseListener,
    IViewportListener,
    KeyListener,
    FocusListener,
    Listener {
        private Control fSubjectControl;
        private boolean fIsActive = false;
        private Display fDisplay;

        Closer() {
        }

        @Override
        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        @Override
        public void setInformationControl(IInformationControl iInformationControl) {
        }

        @Override
        public void start(Rectangle rectangle) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
            }
            StickyHoverManager.this.fTextViewer.addViewportListener(this);
            IInformationControl iInformationControl = StickyHoverManager.this.getCurrentInformationControl2();
            if (iInformationControl != null) {
                iInformationControl.addFocusListener(this);
            }
            this.fDisplay = this.fSubjectControl.getDisplay();
            if (!this.fDisplay.isDisposed()) {
                this.fDisplay.addFilter(5, (Listener)this);
                this.fDisplay.addFilter(16, (Listener)this);
            }
        }

        @Override
        public void stop() {
            IInformationControl iInformationControl;
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            StickyHoverManager.this.fTextViewer.removeViewportListener(this);
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
            if ((iInformationControl = StickyHoverManager.this.getCurrentInformationControl2()) != null) {
                iInformationControl.removeFocusListener(this);
            }
            if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                this.fDisplay.removeFilter(5, (Listener)this);
                this.fDisplay.removeFilter(16, (Listener)this);
            }
            this.fDisplay = null;
        }

        public void controlResized(ControlEvent controlEvent) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void controlMoved(ControlEvent controlEvent) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void mouseDown(MouseEvent mouseEvent) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            StickyHoverManager.this.hideInformationControl();
        }

        @Override
        public void viewportChanged(int n) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void keyPressed(KeyEvent keyEvent) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (DEBUG) {
                System.out.println("StickyHoverManager.Closer.focusLost(): " + focusEvent);
            }
            Display display = this.fSubjectControl.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    StickyHoverManager.this.hideInformationControl();
                }
            });
        }

        public void handleEvent(Event event) {
            if (event.type == 5) {
                if (!(event.widget instanceof Control) || event.widget.isDisposed()) {
                    return;
                }
                IInformationControl iInformationControl = StickyHoverManager.this.getCurrentInformationControl2();
                if (iInformationControl != null && !iInformationControl.isFocusControl() && iInformationControl instanceof IInformationControlExtension3) {
                    IInformationControlExtension3 iInformationControlExtension3 = (IInformationControlExtension3)((Object)iInformationControl);
                    Rectangle rectangle = iInformationControlExtension3.getBounds();
                    if (rectangle != null) {
                        Point point = event.display.map((Control)event.widget, null, event.x, event.y);
                        int n = StickyHoverManager.this.getKeepUpMargin();
                        Geometry.expand((Rectangle)rectangle, (int)n, (int)n, (int)n, (int)n);
                        if (!rectangle.contains(point)) {
                            StickyHoverManager.this.hideInformationControl();
                        }
                    }
                } else if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                    this.fDisplay.removeFilter(5, (Listener)this);
                }
            } else if (event.type == 16) {
                IInformationControl iInformationControl;
                if (DEBUG) {
                    System.out.println("StickyHoverManager.Closer.handleEvent(): focusOut: " + event);
                }
                if ((iInformationControl = StickyHoverManager.this.getCurrentInformationControl2()) != null && !iInformationControl.isFocusControl()) {
                    StickyHoverManager.this.hideInformationControl();
                }
            }
        }
    }
}

