/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.IBlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class SelectionProcessor {
    private final Implementation NULL_IMPLEMENTATION = new Implementation();
    private final Implementation RANGE_IMPLEMENTATION = new Implementation(){

        @Override
        TextEdit replace(ISelection iSelection, String string) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return new ReplaceEdit(iTextSelection.getOffset(), iTextSelection.getLength(), string);
        }

        @Override
        String getText(ISelection iSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return iTextSelection.getText();
        }

        @Override
        boolean isEmpty(ISelection iSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return iTextSelection.getLength() <= 0;
        }

        @Override
        boolean isMultiline(ISelection iSelection) throws BadLocationException {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return SelectionProcessor.this.fDocument.getLineOfOffset(iTextSelection.getOffset()) < SelectionProcessor.this.fDocument.getLineOfOffset(iTextSelection.getOffset() + iTextSelection.getLength());
        }

        @Override
        TextEdit delete(ISelection iSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            if (this.isEmpty(iSelection)) {
                return new DeleteEdit(iTextSelection.getOffset(), 1);
            }
            return new DeleteEdit(iTextSelection.getOffset(), iTextSelection.getLength());
        }

        @Override
        TextEdit backspace(ISelection iSelection) throws BadLocationException {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            if (this.isEmpty(iSelection)) {
                return new DeleteEdit(iTextSelection.getOffset() - 1, 1);
            }
            return new DeleteEdit(iTextSelection.getOffset(), iTextSelection.getLength());
        }

        @Override
        ISelection makeEmpty(ISelection iSelection, boolean bl) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return bl ? new TextSelection(SelectionProcessor.this.fDocument, iTextSelection.getOffset(), 0) : new TextSelection(SelectionProcessor.this.fDocument, iTextSelection.getOffset() + iTextSelection.getLength(), 0);
        }

        @Override
        IRegion[] getRanges(ISelection iSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return new IRegion[]{new Region(iTextSelection.getOffset(), iTextSelection.getLength())};
        }

        @Override
        int getCoveredLines(ISelection iSelection) throws BadLocationException {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return iTextSelection.getEndLine() - iTextSelection.getStartLine() + 1;
        }

        @Override
        ISelection makeReplaceSelection(ISelection iSelection, String string) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return new TextSelection(SelectionProcessor.this.fDocument, iTextSelection.getOffset() + string.length(), 0);
        }
    };
    private final Implementation COLUMN_IMPLEMENTATION = new Implementation(){

        @Override
        TextEdit replace(ISelection iSelection, String string) throws BadLocationException {
            try {
                Object object;
                Object object2;
                IBlockTextSelection iBlockTextSelection = (IBlockTextSelection)iSelection;
                int n = iBlockTextSelection.getStartLine();
                int n2 = iBlockTextSelection.getEndLine();
                int n3 = iBlockTextSelection.getStartColumn();
                int n4 = iBlockTextSelection.getEndColumn();
                int n5 = this.computeVisualColumn(n, n3);
                int n6 = this.computeVisualColumn(n2, n4);
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                String[] stringArray = SelectionProcessor.this.fDocument.getLegalLineDelimiters();
                Object object3 = 0;
                int n7 = n;
                while (n7 <= n2) {
                    if (object3 == -1) {
                        object2 = "";
                    } else {
                        object = TextUtilities.indexOf((String[])stringArray, (String)string, (int)object3);
                        if (object[0] == -1) {
                            object2 = string.substring((int)object3);
                            object3 = -1;
                        } else {
                            object2 = string.substring((int)object3, object[0]);
                            object3 = object[0] + stringArray[object[1]].length();
                        }
                    }
                    object = this.createReplaceEdit(n7, n5, n6, (String)object2);
                    multiTextEdit.addChild((TextEdit)object);
                    ++n7;
                }
                while (object3 != -1) {
                    String string2;
                    object2 = TextUtilities.indexOf((String[])stringArray, (String)string, (int)object3);
                    if (object2[0] == -1) {
                        string2 = string.substring((int)object3);
                        object3 = -1;
                    } else {
                        string2 = string.substring((int)object3, (int)object2[0]);
                        object3 = object2[0] + stringArray[object2[1]].length();
                    }
                    if (++n2 < SelectionProcessor.this.fDocument.getNumberOfLines()) {
                        object = this.createReplaceEdit(n2, n5, n6, string2);
                    } else {
                        int n8 = multiTextEdit.getExclusiveEnd();
                        int n9 = n5;
                        char[] cArray = new char[n9];
                        Arrays.fill(cArray, ' ');
                        string2 = String.valueOf(SelectionProcessor.this.fDocument.getLegalLineDelimiters()[0]) + String.valueOf(cArray) + string2;
                        object = new InsertEdit(n8, string2);
                        n8 += string2.length();
                    }
                    multiTextEdit.addChild((TextEdit)object);
                }
                return multiTextEdit;
            }
            catch (MalformedTreeException malformedTreeException) {
                Assert.isTrue((boolean)false);
                return null;
            }
        }

        @Override
        String getText(ISelection iSelection) throws BadLocationException {
            IBlockTextSelection iBlockTextSelection = (IBlockTextSelection)iSelection;
            StringBuffer stringBuffer = new StringBuffer(iBlockTextSelection.getLength());
            int n = iBlockTextSelection.getStartLine();
            int n2 = iBlockTextSelection.getEndLine();
            int n3 = iBlockTextSelection.getStartColumn();
            int n4 = iBlockTextSelection.getEndColumn();
            int n5 = this.computeVisualColumn(n, n3);
            int n6 = this.computeVisualColumn(n2, n4);
            int n7 = n;
            while (n7 <= n2) {
                this.appendColumnRange(stringBuffer, n7, n5, n6);
                if (n7 != n2) {
                    stringBuffer.append(SelectionProcessor.this.fDocument.getLineDelimiter(n7));
                }
                ++n7;
            }
            return stringBuffer.toString();
        }

        @Override
        boolean isEmpty(ISelection iSelection) throws BadLocationException {
            IBlockTextSelection iBlockTextSelection = (IBlockTextSelection)iSelection;
            int n = iBlockTextSelection.getStartLine();
            int n2 = iBlockTextSelection.getEndLine();
            int n3 = iBlockTextSelection.getStartColumn();
            int n4 = iBlockTextSelection.getEndColumn();
            int n5 = this.computeVisualColumn(n, n3);
            int n6 = this.computeVisualColumn(n2, n4);
            return n6 == n5;
        }

        @Override
        boolean isMultiline(ISelection iSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return iTextSelection.getEndLine() > iTextSelection.getStartLine();
        }

        @Override
        TextEdit delete(ISelection iSelection) throws BadLocationException {
            if (this.isEmpty(iSelection)) {
                IBlockTextSelection iBlockTextSelection = (IBlockTextSelection)iSelection;
                iSelection = new BlockTextSelection(SelectionProcessor.this.fDocument, iBlockTextSelection.getStartLine(), iBlockTextSelection.getStartColumn(), iBlockTextSelection.getEndLine(), iBlockTextSelection.getEndColumn() + 1, SelectionProcessor.this.fTabWidth);
            }
            return this.replace(iSelection, "");
        }

        @Override
        TextEdit backspace(ISelection iSelection) throws BadLocationException {
            IBlockTextSelection iBlockTextSelection = (IBlockTextSelection)iSelection;
            if (this.isEmpty(iSelection) && iBlockTextSelection.getStartColumn() > 0) {
                iSelection = new BlockTextSelection(SelectionProcessor.this.fDocument, iBlockTextSelection.getStartLine(), iBlockTextSelection.getStartColumn() - 1, iBlockTextSelection.getEndLine(), iBlockTextSelection.getEndColumn(), SelectionProcessor.this.fTabWidth);
            }
            return this.replace(iSelection, "");
        }

        @Override
        ISelection makeEmpty(ISelection iSelection, boolean bl) throws BadLocationException {
            int n;
            int n2;
            int n3;
            int n4;
            IBlockTextSelection iBlockTextSelection = (IBlockTextSelection)iSelection;
            if (bl) {
                n4 = iBlockTextSelection.getStartLine();
                n3 = iBlockTextSelection.getStartColumn();
                n2 = iBlockTextSelection.getEndLine();
                n = this.computeCharacterColumn(n2, this.computeVisualColumn(n4, n3));
            } else {
                n2 = iBlockTextSelection.getEndLine();
                n = iBlockTextSelection.getEndColumn();
                n4 = iBlockTextSelection.getStartLine();
                n3 = this.computeCharacterColumn(n4, this.computeVisualColumn(n2, n));
            }
            return new BlockTextSelection(SelectionProcessor.this.fDocument, n4, n3, n2, n, SelectionProcessor.this.fTabWidth);
        }

        @Override
        ISelection makeReplaceSelection(ISelection iSelection, String string) throws BadLocationException {
            IBlockTextSelection iBlockTextSelection = (IBlockTextSelection)iSelection;
            String[] stringArray = SelectionProcessor.this.fDocument.getLegalLineDelimiters();
            int[] nArray = TextUtilities.indexOf((String[])stringArray, (String)string, (int)0);
            int n = nArray[0] == -1 ? string.length() : nArray[0];
            int n2 = iBlockTextSelection.getStartLine();
            int n3 = iBlockTextSelection.getStartColumn() + n;
            int n4 = iBlockTextSelection.getEndLine();
            int n5 = this.computeCharacterColumn(n4, this.computeVisualColumn(n2, n3));
            return new BlockTextSelection(SelectionProcessor.this.fDocument, n2, n3, n4, n5, SelectionProcessor.this.fTabWidth);
        }

        @Override
        IRegion[] getRanges(ISelection iSelection) throws BadLocationException {
            IBlockTextSelection iBlockTextSelection = (IBlockTextSelection)iSelection;
            int n = iBlockTextSelection.getStartLine();
            int n2 = iBlockTextSelection.getEndLine();
            int n3 = this.computeVisualColumn(n, iBlockTextSelection.getStartColumn());
            int n4 = this.computeVisualColumn(n2, iBlockTextSelection.getEndColumn());
            IRegion[] iRegionArray = new IRegion[n2 - n + 1];
            int n5 = n;
            while (n5 <= n2) {
                int n6 = this.computeCharacterColumn(n5, n3);
                int n7 = this.computeCharacterColumn(n5, n4);
                IRegion iRegion = SelectionProcessor.this.fDocument.getLineInformation(n5);
                int n8 = iRegion.getLength();
                n6 = Math.min(n6, n8);
                n7 = Math.min(n7, n8);
                iRegionArray[n5 - n] = new Region(iRegion.getOffset() + n6, n7 - n6);
                ++n5;
            }
            return iRegionArray;
        }

        @Override
        int getCoveredLines(ISelection iSelection) throws BadLocationException {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            return iTextSelection.getEndLine() - iTextSelection.getStartLine() + 1;
        }

        private TextEdit createReplaceEdit(int n, int n2, int n3, String string) throws BadLocationException {
            IRegion iRegion = SelectionProcessor.this.fDocument.getLineInformation(n);
            int n4 = iRegion.getLength();
            String string2 = SelectionProcessor.this.fDocument.get(iRegion.getOffset(), n4);
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                if (n5 == -1 && n7 >= n2) {
                    n5 = n8;
                }
                if (n7 >= n3) {
                    n6 = n8;
                    break;
                }
                n7 += this.visualSizeIncrement(string2.charAt(n8), n7);
                ++n8;
            }
            if (n5 == -1) {
                int n9 = n8 = string.length() != 0 ? 1 : 0;
                if (n8 != 0) {
                    int n10 = Math.max(0, n2 - n7);
                    char[] cArray = new char[n10];
                    Arrays.fill(cArray, ' ');
                    return new InsertEdit(iRegion.getOffset() + n4, String.valueOf(String.valueOf(cArray)) + string);
                }
                return new MultiTextEdit();
            }
            if (n6 == -1) {
                n6 = n4;
            }
            if (string.length() == 0) {
                return new DeleteEdit(iRegion.getOffset() + n5, n6 - n5);
            }
            return new ReplaceEdit(iRegion.getOffset() + n5, n6 - n5, string);
        }

        private void appendColumnRange(StringBuffer stringBuffer, int n, int n2, int n3) throws BadLocationException {
            IRegion iRegion = SelectionProcessor.this.fDocument.getLineInformation(n);
            int n4 = iRegion.getLength();
            String string = SelectionProcessor.this.fDocument.get(iRegion.getOffset(), n4);
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                if (n5 == -1 && n7 >= n2) {
                    n5 = n8;
                }
                if (n7 >= n3) {
                    n6 = n8;
                    break;
                }
                n7 += this.visualSizeIncrement(string.charAt(n8), n7);
                ++n8;
            }
            if (n5 != -1) {
                stringBuffer.append(string.substring(n5, n6 == -1 ? n4 : n6));
            }
            if (n6 == -1) {
                n8 = Math.max(0, n3 - Math.max(n7, n2));
                int n9 = 0;
                while (n9 < n8) {
                    stringBuffer.append(' ');
                    ++n9;
                }
            }
        }

        private int computeVisualColumn(int n, int n2) throws BadLocationException {
            IRegion iRegion = SelectionProcessor.this.fDocument.getLineInformation(n);
            int n3 = iRegion.getLength();
            int n4 = Math.min(n3, n2);
            String string = SelectionProcessor.this.fDocument.get(iRegion.getOffset(), n3);
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                n5 += this.visualSizeIncrement(string.charAt(n6), n5);
                ++n6;
            }
            if (n2 > n3) {
                n5 += n2 - n3;
            }
            return n5;
        }

        private int computeCharacterColumn(int n, int n2) throws BadLocationException {
            IRegion iRegion = SelectionProcessor.this.fDocument.getLineInformation(n);
            int n3 = iRegion.getLength();
            String string = SelectionProcessor.this.fDocument.get(iRegion.getOffset(), n3);
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                if (n4 >= n2) {
                    return n5;
                }
                n4 += this.visualSizeIncrement(string.charAt(n5), n4);
                ++n5;
            }
            return n3 + Math.max(0, n2 - n4);
        }

        private int visualSizeIncrement(char c, int n) {
            if (c != '\t') {
                return 1;
            }
            if (SelectionProcessor.this.fTabWidth <= 0) {
                return 0;
            }
            return SelectionProcessor.this.fTabWidth - n % SelectionProcessor.this.fTabWidth;
        }
    };
    private final IDocument fDocument;
    private final int fTabWidth;
    private IRewriteTarget fRewriteTarget;
    private ISelectionProvider fSelectionProvider;

    public SelectionProcessor(ITextViewer iTextViewer) {
        this(iTextViewer.getDocument(), iTextViewer.getTextWidget().getTabs());
        if (iTextViewer instanceof ITextViewerExtension) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)iTextViewer);
            this.fRewriteTarget = iTextViewerExtension.getRewriteTarget();
        }
        this.fSelectionProvider = iTextViewer.getSelectionProvider();
    }

    public SelectionProcessor(IDocument iDocument, int n) {
        Assert.isNotNull((Object)iDocument);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fDocument = iDocument;
        this.fTabWidth = n;
    }

    public TextEdit delete(ISelection iSelection) throws BadLocationException {
        return this.getImplementation(iSelection).delete(iSelection);
    }

    public TextEdit backspace(ISelection iSelection) throws BadLocationException {
        return this.getImplementation(iSelection).backspace(iSelection);
    }

    public TextEdit replace(ISelection iSelection, String string) throws BadLocationException {
        return this.getImplementation(iSelection).replace(iSelection, string);
    }

    public String getText(ISelection iSelection) throws BadLocationException {
        return this.getImplementation(iSelection).getText(iSelection);
    }

    public boolean isEmpty(ISelection iSelection) throws BadLocationException {
        return this.getImplementation(iSelection).isEmpty(iSelection);
    }

    public boolean isMultiline(ISelection iSelection) throws BadLocationException {
        return this.getImplementation(iSelection).isMultiline(iSelection);
    }

    public ISelection makeEmpty(ISelection iSelection, boolean bl) throws BadLocationException {
        return this.getImplementation(iSelection).makeEmpty(iSelection, bl);
    }

    private ISelection makeReplaceSelection(ISelection iSelection, String string) throws BadLocationException {
        return this.getImplementation(iSelection).makeReplaceSelection(iSelection, string);
    }

    public void doDelete(ISelection iSelection) throws BadLocationException {
        TextEdit textEdit = this.delete(iSelection);
        boolean bl = textEdit.hasChildren();
        if (bl && this.fRewriteTarget != null) {
            this.fRewriteTarget.beginCompoundChange();
        }
        try {
            textEdit.apply(this.fDocument, 2);
            if (this.fSelectionProvider != null) {
                ISelection iSelection2 = this.makeEmpty(iSelection, true);
                this.fSelectionProvider.setSelection(iSelection2);
            }
        }
        finally {
            if (bl && this.fRewriteTarget != null) {
                this.fRewriteTarget.endCompoundChange();
            }
        }
    }

    public void doReplace(ISelection iSelection, String string) throws BadLocationException {
        TextEdit textEdit = this.replace(iSelection, string);
        boolean bl = textEdit.hasChildren();
        if (bl && this.fRewriteTarget != null) {
            this.fRewriteTarget.beginCompoundChange();
        }
        try {
            textEdit.apply(this.fDocument, 2);
            if (this.fSelectionProvider != null) {
                ISelection iSelection2 = this.makeReplaceSelection(iSelection, string);
                this.fSelectionProvider.setSelection(iSelection2);
            }
        }
        finally {
            if (bl && this.fRewriteTarget != null) {
                this.fRewriteTarget.endCompoundChange();
            }
        }
    }

    public IRegion[] getRanges(ISelection iSelection) throws BadLocationException {
        return this.getImplementation(iSelection).getRanges(iSelection);
    }

    public int getCoveredLines(ISelection iSelection) throws BadLocationException {
        return this.getImplementation(iSelection).getCoveredLines(iSelection);
    }

    private Implementation getImplementation(ISelection iSelection) {
        if (iSelection instanceof IBlockTextSelection) {
            return this.COLUMN_IMPLEMENTATION;
        }
        if (iSelection instanceof ITextSelection) {
            return this.RANGE_IMPLEMENTATION;
        }
        return this.NULL_IMPLEMENTATION;
    }

    private static class Implementation {
        private Implementation() {
        }

        TextEdit replace(ISelection iSelection, String string) throws BadLocationException {
            return new MultiTextEdit();
        }

        String getText(ISelection iSelection) throws BadLocationException {
            return "";
        }

        boolean isEmpty(ISelection iSelection) throws BadLocationException {
            return iSelection.isEmpty();
        }

        boolean isMultiline(ISelection iSelection) throws BadLocationException {
            if (iSelection == null) {
                throw new NullPointerException();
            }
            return false;
        }

        TextEdit delete(ISelection iSelection) throws BadLocationException {
            return this.replace(iSelection, "");
        }

        TextEdit backspace(ISelection iSelection) throws BadLocationException {
            return this.replace(iSelection, "");
        }

        ISelection makeEmpty(ISelection iSelection, boolean bl) throws BadLocationException {
            return iSelection;
        }

        IRegion[] getRanges(ISelection iSelection) throws BadLocationException {
            return new IRegion[0];
        }

        int getCoveredLines(ISelection iSelection) throws BadLocationException {
            return 0;
        }

        ISelection makeReplaceSelection(ISelection iSelection, String string) throws BadLocationException {
            return this.makeEmpty(iSelection, false);
        }

        /* synthetic */ Implementation(Implementation implementation, Implementation implementation2) {
            this();
        }
    }
}

