/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text;

import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class InformationControlReplacer
extends AbstractInformationControlManager {
    private static final int MIN_WIDTH = 80;
    private static final int MIN_HEIGHT = 50;
    private boolean fIsReplacing;
    private Object fReplacableInformation;
    private boolean fDelayedInformationSet;
    private Rectangle fReplaceableArea;
    private Rectangle fContentBounds;

    public InformationControlReplacer(IInformationControlCreator iInformationControlCreator) {
        super(iInformationControlCreator);
        this.takesFocusWhenVisible(false);
    }

    public void replaceInformationControl(IInformationControlCreator iInformationControlCreator, Rectangle rectangle, Object object, Rectangle rectangle2, boolean bl) {
        try {
            this.fIsReplacing = true;
            if (!this.fDelayedInformationSet) {
                this.fReplacableInformation = object;
            } else {
                bl = true;
            }
            this.fContentBounds = rectangle;
            this.fReplaceableArea = rectangle2;
            this.setCustomInformationControlCreator(iInformationControlCreator);
            this.takesFocusWhenVisible(bl);
            this.showInformation();
        }
        finally {
            this.fIsReplacing = false;
            this.fReplacableInformation = null;
            this.fDelayedInformationSet = false;
            this.fReplaceableArea = null;
            this.setCustomInformationControlCreator(null);
        }
    }

    @Override
    protected void computeInformation() {
        if (this.fIsReplacing && this.fReplacableInformation != null) {
            this.setInformation(this.fReplacableInformation, this.fReplaceableArea);
            return;
        }
        if (DEBUG) {
            System.out.println("InformationControlReplacer: no active replaceable");
        }
    }

    public void showInformationControl(Rectangle rectangle, Object object) {
        Rectangle rectangle2;
        IInformationControlExtension3 iInformationControlExtension3;
        IInformationControl iInformationControl = this.getInformationControl();
        Rectangle rectangle3 = this.fContentBounds;
        if (iInformationControl instanceof IInformationControlExtension3) {
            iInformationControlExtension3 = (IInformationControlExtension3)((Object)iInformationControl);
            rectangle2 = iInformationControlExtension3.computeTrim();
            rectangle3 = Geometry.add((Rectangle)rectangle3, (Rectangle)rectangle2);
            rectangle3.width = Math.max(rectangle3.width, 80);
            rectangle3.height = Math.max(rectangle3.height, 50);
            this.getInternalAccessor().cropToClosestMonitor(rectangle3);
        }
        iInformationControlExtension3 = Geometry.getLocation((Rectangle)rectangle3);
        rectangle2 = Geometry.getSize((Rectangle)rectangle3);
        iInformationControl.setSizeConstraints(rectangle2.x, rectangle2.y);
        if (iInformationControl instanceof IInformationControlExtension2) {
            ((IInformationControlExtension2)((Object)iInformationControl)).setInput(object);
        } else {
            iInformationControl.setInformation(object.toString());
        }
        iInformationControl.setLocation((Point)iInformationControlExtension3);
        iInformationControl.setSize(rectangle2.x, rectangle2.y);
        this.showInformationControl(rectangle);
    }

    @Override
    public void hideInformationControl() {
        super.hideInformationControl();
    }

    public void setDelayedInput(Object object) {
        this.fReplacableInformation = object;
        if (!this.isReplacing()) {
            this.fDelayedInformationSet = true;
        } else if (this.getCurrentInformationControl2() instanceof IInformationControlExtension2) {
            ((IInformationControlExtension2)((Object)this.getCurrentInformationControl2())).setInput(object);
        } else if (this.getCurrentInformationControl2() != null) {
            this.getCurrentInformationControl2().setInformation(object.toString());
        }
    }

    public boolean isReplacing() {
        return this.fIsReplacing;
    }

    public IInformationControl getCurrentInformationControl2() {
        return this.getInternalAccessor().getCurrentInformationControl();
    }

    public int getKeepUpMargin() {
        return 15;
    }

    protected static class DefaultInformationControlCreator
    extends AbstractReusableInformationControlCreator {
        protected DefaultInformationControlCreator() {
        }

        @Override
        public IInformationControl doCreateInformationControl(Shell shell) {
            return new DefaultInformationControl(shell, true);
        }
    }
}

