/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.contentassist;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.AbstractControlContentAssistSubjectAdapter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextContentAssistSubjectAdapter
extends AbstractControlContentAssistSubjectAdapter {
    private Text fText;
    private HashMap fModifyListeners = new HashMap();

    public TextContentAssistSubjectAdapter(Text text) {
        Assert.isNotNull((Object)text);
        this.fText = text;
    }

    @Override
    public Control getControl() {
        return this.fText;
    }

    @Override
    public int getLineHeight() {
        return this.fText.getLineHeight();
    }

    @Override
    public int getCaretOffset() {
        return this.fText.getCaretPosition();
    }

    @Override
    public Point getLocationAtOffset(int n) {
        Point point = this.fText.getCaretLocation();
        point.y += 2;
        return point;
    }

    @Override
    public Point getWidgetSelectionRange() {
        return new Point(this.fText.getSelection().x, Math.abs(this.fText.getSelection().y - this.fText.getSelection().x));
    }

    @Override
    public Point getSelectedRange() {
        return new Point(this.fText.getSelection().x, Math.abs(this.fText.getSelection().y - this.fText.getSelection().x));
    }

    @Override
    public IDocument getDocument() {
        Object object = (IDocument)this.fText.getData("document");
        if (object == null) {
            object = new InternalDocument();
            this.fText.setData("document", object);
        }
        return object;
    }

    @Override
    public void setSelectedRange(int n, int n2) {
        this.fText.setSelection(new Point(n, n + n2));
    }

    @Override
    public void revealRange(int n, int n2) {
        this.fText.setSelection(new Point(n, n + n2));
    }

    @Override
    public boolean addSelectionListener(final SelectionListener selectionListener) {
        this.fText.addSelectionListener(selectionListener);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                selectionListener.widgetSelected(new SelectionEvent(event));
            }
        };
        this.fText.addListener(24, listener);
        this.fModifyListeners.put(selectionListener, listener);
        return true;
    }

    @Override
    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fText.removeSelectionListener(selectionListener);
        Object v = this.fModifyListeners.get(selectionListener);
        if (v instanceof Listener) {
            this.fText.removeListener(24, (Listener)v);
        }
    }

    private class InternalDocument
    extends Document {
        private ModifyListener fModifyListener;

        private InternalDocument() {
            super(TextContentAssistSubjectAdapter.this.fText.getText());
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    InternalDocument.this.set(TextContentAssistSubjectAdapter.this.fText.getText());
                }
            };
            TextContentAssistSubjectAdapter.this.fText.addModifyListener(this.fModifyListener);
        }

        public void replace(int n, int n2, String string) throws BadLocationException {
            super.replace(n, n2, string);
            TextContentAssistSubjectAdapter.this.fText.removeModifyListener(this.fModifyListener);
            TextContentAssistSubjectAdapter.this.fText.setText(this.get());
            TextContentAssistSubjectAdapter.this.fText.addModifyListener(this.fModifyListener);
        }
    }
}

