/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.contentassist;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.AbstractControlContentAssistSubjectAdapter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ComboContentAssistSubjectAdapter
extends AbstractControlContentAssistSubjectAdapter {
    private Combo fCombo;
    private HashMap fModifyListeners;

    public ComboContentAssistSubjectAdapter(Combo combo) {
        Assert.isNotNull((Object)combo);
        this.fCombo = combo;
        this.fModifyListeners = new HashMap();
    }

    @Override
    public Control getControl() {
        return this.fCombo;
    }

    @Override
    public int getLineHeight() {
        return this.fCombo.getTextHeight();
    }

    @Override
    public int getCaretOffset() {
        return this.fCombo.getCaretPosition();
    }

    @Override
    public Point getLocationAtOffset(int n) {
        String string = this.fCombo.getText();
        GC gC = new GC((Drawable)this.fCombo);
        gC.setFont(this.fCombo.getFont());
        Point point = gC.textExtent(string.substring(0, Math.min(n, string.length())));
        int n2 = gC.textExtent((String)" ").x;
        gC.dispose();
        int n3 = 2 * n2 + this.fCombo.getClientArea().x + this.fCombo.getBorderWidth() + point.x;
        return new Point(n3, this.fCombo.getClientArea().y);
    }

    @Override
    public Point getWidgetSelectionRange() {
        return new Point(this.fCombo.getSelection().x, Math.abs(this.fCombo.getSelection().y - this.fCombo.getSelection().x));
    }

    @Override
    public Point getSelectedRange() {
        return new Point(this.fCombo.getSelection().x, Math.abs(this.fCombo.getSelection().y - this.fCombo.getSelection().x));
    }

    @Override
    public IDocument getDocument() {
        Object object = (IDocument)this.fCombo.getData("document");
        if (object == null) {
            object = new InternalDocument();
            this.fCombo.setData("document", object);
        }
        return object;
    }

    @Override
    public void setSelectedRange(int n, int n2) {
        this.fCombo.setSelection(new Point(n, n + n2));
    }

    @Override
    public void revealRange(int n, int n2) {
        this.fCombo.setSelection(new Point(n, n + n2));
    }

    @Override
    public boolean addSelectionListener(final SelectionListener selectionListener) {
        this.fCombo.addSelectionListener(selectionListener);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                selectionListener.widgetSelected(new SelectionEvent(event));
            }
        };
        this.fCombo.addListener(24, listener);
        this.fModifyListeners.put(selectionListener, listener);
        return true;
    }

    @Override
    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fCombo.removeSelectionListener(selectionListener);
        Object v = this.fModifyListeners.get(selectionListener);
        if (v instanceof Listener) {
            this.fCombo.removeListener(24, (Listener)v);
        }
    }

    private class InternalDocument
    extends Document {
        private ModifyListener fModifyListener;

        private InternalDocument() {
            super(ComboContentAssistSubjectAdapter.this.fCombo.getText());
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    InternalDocument.this.set(ComboContentAssistSubjectAdapter.this.fCombo.getText());
                }
            };
            ComboContentAssistSubjectAdapter.this.fCombo.addModifyListener(this.fModifyListener);
        }

        public void replace(int n, int n2, String string) throws BadLocationException {
            super.replace(n, n2, string);
            ComboContentAssistSubjectAdapter.this.fCombo.removeModifyListener(this.fModifyListener);
            ComboContentAssistSubjectAdapter.this.fCombo.setText(this.get());
            ComboContentAssistSubjectAdapter.this.fCombo.addModifyListener(this.fModifyListener);
        }
    }
}

