/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.contentassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractControlContentAssistSubjectAdapter
implements IContentAssistSubjectControl {
    protected static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text/debug/ContentAssistSubjectAdapters"));
    private List fVerifyKeyListeners = new ArrayList(1);
    private Set fKeyListeners = new HashSet(1);
    private Listener fControlListener;
    private ILabelProvider fCueLabelProvider;
    private ControlDecoration fControlDecoration;
    private Image fCachedDefaultCueImage;

    @Override
    public abstract Control getControl();

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.fKeyListeners.add(keyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#addKeyListener()");
        }
        this.installControlListener();
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        boolean bl = this.fKeyListeners.remove(keyListener);
        if (DEBUG) {
            if (!bl) {
                System.out.println("removeKeyListener -> wasn't here");
            }
            System.out.println("AbstractControlContentAssistSubjectAdapter#removeKeyListener() -> " + this.fKeyListeners.size());
        }
        this.uninstallControlListener();
    }

    @Override
    public boolean supportsVerifyKeyListener() {
        return true;
    }

    @Override
    public boolean appendVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListeners.add(verifyKeyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#appendVerifyKeyListener() -> " + this.fVerifyKeyListeners.size());
        }
        this.installControlListener();
        return true;
    }

    @Override
    public boolean prependVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListeners.add(0, verifyKeyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#prependVerifyKeyListener() -> " + this.fVerifyKeyListeners.size());
        }
        this.installControlListener();
        return true;
    }

    @Override
    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListeners.remove(verifyKeyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#removeVerifyKeyListener() -> " + this.fVerifyKeyListeners.size());
        }
        this.uninstallControlListener();
    }

    @Override
    public void setEventConsumer(IEventConsumer iEventConsumer) {
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#setEventConsumer()");
        }
    }

    @Override
    public String getLineDelimiter() {
        return System.getProperty("line.separator");
    }

    private void installControlListener() {
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#installControlListener() -> k: " + this.fKeyListeners.size() + ", v: " + this.fVerifyKeyListeners.size());
        }
        if (this.fControlListener != null) {
            return;
        }
        this.fControlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!AbstractControlContentAssistSubjectAdapter.this.getControl().isFocusControl()) {
                    return;
                }
                VerifyEvent verifyEvent = new VerifyEvent(event);
                KeyEvent keyEvent = new KeyEvent(event);
                switch (event.type) {
                    case 31: {
                        if (DEBUG) {
                            this.dump("before traverse", event, verifyEvent);
                        }
                        verifyEvent.doit = true;
                        Iterator iterator = AbstractControlContentAssistSubjectAdapter.this.fVerifyKeyListeners.iterator();
                        while (iterator.hasNext()) {
                            ((VerifyKeyListener)iterator.next()).verifyKey(verifyEvent);
                            if (!verifyEvent.doit) {
                                event.detail = 0;
                                event.doit = true;
                                if (DEBUG) {
                                    this.dump("traverse eaten by verify", event, verifyEvent);
                                }
                                return;
                            }
                            if (!DEBUG) continue;
                            this.dump("traverse OK", event, verifyEvent);
                        }
                        break;
                    }
                    case 1: {
                        Iterator iterator = AbstractControlContentAssistSubjectAdapter.this.fVerifyKeyListeners.iterator();
                        while (iterator.hasNext()) {
                            ((VerifyKeyListener)iterator.next()).verifyKey(verifyEvent);
                            if (verifyEvent.doit) continue;
                            event.doit = verifyEvent.doit;
                            if (DEBUG) {
                                this.dump("keyDown eaten by verify", event, verifyEvent);
                            }
                            return;
                        }
                        if (DEBUG) {
                            this.dump("keyDown OK", event, verifyEvent);
                        }
                        iterator = AbstractControlContentAssistSubjectAdapter.this.fKeyListeners.iterator();
                        while (iterator.hasNext()) {
                            ((KeyListener)iterator.next()).keyPressed(keyEvent);
                        }
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false);
                    }
                }
            }

            private void dump(String string, Event event, VerifyEvent verifyEvent) {
                StringBuffer stringBuffer = new StringBuffer("--- [AbstractControlContentAssistSubjectAdapter]\n");
                stringBuffer.append(string);
                stringBuffer.append(" - e: keyCode=" + event.keyCode + this.hex(event.keyCode));
                stringBuffer.append("; character=" + event.character + this.hex(event.character));
                stringBuffer.append("; stateMask=" + event.stateMask + this.hex(event.stateMask));
                stringBuffer.append("; doit=" + event.doit);
                stringBuffer.append("; detail=" + event.detail + this.hex(event.detail));
                stringBuffer.append("; widget=" + event.widget);
                stringBuffer.append("\n");
                stringBuffer.append("  verifyEvent keyCode=" + event.keyCode + this.hex(event.keyCode));
                stringBuffer.append("; character=" + event.character + this.hex(event.character));
                stringBuffer.append("; stateMask=" + event.stateMask + this.hex(event.stateMask));
                stringBuffer.append("; doit=" + verifyEvent.doit);
                stringBuffer.append("; widget=" + event.widget);
                System.out.println(stringBuffer);
            }

            private String hex(int n) {
                return "[0x" + Integer.toHexString(n) + ']';
            }
        };
        this.getControl().addListener(31, this.fControlListener);
        this.getControl().addListener(1, this.fControlListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#installControlListener() - installed");
        }
    }

    private void uninstallControlListener() {
        if (this.fControlListener == null || this.fKeyListeners.size() + this.fVerifyKeyListeners.size() != 0) {
            if (DEBUG) {
                System.out.println("AbstractControlContentAssistSubjectAdapter#uninstallControlListener() -> k: " + this.fKeyListeners.size() + ", v: " + this.fVerifyKeyListeners.size());
            }
            return;
        }
        this.getControl().removeListener(31, this.fControlListener);
        this.getControl().removeListener(1, this.fControlListener);
        this.fControlListener = null;
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#uninstallControlListener() - done");
        }
    }

    public void setContentAssistCueProvider(final ILabelProvider iLabelProvider) {
        if (this.fCueLabelProvider != null) {
            this.fCueLabelProvider.dispose();
        }
        this.fCueLabelProvider = iLabelProvider;
        if (iLabelProvider == null) {
            if (this.fControlDecoration != null) {
                this.fControlDecoration.dispose();
                this.fControlDecoration = null;
            }
        } else {
            if (this.fControlDecoration == null) {
                this.fControlDecoration = new ControlDecoration(this.getControl(), 16512);
                this.getControl().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        if (AbstractControlContentAssistSubjectAdapter.this.fCueLabelProvider != null) {
                            AbstractControlContentAssistSubjectAdapter.this.fCueLabelProvider.dispose();
                            AbstractControlContentAssistSubjectAdapter.this.fCueLabelProvider = null;
                        }
                        if (AbstractControlContentAssistSubjectAdapter.this.fControlDecoration != null) {
                            AbstractControlContentAssistSubjectAdapter.this.fControlDecoration.dispose();
                            AbstractControlContentAssistSubjectAdapter.this.fControlDecoration = null;
                        }
                        if (AbstractControlContentAssistSubjectAdapter.this.fCachedDefaultCueImage != null) {
                            AbstractControlContentAssistSubjectAdapter.this.fCachedDefaultCueImage.dispose();
                            AbstractControlContentAssistSubjectAdapter.this.fCachedDefaultCueImage = null;
                        }
                    }
                });
                this.fControlDecoration.setShowHover(true);
                this.fControlDecoration.setShowOnlyOnFocus(true);
            }
            ILabelProviderListener iLabelProviderListener = new ILabelProviderListener(){

                public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
                    AbstractControlContentAssistSubjectAdapter.this.fControlDecoration.setDescriptionText(iLabelProvider.getText((Object)AbstractControlContentAssistSubjectAdapter.this.getControl()));
                    Image image = iLabelProvider.getImage((Object)AbstractControlContentAssistSubjectAdapter.this.getControl());
                    if (image == null) {
                        image = AbstractControlContentAssistSubjectAdapter.this.getDefaultCueImage();
                    }
                    AbstractControlContentAssistSubjectAdapter.this.fControlDecoration.setImage(image);
                }
            };
            iLabelProvider.addListener(iLabelProviderListener);
            iLabelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)iLabelProvider));
        }
    }

    private Image getDefaultCueImage() {
        if (this.fCachedDefaultCueImage == null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile(AbstractControlContentAssistSubjectAdapter.class, (String)"images/content_assist_cue.gif");
            this.fCachedDefaultCueImage = imageDescriptor.createImage((Device)this.getControl().getDisplay());
        }
        return this.fCachedDefaultCueImage;
    }
}

