/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class Win32MouseWheelFilter
implements Listener {
    private final Display fDisplay;
    private int WM_VSCROLL;
    private int WM_HSCROLL;
    private int SB_LINEUP;
    private int SB_LINEDOWN;
    private Method fSendEventMethod32;
    private Method fSendEventMethod64;

    public Win32MouseWheelFilter(Display display) {
        this.fDisplay = display;
        if (!SWT.getPlatform().equals("win32")) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.win32.OS");
            this.WM_VSCROLL = clazz.getDeclaredField("WM_VSCROLL").getInt(null);
            this.WM_HSCROLL = clazz.getDeclaredField("WM_HSCROLL").getInt(null);
            this.SB_LINEUP = clazz.getDeclaredField("SB_LINEUP").getInt(null);
            this.SB_LINEDOWN = clazz.getDeclaredField("SB_LINEDOWN").getInt(null);
            try {
                this.fSendEventMethod32 = clazz.getDeclaredMethod("SendMessage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.fSendEventMethod64 = clazz.getDeclaredMethod("SendMessage", Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE);
            }
            display.addFilter(37, (Listener)this);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        System.out.println("Warning: Running on win32 SWT platform, but unable to install Win32MouseWheelFilter filter.");
    }

    public final void dispose() {
        this.fDisplay.removeFilter(37, (Listener)this);
    }

    public final void handleEvent(Event event) {
        Control control;
        Control control2 = event.display.getCursorControl();
        if (control2 == null) {
            event.type = 0;
            event.doit = false;
            return;
        }
        if (event.widget == control2) {
            return;
        }
        if (event.widget instanceof Control) {
            control = (Control)event.widget;
            Rectangle rectangle = control.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            Point point = control.toControl(this.fDisplay.getCursorLocation());
            if (rectangle.contains(point)) {
                return;
            }
        }
        control = control2;
        int n = 768;
        while (control != null && (control.getStyle() & n) == 0 && control.getListeners(37).length == 0) {
            control = control.getParent();
        }
        if (control == null) {
            return;
        }
        int n2 = control.getStyle();
        if ((n2 & n) != 0 && control instanceof Scrollable) {
            ScrollBar scrollBar;
            int n3 = (n2 & 0x200) != 0 ? ((scrollBar = ((Scrollable)control).getVerticalBar()) == null || scrollBar.getMinimum() == 0 && scrollBar.getMaximum() == 0 && scrollBar.getSelection() == 0 || !scrollBar.isEnabled() || !scrollBar.isVisible() ? this.WM_HSCROLL : this.WM_VSCROLL) : this.WM_HSCROLL;
            int n4 = event.count;
            int n5 = this.SB_LINEUP;
            if (event.count < 0) {
                n4 = -n4;
                n5 = this.SB_LINEDOWN;
            }
            try {
                if (this.fSendEventMethod32 != null) {
                    int n6 = Control.class.getDeclaredField("handle").getInt(control);
                    int n7 = 0;
                    while (n7 < n4) {
                        this.fSendEventMethod32.invoke(null, n6, n3, n5, 0);
                        ++n7;
                    }
                } else {
                    long l = Control.class.getDeclaredField("handle").getLong(control);
                    int n8 = 0;
                    while (n8 < n4) {
                        this.fSendEventMethod64.invoke(null, l, n3, n5, 0);
                        ++n8;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
        } else {
            Point point = control.toControl(event.display.getCursorLocation());
            event.x = point.x;
            event.y = point.y;
            event.widget = control;
            control.notifyListeners(event.type, event);
        }
        event.type = 0;
        event.doit = false;
    }
}

