/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.interfaces.ISyncProgressMonitorUI;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.deltopia.ui.swt.ProgressMonitorProxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncProgressMonitorProxy
extends ProgressMonitorProxy
implements ISyncProgressMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(SyncProgressMonitorProxy.class);
    private ISyncProgressMonitor.AdvanceBy advanceBy = ISyncProgressMonitor.AdvanceBy.SIZE;
    private long bytesDone;
    private int counter;
    private double elapsedTime;
    private int itemsDone;
    private long speed;
    private long startTime;
    private int totalCount;
    private long totalSize;

    public SyncProgressMonitorProxy(Control control, ISyncProgressMonitorUI iSyncProgressMonitorUI) {
        super(control, (IProgressMonitor)iSyncProgressMonitorUI);
    }

    @Override
    public void beginTask(String string, int n) {
        assert (false);
    }

    public void beginTask(String string, long l, int n) {
        int n2 = 0;
        if (n > 100) {
            this.advanceBy = ISyncProgressMonitor.AdvanceBy.COUNT;
            n2 = n;
        } else {
            this.advanceBy = ISyncProgressMonitor.AdvanceBy.SIZE;
            n2 = (int)l;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        super.beginTask(string, n2);
        this.bytesDone = 0L;
        this.startTime = System.currentTimeMillis();
        this.speed = 0L;
        this.itemsDone = 0;
        this.totalCount = n;
        this.elapsedTime = 1.0;
        this.totalSize = l == 0L ? 1L : l;
        ISyncProgressMonitorUI iSyncProgressMonitorUI = (ISyncProgressMonitorUI)this.pmUI;
        iSyncProgressMonitorUI.setTotalItems(n);
        iSyncProgressMonitorUI.setTotalSize(l);
        this.counter = 0;
    }

    public boolean bytesTransferred(long l) {
        assert (l >= 0L);
        this.bytesDone += l;
        this.elapsedTime = Math.ceil((double)(System.currentTimeMillis() - this.startTime) / 1000.0);
        this.speed = (long)((double)this.bytesDone / this.elapsedTime);
        if (this.advanceBy == ISyncProgressMonitor.AdvanceBy.SIZE) {
            long l2 = this.bytesDone * (long)this.REPORT_COUNT / this.totalSize;
            this.worked((int)l2);
        }
        return !this.isCanceled();
    }

    public ISyncProgressMonitor.AdvanceBy getAdvanceBy() {
        return this.advanceBy;
    }

    public void itemFailed(Throwable throwable) {
    }

    public void itemTransferred() {
        ++this.itemsDone;
        assert (this.itemsDone >= 0 && this.itemsDone <= this.totalCount);
        if (this.advanceBy == ISyncProgressMonitor.AdvanceBy.COUNT) {
            long l = this.itemsDone * this.REPORT_COUNT / this.totalCount;
            this.worked((int)l);
        }
    }

    private long totalWork() {
        return this.advanceBy == ISyncProgressMonitor.AdvanceBy.SIZE ? this.totalSize : (long)this.totalCount;
    }

    @Override
    public void worked(final int n) {
        assert (n >= 0);
        long l = this.advanceBy == ISyncProgressMonitor.AdvanceBy.SIZE ? this.bytesDone : (long)this.itemsDone;
        long l2 = this.totalWork();
        if (!this.canReport() || this.control.isDisposed()) {
            return;
        }
        final ISyncProgressMonitorUI iSyncProgressMonitorUI = (ISyncProgressMonitorUI)this.pmUI;
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        long l3 = (long)(this.elapsedTime * (double)l2 / (double)Math.max(l, 1L));
        long l4 = (long)(((double)l3 - this.elapsedTime) / 1000.0);
        if (l4 < 0L) {
            LOG.warn("Negative remaining time: estimated=" + l3 + " elapsed=" + this.elapsedTime);
            l4 = 0L;
        }
        final long l5 = l4;
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (!SyncProgressMonitorProxy.this.control.isDisposed()) {
                    if (!$assertionsDisabled && l5 < 0L) {
                        throw new AssertionError();
                    }
                    iSyncProgressMonitorUI.setRemainingTime(Math.abs(l5));
                    iSyncProgressMonitorUI.setRemainingSize(Math.abs(SyncProgressMonitorProxy.this.totalSize - SyncProgressMonitorProxy.this.bytesDone));
                    if (!($assertionsDisabled || SyncProgressMonitorProxy.this.itemsDone >= 0 && SyncProgressMonitorProxy.this.itemsDone <= SyncProgressMonitorProxy.this.totalCount)) {
                        throw new AssertionError();
                    }
                    iSyncProgressMonitorUI.setRemainingItems(Math.abs(SyncProgressMonitorProxy.this.totalCount - SyncProgressMonitorProxy.this.itemsDone));
                    if (!$assertionsDisabled && SyncProgressMonitorProxy.this.speed < 0L) {
                        throw new AssertionError();
                    }
                    if (SyncProgressMonitorProxy.this.counter % 5 == 0) {
                        iSyncProgressMonitorUI.setSpeed(Math.abs(SyncProgressMonitorProxy.this.speed));
                    }
                    SyncProgressMonitorProxy syncProgressMonitorProxy = SyncProgressMonitorProxy.this;
                    syncProgressMonitorProxy.counter = syncProgressMonitorProxy.counter + 1;
                    iSyncProgressMonitorUI.worked(n);
                }
            }
        });
    }
}

