/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import java.util.Stack;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class StyledTextUndo
implements KeyListener,
ExtendedModifyListener {
    private StyledText editor;
    private boolean isRedo;
    private boolean isUndo;
    private UndoRedoStack<ExtendedModifyEvent> stack;

    public StyledTextUndo(StyledText styledText) {
        styledText.addExtendedModifyListener((ExtendedModifyListener)this);
        styledText.addKeyListener((KeyListener)this);
        this.editor = styledText;
        this.stack = new UndoRedoStack();
    }

    public boolean hasRedo() {
        return this.stack.hasRedo();
    }

    public boolean hasUndo() {
        return this.stack.hasUndo();
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = (keyEvent.stateMask & SWT.MOD1) > 0;
        boolean bl3 = bl = (keyEvent.stateMask & SWT.MOD3) > 0;
        if (bl2 && !bl) {
            boolean bl4;
            boolean bl5 = bl4 = (keyEvent.stateMask & SWT.MOD2) > 0;
            if (!bl4 && keyEvent.keyCode == 122) {
                this.undo();
            } else if (!bl4 && keyEvent.keyCode == 121 || bl4 && keyEvent.keyCode == 122) {
                this.redo();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void modifyText(ExtendedModifyEvent extendedModifyEvent) {
        if (this.isUndo) {
            this.stack.pushRedo(extendedModifyEvent);
        } else {
            this.stack.pushUndo(extendedModifyEvent);
            if (!this.isRedo) {
                this.stack.clearRedo();
            }
        }
    }

    public void redo() {
        if (this.stack.hasRedo()) {
            this.isRedo = true;
            this.revertEvent(this.stack.popRedo());
            this.isRedo = false;
        }
    }

    private void revertEvent(ExtendedModifyEvent extendedModifyEvent) {
        this.editor.replaceTextRange(extendedModifyEvent.start, extendedModifyEvent.length, extendedModifyEvent.replacedText);
        this.editor.setSelectionRange(extendedModifyEvent.start, extendedModifyEvent.replacedText.length());
    }

    public void undo() {
        if (this.stack.hasUndo()) {
            this.isUndo = true;
            this.revertEvent(this.stack.popUndo());
            this.isUndo = false;
        }
    }

    private static class UndoRedoStack<T> {
        private Stack<T> redo;
        private Stack<T> undo = new Stack();

        public UndoRedoStack() {
            this.redo = new Stack();
        }

        public void clearRedo() {
            this.redo.clear();
        }

        public boolean hasRedo() {
            return !this.redo.isEmpty();
        }

        public boolean hasUndo() {
            return !this.undo.isEmpty();
        }

        public T popRedo() {
            T t = this.redo.pop();
            return t;
        }

        public T popUndo() {
            T t = this.undo.pop();
            return t;
        }

        public void pushRedo(T t) {
            this.redo.add(t);
        }

        public void pushUndo(T t) {
            this.undo.add(t);
        }
    }
}

