/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import com.deltopia.ui.concurrency.GuiExecutor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ProgressMonitorProxy
implements IProgressMonitor {
    private static final int REPORT_INTERVAL = 300;
    private volatile boolean canReport = true;
    protected final Control control;
    protected final IProgressMonitor pmUI;
    protected int REPORT_COUNT = 100;
    private volatile boolean stopTimer = false;

    public ProgressMonitorProxy(Control control, IProgressMonitor iProgressMonitor) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        if (iProgressMonitor == null) {
            throw new NullPointerException("pm");
        }
        this.control = control;
        this.pmUI = iProgressMonitor;
    }

    public void beginTask(final String string, final int n) {
        if (string == null) {
            throw new IllegalArgumentException("name");
        }
        this.control.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ProgressMonitorProxy.this.control.isDisposed()) {
                    ProgressMonitorProxy.this.pmUI.beginTask(string, n);
                    ProgressMonitorProxy.this.startReportTimer();
                }
            }
        });
    }

    protected boolean canReport() {
        if (this.canReport) {
            if (!this.stopTimer) {
                this.canReport = false;
            }
            return true;
        }
        return false;
    }

    public void done() {
        this.stopTimer = true;
        this.canReport = true;
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (!ProgressMonitorProxy.this.control.isDisposed()) {
                    ProgressMonitorProxy.this.pmUI.done();
                }
            }
        });
    }

    public void internalWorked(final double d) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (!ProgressMonitorProxy.this.control.isDisposed()) {
                    ProgressMonitorProxy.this.pmUI.internalWorked(d);
                }
            }
        });
    }

    public boolean isCanceled() {
        return this.pmUI.isCanceled();
    }

    public void setCanceled(boolean bl) {
        this.pmUI.setCanceled(bl);
    }

    public void setTaskName(final String string) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (!ProgressMonitorProxy.this.control.isDisposed()) {
                    ProgressMonitorProxy.this.pmUI.setTaskName(string);
                }
            }
        });
    }

    private void startReportTimer() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ProgressMonitorProxy.this.control.isDisposed()) {
                    return;
                }
                ProgressMonitorProxy.this.canReport = true;
                if (!ProgressMonitorProxy.this.stopTimer) {
                    Display.getDefault().timerExec(300, (Runnable)this);
                }
            }
        };
        Display.getDefault().timerExec(300, runnable);
    }

    public void subTask(final String string) {
        if (!this.canReport()) {
            return;
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (!ProgressMonitorProxy.this.control.isDisposed()) {
                    ProgressMonitorProxy.this.pmUI.subTask(string);
                }
            }
        });
    }

    public void worked(final int n) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (!ProgressMonitorProxy.this.control.isDisposed()) {
                    ProgressMonitorProxy.this.pmUI.worked(n);
                }
            }
        });
    }

    public static interface ITimeIndicator {
        public void showTime(String var1);
    }
}

