/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import com.deltopia.ui.swt.Border;
import com.deltopia.ui.swt.BorderDoubleLine;
import com.deltopia.ui.swt.CloseRenderer;
import com.deltopia.ui.swt.IPannerHost;
import com.deltopia.util.Const;
import java.awt.Insets;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Panner
extends Canvas {
    private static final Logger LOG = LoggerFactory.getLogger(Panner.class);
    private Border border;
    private boolean canPan = false;
    private CloseRenderer closer;
    final int DOCK_DISTANCE = 5;
    private IPannerHost host;
    private final MouseHandler onMouse;
    private Border outlineMove;
    private Border outlineStill;
    private static Boolean canAlpha;
    private boolean panning = false;
    private final Rectangle RC_PROJECT = new Rectangle(5, 5, 30, 30);
    private Rectangle rcProject = new Rectangle(0, 0, 0, 0);

    public static boolean canAlpha() {
        if (canAlpha != null) {
            return canAlpha;
        }
        try {
            GC gC = new GC((Drawable)Display.getDefault());
            int n = gC.getAlpha();
            gC.setAlpha(80);
            gC.setAlpha(n);
            canAlpha = true;
        }
        catch (SWTException sWTException) {
            canAlpha = false;
            LOG.error("No alpha support: ", (Throwable)sWTException);
        }
        return canAlpha;
    }

    public Panner(Composite composite, int n, IPannerHost iPannerHost) {
        super(composite, n | 0x40000000 | 0x40000 | 0x100000);
        this.host = iPannerHost;
        this.outlineStill = new BorderDoubleLine((Device)this.getDisplay(), 2, 1, 0, 0);
        this.outlineMove = new BorderDoubleLine((Device)this.getDisplay(), 2, 7, 0, 0);
        this.onMouse = new MouseHandler();
        this.addMouseListener(this.onMouse);
        this.addMouseMoveListener(this.onMouse);
        this.addMouseTrackListener(this.onMouse);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Panner.this.paint(paintEvent.gc);
            }
        });
        this.createToolTip();
    }

    private void createToolTip() {
        DefaultToolTip defaultToolTip = new DefaultToolTip((Control)this){

            protected String getText(Event event) {
                return "Execute Script";
            }
        };
        defaultToolTip.setPopupDelay(0);
        defaultToolTip.setShift(new Point(8, 16));
    }

    public void dispose() {
        super.dispose();
        if (this.outlineStill != null) {
            this.outlineStill.dispose();
            this.outlineStill = null;
        }
        if (this.outlineMove != null) {
            this.outlineMove.dispose();
            this.outlineMove = null;
        }
    }

    public final Border getBorder() {
        return this.border;
    }

    public Rectangle getClientArea() {
        Rectangle rectangle = super.getClientArea();
        if (this.border != null) {
            Insets insets = this.border.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            if (rectangle.width < 0) {
                rectangle.width = 0;
            }
            if (rectangle.height < 0) {
                rectangle.height = 0;
            }
        }
        return rectangle;
    }

    protected Rectangle getOutermostClientArea() {
        return super.getClientArea();
    }

    protected Rectangle imageBounds() {
        return this.projectionBounds();
    }

    public void move(int n, int n2) {
        Rectangle rectangle = this.getParent().getClientArea();
        if (rectangle.isEmpty()) {
            return;
        }
        Rectangle rectangle2 = this.getBounds();
        int n3 = Math.max(rectangle.x, Math.min(rectangle2.x + n, rectangle.x + rectangle.width - rectangle2.width));
        int n4 = Math.max(rectangle.y, Math.min(rectangle2.y + n2, rectangle.y + rectangle.height - rectangle2.height));
        if (n3 != rectangle2.x || n4 != rectangle2.y) {
            this.setLocation(n3, n4);
            Rectangle rectangle3 = this.getClientArea();
            Point point = this.getSize();
            Point point2 = new Point(rectangle3.width - point.x, rectangle3.height - point.y - 15);
            boolean bl = n3 > point2.x - 5 && n4 > point2.y - 5;
            this.host.setDockPanner(bl);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Move panner to : " + n3 + 'x' + n4 + " canvas=" + rectangle + ", panner=" + rectangle2);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Cannot move panner to : " + n3 + 'x' + n4 + " canvas=" + rectangle + ", panner=" + rectangle2);
        }
    }

    protected void paint(GC gC) {
        block9: {
            try {
                Rectangle rectangle;
                if (this.host.isEmpty()) {
                    return;
                }
                this.host.paint(gC);
                if ((this.getStyle() & 0x40) != 0) {
                    this.closer.drawClose(gC, this.getDisplay());
                }
                if (this.panning && !this.rcProject.isEmpty()) {
                    this.outlineMove.paintBorder((Control)this, gC, this.rcProject);
                }
                if ((rectangle = this.projectionBounds()).isEmpty()) break block9;
                if (!Panner.canAlpha()) {
                    return;
                }
                int n = gC.getAlpha();
                Color color = gC.getBackground();
                Rectangle rectangle2 = this.imageBounds();
                Region region = new Region((Device)this.getDisplay());
                Region region2 = new Region((Device)this.getDisplay());
                try {
                    Rectangle rectangle3 = this.getOutermostClientArea();
                    region2.add(rectangle3);
                    region2.subtract(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    gC.setAlpha(150);
                    gC.setClipping(region2);
                    gC.setBackground(this.getDisplay().getSystemColor(16));
                    gC.fillRoundRectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, Const.ARC_M.x, Const.ARC_M.y);
                }
                finally {
                    region.dispose();
                    region2.dispose();
                }
                gC.setClipping(null);
                gC.setBackground(color);
                gC.setAlpha(n);
            }
            catch (Throwable throwable) {
                LOG.error("Error painting panner " + (Object)((Object)this), throwable);
            }
        }
    }

    public Rectangle projectionBounds() {
        return new Rectangle(this.RC_PROJECT.x, this.RC_PROJECT.y, this.RC_PROJECT.width, this.RC_PROJECT.height);
    }

    public final void setBorder(Border border) {
        if (this.border != null) {
            border.dispose();
        }
        this.border = border;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.closer = new CloseRenderer(new Rectangle(n - 16, 6, 16, 16));
    }

    private class MouseHandler
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener {
        private final Point ptOffset = new Point(0, 0);
        private Point ptOldLoc = null;

        private MouseHandler() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            Panner.this.rcProject = Panner.this.projectionBounds();
            if (mouseEvent.button == 1) {
                if (Panner.this.rcProject.contains(mouseEvent.x, mouseEvent.y)) {
                    if (Panner.this.canPan) {
                        Panner.this.panning = true;
                        this.ptOffset.x = mouseEvent.x - ((Panner)Panner.this).rcProject.x;
                        this.ptOffset.y = mouseEvent.y - ((Panner)Panner.this).rcProject.y;
                    }
                } else {
                    this.ptOldLoc = Panner.this.toDisplay(mouseEvent.x, mouseEvent.y);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Start move panner: " + this.ptOldLoc);
                    }
                }
            }
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            Panner.this.setCursor(Panner.this.getDisplay().getSystemCursor(0));
            Panner.this.closer.setState(CloseRenderer.State.NORMAL);
            this.redrawClose();
        }

        public void mouseExit(MouseEvent mouseEvent) {
            Panner.this.closer.setState(CloseRenderer.State.NONE);
            this.redrawClose();
        }

        public void mouseHover(MouseEvent mouseEvent) {
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (Panner.this.panning) {
                ((Panner)Panner.this).rcProject.x = mouseEvent.x - this.ptOffset.x;
                ((Panner)Panner.this).rcProject.y = mouseEvent.y - this.ptOffset.y;
                Panner.this.redraw();
            } else if (this.ptOldLoc != null) {
                Point point = Panner.this.toDisplay(mouseEvent.x, mouseEvent.y);
                int n = point.x - this.ptOldLoc.x;
                int n2 = point.y - this.ptOldLoc.y;
                if (n != 0 || n2 != 0) {
                    this.ptOldLoc.x = point.x;
                    this.ptOldLoc.y = point.y;
                    Panner.this.move(n, n2);
                }
            } else {
                CloseRenderer.State state;
                boolean bl = Panner.this.closer.isInside(new Point(mouseEvent.x, mouseEvent.y));
                CloseRenderer.State state2 = state = bl ? CloseRenderer.State.HOT : CloseRenderer.State.NORMAL;
                if (state != Panner.this.closer.getState()) {
                    Panner.this.closer.setState(state);
                    this.redrawClose();
                }
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            Panner.this.panning = false;
            this.ptOldLoc = null;
            if (Panner.this.closer.isInside(new Point(mouseEvent.x, mouseEvent.y))) {
                Panner.this.host.showPanner(false, true);
            }
        }

        private void redrawClose() {
            Rectangle rectangle = Panner.this.closer.bounds();
            Panner.this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }
}

