/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class KeyUtil {
    public static final String MODIFIER_KEY = "MODIFIER_KEY";

    public static String acceleratorText(int n, int n2) {
        return KeyUtil.acceleratorText(n, n2, false);
    }

    public static String acceleratorText(int n, int n2, boolean bl) {
        String string = "";
        KeyStroke keyStroke = KeyStroke.getInstance((int)n, (int)n2);
        KeySequence keySequence = KeySequence.getInstance((KeyStroke)keyStroke);
        String string2 = keySequence.format();
        string = bl && !string2.isEmpty() ? JFaceResources.format((String)"Toolbar_Tooltip_Accelerator", (Object[])new Object[]{string, string2}) : string2;
        return string;
    }

    public static int getModifier(Widget widget, boolean bl) {
        Object object = widget.getData(MODIFIER_KEY);
        if (object instanceof Integer) {
            int n = (Integer)object;
            if (bl) {
                widget.setData(MODIFIER_KEY, null);
            }
            return n;
        }
        return 0;
    }

    public static boolean hasKey(Event event, int n) {
        return event.keyCode == n;
    }

    public static boolean hasKey(Event event, int n, int n2) {
        return KeyUtil.hasMask(event, n2) && event.keyCode == n;
    }

    public static boolean hasKey(KeyEvent keyEvent, int n) {
        return keyEvent.keyCode == n;
    }

    public static boolean hasMask(Event event, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("'mask' cannot be 0");
        }
        return (event.stateMask & n) == n;
    }

    public static boolean hasMask(int n, int n2) {
        return (n & n2) == n2;
    }

    public static boolean hasMask(KeyEvent keyEvent, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("'mask' cannot be 0");
        }
        return (keyEvent.stateMask & n) == n;
    }

    public static boolean hasMask(Widget widget, int n, boolean bl) {
        return KeyUtil.hasMask(KeyUtil.getModifier(widget, bl), n);
    }

    public static void setModifier(Widget widget, int n) {
        widget.setData(MODIFIER_KEY, (Object)n);
    }
}

