/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ImageCanvas
extends Canvas {
    private Image image;
    private Point ptOffset = new Point(0, 0);

    public ImageCanvas(Composite composite, int n) {
        super(composite, n | 0x20000000);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                if (ImageCanvas.this.image != null && !ImageCanvas.this.image.isDisposed()) {
                    Rectangle rectangle = ImageCanvas.this.image.getBounds();
                    Rectangle rectangle2 = ImageCanvas.this.getClientArea();
                    event.gc.drawImage(ImageCanvas.this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2.x + ((ImageCanvas)ImageCanvas.this).ptOffset.x, rectangle2.y + ((ImageCanvas)ImageCanvas.this).ptOffset.y, rectangle2.width, rectangle2.height);
                }
            }
        });
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Rectangle rectangle;
        int n3 = 0;
        int n4 = 0;
        if (this.image != null && !this.image.isDisposed()) {
            rectangle = this.image.getBounds();
            n3 = rectangle.width;
            n4 = rectangle.height;
        }
        rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.image != image) {
            this.image = image;
            if (!this.isDisposed()) {
                this.getParent().layout();
                this.redraw();
            }
        }
    }

    public void setOffset(Point point) {
        this.ptOffset = point;
    }
}

