/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import com.deltopia.ui.swt.ImageCanvas;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ImageButton
extends ImageCanvas {
    private boolean enabled = true;
    private Image imgDefault;
    private Image imgDisabled;
    private Image imgDown;
    private Image imgHover;
    private boolean mouseDown;
    Listener onMouse = new Listener(){

        public void handleEvent(Event event) {
            if (!ImageButton.this.enabled) {
                ImageButton.this.setImage(ImageButton.this.getDisabledImage());
                return;
            }
            switch (event.type) {
                case 3: {
                    this.handleMouseDown(event);
                    break;
                }
                case 6: {
                    this.handleMouseEnter(event);
                    break;
                }
                case 7: {
                    this.handleMouseExit(event);
                    break;
                }
                case 5: {
                    this.handleMouseMove(event);
                    break;
                }
                case 4: {
                    this.handleMouseUp(event);
                }
            }
        }

        protected void handleMouseDown(Event event) {
            ImageButton.this.mouseDown = true;
            ImageButton.this.setImage(ImageButton.this.getDownImage());
        }

        private void handleMouseEnter(Event event) {
            ImageButton.this.setImage(ImageButton.this.getHoverImage());
        }

        private void handleMouseExit(Event event) {
            ImageButton.this.setImage(ImageButton.this.getDefaultImage());
        }

        private void handleMouseMove(Event event) {
            if (ImageButton.this.getClientArea().contains(event.x, event.y)) {
                ImageButton.this.setImage(ImageButton.this.mouseDown ? ImageButton.this.getDownImage() : ImageButton.this.getHoverImage());
            } else {
                ImageButton.this.setImage(ImageButton.this.getDefaultImage());
            }
        }

        private void handleMouseUp(Event event) {
            ImageButton.this.mouseDown = false;
            if (ImageButton.this.getClientArea().contains(event.x, event.y)) {
                ImageButton.this.handleSelection();
                ImageButton.this.setImage(ImageButton.this.getHoverImage());
            } else {
                ImageButton.this.setImage(ImageButton.this.getDefaultImage());
            }
        }
    };

    public ImageButton(Composite composite, int n) {
        super(composite, n);
        this.setLayoutData(new GridData(0x1000000, 0x1000000, false, false));
        this.addListener(3, this.onMouse);
        this.addListener(6, this.onMouse);
        this.addListener(7, this.onMouse);
        this.addListener(5, this.onMouse);
        this.addListener(4, this.onMouse);
    }

    public Image getDefaultImage() {
        return this.imgDefault;
    }

    public Image getDisabledImage() {
        return this.imgDisabled;
    }

    public Image getDownImage() {
        return this.imgDown;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Image getHoverImage() {
        return this.imgHover != null ? this.imgHover : this.getDefaultImage();
    }

    protected void handleSelection() {
    }

    public void setDefaultImage(Image image) {
        this.imgDefault = image;
    }

    public void setDisabledImage(Image image) {
        this.imgDisabled = image;
    }

    public void setDownImage(Image image) {
        this.imgDown = image;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.setImage(bl ? this.getDefaultImage() : this.getDisabledImage());
    }

    public void setHoverImage(Image image) {
        this.imgHover = image;
    }
}

