/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GifCLabel
extends Canvas {
    private static final int GAP = 5;
    private static final int DEFAULT_MARGIN = 3;
    private static final String ELLIPSIS = "...";
    private int align = 16384;
    private int leftMargin = 3;
    private int topMargin = 3;
    private int rightMargin = 3;
    private int bottomMargin = 3;
    private String text;
    private Image imgFrame;
    private String appToolTipText;
    private boolean ignoreDispose;
    private Image bgImage;
    private Color[] gradientColors;
    private int[] gradientPercents;
    private boolean gradientVertical;
    private Color background;
    private GifThread thread = null;
    private static int DRAW_FLAGS = 15;

    public GifCLabel(Composite composite, int n) {
        super(composite, GifCLabel.checkStyle(n));
        if ((n & 0x1020000) == 0) {
            n |= 0x4000;
        }
        if ((n & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((n & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((n & 0x4000) != 0) {
            this.align = 16384;
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                GifCLabel.this.onPaint(paintEvent);
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 128) {
                    GifCLabel.this.onMnemonic(traverseEvent);
                }
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                GifCLabel.this.onDispose(event);
            }
        });
        this.initAccessible();
    }

    private static int checkStyle(int n) {
        if ((n & 0x800) != 0) {
            n |= 4;
        }
        int n2 = 100663340;
        n &= n2;
        return n |= 0x20080000;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = this.getTotalSize(this.imgFrame, this.text);
        point.x = n == -1 ? (point.x += this.leftMargin + this.rightMargin) : n;
        point.y = n2 == -1 ? (point.y += this.topMargin + this.bottomMargin) : n2;
        return point;
    }

    private void drawBevelRect(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        gC.setForeground(color2);
        gC.drawLine(n + n3, n2, n + n3, n2 + n4);
        gC.drawLine(n, n2 + n4, n + n3, n2 + n4);
        gC.setForeground(color);
        gC.drawLine(n, n2, n + n3 - 1, n2);
        gC.drawLine(n, n2, n, n2 + n4 - 1);
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return Character.toLowerCase(string.charAt(n));
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    public int getAlignment() {
        return this.align;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public Image getImage() {
        return this.imgFrame;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    private Point getTotalSize(Image image, String string) {
        Rectangle rectangle;
        Point point = new Point(0, 0);
        if (image != null) {
            rectangle = image.getBounds();
            point.x += rectangle.width;
            point.y += rectangle.height;
        }
        rectangle = new GC((Drawable)this);
        if (string != null && string.length() > 0) {
            Point point2 = rectangle.textExtent(string, DRAW_FLAGS);
            point.x += point2.x;
            point.y = Math.max(point.y, point2.y);
            if (image != null) {
                point.x += 5;
            }
        } else {
            point.y = Math.max(point.y, rectangle.getFontMetrics().getHeight());
        }
        rectangle.dispose();
        return point;
    }

    public int getStyle() {
        int n = super.getStyle();
        switch (this.align) {
            case 131072: {
                n |= 0x20000;
                break;
            }
            case 0x1000000: {
                n |= 0x1000000;
                break;
            }
            case 16384: {
                n |= 0x4000;
            }
        }
        return n;
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = GifCLabel.this.getText();
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = GifCLabel.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c = GifCLabel.this._findMnemonic(GifCLabel.this.text);
                if (c != '\u0000') {
                    accessibleEvent.result = "Alt+" + c;
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = GifCLabel.this.getDisplay().map((Control)GifCLabel.this.getParent(), null, GifCLabel.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 41;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 64;
            }
        });
    }

    void onDispose(Event event) {
        if (this.ignoreDispose) {
            this.ignoreDispose = false;
            return;
        }
        this.ignoreDispose = true;
        this.notifyListeners(event.type, event);
        event.type = 0;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.bgImage = null;
        this.text = null;
        this.imgFrame = null;
        this.appToolTipText = null;
    }

    void onMnemonic(TraverseEvent traverseEvent) {
        char c = this._findMnemonic(this.text);
        if (c == '\u0000') {
            return;
        }
        if (Character.toLowerCase(traverseEvent.character) != c) {
            return;
        }
        Composite composite = this.getParent();
        while (composite != null) {
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (++n < controlArray.length && controlArray[n].setFocus()) {
                traverseEvent.doit = true;
                traverseEvent.detail = 0;
            }
            composite = composite.getParent();
        }
    }

    void onPaint(PaintEvent paintEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        String[] stringArray;
        GC gC;
        Point point;
        Image image;
        Rectangle rectangle;
        block41: {
            Point point2;
            rectangle = this.getClientArea();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            boolean bl = false;
            String string = this.text;
            image = this.imgFrame;
            int n5 = Math.max(0, rectangle.width - (this.leftMargin + this.rightMargin));
            point = this.getTotalSize(image, string);
            if (point.x > n5) {
                image = null;
                point = this.getTotalSize(image, string);
                if (point.x > n5) {
                    bl = true;
                }
            }
            gC = paintEvent.gc;
            String[] stringArray2 = stringArray = this.text == null ? null : this.splitString(this.text);
            if (bl) {
                point.x = 0;
                n4 = 0;
                while (n4 < stringArray.length) {
                    point2 = gC.textExtent(stringArray[n4], DRAW_FLAGS);
                    if (point2.x > n5) {
                        stringArray[n4] = this.shortenText(gC, stringArray[n4], n5);
                        point.x = Math.max(point.x, this.getTotalSize(null, (String)stringArray[n4]).x);
                    } else {
                        point.x = Math.max(point.x, point2.x);
                    }
                    ++n4;
                }
                if (this.appToolTipText == null) {
                    super.setToolTipText(this.text);
                }
            } else {
                super.setToolTipText(this.appToolTipText);
            }
            n4 = rectangle.x + this.leftMargin;
            if (this.align == 0x1000000) {
                n4 = (rectangle.width - point.x) / 2;
            }
            if (this.align == 131072) {
                n4 = rectangle.width - this.rightMargin - point.x;
            }
            try {
                if (this.bgImage != null) {
                    point2 = this.bgImage.getBounds();
                    gC.setBackground(this.getBackground());
                    gC.fillRectangle(rectangle);
                    int n6 = 0;
                    while (n6 < rectangle.width) {
                        int n7 = 0;
                        while (n7 < rectangle.height) {
                            gC.drawImage(this.bgImage, n6, n7);
                            n7 += point2.height;
                        }
                        n6 += point2.width;
                    }
                } else if (this.gradientColors != null) {
                    point2 = gC.getBackground();
                    if (this.gradientColors.length == 1) {
                        if (this.gradientColors[0] != null) {
                            gC.setBackground(this.gradientColors[0]);
                        }
                        gC.fillRectangle(0, 0, rectangle.width, rectangle.height);
                    } else {
                        Color color = gC.getForeground();
                        Color color2 = this.gradientColors[0];
                        if (color2 == null) {
                            color2 = point2;
                        }
                        n3 = 0;
                        n2 = 0;
                        while (n2 < this.gradientPercents.length) {
                            gC.setForeground(color2);
                            color2 = this.gradientColors[n2 + 1];
                            if (color2 == null) {
                                color2 = point2;
                            }
                            gC.setBackground(color2);
                            if (this.gradientVertical) {
                                n = this.gradientPercents[n2] * rectangle.height / 100 - n3;
                                gC.fillGradientRectangle(0, n3, rectangle.width, n, true);
                                n3 += n;
                            } else {
                                n = this.gradientPercents[n2] * rectangle.width / 100 - n3;
                                gC.fillGradientRectangle(n3, 0, n, rectangle.height, false);
                                n3 += n;
                            }
                            ++n2;
                        }
                        if (this.gradientVertical && n3 < rectangle.height) {
                            gC.setBackground(this.getBackground());
                            gC.fillRectangle(0, n3, rectangle.width, rectangle.height - n3);
                        }
                        if (!this.gradientVertical && n3 < rectangle.width) {
                            gC.setBackground(this.getBackground());
                            gC.fillRectangle(n3, 0, rectangle.width - n3, rectangle.height);
                        }
                        gC.setForeground(color);
                    }
                    gC.setBackground((Color)point2);
                } else if (this.background != null || (this.getStyle() & 0x20000000) == 0) {
                    gC.setBackground(this.getBackground());
                    gC.fillRectangle(rectangle);
                }
            }
            catch (SWTException sWTException) {
                if ((this.getStyle() & 0x20000000) != 0) break block41;
                gC.setBackground(this.getBackground());
                gC.fillRectangle(rectangle);
            }
        }
        int n8 = this.getStyle();
        if ((n8 & 4) != 0 || (n8 & 8) != 0) {
            this.paintBorder(gC, rectangle);
        }
        Rectangle rectangle2 = null;
        int n9 = 0;
        n3 = 0;
        n2 = 0;
        if (image != null) {
            rectangle2 = image.getBounds();
            n2 = rectangle2.height;
        }
        if (stringArray != null) {
            n9 = gC.getFontMetrics().getHeight();
            n3 = stringArray.length * n9;
        }
        n = 0;
        int n10 = 0;
        int n11 = 0;
        if (n2 > n3) {
            n = this.topMargin == 3 && this.bottomMargin == 3 ? rectangle.y + (rectangle.height - n2) / 2 : this.topMargin;
            n10 = n + n2 / 2;
            n11 = n10 - n3 / 2;
        } else {
            n11 = this.topMargin == 3 && this.bottomMargin == 3 ? rectangle.y + (rectangle.height - n3) / 2 : this.topMargin;
            n10 = n11 + n3 / 2;
            n = n10 - n2 / 2;
        }
        if (image != null) {
            gC.drawImage(image, 0, 0, rectangle2.width, n2, n4, n, rectangle2.width, n2);
            n4 += rectangle2.width + 5;
            point.x -= rectangle2.width + 5;
        }
        if (stringArray != null) {
            gC.setForeground(this.getForeground());
            int n12 = 0;
            while (n12 < stringArray.length) {
                int n13 = n4;
                if (stringArray.length > 1) {
                    int n14;
                    if (this.align == 0x1000000) {
                        n14 = gC.textExtent((String)stringArray[n12], (int)GifCLabel.DRAW_FLAGS).x;
                        n13 = n4 + Math.max(0, (point.x - n14) / 2);
                    }
                    if (this.align == 131072) {
                        n14 = gC.textExtent((String)stringArray[n12], (int)GifCLabel.DRAW_FLAGS).x;
                        n13 = Math.max(n4, rectangle.x + rectangle.width - this.rightMargin - n14);
                    }
                }
                gC.drawText(stringArray[n12], n13, n11, DRAW_FLAGS);
                n11 += n9;
                ++n12;
            }
        }
    }

    private void paintBorder(GC gC, Rectangle rectangle) {
        Display display = this.getDisplay();
        Color color = null;
        Color color2 = null;
        int n = this.getStyle();
        if ((n & 4) != 0) {
            color = display.getSystemColor(18);
            color2 = display.getSystemColor(20);
        }
        if ((n & 8) != 0) {
            color = display.getSystemColor(19);
            color2 = display.getSystemColor(18);
        }
        if (color != null && color2 != null) {
            gC.setLineWidth(1);
            this.drawBevelRect(gC, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, color, color2);
        }
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if (n != 16384 && n != 131072 && n != 0x1000000) {
            SWT.error((int)5);
        }
        if (this.align != n) {
            this.align = n;
            this.redraw();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.bgImage == null && this.gradientColors == null && this.gradientPercents == null && (color == null ? this.background == null : color.equals((Object)this.background))) {
            return;
        }
        this.background = color;
        this.bgImage = null;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.redraw();
    }

    public void setBackground(Color[] colorArray, int[] nArray) {
        this.setBackground(colorArray, nArray, false);
    }

    public void setBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error((int)5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] < 0 || nArray[n2] > 100) {
                    SWT.error((int)5);
                }
                if (n2 > 0 && nArray[n2] < nArray[n2 - 1]) {
                    SWT.error((int)5);
                }
                ++n2;
            }
        }
        Color color = this.getBackground();
        if (this.bgImage == null) {
            if (this.gradientColors != null && colorArray != null && this.gradientColors.length == colorArray.length) {
                n = 0;
                int n3 = 0;
                while (n3 < this.gradientColors.length) {
                    int n4 = n = !(this.gradientColors[n3] == colorArray[n3] || this.gradientColors[n3] == null && colorArray[n3] == color || this.gradientColors[n3] == color && colorArray[n3] == null) ? 0 : 1;
                    if (n == 0) break;
                    ++n3;
                }
                if (n != 0) {
                    n3 = 0;
                    while (n3 < this.gradientPercents.length) {
                        int n5 = n = this.gradientPercents[n3] == nArray[n3] ? 1 : 0;
                        if (n == 0) break;
                        ++n3;
                    }
                }
                if (n != 0 && this.gradientVertical == bl) {
                    return;
                }
            }
        } else {
            this.bgImage = null;
        }
        if (colorArray == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
        } else {
            this.gradientColors = new Color[colorArray.length];
            n = 0;
            while (n < colorArray.length) {
                this.gradientColors[n] = colorArray[n] != null ? colorArray[n] : color;
                ++n;
            }
            this.gradientPercents = new int[nArray.length];
            n = 0;
            while (n < nArray.length) {
                this.gradientPercents[n] = nArray[n];
                ++n;
            }
            this.gradientVertical = bl;
        }
        this.redraw();
    }

    public void setBackground(Image image) {
        this.checkWidget();
        if (image == this.bgImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.bgImage = image;
        this.redraw();
    }

    public void setBottomMargin(int n) {
        this.checkWidget();
        if (this.bottomMargin == n || n < 0) {
            return;
        }
        this.bottomMargin = n;
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (this.thread != null) {
            this.thread.stopRunning();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (image != this.imgFrame) {
            this.imgFrame = image;
            this.redraw();
        }
    }

    public void setGifImage(String string) {
        try {
            this.setGifImage(new FileInputStream(new File(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.imgFrame = null;
            return;
        }
    }

    public void setGifImage(InputStream inputStream) {
        this.checkWidget();
        if (this.thread != null) {
            this.thread.stopRunning();
        }
        ImageLoader imageLoader = new ImageLoader();
        try {
            imageLoader.load(inputStream);
        }
        catch (Exception exception) {
            this.imgFrame = null;
            return;
        }
        if (imageLoader.data[0] != null) {
            this.imgFrame = new Image((Device)this.getDisplay(), imageLoader.data[0]);
        }
        if (imageLoader.data.length > 1) {
            this.thread = new GifThread(imageLoader);
            this.thread.start();
        }
        this.redraw();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.stopRunning();
        }
    }

    public void setLeftMargin(int n) {
        this.checkWidget();
        if (this.leftMargin == n || n < 0) {
            return;
        }
        this.leftMargin = n;
        this.redraw();
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.leftMargin = Math.max(0, n);
        this.topMargin = Math.max(0, n2);
        this.rightMargin = Math.max(0, n3);
        this.bottomMargin = Math.max(0, n4);
        this.redraw();
    }

    public void setRightMargin(int n) {
        this.checkWidget();
        if (this.rightMargin == n || n < 0) {
            return;
        }
        this.rightMargin = n;
        this.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.text)) {
            this.text = string;
            this.redraw();
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    public void setTopMargin(int n) {
        this.checkWidget();
        if (this.topMargin == n || n < 0) {
            return;
        }
        this.topMargin = n;
        this.redraw();
    }

    protected String shortenText(GC gC, String string, int n) {
        String string2;
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = gC.textExtent((String)ELLIPSIS, (int)GifCLabel.DRAW_FLAGS).x;
        if (n <= n3) {
            return string;
        }
        int n4 = string.length();
        int n5 = n4 / 2;
        int n6 = (n5 + (n2 = 0)) / 2 - 1;
        if (n6 <= 0) {
            return string;
        }
        TextLayout textLayout = new TextLayout((Device)this.getDisplay());
        textLayout.setText(string);
        n6 = this.validateOffset(textLayout, n6);
        while (n2 < n6 && n6 < n5) {
            string2 = string.substring(0, n6);
            String string3 = string.substring(this.validateOffset(textLayout, n4 - n6), n4);
            int n7 = gC.textExtent((String)string2, (int)GifCLabel.DRAW_FLAGS).x;
            int n8 = gC.textExtent((String)string3, (int)GifCLabel.DRAW_FLAGS).x;
            if (n7 + n3 + n8 > n) {
                n5 = n6;
                n6 = this.validateOffset(textLayout, (n5 + n2) / 2);
                continue;
            }
            if (n7 + n3 + n8 < n) {
                n2 = n6;
                n6 = this.validateOffset(textLayout, (n5 + n2) / 2);
                continue;
            }
            n2 = n5;
        }
        string2 = n6 == 0 ? string : String.valueOf(string.substring(0, n6)) + ELLIPSIS + string.substring(this.validateOffset(textLayout, n4 - n6), n4);
        textLayout.dispose();
        return string2;
    }

    int validateOffset(TextLayout textLayout, int n) {
        int n2 = textLayout.getNextOffset(n, 2);
        if (n2 != n) {
            return textLayout.getPreviousOffset(n2, 2);
        }
        return n;
    }

    private String[] splitString(String string) {
        int n;
        String[] stringArray = new String[1];
        int n2 = 0;
        do {
            if ((n = string.indexOf(10, n2)) == -1) {
                stringArray[stringArray.length - 1] = string.substring(n2);
                continue;
            }
            boolean bl = n > 0 && string.charAt(n - 1) == '\r';
            stringArray[stringArray.length - 1] = string.substring(n2, n - (bl ? 1 : 0));
            n2 = n + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        } while (n != -1);
        return stringArray;
    }

    private class GifThread
    extends Thread {
        private int frameIx = 0;
        private ImageLoader loader = null;
        private boolean run = true;

        public GifThread(ImageLoader imageLoader) {
            this.loader = imageLoader;
        }

        @Override
        public void run() {
            while (this.run) {
                int n = this.loader.data[this.frameIx].delayTime;
                try {
                    Thread.sleep(n * 10);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (!GifCLabel.this.isDisposed()) {
                    GifCLabel.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!GifThread.this.run) {
                                return;
                            }
                            if (!GifCLabel.this.isDisposed()) {
                                GifThread.this.frameIx = GifThread.this.frameIx == ((GifThread)GifThread.this).loader.data.length - 1 ? 0 : GifThread.this.frameIx + 1;
                                if (!GifCLabel.this.imgFrame.isDisposed()) {
                                    GifCLabel.this.imgFrame.dispose();
                                }
                                ImageData imageData = ((GifThread)GifThread.this).loader.data[GifThread.this.frameIx];
                                GifCLabel.this.imgFrame = new Image((Device)GifCLabel.this.getDisplay(), imageData);
                                GifCLabel.this.redraw();
                            } else {
                                GifThread.this.stopRunning();
                            }
                        }
                    });
                    continue;
                }
                this.stopRunning();
            }
        }

        public void stopRunning() {
            this.run = false;
        }
    }
}

