/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.swt;

import com.deltopia.ui.swt.Panner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class CloseRenderer {
    static final int BORDER = 16;
    static final RGB CLOSE_FILL = new RGB(252, 160, 160);
    private static Color clrFill;
    static final int FILL = 25;
    public static final int MARGIN = 2;
    public static final int SIZE = 16;
    final int ALPHA = 200;
    final int ALPHA_HOT = 160;
    private final Rectangle rcBounds;
    private State state = State.NONE;

    static Color getFillColor(Display display) {
        if (clrFill == null) {
            clrFill = new Color((Device)display, CLOSE_FILL);
        }
        return clrFill;
    }

    public CloseRenderer(Rectangle rectangle) {
        this.rcBounds = rectangle;
    }

    public Rectangle bounds() {
        return this.rcBounds;
    }

    public void drawClose(GC gC, Display display) {
        if (this.state == State.NONE || this.rcBounds.isEmpty()) {
            return;
        }
        int n = this.rcBounds.x;
        int n2 = this.rcBounds.y;
        Color color = gC.getForeground();
        Color color2 = gC.getBackground();
        int n3 = gC.getLineWidth();
        int n4 = gC.getAlpha();
        try {
            int n5;
            Color color3;
            Color color4 = display.getSystemColor(1);
            Color color5 = color3 = display.getSystemColor(16);
            boolean bl = Panner.canAlpha();
            if (this.state == State.NORMAL) {
                gC.setForeground(color3);
            } else {
                if (bl) {
                    gC.setAlpha(200);
                }
                n5 = 3;
                gC.setForeground(color5);
                gC.setLineWidth(1);
                gC.drawRoundRectangle(n, n2, 11, 11, n5, n5);
                if (bl) {
                    if (this.state != State.HIT) {
                        gC.setAlpha(160);
                    }
                    gC.setBackground(color5);
                    gC.fillRoundRectangle(n + 1, n2 + 1, 10, 10, n5 -= 2, n5);
                    gC.setAlpha(n4);
                    gC.setForeground(color4);
                }
            }
            gC.setLineWidth(2);
            n5 = 3;
            int n6 = 6;
            gC.drawLine(n + n5, n2 + n5, n + n5 + n6, n2 + n5 + n6);
            gC.drawLine(n + n5, n2 + n5 + n6, n + n5 + n6, n2 + n5);
        }
        finally {
            gC.setForeground(color);
            gC.setBackground(color2);
            gC.setLineWidth(n3);
            gC.setAlpha(n4);
        }
    }

    public State getState() {
        return this.state;
    }

    public boolean isInside(Point point) {
        return this.rcBounds.contains(point);
    }

    public void setState(State state) {
        this.state = state;
    }

    public static enum State {
        HIT,
        HOT,
        NONE,
        NORMAL;

    }
}

