/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.concurrency;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.widgets.Display;

public class GuiExecutor
extends AbstractExecutorService {
    private static final GuiExecutor instance = new GuiExecutor();

    private static Display display() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static GuiExecutor instance() {
        return instance;
    }

    private GuiExecutor() {
    }

    public void asyncExec(Display display, Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("Task");
        }
        if (display == null) {
            display = GuiExecutor.display();
        }
        if (Thread.currentThread().equals(display.getThread())) {
            runnable.run();
        } else {
            display.asyncExec(runnable);
        }
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable runnable) {
        Display display = GuiExecutor.display();
        if (Thread.currentThread().equals(display.getThread())) {
            runnable.run();
        } else {
            display.syncExec(runnable);
        }
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }
}

