/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui.concurrency;

import com.deltopia.ui.concurrency.GuiExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundTask<V>
implements Runnable,
Future<V> {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundTask.class);
    private final FutureTask<V> computation = new Computation();

    protected void setProgress(final int n, final int n2) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                BackgroundTask.this.onProgress(n, n2);
            }
        });
    }

    protected abstract V compute() throws Exception;

    protected void onCompletion(V v, Throwable throwable, boolean bl) {
    }

    protected void onProgress(int n, int n2) {
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.computation.cancel(bl);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.computation.get();
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.computation.get(l, timeUnit);
    }

    @Override
    public boolean isCancelled() {
        return this.computation.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.computation.isDone();
    }

    @Override
    public void run() {
        try {
            this.computation.run();
        }
        catch (RuntimeException runtimeException) {
            LOG.warn("Task run failed: " + this.computation, (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    private class Computation
    extends FutureTask<V> {
        public Computation() {
            super(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return BackgroundTask.this.compute();
                }
            });
        }

        @Override
        protected final void done() {
            GuiExecutor.instance().execute(new Runnable(){

                /*
                 * Loose catch block
                 */
                @Override
                public void run() {
                    block9: {
                        Object v = null;
                        Throwable throwable = null;
                        boolean bl = false;
                        try {
                            try {
                                v = Computation.this.get();
                            }
                            catch (ExecutionException executionException) {
                                throwable = executionException.getCause();
                                BackgroundTask.this.onCompletion(v, throwable, bl);
                            }
                            catch (CancellationException cancellationException) {
                                bl = true;
                                BackgroundTask.this.onCompletion(v, throwable, bl);
                            }
                            catch (InterruptedException interruptedException) {
                                BackgroundTask.this.onCompletion(v, throwable, bl);
                                break block9;
                                {
                                    catch (Throwable throwable2) {
                                        throw throwable2;
                                    }
                                }
                            }
                        }
                        finally {
                            BackgroundTask.this.onCompletion(v, throwable, bl);
                        }
                    }
                }
            });
        }
    }
}

