/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.ui;

import com.deltopia.LibLoadResult;
import com.deltopia.ui.internal.IControlFactory;
import com.deltopia.ui.internal.LocalFileDialog;
import com.deltopia.ui.swt.IFileDialog;
import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UI {
    private static int gtkVersion;
    private static LibLoadResult loadResult;
    private static final Logger LOG;

    static {
        loadResult = LibLoadResult.UNDEFINED;
        LOG = LoggerFactory.getLogger(UI.class);
    }

    public static IFileDialog createFileDialog(Shell shell, int n, IControlFactory iControlFactory) {
        String string = Platform.getOS();
        if (!string.equals("win32")) {
            return new LocalFileDialog(shell, n);
        }
        if (loadResult == LibLoadResult.UNDEFINED) {
            IFileDialog iFileDialog = null;
            String string2 = String.valueOf(UI.getPackageName(LocalFileDialog.class)) + '.' + string + '.' + Platform.getOSArch() + ".FileDialog";
            try {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(Shell.class, Integer.TYPE, IControlFactory.class);
                iFileDialog = (IFileDialog)constructor.newInstance(shell, new Integer(n), iControlFactory);
                return iFileDialog;
            }
            catch (Throwable throwable) {
                LOG.warn("No " + string2 + ", using the SWT FileDialog.");
                loadResult = LibLoadResult.FAILURE;
            }
        }
        return new LocalFileDialog(shell, n);
    }

    private static int getGtkVersion() {
        if (gtkVersion == 0) {
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.gtk.OS", true, SWT.class.getClassLoader());
                gtkVersion = clazz.getField("GTK_VERSION").getInt(null);
            }
            catch (Throwable throwable) {
                LOG.error("Couldn't obtain GTK version: ", throwable);
            }
        }
        return gtkVersion;
    }

    private static String getPackageName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return -1 < n ? string.substring(0, n) : string;
    }

    private UI() {
    }
}

