/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.vfs.util;

import com.deltopia.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.URIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UriUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltopia.io.UriUtil");
    private static final String[] ESCAPE_CHARS = new String[]{" ", "!", "<", ">", "#", "%", "{", "}", "|", "\\", "^", "~", "[", "]", "'", ";", "/", "?", ":", "@", "=", "&", "$"};
    private static final String[] ESCAPE_CODES = new String[]{"20", "21", "3C", "3E", "23", "25", "7B", "7D", "7C", "5C", "5E", "7E", "5B", "5D", "60", "3B", "2F", "3F", "3A", "40", "3D", "26", "24"};
    private static List<String> escCodes = new ArrayList<String>();

    static {
        int n = 0;
        while (n < ESCAPE_CODES.length) {
            escCodes.add(ESCAPE_CODES[n]);
            ++n;
        }
    }

    public static String constructPrefKey(String string, String string2, String string3) {
        String string4 = "";
        try {
            org.apache.commons.httpclient.URI uRI = new org.apache.commons.httpclient.URI(string, UriUtil.isEscaped(string));
            String string5 = uRI.getHost();
            if (string5 == null) {
                try {
                    URI uRI2 = new URI(string);
                    string5 = uRI2.getHost();
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOG.error("Couldn't extract host for " + string, (Throwable)uRISyntaxException);
                }
            }
            string4 = String.valueOf(string3) + '@' + string5 + "-" + string2;
        }
        catch (URIException uRIException) {
            LOG.error("Couldn't construct pref key for " + string2, (Throwable)uRIException);
        }
        return string4;
    }

    public static String constructSshPassphrasePrefKey(String string, String string2) {
        return UriUtil.constructPrefKey(string, "passphrase", string2);
    }

    public static String constructUriPasswordPrefKey(String string, String string2) {
        return UriUtil.constructPrefKey(string, "password", string2);
    }

    public static String escapeUriComponent(String string) {
        return UriUtil.escapeUriComponent(string, "");
    }

    public static String escapeUriComponent(String string, String string2) {
        if (StringUtil.isEmpty((String)string) || UriUtil.isEscaped(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = 0;
        while (n < ESCAPE_CHARS.length) {
            String string3 = ESCAPE_CHARS[n];
            if (StringUtil.isEmpty((String)string2) || !ESCAPE_CHARS[n].equals(string2)) {
                int n2 = 0;
                while ((n2 = stringBuilder.indexOf(string3, n2)) != -1) {
                    if (!string3.equals("%") || n2 < stringBuilder.length() - 3 && !escCodes.contains(stringBuilder.substring(n2 + 1, n2 + 3))) {
                        stringBuilder.replace(n2, n2 + 1, String.valueOf('%') + ESCAPE_CODES[n]);
                        n2 += 3;
                        continue;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static boolean isEscaped(String string) {
        if (string == null) {
            throw new NullPointerException("uri");
        }
        boolean bl = false;
        int n = string.indexOf(37);
        if (n > -1 && n < string.length() - 3) {
            String string2 = string.substring(n + 1, n + 3);
            int n2 = 0;
            while (n2 < ESCAPE_CODES.length) {
                if (string2.equalsIgnoreCase(ESCAPE_CODES[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public static String passwordFromUri(String string) {
        if (string == null) {
            throw new NullPointerException("strUri");
        }
        String string2 = "";
        try {
            org.apache.commons.httpclient.URI uRI = new org.apache.commons.httpclient.URI(string, UriUtil.isEscaped(string));
            String string3 = uRI.getEscapedUserinfo();
            string2 = UriUtil.usernameFromUserInfo(string3);
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        return string2;
    }

    public static String passwordFromUserInfo(String string) {
        if (string == null) {
            throw new NullPointerException("userInfo");
        }
        int n = StringUtil.makeSafe((String)string).indexOf(58);
        boolean bl = n != -1;
        String string2 = bl ? string.substring(n + 1, string.length()) : "";
        return string2;
    }

    public static String usernameFromUserInfo(String string) {
        if (string == null) {
            throw new NullPointerException("userInfo");
        }
        int n = StringUtil.makeSafe((String)string).indexOf(58);
        boolean bl = n != -1;
        String string2 = bl ? string.substring(0, n) : string;
        return string2;
    }

    private UriUtil() {
    }
}

