/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.jface.util;

import com.deltawalker.NotifyUtil;
import com.deltopia.AdaptableUtil;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.jface.util.IActiveViewListener;
import com.deltopia.jface.util.IViewHolder;
import java.util.LinkedList;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class ViewHolder
extends EventManager
implements IViewHolder,
IAdaptable {
    private static final String VIEWER_KEY = "VIEWER_KEY";
    private int activeIx = -1;
    private final Listener onDispose = new Listener(){

        public void handleEvent(Event event) {
            ViewHolder.this.handleDispose(event);
        }
    };
    private boolean insideTabChanged;
    protected final CTabFolder tabFolder;

    public ViewHolder(Composite composite) {
        this.tabFolder = new CTabFolder(composite, 0x800400){

            public void showItem(CTabItem cTabItem) {
                if (ViewHolder.this.canShowViewer(ViewHolder.this.tabFolder.indexOf(cTabItem))) {
                    super.showItem(cTabItem);
                } else {
                    this.setSelection(0);
                }
                ViewHolder.this.tabChanged();
            }
        };
    }

    @Override
    public void activate(int n) {
        if (n >= this.tabFolder.getItemCount()) {
            throw new IndexOutOfBoundsException();
        }
        this.tabFolder.setFocus();
        this.tabFolder.setSelection(n);
    }

    protected void activeViewChanged(int n, int n2) {
    }

    @Override
    public void addActiveViewListener(IActiveViewListener iActiveViewListener) {
        this.addListenerObject(iActiveViewListener);
    }

    protected CTabItem addTab() {
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        cTabItem.addListener(12, this.onDispose);
        this.updateLayout();
        return cTabItem;
    }

    @Override
    public int add(IMvcView iMvcView) {
        CTabItem cTabItem = this.addTab();
        int n = this.tabFolder.indexOf(cTabItem);
        this.placeViewInTab(iMvcView, n);
        return this.tabFolder.getItemCount() - 1;
    }

    protected boolean canShowViewer(int n) {
        return true;
    }

    protected abstract IMvcView createView(Composite var1, int var2);

    protected void fireActiveViewerChanged(int n, int n2) {
        NotifyUtil.fireActiveViewerChanged(this.getListeners(), this, n, n2);
    }

    @Override
    public IMvcView activeView() {
        if (this.tabFolder.isDisposed()) {
            return null;
        }
        CTabItem cTabItem = this.tabFolder.getSelection();
        if (cTabItem != null) {
            return this.view(this.tabFolder.indexOf(cTabItem), false);
        }
        return null;
    }

    public Object getAdapter(Class clazz) {
        return AdaptableUtil.getAdapter((Object)this.activeView(), (Class)clazz);
    }

    @Override
    public Control getControl() {
        return this.tabFolder;
    }

    @Override
    public IMvcView view(int n, boolean bl) {
        CTabItem cTabItem = this.tabFolder.getItem(n);
        Object object = cTabItem.getData(VIEWER_KEY);
        if (object instanceof IMvcView) {
            return (IMvcView)object;
        }
        if (!bl) {
            return null;
        }
        IMvcView iMvcView = this.createView((Composite)this.tabFolder, n);
        this.placeViewInTab(iMvcView, n);
        return iMvcView;
    }

    @Override
    public int viewCount(boolean bl) {
        if (bl) {
            return this.views(false).length;
        }
        return this.tabFolder.getItemCount();
    }

    @Override
    public IMvcView[] views(boolean bl) {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        LinkedList<IMvcView> linkedList = new LinkedList<IMvcView>();
        int n = 0;
        while (n < cTabItemArray.length) {
            IMvcView iMvcView = this.view(n, bl);
            if (iMvcView != null) {
                linkedList.add(iMvcView);
            }
            ++n;
        }
        return linkedList.toArray(new IMvcView[linkedList.size()]);
    }

    protected void handleDispose(Event event) {
        Control control;
        Widget widget = event.widget;
        if (!widget.isDisposed() && widget instanceof CTabItem && (control = ((CTabItem)widget).getControl()) != null && !control.isDisposed()) {
            control.dispose();
        }
    }

    @Override
    public int indexOf(IMvcView iMvcView) {
        int n = this.tabFolder.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.tabFolder.getItem(n2).getData(VIEWER_KEY).equals(iMvcView)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void placeViewInTab(IMvcView iMvcView, int n) {
        CTabItem cTabItem = this.tabFolder.getItem(n);
        cTabItem.setData(VIEWER_KEY, (Object)iMvcView);
        ((Viewer)iMvcView).setData("VIEW_HOLDER_KEY", (Object)this);
        cTabItem.setControl(iMvcView.control());
        this.tabFolder.setSelection(n);
    }

    protected void refresh() {
        IMvcView[] iMvcViewArray = this.views(false);
        int n = 0;
        while (n < iMvcViewArray.length) {
            if (iMvcViewArray[n] instanceof Viewer) {
                ((Viewer)iMvcViewArray[n]).refresh();
            }
            ++n;
        }
    }

    @Override
    public void removeActiveViewListener(IActiveViewListener iActiveViewListener) {
        this.removeListenerObject(iActiveViewListener);
    }

    @Override
    public void remove(int n) {
        CTabItem cTabItem = this.tabFolder.getItem(n);
        cTabItem.dispose();
        int n2 = this.tabFolder.getItemCount();
        if (n2 > 0) {
            this.tabFolder.setSelection(n2 - 1);
        }
        this.updateLayout();
    }

    private void tabChanged() {
        if (!this.insideTabChanged) {
            this.insideTabChanged = true;
            int n = this.tabFolder.getSelectionIndex();
            if (n != -1 && n != this.activeIx) {
                this.activeViewChanged(this.activeIx, n);
                this.activeIx = n;
            }
        }
        this.insideTabChanged = false;
    }

    protected void updateLayout() {
        int n = this.tabFolder.getItemCount();
        this.tabFolder.setTabHeight(n < 2 ? 0 : -1);
        this.tabFolder.layout();
    }
}

