/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.jface.util;

import com.deltawalker.internal.ContextId;
import com.deltawalker.ui.UIUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class SelectionDialogUtil {
    private static final int VIEWER_HEIGHT_HINT_LG = 200;
    private static final int VIEWER_HEIGHT_HINT = 150;
    private static final int VIEWER_WIDTH_HINT_LG = 500;
    private static final int VIEWER_WIDTH_HINT = 300;

    private static void createButtonsForButtonBar(IButtonsForButtonBarCreator iButtonsForButtonBarCreator, Composite composite, String string, String string2, boolean bl) {
        if (string != null) {
            iButtonsForButtonBarCreator.createButton(composite, 2, string, true);
        }
        if (string2 != null) {
            iButtonsForButtonBarCreator.createButton(composite, 3, string2, false);
        }
        if (bl) {
            iButtonsForButtonBarCreator.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    public static SelectionDialog createSelectionDialog(Shell shell, Object object, ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider, String string, final String string2, final String string3, final boolean bl) {
        Object object2;
        boolean bl2 = SelectionDialogUtil.useListSelectionDialog(object, (IStructuredContentProvider)iTreeContentProvider);
        if (bl2) {
            object2 = new ListSelectionDialog(shell, object, (IStructuredContentProvider)iTreeContentProvider, iLabelProvider, string){

                protected void buttonPressed(int n) {
                    super.buttonPressed(SelectionDialogUtil.handleButtonPressed((Viewer)this.getViewer(), n));
                }

                protected void createButtonsForButtonBar(Composite composite) {
                    SelectionDialogUtil.createButtonsForButtonBar(new IButtonsForButtonBarCreator(){

                        @Override
                        public Button createButton(Composite composite, int n, String string, boolean bl) {
                            return this.internalCreateButton(composite, n, string, bl);
                        }
                    }, composite, string2, string3, bl);
                }

                protected Point getInitialSize() {
                    SelectionDialogUtil.fixInitialSize((Viewer)this.getViewer(), false);
                    return super.getInitialSize();
                }

                private Button internalCreateButton(Composite composite, int n, String string, boolean bl2) {
                    return this.createButton(composite, n, string, bl2);
                }

                public int open() {
                    this.setShellStyle(this.getShellStyle() | 0x10000000);
                    return super.open();
                }
            };
        } else {
            CheckedTreeSelectionDialog checkedTreeSelectionDialog = new CheckedTreeSelectionDialog(shell, iLabelProvider, iTreeContentProvider){

                protected void buttonPressed(int n) {
                    super.buttonPressed(SelectionDialogUtil.handleButtonPressed((Viewer)this.getTreeViewer(), n));
                }

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    UIUtil.setHelpContextId((Control)shell, ContextId.CONFIRM_MULTIPLE_FILE_DELETE_DIALOG);
                }

                protected void helpPressed() {
                    UIUtil.showHelp("confirm-multiple-file-delete", UIUtil.HelpContext.DIALOG);
                }

                protected void createButtonsForButtonBar(Composite composite) {
                    SelectionDialogUtil.createButtonsForButtonBar(new IButtonsForButtonBarCreator(){

                        @Override
                        public Button createButton(Composite composite, int n, String string, boolean bl) {
                            return this.internalCreateButton(composite, n, string, bl);
                        }
                    }, composite, string2, string3, bl);
                }

                protected Composite createSelectionButtons(Composite composite) {
                    GridData gridData;
                    Composite composite2 = super.createSelectionButtons(composite);
                    Object object = composite2.getLayoutData();
                    if (object instanceof GridData) {
                        gridData = (GridData)object;
                    } else {
                        gridData = new GridData();
                        composite2.setLayoutData((Object)gridData);
                    }
                    gridData.grabExcessHorizontalSpace = false;
                    gridData.horizontalAlignment = 0x1000008;
                    Layout layout = composite2.getLayout();
                    if (layout instanceof GridLayout) {
                        GridLayout gridLayout = (GridLayout)layout;
                        gridLayout.marginWidth = 0;
                        if (gridLayout.numColumns != 2) {
                            gridLayout.numColumns = 2;
                        }
                    }
                    return composite2;
                }

                protected CheckboxTreeViewer createTreeViewer(Composite composite) {
                    CheckboxTreeViewer checkboxTreeViewer = super.createTreeViewer(composite);
                    Object[] objectArray = ((ITreeContentProvider)checkboxTreeViewer.getContentProvider()).getElements(checkboxTreeViewer.getInput());
                    this.setExpandedElements(objectArray);
                    return checkboxTreeViewer;
                }

                protected Point getInitialSize() {
                    SelectionDialogUtil.fixInitialSize((Viewer)this.getTreeViewer(), true);
                    return super.getInitialSize();
                }

                private Button internalCreateButton(Composite composite, int n, String string, boolean bl2) {
                    return this.createButton(composite, n, string, bl2);
                }

                public int open() {
                    this.setShellStyle(this.getShellStyle() | 0x10000000);
                    return super.open();
                }
            };
            checkedTreeSelectionDialog.setContainerMode(true);
            checkedTreeSelectionDialog.setInput(object);
            checkedTreeSelectionDialog.setMessage(string);
            object2 = checkedTreeSelectionDialog;
        }
        return object2;
    }

    private static void fixInitialSize(Viewer viewer, boolean bl) {
        Control control = viewer.getControl();
        control.pack();
        GridData gridData = (GridData)control.getLayoutData();
        Rectangle rectangle = control.getBounds();
        if (bl) {
            int n = rectangle.width > 500 ? rectangle.width : 500;
            gridData.widthHint = n < 1000 ? n : 1000;
            gridData.heightHint = 200;
        } else {
            gridData.widthHint = 300;
            gridData.heightHint = 150;
        }
    }

    private static int handleButtonPressed(Viewer viewer, int n) {
        if (2 == n) {
            n = 0;
        } else if (3 == n) {
            if (viewer instanceof CheckboxTableViewer) {
                ((CheckboxTableViewer)viewer).setAllChecked(false);
            } else if (viewer instanceof CheckboxTreeViewer) {
                ((CheckboxTreeViewer)viewer).setAllChecked(false);
            } else {
                throw new IllegalArgumentException("viewer");
            }
            n = 0;
        }
        return n;
    }

    private static boolean useListSelectionDialog(Object object, IStructuredContentProvider iStructuredContentProvider) {
        Object[] objectArray;
        if (iStructuredContentProvider instanceof ITreeContentProvider && (objectArray = iStructuredContentProvider.getElements(object)) != null) {
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)iStructuredContentProvider;
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                Object[] objectArray3 = iTreeContentProvider.getChildren(object2);
                if (objectArray3 != null && objectArray3.length > 0) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private SelectionDialogUtil() {
    }

    private static interface IButtonsForButtonBarCreator {
        public Button createButton(Composite var1, int var2, String var3, boolean var4);
    }
}

