/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.jface.util;

import com.deltawalker.BoldFontCache;
import com.deltawalker.PrefKey;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public final class DialogUtil {
    public static int BEZEL_STYLE_EX = 13;
    private static FontMetrics fontMetrics;
    public static final int HORIZONTAL_INDENT;
    public static final int VERTICAL_INDENT;

    static {
        HORIZONTAL_INDENT = DialogUtil.convertDLUsToPixels(7, true) + DialogUtil.convertDLUsToPixels(4, true);
        VERTICAL_INDENT = DialogUtil.convertDLUsToPixels(7, false);
    }

    public static Button addButton(Composite composite, String string, String string2, String string3, int n, SelectionListener selectionListener) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        boolean bl = string3 != null;
        final Button[] buttonArray = new Button[1];
        if (bl) {
            buttonArray[0] = new Button(composite, 16);
            buttonArray[0].setLayoutData((Object)gridData);
            buttonArray[0].setText(string3);
            buttonArray[0].setData((Object)string2);
        }
        Button button = new Button(composite, bl ? 16 : 32);
        button.setData((Object)string2);
        button.setLayoutData((Object)gridData);
        button.setText(string);
        button.addSelectionListener(selectionListener);
        if (bl) {
            button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    buttonArray[0].setSelection(!((Button)event.widget).getSelection());
                }
            });
        }
        return button;
    }

    public static void initializeFromPrefsAndNotify(Control control, IPreferenceStore iPreferenceStore) {
        Object object;
        Control control2;
        Control[] controlArray;
        Control[] controlArray2 = controlArray = ControlUtil.getChildren(control, Button.class);
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control2 = controlArray2[n2];
            object = (Button)control2;
            int n3 = object.getStyle();
            String string = (String)object.getData();
            if (32 == (n3 & 0x20) || 16 == (n3 & 0x10)) {
                if (string != null) {
                    object.setSelection(iPreferenceStore.getBoolean(string));
                    object.notifyListeners(13, null);
                } else assert (16 == (n3 & 0x10));
            }
            ++n2;
        }
        controlArray2 = controlArray = ControlUtil.getChildren(control, Spinner.class);
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            control2 = controlArray2[n2];
            object = (String)control2.getData();
            if (!StringUtil.isEmpty((String)object)) {
                ((Spinner)control2).setSelection(iPreferenceStore.getInt((String)object));
                control2.notifyListeners(13, null);
            }
            ++n2;
        }
    }

    public static void centerInParent(Shell shell, Shell shell2) {
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n = (rectangle.width - rectangle2.width) / 2 + rectangle.x;
        int n2 = (rectangle.height - rectangle2.height) / 2 + rectangle.y;
        shell2.setLocation(new Point(n, n2));
    }

    public static int convertDLUsToPixels(int n, boolean bl) {
        if (fontMetrics == null) {
            GC gC = new GC((Drawable)UIUtil.display());
            gC.setFont(JFaceResources.getDialogFont());
            fontMetrics = gC.getFontMetrics();
            gC.dispose();
        }
        return bl ? Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)n) : Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)n);
    }

    public static Composite createComposite(Composite composite, int n, int n2, boolean bl) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        if (bl) {
            gridLayout.marginLeft = HORIZONTAL_INDENT;
            gridLayout.horizontalSpacing = HORIZONTAL_INDENT;
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(n2));
        return composite2;
    }

    public static GridData createFillGridData() {
        return new GridData(4, 128, true, true);
    }

    public static GridLayout createGridLayout(int n, int n2, int n3, int n4) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.marginTop = n2;
        gridLayout.marginBottom = n3;
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = gridLayout.marginWidth;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = n4;
        return gridLayout;
    }

    public static Composite createIndentComposite(Composite composite, int n, int n2) {
        return DialogUtil.createIndentComposite(composite, n, n2, -1, -1);
    }

    public static Composite createIndentComposite(Composite composite, int n, int n2, int n3, int n4) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = HORIZONTAL_INDENT;
        gridLayout.horizontalSpacing = HORIZONTAL_INDENT;
        if (n3 != -1) {
            gridLayout.marginTop = n3;
        }
        if (n4 != -1) {
            gridLayout.verticalSpacing = n4;
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(n2));
        return composite2;
    }

    public static Composite createPageComposite(Composite composite) {
        GridLayout gridLayout = DialogUtil.createGridLayout(1, 5, 5, 5);
        gridLayout.marginRight += gridLayout.marginRight;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData());
        return composite2;
    }

    public static Composite createSectionComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)DialogUtil.createGridLayout(1, 0, 0, 0));
        composite2.setLayoutData((Object)new GridData(4, 128, true, true));
        return composite2;
    }

    public static void createSectionTitle(Composite composite, String string, boolean bl) {
        DialogUtil.createSectionTitle(composite, string, bl, 1);
    }

    public static void createSectionTitle(Composite composite, String string, boolean bl, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)DialogUtil.createGridLayout(bl ? 2 : 1, 0, 5, 5));
        composite2.setLayoutData((Object)new GridData(n, 4, true, true));
        Label label = new Label(composite2, 0);
        label.setFont(BoldFontCache.get(composite.getFont()));
        label.setText(string);
        if (bl) {
            Button button = new Button(composite2, 0x800008, BEZEL_STYLE_EX);
            button.setText("...");
            button.setLayoutData((Object)new GridData(131072, 4, false, true));
        }
    }

    public static Spinner createSpinner(Composite composite, PrefKey prefKey, int n, SelectionListener selectionListener) {
        Spinner spinner = new Spinner(composite, 2048);
        if (prefKey != null) {
            spinner.setData((Object)prefKey.toString());
        }
        spinner.setMaximum(n);
        spinner.addSelectionListener(selectionListener);
        return spinner;
    }

    public static void enableControls(Control[] controlArray, boolean bl) {
        Control[] controlArray2 = controlArray;
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            control.setEnabled(bl);
            ++n2;
        }
    }

    public static void insertLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(4, 128, true, false);
        label.setText(string);
        label.setLayoutData((Object)gridData);
    }

    public static Composite insertLabelSeparator(Composite composite, String string) {
        return DialogUtil.insertLabelSeparator(composite, string, 1);
    }

    public static Composite insertLabelSeparator(Composite composite, String string, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = n;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText(string);
        Label label2 = new Label(composite2, 258);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite2;
    }

    public static Label insertSeparator(Composite composite) {
        return DialogUtil.insertSeparator(composite, 1);
    }

    public static Label insertSeparator(Composite composite, int n) {
        Label label = new Label(composite, 258);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.heightHint = VERTICAL_INDENT;
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Label insertSpace(Composite composite) {
        return DialogUtil.insertSpace(composite, false);
    }

    public static Label insertSpace(Composite composite, boolean bl) {
        return DialogUtil.insertSpace(composite, bl, 1);
    }

    public static Label insertSpace(Composite composite, boolean bl, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = n;
        if (!bl) {
            gridData.heightHint = 0;
            gridData.widthHint = 0;
        }
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static void removeControlFromTabOrder(Control control, Composite composite) {
        Control[] controlArray = composite.getTabList();
        ArrayList<Control> arrayList = new ArrayList<Control>();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] != control) {
                arrayList.add(controlArray[n]);
            }
            ++n;
        }
        composite.setTabList(arrayList.toArray(new Control[arrayList.size()]));
    }

    private DialogUtil() {
    }
}

