/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.eclipse.util;

import com.deltawalker.Msg;
import com.deltopia.eclipse.util.TimeUnit;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.osgi.util.NLS;

public final class TimeFormatter {
    private static String BIND = Msg.TimeFormatter_bind;
    private static String BIND_ABOUT = Msg.TimeFormatter_about;
    private static String BIND_DAYS = Msg.TimeFormatter_bindDays;
    private static String BIND_HOURS = Msg.TimeFormatter_bindHours;
    private static String BIND_MINUTES = Msg.TimeFormatter_bindMinutes;
    private static String BIND_MONTHS = Msg.TimeFormatter_bindMonths;
    private static String BIND_SHORT_DATE_TIME = Msg.TimeFormatter_bindDateTime;
    private static String BIND_YEARS = Msg.TimeFormatter_bindYears;
    private static final DateFormat longDate = DateFormat.getDateTimeInstance(1, 1);
    private static final String INVALID_DATE = "--/--/-- --:--:--";
    private static final DateFormat shortDate = DateFormat.getDateInstance(3);
    private static final DateFormat shortTime = new SimpleDateFormat("HH:mm:ss");

    public static synchronized String formatDelta(long l) {
        if (l < TimeUnit.MINUTES.toSeconds()) {
            if (l > 0L && l <= 5L) {
                return NLS.bind((String)BIND_ABOUT, (Object)l);
            }
            return NLS.bind((String)BIND, (Object)l, (Object)TimeUnit.SECONDS.label());
        }
        if (l < TimeUnit.HOURS.toSeconds()) {
            short s = (short)(l % TimeUnit.MINUTES.toSeconds());
            short s2 = (short)(l / TimeUnit.MINUTES.toSeconds());
            if (s != 0) {
                return NLS.bind((String)BIND_MINUTES, (Object)s2, (Object)s);
            }
            return NLS.bind((String)BIND, (Object)s2, (Object)TimeUnit.MINUTES.label());
        }
        if (l < TimeUnit.DAYS.toSeconds()) {
            short s = (short)(l % TimeUnit.HOURS.toSeconds() / TimeUnit.MINUTES.toSeconds());
            short s3 = (short)(l / TimeUnit.HOURS.toSeconds());
            if (s != 0) {
                return NLS.bind((String)BIND_HOURS, (Object)s3, (Object)s);
            }
            return NLS.bind((String)BIND, (Object)s3, (Object)TimeUnit.HOURS.label());
        }
        if (l < TimeUnit.MONTHS.toSeconds()) {
            short s = (short)(l % TimeUnit.DAYS.toSeconds() / TimeUnit.HOURS.toSeconds());
            short s4 = (short)(l / TimeUnit.DAYS.toSeconds());
            if (s != 0) {
                return NLS.bind((String)BIND_DAYS, (Object)s4, (Object)s);
            }
            return NLS.bind((String)BIND, (Object)s4, (Object)TimeUnit.DAYS.label());
        }
        if (l < TimeUnit.YEARS.toSeconds()) {
            short s = (short)(l % TimeUnit.MONTHS.toSeconds() / TimeUnit.DAYS.toSeconds());
            short s5 = (short)(l / TimeUnit.DAYS.toSeconds());
            if (s != 0) {
                return NLS.bind((String)BIND_MONTHS, (Object)s5, (Object)s);
            }
            return NLS.bind((String)BIND, (Object)s5, (Object)TimeUnit.MONTHS.label());
        }
        short s = (short)(l % TimeUnit.YEARS.toSeconds() / TimeUnit.MONTHS.toSeconds());
        short s6 = (short)(l / TimeUnit.YEARS.toSeconds());
        if (s != 0) {
            return NLS.bind((String)BIND_YEARS, (Object)s6, (Object)s);
        }
        return NLS.bind((String)BIND, (Object)s6, (Object)TimeUnit.YEARS.label());
    }

    public static String formatLong(long l) {
        String string = longDate.format(l);
        if (l == 0L) {
            return String.valueOf(string) + " (most likely missing or improperly set)";
        }
        return string;
    }

    public static synchronized String formatMilliDelta(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("delta");
        }
        if (l < 10000L) {
            float f = (float)l / 1000.0f;
            f = TimeFormatter.round(f, 2);
            return NLS.bind((String)BIND, (Object)Float.valueOf(f), (Object)TimeUnit.SECONDS.label()).toLowerCase();
        }
        return TimeFormatter.formatDelta(l / 1000L).toLowerCase();
    }

    public static String formatShort(long l) {
        if (l == 0L) {
            return INVALID_DATE;
        }
        return NLS.bind((String)BIND_SHORT_DATE_TIME, (Object)shortDate.format(l), (Object)shortTime.format(l));
    }

    public static synchronized float round(float f, int n) {
        BigDecimal bigDecimal = new BigDecimal(Float.toString(f));
        bigDecimal = bigDecimal.setScale(n, 4);
        return bigDecimal.floatValue();
    }

    private TimeFormatter() {
    }
}

